/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config12.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.converters.BuiltInConverter;
import com.ibm.ws.microprofile.config.converters.PriorityConverterMap;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.impl.ConversionStatus;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.microprofile.config12.converters.ImplicitConverter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Config12ConversionManager
extends ConversionManager {
    private static final TraceComponent tc = Tr.register(Config12ConversionManager.class);
    static final long serialVersionUID = -2927068684966672868L;

    public Config12ConversionManager(PriorityConverterMap converters, ClassLoader classLoader) {
        super(converters, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected <T> ConversionStatus implicitConverters(String rawString, Class<T> type) {
        ConversionStatus status = new ConversionStatus();
        BuiltInConverter automaticConverter = this.getConverter(type);
        if (automaticConverter != null) {
            try {
                Object converted = automaticConverter.convert(rawString);
                status.setConverted(converted);
            }
            catch (IllegalArgumentException converted) {
                void e;
                FFDCFilter.processException((Throwable)converted, (String)"com.ibm.ws.microprofile.config12.impl.Config12ConversionManager", (String)"52", (Object)this, (Object[])new Object[]{rawString, type});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"implicitConverters: An automatic converter for type ''{0}'' and raw String ''{1}'' threw an exception: {2}.", (Object[])new Object[]{type, rawString, e});
                }
                throw e;
            }
            catch (Throwable e) {
                void t;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config12.impl.Config12ConversionManager", (String)"57", (Object)this, (Object[])new Object[]{rawString, type});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"implicitConverters: An automatic converter for type ''{0}'' and raw String ''{1}'' threw an exception: {2}.", (Object[])new Object[]{type, rawString, t});
                }
                throw new ConfigException((Throwable)t);
            }
        }
        return status;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalArgumentException.class})
    protected <T> BuiltInConverter getConverter(Class<T> type) {
        ImplicitConverter automaticConverter = null;
        try {
            automaticConverter = new ImplicitConverter(type);
        }
        catch (IllegalArgumentException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getConverter (INFO): An automatic converter for type ''{0}'' could not be constructed: {2}.", (Object[])new Object[]{type, e});
            }
        }
        catch (Throwable e) {
            void t;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config12.impl.Config12ConversionManager", (String)"81", (Object)this, (Object[])new Object[]{type});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getConverter: An automatic converter for type ''{0}'' could not be constructed: {2}.", (Object[])new Object[]{type, t});
            }
            throw new ConfigException((Throwable)t);
        }
        return automaticConverter;
    }
}

