/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;

public class SSLAlpnNegotiatorJdk8 {
    private static final TraceComponent tc;
    private final String h1 = "http/1.1";
    private final String h2 = "h2";
    private static boolean grizzlyAlpnPresent;
    private static boolean jettyAlpnPresent;
    private static boolean ibmAlpnPresent;
    private static Class<?> ibmAlpn;
    private static Method ibmAlpnGet;
    private static Method ibmAlpnPut;
    private static Method ibmAlpnDelete;
    private static Class<?> jettyAlpn;
    private static Class<?> jettyServerProviderInterface;
    private static Class<?> jettyProviderInterface;
    private static Class<?> grizzlyNegotiationSupport;
    private static Class<?> grizzlyAlpnClientNegotiator;
    private static Class<?> grizzlyAlpnServerNegotiator;
    private static Object grizzlyNegotiationSupportObject;

    protected boolean isIbmAlpnActive() {
        return ibmAlpnPresent;
    }

    protected boolean isGrizzlyAlpnActive() {
        return grizzlyAlpnPresent;
    }

    protected boolean isJettyAlpnActive() {
        return jettyAlpnPresent;
    }

    protected ThirdPartyAlpnNegotiator tryToRegisterAlpnNegotiator(SSLEngine engine, SSLConnectionLink link, boolean useAlpn) {
        if (this.isIbmAlpnActive()) {
            this.registerIbmAlpn(engine, useAlpn);
        } else {
            if (this.isJettyAlpnActive() && useAlpn) {
                return this.registerJettyAlpn(engine, link);
            }
            if (this.isGrizzlyAlpnActive() && useAlpn) {
                return this.registerGrizzlyAlpn(engine, link);
            }
        }
        return null;
    }

    protected void tryToRemoveAlpnNegotiator(ThirdPartyAlpnNegotiator negotiator, SSLEngine engine, SSLConnectionLink link) {
        if (negotiator == null && this.isIbmAlpnActive()) {
            this.getAndRemoveIbmAlpnChoice(engine, link);
        } else if (negotiator != null && this.isJettyAlpnActive() && negotiator instanceof JettyServerNegotiator) {
            ((JettyServerNegotiator)negotiator).removeEngine();
        } else if (negotiator != null && this.isGrizzlyAlpnActive() && negotiator instanceof GrizzlyAlpnNegotiator) {
            ((GrizzlyAlpnNegotiator)negotiator).removeServerNegotiatorEngine();
        }
    }

    protected void registerIbmAlpn(SSLEngine engine, boolean useAlpn) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("registerIbmAlpn entry " + engine), (Object[])new Object[0]);
            }
            try {
                String[] protocols = useAlpn ? new String[]{"h2", "http/1.1"} : new String[]{};
                ibmAlpnPut.invoke(null, engine, protocols);
            }
            catch (InvocationTargetException ie) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("registerIbmAlpn exception: " + ie.getTargetException()), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("registerIbmAlpn exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    protected void getAndRemoveIbmAlpnChoice(SSLEngine engine, SSLConnectionLink link) {
        block10: {
            if (this.isIbmAlpnActive()) {
                try {
                    String[] alpnResult = (String[])ibmAlpnGet.invoke(null, engine);
                    ibmAlpnDelete.invoke(null, engine);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("getAndRemoveIbmAlpnChoice");
                        if (alpnResult != null && alpnResult.length > 0) {
                            sb.append(" results:");
                            for (String s : alpnResult) {
                                sb.append(" " + s);
                            }
                            sb.append(" " + engine);
                        } else {
                            sb.append(": ALPN not used for " + engine);
                        }
                        Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
                    }
                    if (alpnResult != null && alpnResult.length == 1 && "h2".equals(alpnResult[0]) && link.getAlpnProtocol() == null) {
                        link.setAlpnProtocol("h2");
                    }
                }
                catch (InvocationTargetException ie) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getAndRemoveIbmAlpnChoice exception: " + ie.getTargetException()), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)("getAndRemoveIbmAlpnChoice exception: " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    protected GrizzlyAlpnNegotiator registerGrizzlyAlpn(SSLEngine engine, SSLConnectionLink link) {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("registerGrizzlyAlpn entry " + engine), (Object[])new Object[0]);
            }
            if (grizzlyNegotiationSupport != null && grizzlyAlpnClientNegotiator != null && grizzlyAlpnServerNegotiator != null && grizzlyNegotiationSupportObject != null) {
                try {
                    GrizzlyAlpnNegotiator negotiator = new GrizzlyAlpnNegotiator(engine, link);
                    if (!engine.getUseClientMode()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("initializeAlpn invoke AlpnServerNegotiator " + engine), (Object[])new Object[0]);
                        }
                        Method m = grizzlyNegotiationSupport.getMethod("addNegotiator", SSLEngine.class, grizzlyAlpnServerNegotiator);
                        m.invoke(grizzlyNegotiationSupportObject, engine, Proxy.newProxyInstance(grizzlyAlpnServerNegotiator.getClassLoader(), new Class[]{grizzlyAlpnServerNegotiator}, (InvocationHandler)negotiator));
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("initializeAlpn invoke AlpnClientNegotiator " + engine), (Object[])new Object[0]);
                        }
                        Method m = grizzlyNegotiationSupport.getMethod("addNegotiator", SSLEngine.class, grizzlyAlpnClientNegotiator);
                        m.invoke(grizzlyNegotiationSupportObject, engine, Proxy.newProxyInstance(grizzlyAlpnClientNegotiator.getClassLoader(), new Class[]{grizzlyAlpnClientNegotiator}, (InvocationHandler)negotiator));
                    }
                    return negotiator;
                }
                catch (InvocationTargetException ie) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registerGrizzlyAlpn exception: " + ie.getTargetException()), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)("registerGrizzlyAlpn grizzly-npn exception: " + e), (Object[])new Object[0]);
                }
            }
        }
        return null;
    }

    protected JettyServerNegotiator registerJettyAlpn(SSLEngine engine, SSLConnectionLink link) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("registerJettyAlpn entry " + engine), (Object[])new Object[0]);
            }
            try {
                JettyServerNegotiator negotiator = new JettyServerNegotiator(engine, link);
                Method m = jettyAlpn.getMethod("put", SSLEngine.class, jettyProviderInterface);
                m.invoke(null, engine, Proxy.newProxyInstance(jettyServerProviderInterface.getClassLoader(), new Class[]{jettyServerProviderInterface}, (InvocationHandler)negotiator));
                return negotiator;
            }
            catch (InvocationTargetException ie) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("registerJettyAlpn exception: " + ie.getTargetException()), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("registerJettyAlpn jetty-alpn exception: " + e), (Object[])new Object[0]);
            }
        }
        return null;
    }

    static {
        block13: {
            block12: {
                block11: {
                    tc = Tr.register(SSLAlpnNegotiatorJdk8.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
                    grizzlyAlpnPresent = false;
                    jettyAlpnPresent = false;
                    ibmAlpnPresent = false;
                    try {
                        ibmAlpn = ClassLoader.getSystemClassLoader().loadClass("com.ibm.jsse2.ext.ALPNJSSEExt");
                        ibmAlpnPresent = true;
                        ibmAlpn.getMethod("init", new Class[0]).invoke(null, new Object[0]);
                        ibmAlpnGet = ibmAlpn.getMethod("get", SSLEngine.class);
                        ibmAlpnPut = ibmAlpn.getMethod("put", SSLEngine.class, String[].class);
                        ibmAlpnDelete = ibmAlpn.getMethod("delete", SSLEngine.class);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"com.ibm.jsse2.ext.ALPNJSSEExt was found on the classpath; ALPN is available", (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)("problem encountered initializing IBM alpn provider: " + t), (Object[])new Object[0]);
                    }
                }
                if (!ibmAlpnPresent) {
                    try {
                        jettyAlpn = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN");
                        jettyServerProviderInterface = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN$ServerProvider");
                        jettyProviderInterface = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.alpn.ALPN$Provider");
                        jettyAlpnPresent = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"jetty-alpn module was found on the classpath; ALPN is available", (Object[])new Object[0]);
                        }
                    }
                    catch (Throwable t) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)("problem initializing jetty alpn provider: " + t), (Object[])new Object[0]);
                    }
                }
            }
            if (!jettyAlpnPresent && !ibmAlpnPresent) {
                try {
                    grizzlyNegotiationSupport = ClassLoader.getSystemClassLoader().loadClass("org.glassfish.grizzly.npn.NegotiationSupport");
                    grizzlyAlpnServerNegotiator = ClassLoader.getSystemClassLoader().loadClass("org.glassfish.grizzly.npn.AlpnServerNegotiator");
                    grizzlyAlpnClientNegotiator = ClassLoader.getSystemClassLoader().loadClass("org.glassfish.grizzly.npn.AlpnClientNegotiator");
                    grizzlyNegotiationSupportObject = grizzlyNegotiationSupport.newInstance();
                    grizzlyAlpnPresent = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"grizzly-npn module was found on the classpath; ALPN is available", (Object[])new Object[0]);
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                    Tr.debug((TraceComponent)tc, (String)("problem initializing grizzly alpn provider: " + t), (Object[])new Object[0]);
                }
            }
        }
    }

    public class GrizzlyAlpnNegotiator
    implements InvocationHandler,
    ThirdPartyAlpnNegotiator {
        private final SSLEngine engine;
        private final SSLConnectionLink link;

        public GrizzlyAlpnNegotiator(SSLEngine e, SSLConnectionLink l) {
            this.engine = e;
            this.link = l;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invoke entry" + method), (Object[])new Object[0]);
            }
            if ((methodName = method.getName()).equals("selectProtocol")) {
                if (args != null && args.length == 2 && args[0] instanceof SSLEngine && args[1] instanceof String[]) {
                    return this.selectProtocol((SSLEngine)args[0], (String[])args[1]);
                }
                if (args != null && args.length == 2 && args[0] instanceof SSLEngine && args[1] instanceof String) {
                    this.selectProtocol((SSLEngine)args[0], (String)args[1]);
                }
            }
            return null;
        }

        protected String selectProtocol(SSLEngine engine, String[] protocolList) {
            this.removeServerNegotiatorEngine();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("selectProtocol entry engine: " + engine + " protocols: " + protocolList), (Object[])new Object[0]);
            }
            if (engine != null && protocolList != null && protocolList.length > 0) {
                if (Arrays.asList(protocolList).contains("h2")) {
                    if (this.link != null) {
                        this.link.setAlpnProtocol("h2");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("selectProtocol protocol h2 selected" + engine), (Object[])new Object[0]);
                    }
                    return "h2";
                }
                if (Arrays.asList(protocolList).contains("http/1.1")) {
                    if (this.link != null) {
                        this.link.setAlpnProtocol("http/1.1");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("selectProtocol protocol http/1.1 selected" + engine), (Object[])new Object[0]);
                        }
                    }
                    return "http/1.1";
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("selectProtocol no protocol matched, returning http/1.1" + engine), (Object[])new Object[0]);
            }
            return "http/1.1";
        }

        protected void selectProtocol(SSLEngine engine, String protocol) {
            this.removeClientNegotiatorEngine();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("selectProtocol entry engine: " + engine + " protocol: " + protocol), (Object[])new Object[0]);
            }
            if (engine != null && protocol != null) {
                if (protocol.equals("h2")) {
                    if (this.link != null) {
                        this.link.setAlpnProtocol("h2");
                    }
                } else if (protocol.equals("http/1.1") && this.link != null) {
                    this.link.setAlpnProtocol("http/1.1");
                }
            }
        }

        public void removeServerNegotiatorEngine() {
            block4: {
                try {
                    Method m = grizzlyNegotiationSupport.getMethod("removeAlpnServerNegotiator", SSLEngine.class);
                    m.invoke(grizzlyNegotiationSupportObject, this.engine);
                }
                catch (InvocationTargetException ie) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removeServerNegotiatorEngine exception: " + ie.getTargetException()), (Object[])new Object[0]);
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("removeServerNegotiatorEngine failed\n" + t), (Object[])new Object[0]);
                }
            }
        }

        public void removeClientNegotiatorEngine() {
            block4: {
                try {
                    Method m = grizzlyNegotiationSupport.getMethod("removeAlpnClientNegotiator", SSLEngine.class);
                    m.invoke(grizzlyNegotiationSupportObject, this.engine);
                }
                catch (InvocationTargetException ie) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removeClientNegotiatorEngine exception: " + ie.getTargetException()), (Object[])new Object[0]);
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("removeClientNegotiatorEngine failed\n" + t), (Object[])new Object[0]);
                }
            }
        }
    }

    public class JettyServerNegotiator
    implements InvocationHandler,
    ThirdPartyAlpnNegotiator {
        private final SSLEngine engine;
        private final SSLConnectionLink link;

        public JettyServerNegotiator(SSLEngine e, SSLConnectionLink l) {
            this.engine = e;
            this.link = l;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invoke entry" + method), (Object[])new Object[0]);
            }
            if ((methodName = method.getName()).equals("select")) {
                if (args != null && args.length == 1 && args[0] instanceof List) {
                    return this.select((List)args[0]);
                }
            } else if (methodName.equals("unsupported") && args == null) {
                this.unsupported();
            }
            return null;
        }

        public String select(List<String> protocols) throws SSLException {
            this.removeEngine();
            if (protocols.contains("h2")) {
                if (this.link != null) {
                    this.link.setAlpnProtocol("h2");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("select protocol h2 selected" + this.engine), (Object[])new Object[0]);
                }
                return "h2";
            }
            if (protocols.contains("http/1.1")) {
                if (this.link != null) {
                    this.link.setAlpnProtocol("http/1.1");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("select protocol http/1.1 selected" + this.engine), (Object[])new Object[0]);
                    }
                }
                return "http/1.1";
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("select no protocol matched, returning http/1.1" + this.engine), (Object[])new Object[0]);
            }
            return "http/1.1";
        }

        public void unsupported() {
            this.removeEngine();
        }

        public void removeEngine() {
            block4: {
                try {
                    Method m = jettyAlpn.getMethod("remove", SSLEngine.class);
                    m.invoke(null, this.engine);
                }
                catch (InvocationTargetException ie) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removeEngine exception: " + ie.getTargetException()), (Object[])new Object[0]);
                    }
                }
                catch (Throwable t) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("removeEngine failed\n" + t), (Object[])new Object[0]);
                }
            }
        }
    }

    public static interface ThirdPartyAlpnNegotiator {
    }
}

