/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.channel.ssl.internal.SSLChannelData;
import com.ibm.ws.channel.ssl.internal.SSLChannelFactoryImpl;
import com.ibm.ws.channel.ssl.internal.SSLChannelProvider;
import com.ibm.ws.channel.ssl.internal.SSLConnectionLink;
import com.ibm.ws.channel.ssl.internal.SSLDiscriminatorState;
import com.ibm.ws.channel.ssl.internal.SSLHandshakeErrorTracker;
import com.ibm.ws.channel.ssl.internal.SSLLinkConfig;
import com.ibm.ws.channel.ssl.internal.SSLUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.OutboundChannel;
import com.ibm.wsspi.channelfw.OutboundProtocol;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;

public class SSLChannel
implements InboundChannel,
OutboundChannel,
Discriminator {
    private static final TraceComponent tc = Tr.register(SSLChannel.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    public static final String SSL_DISCRIMINATOR_STATE = "SSLDiscState";
    protected DiscriminationProcess discProcess = null;
    protected SSLChannelData sslConfig = null;
    private boolean isInitialized = false;
    protected SSLHandshakeErrorTracker handshakeErrorTracker = null;
    protected String alias = null;
    protected String endPointName = null;
    protected String inboundHost = null;
    protected String inboundPort = null;
    protected JSSEProvider jsseProvider;
    protected JSSEHelper jsseHelper;
    protected boolean isZOS = false;
    private SSLSessionContext sessionContext = null;
    private SSLChannelFactoryImpl myFactory = null;
    private int timeoutValueInSSLClosingHandshake = 30;
    private static Boolean useH2ProtocolAttribute = null;
    private volatile boolean stop0Called = false;

    public SSLChannel(ChannelData inputData, SSLChannelFactoryImpl factory) throws ChannelException {
        this(inputData);
        this.myFactory = factory;
        this.handshakeErrorTracker = this.createSSLHandshakeErrorTracker(inputData);
        try {
            this.jsseProvider = SSLChannelProvider.getJSSEProvider();
            this.jsseHelper = SSLChannelProvider.getJSSEHelper();
        }
        catch (IllegalStateException ise) {
            ChannelException ce = new ChannelException("SSL channel could not be created, required services not found " + ise.getMessage(), (Throwable)ise);
            ce.suppressFFDC(true);
            throw ce;
        }
    }

    SSLChannel(ChannelData inputData) throws ChannelException {
        this.sslConfig = new SSLChannelData(inputData);
    }

    private SSLHandshakeErrorTracker createSSLHandshakeErrorTracker(ChannelData inputData) {
        Map bag = inputData.getPropertyBag();
        boolean suppressHandshakeError = false;
        Object value = bag.get("suppressHandshakeErrors");
        if (value != null) {
            suppressHandshakeError = this.convertBooleanValue(value);
        }
        long maxLogEntries = 100L;
        value = bag.get("suppressHandshakeErrorsCount");
        if (value != null) {
            maxLogEntries = this.convertLongValue(value);
        }
        return new SSLHandshakeErrorTracker(!suppressHandshakeError, maxLogEntries);
    }

    private long convertLongValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    private boolean convertBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public SSLHandshakeErrorTracker getHandshakeErrorTracker() {
        return this.handshakeErrorTracker;
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public DiscriminationProcess getDiscriminationProcess() {
        return this.discProcess;
    }

    public void setDiscriminationProcess(DiscriminationProcess dp) {
        this.discProcess = dp;
    }

    public Class<?> getDiscriminatoryType() {
        return WsByteBuffer.class;
    }

    public Class<?> getDeviceAddress() {
        return TCPConnectRequestContext.class;
    }

    public Class<?>[] getApplicationAddress() {
        return new Class[]{TCPConnectRequestContext.class};
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        if (!this.isInitialized) {
            try {
                this.init();
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught while getting SSL connection link: " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"148", (Object)this, (Object[])new Object[]{vc});
                throw new RuntimeException(e);
            }
        }
        SSLConnectionLink link = new SSLConnectionLink(this);
        link.init(vc);
        return link;
    }

    public SSLContext getSSLContextForInboundLink(SSLConnectionLink link, VirtualConnection vc) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContextForInboundLink", (Object[])new Object[0]);
        }
        SSLContext context = this.getSSLContextForLink(vc, this.inboundHost, this.inboundPort, this.endPointName, false, link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLContextForInboundLink");
        }
        return context;
    }

    public SSLContext getSSLContextForOutboundLink(SSLConnectionLink link, VirtualConnection vc, Object address) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContextForOutboundLink", (Object[])new Object[0]);
        }
        TCPConnectRequestContext tcpRequest = (TCPConnectRequestContext)address;
        InetSocketAddress socket = tcpRequest.getRemoteAddress();
        String protocol = "HTTP";
        String mapProtocol = (String)vc.getStateMap().get("protocol");
        if (mapProtocol != null) {
            protocol = mapProtocol;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("OutboundProtocol=" + protocol + " specified by in VC"), (Object[])new Object[0]);
            }
        } else {
            Object channelAccessor = ((OutboundVirtualConnection)vc).getChannelAccessor();
            if (channelAccessor instanceof OutboundProtocol) {
                protocol = ((OutboundProtocol)channelAccessor).getProtocol();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("OutboundProtocol=" + protocol + " specified by " + channelAccessor.getClass().getName()), (Object[])new Object[0]);
                }
            }
        }
        SSLContext context = this.getSSLContextForLink(vc, socket.getHostName(), Integer.toString(socket.getPort()), protocol, Boolean.FALSE, link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLContextForOutboundLink");
        }
        return context;
    }

    protected SSLContext getSSLContextForLink(VirtualConnection vc, String host, String port, String endPoint, Boolean isZWebContainerChain, SSLConnectionLink link) throws ChannelException {
        String sslType;
        boolean useJSSEHelper;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("host=" + host + " port=" + port + " endPoint=" + endPoint), (Object[])new Object[0]);
        }
        String direction = this.getConfig().isInbound() ? "inbound" : "outbound";
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", direction);
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        connectionInfo.put("com.ibm.ssl.endPointName", endPoint);
        Properties props = null;
        boolean bl = useJSSEHelper = null != this.alias;
        if (!useJSSEHelper) {
            block27: {
                try {
                    props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                        @Override
                        public Properties run() throws Exception {
                            return SSLChannel.this.jsseHelper.getSSLPropertiesOnThread();
                        }
                    });
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block27;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception looking for on-thread props; e=" + e), (Object[])new Object[0]);
                }
            }
            if (null == props || 0 == props.size()) {
                props = null;
                useJSSEHelper = !this.getConfig().getProperties().containsKey("com.ibm.ssl.keyStore") || !this.getConfig().getProperties().containsKey("com.ibm.ssl.trustStore");
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found on-thread ssl properties", (Object[])new Object[0]);
            }
        }
        if (useJSSEHelper) {
            try {
                final String aliasFinal = this.alias;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Querying security service for alias=[" + aliasFinal + "]"), (Object[])new Object[0]);
                }
                props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                    @Override
                    public Properties run() throws Exception {
                        return SSLChannel.this.jsseHelper.getProperties(aliasFinal, connectionInfo, null);
                    }
                });
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception getting SSL properties from alias: " + this.alias), (Object[])new Object[0]);
                }
                throw new ChannelException((Throwable)e);
            }
        }
        if (null != props) {
            Enumeration<?> names = this.getConfig().getProperties().propertyNames();
            String key = null;
            String value = null;
            while (names.hasMoreElements()) {
                key = (String)names.nextElement();
                value = this.getConfig().getStringProperty(key);
                if (null == value || props.containsKey(key)) continue;
                props.put(key, value);
            }
        } else {
            props = this.getConfig().getProperties();
        }
        if (null != (sslType = (String)props.get("com.ibm.ssl.sslType"))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SSLConfig type: " + sslType), (Object[])new Object[0]);
            }
            if (sslType.equals("SSSL")) {
                throw new ChannelException("Invalid SSLConfig type: " + sslType);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SSL configuration <null value means non-string>:", (Object[])new Object[0]);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                if (-1 == key.toLowerCase().indexOf("password")) {
                    Tr.debug((TraceComponent)tc, (String)("\t" + key + " = " + value), (Object[])new Object[0]);
                    continue;
                }
                StringBuilder output = new StringBuilder(4 + key.length() + value.length());
                output.append("\t").append(key).append(" = ");
                for (int i = 0; i < value.length(); ++i) {
                    output.append("*");
                }
                Tr.debug((TraceComponent)tc, (String)output.toString(), (Object[])new Object[0]);
            }
        }
        SSLContext context = null;
        try {
            SSLConfig config = new SSLConfig(props);
            context = this.jsseProvider.getSSLContext(connectionInfo, config);
            SSLLinkConfig linkConfig = new SSLLinkConfig(props);
            if (null == link) {
                vc.getStateMap().put("SSLLINKCONFIG", linkConfig);
            } else {
                link.setLinkConfig(linkConfig);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception getting SSLContext from properties.", (Object[])new Object[]{e});
            }
            throw new ChannelException((Throwable)e);
        }
        return context;
    }

    public int getTimeoutValueInSSLClosingHandshake() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("timeoutValueInSSLClosingHandshake : " + this.timeoutValueInSSLClosingHandshake), (Object[])new Object[0]);
        }
        return this.timeoutValueInSSLClosingHandshake;
    }

    public Boolean getUseH2ProtocolAttribute() {
        return useH2ProtocolAttribute;
    }

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        this.stop0Called = false;
        try {
            if (this.getConfig().isInbound()) {
                ChainData chainData = SSLChannelProvider.getCfw().getInternalRunningChains(this.getConfig().getName())[0];
                ChannelData channelData = chainData.getChannelList()[0];
                Map channelProperties = channelData.getPropertyBag();
                this.inboundHost = (String)channelProperties.get("hostname");
                this.inboundPort = (String)channelProperties.get("port");
                this.endPointName = (String)channelProperties.get("endPointName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("inboundHost = " + this.inboundHost + " inboundPort = " + this.inboundPort + " endPointName = " + this.endPointName), (Object[])new Object[0]);
                }
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during start, throwing up stack.  " + e), (Object[])new Object[0]);
            }
            throw new ChannelException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public boolean getstop0Called() {
        return this.stop0Called;
    }

    public void stop(long millisec) throws ChannelException {
        if (millisec == 0L) {
            this.stop0Called = true;
        }
    }

    public void init() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object[])new Object[0]);
        }
        if (this.isInitialized) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"init");
            }
            return;
        }
        try {
            Properties channelProps = this.getConfig().getProperties();
            if (channelProps != null) {
                String protocolVersion;
                String timeoutValueSystemProperty;
                String timeoutValueInSSLClosingHandshake;
                this.alias = channelProps.getProperty("alias");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (this.alias != null) {
                        Tr.debug((TraceComponent)tc, (String)("Found alias in SSL properties, " + this.alias), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"No alias found in SSL properties", (Object[])new Object[0]);
                    }
                }
                if ((timeoutValueInSSLClosingHandshake = channelProps.getProperty("timeoutValueInSSLClosingHandshake")) != null) {
                    this.timeoutValueInSSLClosingHandshake = Integer.parseInt(timeoutValueInSSLClosingHandshake);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found timeoutValueInSSLClosingHandshake in SSL properties, " + this.timeoutValueInSSLClosingHandshake), (Object[])new Object[0]);
                    }
                }
                if ((timeoutValueSystemProperty = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("timeoutValueInSSLClosingHandshake");
                    }
                })) != null) {
                    this.timeoutValueInSSLClosingHandshake = Integer.parseInt(timeoutValueSystemProperty);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found timeoutValueInSSLClosingHandshake in SSL system properties, " + this.timeoutValueInSSLClosingHandshake), (Object[])new Object[0]);
                    }
                }
                if ((protocolVersion = channelProps.getProperty("protocolVersionInternal")) != null) {
                    if ("http/1.1".equalsIgnoreCase(protocolVersion)) {
                        useH2ProtocolAttribute = Boolean.FALSE;
                    } else if ("http/2".equalsIgnoreCase(protocolVersion)) {
                        useH2ProtocolAttribute = Boolean.TRUE;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && useH2ProtocolAttribute != null) {
                        Tr.event((TraceComponent)tc, (String)("SSL Channel Config: versionProtocolOption has been set to " + protocolVersion.toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("init received exception handling properties; " + e), (Object[])new Object[0]);
            }
            throw new ChannelException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("jsseProvider=" + this.jsseProvider), (Object[])new Object[0]);
        }
        this.isInitialized = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void destroy() throws ChannelException {
        if (null != this.myFactory && null != this.getConfig()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing channel from factory; " + this.getConfig().getName()), (Object[])new Object[0]);
            }
            this.myFactory.removeChannel(this.getConfig().getName());
            this.myFactory = null;
        }
        this.discProcess = null;
        this.sslConfig = null;
        this.sessionContext = null;
    }

    public String getName() {
        return this.sslConfig.getName();
    }

    public Class<?> getApplicationInterface() {
        return TCPConnectionContext.class;
    }

    public Class<?> getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public void update(ChannelData inputData) {
        this.handshakeErrorTracker = this.createSSLHandshakeErrorTracker(inputData);
        this.sslConfig.updateChannelData(inputData);
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        SSLDiscriminatorState discState;
        int result;
        SSLEngineResult sslResult;
        SSLContext vcSSLContext;
        SSLEngine sslEngine;
        Map stateMap;
        WsByteBuffer decryptedNetBuffer;
        int initialNetBufLimit;
        int initialNetBufPosition;
        WsByteBuffer netBuffer;
        block36: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"discriminate", (Object[])new Object[0]);
            }
            if (discrimData == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received null discrim data.  Returning NO from discriminator.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"discriminate");
                }
                return 0;
            }
            netBuffer = ((WsByteBuffer[])discrimData)[0];
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("netBuffer: " + SSLUtils.getBufferTraceInfo(netBuffer)), (Object[])new Object[0]);
            }
            if (0 == netBuffer.position()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Received empty discrim data.  Returning MAYBE from discriminator.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"discriminate");
                }
                return -1;
            }
            if (!this.isInitialized) {
                try {
                    this.init();
                }
                catch (Exception e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception caught while getting SSL connection link: " + e), (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"148", (Object)this, (Object[])new Object[]{vc});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"discriminate");
                    }
                    return 0;
                }
            }
            initialNetBufPosition = netBuffer.position();
            initialNetBufLimit = netBuffer.limit();
            decryptedNetBuffer = null;
            stateMap = vc.getStateMap();
            sslEngine = null;
            vcSSLContext = null;
            sslResult = null;
            result = 1;
            discState = null;
            try {
                netBuffer.flip();
                discState = (SSLDiscriminatorState)stateMap.get(SSL_DISCRIMINATOR_STATE);
                if (discState == null) {
                    vcSSLContext = this.getSSLContextForInboundLink(null, vc);
                    sslEngine = SSLUtils.getSSLEngine(vcSSLContext, FlowType.INBOUND, (SSLLinkConfig)vc.getStateMap().get("SSLLINKCONFIG"));
                    decryptedNetBuffer = SSLUtils.allocateByteBuffer(sslEngine.getSession().getApplicationBufferSize(), this.getConfig().getDecryptBuffersDirect());
                } else {
                    sslEngine = discState.getEngine();
                    vcSSLContext = discState.getSSLContext();
                    decryptedNetBuffer = discState.getDecryptedNetBuffer();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("before unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecNetBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer)), (Object[])new Object[0]);
                }
                int savedLimit = SSLUtils.adjustBufferForJSSE(netBuffer, sslEngine.getSession().getPacketBufferSize());
                sslResult = sslEngine.unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                if (0 < sslResult.bytesProduced()) {
                    decryptedNetBuffer.flip();
                }
                if (-1 != savedLimit) {
                    netBuffer.limit(savedLimit);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("after unwrap: \r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecNetBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)sslResult.getStatus()) + " HSstatus=" + (Object)((Object)sslResult.getHandshakeStatus()) + " consumed=" + sslResult.bytesConsumed() + " produced=" + sslResult.bytesProduced()), (Object[])new Object[0]);
                }
                if (sslResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    result = -1;
                } else {
                    result = 1;
                    if (netBuffer.remaining() == 0) {
                        netBuffer.clear();
                    }
                }
            }
            catch (Throwable t) {
                result = 0;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block36;
                Tr.debug((TraceComponent)tc, (String)("Caught Exception during discriminate: " + t), (Object[])new Object[0]);
            }
        }
        switch (result) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminator returning YES", (Object[])new Object[0]);
                }
                if (discState == null) {
                    discState = new SSLDiscriminatorState();
                }
                discState.updateState(vcSSLContext, sslEngine, sslResult, decryptedNetBuffer, netBuffer.position(), netBuffer.limit());
                stateMap.put(SSL_DISCRIMINATOR_STATE, discState);
                break;
            }
            case 0: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminator returning NO", (Object[])new Object[0]);
                }
                if (discState != null) {
                    stateMap.remove(SSL_DISCRIMINATOR_STATE);
                }
                if (null != sslEngine) {
                    this.closeEngine(sslEngine);
                }
                if (null == decryptedNetBuffer) break;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Releasing decryptedNetworkBuffer", (Object[])new Object[0]);
                }
                decryptedNetBuffer.release();
                decryptedNetBuffer = null;
                break;
            }
            default: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminator returning MAYBE", (Object[])new Object[0]);
                }
                if (discState != null) break;
                discState = new SSLDiscriminatorState();
                discState.updateState(vcSSLContext, sslEngine, sslResult, decryptedNetBuffer, netBuffer.position(), netBuffer.limit());
                stateMap.put(SSL_DISCRIMINATOR_STATE, discState);
            }
        }
        netBuffer.limit(initialNetBufLimit);
        netBuffer.position(initialNetBufPosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"discriminate");
        }
        return result;
    }

    public void cleanUpState(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanUpState", (Object[])new Object[0]);
        }
        SSLDiscriminatorState discState = (SSLDiscriminatorState)vc.getStateMap().remove(SSL_DISCRIMINATOR_STATE);
        this.closeEngine(discState.getEngine());
        WsByteBuffer decryptedNetBuffer = discState.getDecryptedNetBuffer();
        if (decryptedNetBuffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Releasing decryptedNetworkBuffer", (Object[])new Object[0]);
            }
            decryptedNetBuffer.release();
            decryptedNetBuffer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanUpState");
        }
    }

    protected void onHandshakeFinish(SSLEngine engine) {
        SSLSessionContext context = null;
        try {
            final SSLEngine localEngine = engine;
            context = AccessController.doPrivileged(new PrivilegedExceptionAction<SSLSessionContext>(){

                @Override
                public SSLSessionContext run() throws Exception {
                    return localEngine.getSession().getSessionContext();
                }
            });
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".onHandshakeFinish"), (String)"814");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception querying sessioncontext; " + e), (Object[])new Object[0]);
            }
            return;
        }
        if (null == context || context.equals(this.sessionContext)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Channel [" + this + "] saving context: " + context), (Object[])new Object[0]);
        }
        this.sessionContext = context;
        context.setSessionCacheSize(this.getConfig().getSSLSessionCacheSize());
        context.setSessionTimeout(this.getConfig().getSSLSessionTimeout());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Session cache size set to " + context.getSessionCacheSize()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Session timeout set to " + context.getSessionTimeout()), (Object[])new Object[0]);
        }
    }

    private void closeEngine(SSLEngine engine) {
        block5: {
            if (null != engine) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Closing discrimination engine", (Object[])new Object[0]);
                }
                engine.closeOutbound();
                if (!engine.isInboundDone()) {
                    try {
                        engine.closeInbound();
                    }
                    catch (SSLException se) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                        Tr.event((TraceComponent)tc, (String)("Error closing inbound engine side; " + se), (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    public Class<?> getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.sslConfig.getWeight();
    }

    public SSLChannelData getConfig() {
        return this.sslConfig;
    }

    public JSSEHelper getJsseHelper() {
        return this.jsseHelper;
    }
}

