/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yoko.util.Fifa;
import org.apache.yoko.util.Fifo;
import org.apache.yoko.util.Sequential;
import org.apache.yoko.util.concurrent.Foot;
import org.apache.yoko.util.concurrent.Head;
import org.apache.yoko.util.concurrent.NNode;
import org.apache.yoko.util.concurrent.PNode;
import org.apache.yoko.util.concurrent.StrongNode;
import org.apache.yoko.util.concurrent.VNode;

class ConcurrentFifo<T>
implements Fifo<T>,
Fifa<T> {
    private final Head<T> head = new Head();
    private final Foot<T> foot = new Foot<T>(this.head);
    protected final AtomicInteger size = new AtomicInteger(0);

    ConcurrentFifo() {
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public T peek() {
        return this.recursivePeek(this.head);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T recursivePeek(PNode<T> start) {
        PNode<T> pNode = start;
        synchronized (pNode) {
            NNode<T> nn = start.next();
            if (nn == this.foot) {
                return null;
            }
            VNode node = (VNode)nn;
            Object result = node.get();
            Object t = result == null ? this.recursivePeek(node) : result;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequential.Place<T> put(T elem) {
        while (true) {
            PNode<T> pnode;
            PNode<T> pNode = pnode = this.foot.prev();
            synchronized (pNode) {
                if (pnode.next() == this.foot) {
                    VNode<T> node;
                    VNode<T> vNode = node = this.createNode(elem);
                    synchronized (vNode) {
                        node.insertAfter(pnode);
                        this.size.incrementAndGet();
                        return new Sequential.Place<T>(){

                            @Override
                            public T relinquish() {
                                return ConcurrentFifo.this.remove(node);
                            }
                        };
                    }
                }
            }
        }
    }

    protected VNode<T> createNode(T elem) {
        return new StrongNode<T>(Objects.requireNonNull(elem));
    }

    @Override
    public T remove() {
        return this.recursiveRemove(this.head);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T recursiveRemove(PNode<T> start) {
        PNode<T> pNode = start;
        synchronized (pNode) {
            NNode<T> nn = start.next();
            if (nn == this.foot) {
                return null;
            }
            VNode node = (VNode)nn;
            Object result = node.get();
            if (result == null) {
                return this.recursiveRemove(node);
            }
            VNode vNode = node;
            synchronized (vNode) {
                node.delete();
                this.size.decrementAndGet();
                return result;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T remove(VNode<T> node) {
        PNode pNode;
        while ((pNode = node.prev()) != null) {
            PNode pNode2 = pNode;
            synchronized (pNode2) {
                if (pNode.next() == node) {
                    VNode<T> vNode = node;
                    synchronized (vNode) {
                        node.delete();
                        this.size.decrementAndGet();
                        return node.get();
                    }
                }
            }
        }
        return null;
    }
}

