/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.tx.jta.TransactionInflowManager;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jca.cm.JcaServiceUtilities;
import com.ibm.ws.jca.internal.BeanValidationHelper;
import com.ibm.ws.jca.internal.J2CTimer;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.internal.ResourceAdapterService;
import com.ibm.ws.jca.internal.SSLHelper;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.internal.WorkManagerImpl;
import com.ibm.ws.jca.security.JCASecurityContext;
import com.ibm.ws.jca.service.AdminObjectService;
import com.ibm.ws.jca.utils.metagen.MetatypeGenerator;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import com.ibm.wsspi.threadcontext.jca.JCAContextProvider;
import com.ibm.wsspi.threading.WSExecutorService;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.net.ssl.SSLSocketFactory;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BootstrapContextImpl
implements BootstrapContext,
ApplicationRecycleContext {
    private static final TraceComponent tc = Tr.register(BootstrapContextImpl.class);
    private static final String ID = "id";
    private static final String RESOURCE_ADAPTER_CLASS = "resourceadapter-class";
    private static final List<String> INTERNAL_PROPS = Arrays.asList("id", "contextServiceRef", "executorServiceRef", "objectClass");
    private static final String WASJMS = "wasJms";
    private static final String WMQJMS = "wmqJms";
    private volatile String myAppName;
    private final AtomicReference<Future<Boolean>> appsStoppedFuture = new AtomicReference();
    private ClassLoadingService classLoadingSvc;
    private ComponentContext componentContext;
    private ConnectorService connectorSvc;
    private final ConcurrentServiceReferenceMap<String, JCAContextProvider> contextProviders = new ConcurrentServiceReferenceMap("contextProvider");
    WSContextService contextSvc;
    private ServiceReference<WSContextService> contextSvcRef;
    WSExecutorService execSvc;
    private FutureMonitor futureMonitorSvc;
    private final CountDownLatch latch = new CountDownLatch(1);
    static final ConcurrentHashMap<String, CountDownLatch> latches = new ConcurrentHashMap();
    boolean propagateThreadContext;
    private Dictionary<String, ?> properties;
    private final Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private JcaServiceUtilities jcasu;
    private ClassLoader raClassLoader;
    private ResourceAdapterMetaData raMetaData;
    private ThreadContextDescriptor raThreadContextDescriptor;
    public ResourceAdapter resourceAdapter;
    String resourceAdapterID;
    private ResourceAdapterService resourceAdapterSvc;
    private final AtomicServiceReference<TransactionInflowManager> tranInflowManagerRef = new AtomicServiceReference("tranInflowManager");
    private final AtomicServiceReference<TransactionSynchronizationRegistry> tranSyncRegistryRef = new AtomicServiceReference("tranSyncRegistry");
    private final AtomicServiceReference<Object> bvalRef = new AtomicServiceReference("beanValidationService");
    private final AtomicServiceReference<JCASecurityContext> jcaSecurityContextRef = new AtomicServiceReference("jcaSecurityContextService");
    final ConcurrentLinkedQueue<Timer> timers = new ConcurrentLinkedQueue();
    private WorkManagerImpl workManager;
    private BeanValidationHelper bvalHelper = null;
    static final long serialVersionUID = 3272773346802428295L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void activate(ComponentContext context) throws Exception {
        Dictionary props = context.getProperties();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{props});
        }
        this.resourceAdapterID = (String)props.get(ID);
        this.contextProviders.activate(context);
        this.bvalRef.activate(context);
        this.tranInflowManagerRef.activate(context);
        this.tranSyncRegistryRef.activate(context);
        this.jcaSecurityContextRef.activate(context);
        this.componentContext = context;
        this.properties = props;
        this.raMetaData = this.resourceAdapterSvc.getResourceAdapterMetaData();
        this.myAppName = this.raMetaData != null ? this.raMetaData.getJ2EEName().getApplication() : null;
        Object svc = this.bvalRef.getService();
        if (svc != null) {
            this.bvalHelper = System.getSecurityManager() == null ? (BeanValidationHelper)this.componentContext.getBundleContext().getBundle().loadClass("com.ibm.ws.jca.internal.BeanValidationHelperImpl").newInstance() : AccessController.doPrivileged(new PrivilegedExceptionAction<BeanValidationHelper>(){
                static final long serialVersionUID = 5292383722689060866L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public BeanValidationHelper run() throws IllegalAccessException, ClassNotFoundException, InstantiationException {
                    return (BeanValidationHelper)BootstrapContextImpl.this.componentContext.getBundleContext().getBundle().loadClass("com.ibm.ws.jca.internal.BeanValidationHelperImpl").newInstance();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            this.bvalHelper.setBeanValidationSvc(svc);
        }
        this.resourceAdapter = this.configureResourceAdapter();
        if (this.resourceAdapter != null) {
            this.propagateThreadContext = !"(service.pid=com.ibm.ws.context.manager)".equals(this.properties.get("contextService.target"));
            this.workManager = new WorkManagerImpl(this);
            this.contextSvc = (WSContextService)Utils.priv.getService(this.componentContext, this.contextSvcRef);
            this.jcasu = new JcaServiceUtilities();
            this.raThreadContextDescriptor = this.captureRaThreadContext(this.contextSvc);
            this.raClassLoader = this.resourceAdapterSvc.getClassLoader();
            this.raClassLoader = this.raClassLoader == null ? null : this.classLoadingSvc.createThreadContextClassLoader(this.raClassLoader);
            ArrayList<ThreadContext> threadContext = this.startTask(this.raThreadContextDescriptor);
            try {
                this.beginContext(this.raMetaData);
                try {
                    ClassLoader previousClassLoader = this.jcasu.beginContextClassLoader(this.raClassLoader);
                    try {
                        this.resourceAdapter.start((BootstrapContext)this);
                    }
                    finally {
                        this.jcasu.endContextClassLoader(this.raClassLoader, previousClassLoader);
                    }
                }
                finally {
                    this.endContext(this.raMetaData);
                }
            }
            finally {
                this.stopTask(this.raThreadContextDescriptor, threadContext);
            }
        }
        latches.put(this.resourceAdapterID, this.latch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @FFDCIgnore(value={NumberFormatException.class, Throwable.class})
    public void configure(Object instance, String id, Map<String, ?> configProps, @Sensitive Map<String, Object> activationProps, AdminObjectService adminObjSvc, AtomicServiceReference<AdminObjectService> destinationRef) throws Exception {
        ComponentMetaData cmd;
        String methodName = "configure";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"configure", (Object[])new Object[]{instance, id, configProps, activationProps, adminObjSvc, destinationRef});
        }
        if (instance instanceof ResourceAdapterAssociation && this.resourceAdapter != null) {
            ((ResourceAdapterAssociation)instance).setResourceAdapter(this.resourceAdapter);
        }
        HashSet<String> invalidPropNames = new HashSet<String>(configProps.keySet());
        if (activationProps != null) {
            invalidPropNames.addAll(activationProps.keySet());
        }
        Class<?> objectClass = instance.getClass();
        for (PropertyDescriptor descriptor : Introspector.getBeanInfo(objectClass).getPropertyDescriptors()) {
            Method writeMethod = descriptor.getWriteMethod();
            Class<?> type = descriptor.getPropertyType();
            String name = MetatypeGenerator.toCamelCase((String)descriptor.getName());
            Object value = null;
            if (activationProps != null && (value = activationProps.get(name)) == null) {
                value = activationProps.get(descriptor.getName());
            }
            try {
                if (value == null && (value = configProps.get(name)) == null && writeMethod != null) {
                    PropertyDescriptor raPropDescriptor = this.propertyDescriptors.get(name);
                    Method getter = raPropDescriptor == null ? null : raPropDescriptor.getReadMethod();
                    Object object = value = getter == null ? this.properties.get(name) : getter.invoke((Object)this.resourceAdapter, new Object[0]);
                }
                if (value != null) {
                    invalidPropNames.remove(name);
                }
                if ("destination".equals(name)) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"name, value before getDestination", (Object[])new Object[]{name, value});
                    }
                    value = this.getDestination(value, type, (String)configProps.get("destinationType"), destinationRef, activationProps, adminObjSvc);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"value after getDestination", (Object[])new Object[]{value});
                    }
                }
                if (value == null) continue;
                boolean isProtectedString = value instanceof SerializableProtectedString;
                if (isProtectedString) {
                    value = new String(((SerializableProtectedString)value).getChars());
                }
                if (value instanceof String && name.toUpperCase().indexOf("PASSWORD") >= 0) {
                    value = PasswordUtil.getCryptoAlgorithm((String)((String)value)) == null ? value : PasswordUtil.decode((String)((String)value));
                    isProtectedString = true;
                    if (name.length() == 8 && (instance instanceof ManagedConnectionFactory || activationProps != null && !activationProps.containsKey("password"))) {
                        ConnectorService.logMessage((Level)Level.INFO, (String)"RECOMMEND_AUTH_ALIAS_J2CA8050", (Object[])new Object[]{id});
                    }
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set " + name + '=' + (isProtectedString ? "***" : value)), (Object[])new Object[0]);
                }
                if (value instanceof String) {
                    if (!type.isAssignableFrom(value.getClass())) {
                        if (SSLSocketFactory.class.equals(type)) {
                            BundleContext bundleContext = Utils.priv.getBundleContext(this.componentContext);
                            ServiceReference sslHelperRef = Utils.priv.getServiceReference(bundleContext, SSLHelper.class);
                            SSLHelper sslHelper = (SSLHelper)Utils.priv.getService(bundleContext, SSLHelper.class);
                            try {
                                value = sslHelper.getSSLSocketFactory((String)value);
                            }
                            finally {
                                bundleContext.ungetService(sslHelperRef);
                            }
                        } else {
                            try {
                                value = Utils.convert((String)value, type);
                            }
                            catch (NumberFormatException numFormatX) {
                                try {
                                    writeMethod = objectClass.getMethod(writeMethod.getName(), String.class);
                                }
                                catch (NoSuchMethodException sslHelperRef) {
                                    Object[] objectArray = new Object[6];
                                    objectArray[0] = instance;
                                    objectArray[1] = id;
                                    objectArray[2] = configProps;
                                    objectArray[3] = "<sensitive java.util.Map>";
                                    objectArray[4] = adminObjSvc;
                                    objectArray[5] = destinationRef;
                                    FFDCFilter.processException((Throwable)sslHelperRef, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"451", (Object)this, (Object[])objectArray);
                                    throw numFormatX;
                                }
                            }
                        }
                    }
                } else if (String.class.equals(type)) {
                    value = value.toString();
                } else if (value instanceof Number && !type.isAssignableFrom(value.getClass())) {
                    value = Utils.convert((Number)value, type);
                }
                writeMethod.invoke(instance, value);
            }
            catch (Throwable x) {
                x = x instanceof InvocationTargetException ? x.getCause() : x;
                x = Utils.ignoreWarnOrFail(tc, x, x.getClass(), "J2CA8500.config.prop.error", name, id, objectClass.getName(), x);
                if (x == null) continue;
                InvalidPropertyException propX = x instanceof InvalidPropertyException ? (InvalidPropertyException)x : new InvalidPropertyException(name, x);
                propX.setInvalidPropertyDescriptors(new PropertyDescriptor[]{descriptor});
                FFDCFilter.processException((Throwable)propX, (String)this.getClass().getName(), (String)"134");
                throw propX;
            }
        }
        for (String name : invalidPropNames) {
            InvalidPropertyException x = Utils.ignoreWarnOrFail(tc, null, InvalidPropertyException.class, "J2CA8501.config.prop.unknown", name, id, objectClass.getName());
            if (x == null) continue;
            FFDCFilter.processException((Throwable)x, (String)Utils.class.getName(), (String)"146");
            throw x;
        }
        if (this.bvalHelper != null && (cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData()) != null) {
            this.bvalHelper.validateInstance(cmd.getModuleMetaData(), this.resourceAdapterSvc.getClassLoader(), instance);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"configure");
        }
    }

    @FFDCIgnore(value={NumberFormatException.class, Throwable.class})
    private ResourceAdapter configureResourceAdapter() throws Exception {
        ResourceAdapterMetaData raMetaData;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String resourceAdapterClassName = (String)this.properties.get(RESOURCE_ADAPTER_CLASS);
        if (resourceAdapterClassName == null) {
            return null;
        }
        ResourceAdapter instance = (ResourceAdapter)this.loadClass(resourceAdapterClassName).newInstance();
        HashSet<Object> invalidPropNames = new HashSet<Object>();
        Enumeration<String> names = this.properties.keys();
        while (names.hasMoreElements()) {
            PropertyDescriptor[] name = names.nextElement();
            if (INTERNAL_PROPS.contains(name) || "objectClass".equals(name) || name.indexOf(46) >= 0 || name.indexOf(45) >= 0 || name.endsWith("Ref")) continue;
            invalidPropNames.add(name);
        }
        Class<?> objectClass = instance.getClass();
        for (PropertyDescriptor descriptor : Introspector.getBeanInfo(objectClass).getPropertyDescriptors()) {
            String name = MetatypeGenerator.toCamelCase((String)descriptor.getName());
            Object value = this.properties.get(name);
            this.propertyDescriptors.put(name, descriptor);
            if (value == null) continue;
            try {
                invalidPropNames.remove(name);
                boolean isProtectedString = value instanceof SerializableProtectedString;
                if (isProtectedString) {
                    value = new String(((SerializableProtectedString)value).getChars());
                }
                if (value instanceof String && name.toUpperCase().indexOf("PASSWORD") >= 0) {
                    value = PasswordUtil.getCryptoAlgorithm((String)((String)value)) == null ? value : PasswordUtil.decode((String)((String)value));
                    isProtectedString = true;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set " + name + '=' + (isProtectedString ? "***" : value)), (Object[])new Object[0]);
                }
                Class<?> type = descriptor.getPropertyType();
                Method writeMethod = descriptor.getWriteMethod();
                if (value instanceof String) {
                    if (!type.isAssignableFrom(value.getClass())) {
                        try {
                            value = Utils.convert((String)value, type);
                        }
                        catch (NumberFormatException numFormatX) {
                            try {
                                writeMethod = objectClass.getMethod(writeMethod.getName(), String.class);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"552", (Object)this, (Object[])new Object[0]);
                                throw numFormatX;
                            }
                        }
                    }
                } else if (String.class.equals(type)) {
                    value = value.toString();
                } else if (value instanceof Number && !type.isAssignableFrom(value.getClass())) {
                    value = Utils.convert((Number)value, type);
                }
                writeMethod.invoke((Object)instance, value);
            }
            catch (Throwable x) {
                x = x instanceof InvocationTargetException ? x.getCause() : x;
                x = Utils.ignoreWarnOrFail(tc, x, x.getClass(), "J2CA8500.config.prop.error", name, this.getConfigElementName(), objectClass.getName(), x);
                if (x == null) continue;
                InvalidPropertyException propX = new InvalidPropertyException(name, x);
                propX.setInvalidPropertyDescriptors(new PropertyDescriptor[]{descriptor});
                FFDCFilter.processException((Throwable)propX, (String)this.getClass().getName(), (String)"239");
                throw propX;
            }
        }
        for (String string : invalidPropNames) {
            InvalidPropertyException x = Utils.ignoreWarnOrFail(tc, null, InvalidPropertyException.class, "J2CA8501.config.prop.unknown", string, this.getConfigElementName(), objectClass.getName());
            if (x == null) continue;
            FFDCFilter.processException((Throwable)x, (String)Utils.class.getName(), (String)"249");
            throw x;
        }
        if (this.bvalHelper != null && (raMetaData = this.resourceAdapterSvc.getResourceAdapterMetaData()) != null) {
            this.bvalHelper.validateInstance(raMetaData.getModuleMetaData(), this.resourceAdapterSvc.getClassLoader(), instance);
        }
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    public Timer createTimer() throws UnavailableException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Timer>(){
                static final long serialVersionUID = 3156038826887226212L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Timer run() throws UnavailableException {
                    return new J2CTimer(BootstrapContextImpl.this);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"606", (Object)this, (Object[])new Object[0]);
            throw (UnavailableException)e.getException();
        }
    }

    protected void deactivate(ComponentContext context) throws Exception {
        this.contextProviders.deactivate(context);
        this.bvalRef.deactivate(context);
        this.tranInflowManagerRef.deactivate(context);
        this.tranSyncRegistryRef.deactivate(context);
        this.jcaSecurityContextRef.deactivate(context);
        this.latch.countDown();
        latches.remove(this.resourceAdapterID, this.latch);
        FutureMonitor futureMonitor = this.futureMonitorSvc;
        Future future = this.appsStoppedFuture.getAndSet(null);
        if (futureMonitor != null && future != null) {
            futureMonitor.onCompletion(future, (CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = 9196643888431362988L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    BootstrapContextImpl.this.stopResourceAdapter();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    BootstrapContextImpl.this.stopResourceAdapter();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        } else {
            this.stopResourceAdapter();
        }
    }

    @Trivial
    private final String getConfigElementName() {
        return WMQJMS.equals(this.resourceAdapterID) ? "wmqJmsClient" : (WASJMS.equals(this.resourceAdapterID) ? this.resourceAdapterID : "properties." + this.resourceAdapterID);
    }

    public final ConnectorService getConnectorService() {
        return this.connectorSvc;
    }

    @ManualTrace
    private Object getDestination(Object value, Class<?> type, String destinationType, AtomicServiceReference<AdminObjectService> destinationRef, @Sensitive Map<String, Object> activationProps, AdminObjectService adminObjSvc) throws Exception {
        boolean isJNDIName;
        boolean isString;
        String methodName = "getDestination";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDestination", (Object[])new Object[]{value, type, destinationType, destinationRef, activationProps, adminObjSvc});
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Resource adapter id", (Object[])new Object[]{this.resourceAdapterID});
        }
        String savedValue = (isString = String.class.equals(type)) ? (String)value : null;
        boolean bl = isJNDIName = this.resourceAdapterID.equals(WMQJMS) && isString && activationProps != null && Boolean.parseBoolean((String)activationProps.get("useJNDI"));
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isString, isJNDIName, savedValue", (Object[])new Object[]{isString, isJNDIName, savedValue});
        }
        if (adminObjSvc != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"use adminObjSvc found by MDB runtime", (Object[])new Object[0]);
            }
            if (isJNDIName) {
                value = adminObjSvc.getJndiName();
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"useJNDI name was specified, using jndiName from the admin obj svc from mdb", (Object[])new Object[]{value});
                }
            } else {
                value = adminObjSvc.createResource(null);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"created admin object resource using admin object service from mdb runtime", (Object[])new Object[]{value});
                }
            }
        } else {
            ServiceReference reference;
            ServiceReference serviceReference = reference = destinationRef != null ? destinationRef.getReference() : null;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"reference", (Object[])new Object[]{reference});
            }
            if (reference != null && !"com.ibm.ws.jca.destination.unspecified".equals(reference.getProperty("component.name")) && (value == null || value.equals(reference.getProperty(ID)) || value.equals(reference.getProperty("jndiName")))) {
                if (isJNDIName) {
                    value = reference.getProperty("jndiName");
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"return JNDI name", (Object[])new Object[]{value});
                    }
                } else {
                    value = ((AdminObjectService)destinationRef.getServiceWithException()).createResource(null);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"return the created resource based on destinationRef", (Object[])new Object[]{value});
                    }
                }
            } else if (value != null && reference != null) {
                String filter;
                BundleContext bundleContext;
                Collection refs;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"use bundle context", (Object[])new Object[0]);
                }
                if ((refs = Utils.priv.getServiceReferences(bundleContext = Utils.priv.getBundleContext(this.componentContext), AdminObjectService.class, filter = FilterUtils.createPropertyFilter((String)ID, (String)((String)value)))).isEmpty() && (refs = Utils.priv.getServiceReferences(bundleContext, AdminObjectService.class, filter = FilterUtils.createPropertyFilter((String)"jndiName", (String)((String)value)))).isEmpty()) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("An administered object for " + value + " was not found.  This is ok if one was not provided."), (Object[])new Object[0]);
                    }
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getDestination");
                    }
                    return value;
                }
                reference = (ServiceReference)refs.iterator().next();
                if (isJNDIName) {
                    value = reference.getProperty("jndiName");
                } else {
                    AdminObjectService destinationSvc = (AdminObjectService)Utils.priv.getService(bundleContext, reference);
                    value = destinationSvc.createResource(null);
                }
            }
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"value, savedValue", (Object[])new Object[]{value, savedValue});
        }
        if (this.resourceAdapterID.equals(WASJMS) || this.resourceAdapterID.equals(WMQJMS)) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extra processing", (Object[])new Object[0]);
            }
            if (isString && !isJNDIName) {
                String activationPropsDestinationType = activationProps == null ? null : (String)activationProps.get("destinationType");
                String string = destinationType = activationPropsDestinationType == null ? destinationType : activationPropsDestinationType;
                if (destinationType == null) {
                    destinationType = (String)this.properties.get("destinationType");
                }
                if (destinationType != null) {
                    value = this.getDestinationName(destinationType, value);
                }
            }
        } else {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extra processing skipped", (Object[])new Object[0]);
            }
            if (savedValue != null) {
                value = savedValue;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"value, savedValue", (Object[])new Object[]{value, savedValue});
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDestination");
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private Object getDestinationName(String destinationType, Object destination) throws Exception {
        String methodName;
        if ("javax.jms.Queue".equals(destinationType)) {
            methodName = "getQueueName";
        } else if ("javax.jms.Topic".equals(destinationType)) {
            methodName = "getTopicName";
        } else {
            throw new InvalidPropertyException("destinationType: " + destinationType);
        }
        try {
            return destination.getClass().getMethod(methodName, new Class[0]).invoke(destination, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void x;
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"810", (Object)this, (Object[])new Object[]{destinationType, destination});
            throw new InvalidPropertyException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA8505.destination.type.mismatch", (Object[])new Object[]{destination, destinationType}), (Throwable)x);
        }
    }

    JCAContextProvider getJCAContextProvider(Class<?> workContextClass) {
        JCAContextProvider provider = null;
        for (Class<?> cl = workContextClass; provider == null && cl != null; cl = cl.getSuperclass()) {
            provider = (JCAContextProvider)this.contextProviders.getService((Object)cl.getName());
        }
        return provider;
    }

    String getJCAContextProviderName(Class<?> workContextClass) {
        String name;
        ServiceReference ref = null;
        for (Class<?> cl = workContextClass; ref == null && cl != null; cl = cl.getSuperclass()) {
            ref = this.contextProviders.getReference((Object)cl.getName());
        }
        String string = name = ref == null ? null : (String)ref.getProperty("context.name");
        if (name == null && ref != null) {
            name = (String)ref.getProperty("component.name");
        }
        return name;
    }

    @Trivial
    public ClassLoader getRaClassLoader() {
        return this.raClassLoader;
    }

    @Trivial
    public final ResourceAdapterMetaData getResourceAdapterMetaData() {
        return this.resourceAdapterSvc.getResourceAdapterMetaData();
    }

    @Trivial
    public final String getResourceAdapterName() {
        return this.resourceAdapterID;
    }

    @Trivial
    public JCASecurityContext getJCASecurityContext() {
        return (JCASecurityContext)this.jcaSecurityContextRef.getService();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)this.tranSyncRegistryRef.getServiceWithException();
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public XATerminator getXATerminator() {
        return ((TransactionInflowManager)this.tranInflowManagerRef.getServiceWithException()).getXATerminator(this.resourceAdapterID);
    }

    public boolean isContextSupported(Class<? extends WorkContext> workContextClass) {
        return HintsContext.class.equals(workContextClass) || this.getJCAContextProvider(workContextClass) != null;
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> loadClass(final String className) throws ClassNotFoundException {
        ClassLoader raClassLoader = this.resourceAdapterSvc.getClassLoader();
        if (raClassLoader != null) {
            return Utils.priv.loadClass(raClassLoader, className);
        }
        try {
            if (System.getSecurityManager() == null) {
                for (Bundle bundle : this.componentContext.getBundleContext().getBundles()) {
                    if (this.resourceAdapterID.equals(WASJMS) && ("com.ibm.ws.messaging.jms.1.1".equals(bundle.getSymbolicName()) || "com.ibm.ws.messaging.jms.2.0".equals(bundle.getSymbolicName()))) {
                        return bundle.loadClass(className);
                    }
                    if (!this.resourceAdapterID.equals(WMQJMS) || !"com.ibm.ws.messaging.jms.wmq".equals(bundle.getSymbolicName())) continue;
                    return bundle.loadClass(className);
                }
                throw new ClassNotFoundException(className);
            }
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){
                    static final long serialVersionUID = 8505429880389456330L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        for (Bundle bundle : BootstrapContextImpl.this.componentContext.getBundleContext().getBundles()) {
                            if (BootstrapContextImpl.this.resourceAdapterID.equals(BootstrapContextImpl.WASJMS) && ("com.ibm.ws.messaging.jms.1.1".equals(bundle.getSymbolicName()) || "com.ibm.ws.messaging.jms.2.0".equals(bundle.getSymbolicName()))) {
                                return bundle.loadClass(className);
                            }
                            if (!BootstrapContextImpl.this.resourceAdapterID.equals(BootstrapContextImpl.WMQJMS) || !"com.ibm.ws.messaging.jms.wmq".equals(bundle.getSymbolicName())) continue;
                            return bundle.loadClass(className);
                        }
                        throw new ClassNotFoundException(className);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(4.class);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"944", (Object)this, (Object[])new Object[]{className});
                throw (ClassNotFoundException)e.getCause();
            }
        }
        catch (ClassNotFoundException e) {
            void cnf;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"948", (Object)this, (Object[])new Object[]{className});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Could not find adapter file and bundle does not have the class either. Possible cause is incorrectly specified file path.", (Object[])new Object[]{cnf});
            }
            throw cnf;
        }
    }

    protected void setClassLoadingService(ClassLoadingService svc) {
        this.classLoadingSvc = svc;
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    protected void setContextProvider(ServiceReference<JCAContextProvider> ref) {
        this.contextProviders.putReference((Object)((String)ref.getProperty("type")), ref);
    }

    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextSvcRef = ref;
    }

    protected void setExecutorService(ExecutorService svc) {
        this.execSvc = (WSExecutorService)svc;
    }

    protected void setRequiredContextProvider(ServiceReference<JCAContextProvider> ref) {
        this.contextProviders.putReference((Object)((String)ref.getProperty("type")), ref);
    }

    protected void setResourceAdapterService(ResourceAdapterService svc) {
        this.resourceAdapterSvc = svc;
    }

    protected void setBeanValidationService(ServiceReference<Object> ref) throws Exception {
        this.bvalRef.setReference(ref);
    }

    protected void setTranInflowManager(ServiceReference<TransactionInflowManager> ref) {
        this.tranInflowManagerRef.setReference(ref);
    }

    protected void setTranSyncRegistry(ServiceReference<TransactionSynchronizationRegistry> ref) {
        this.tranSyncRegistryRef.setReference(ref);
    }

    protected void setJcaSecurityContextService(ServiceReference<JCASecurityContext> ref) {
        this.jcaSecurityContextRef.setReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopResourceAdapter() {
        if (this.resourceAdapter != null) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"stop", (Object[])new Object[]{this.resourceAdapter});
                }
                ArrayList<ThreadContext> threadContext = this.startTask(this.raThreadContextDescriptor);
                try {
                    this.beginContext(this.raMetaData);
                    try {
                        ClassLoader previousClassLoader = this.jcasu.beginContextClassLoader(this.raClassLoader);
                        try {
                            this.resourceAdapter.stop();
                        }
                        finally {
                            if (this.raClassLoader != null) {
                                this.jcasu.endContextClassLoader(this.raClassLoader, previousClassLoader);
                                this.classLoadingSvc.destroyThreadContextClassLoader(this.raClassLoader);
                            }
                        }
                    }
                    finally {
                        this.endContext(this.raMetaData);
                    }
                }
                finally {
                    this.stopTask(this.raThreadContextDescriptor, threadContext);
                }
                Timer timer = this.timers.poll();
                while (timer != null) {
                    timer.cancel();
                    timer.purge();
                    timer = this.timers.poll();
                }
                this.workManager.stop();
            }
            catch (Throwable bundleContext) {
                FFDCFilter.processException((Throwable)bundleContext, (String)"com.ibm.ws.jca.internal.BootstrapContextImpl", (String)"1096", (Object)this, (Object[])new Object[0]);
            }
            finally {
                BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                if (bundleContext != null) {
                    bundleContext.ungetService(this.contextSvcRef);
                }
            }
        }
    }

    private ThreadContextDescriptor captureRaThreadContext(WSContextService contextSvc) {
        HashMap<String, String> execProps = new HashMap<String, String>();
        execProps.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "ALL_CONTEXT_TYPES");
        execProps.put("com.ibm.ws.concurrent.REQUIRE_AVAILABLE_APP", "false");
        return contextSvc.captureThreadContext(execProps, new Map[0]);
    }

    private ArrayList<ThreadContext> startTask(ThreadContextDescriptor raThreadContextDescriptor) {
        return raThreadContextDescriptor == null ? null : raThreadContextDescriptor.taskStarting();
    }

    private void stopTask(ThreadContextDescriptor raThreadContextDescriptor, ArrayList<ThreadContext> threadContext) {
        if (raThreadContextDescriptor != null) {
            raThreadContextDescriptor.taskStopping(threadContext);
        }
    }

    private void beginContext(ComponentMetaData raMetaData) {
        if (raMetaData != null) {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(raMetaData);
        }
    }

    private void endContext(ComponentMetaData raMetaData) {
        if (raMetaData != null) {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        }
    }

    public String getAppName() {
        return this.myAppName;
    }

    public Future<Boolean> getAppsStoppedFuture() {
        Future future;
        while ((future = this.appsStoppedFuture.get()) == null) {
            if (this.futureMonitorSvc == null) {
                return null;
            }
            future = this.futureMonitorSvc.createFuture(Boolean.class);
            if (this.appsStoppedFuture.compareAndSet(null, future)) break;
            this.futureMonitorSvc.setResult(future, (Object)true);
        }
        return future;
    }

    protected void unsetClassLoadingService(ClassLoadingService svc) {
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    protected void unsetContextProvider(ServiceReference<JCAContextProvider> ref) {
        this.contextProviders.removeReference((Object)((String)ref.getProperty("type")), ref);
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
    }

    protected void unsetExecutorService(ExecutorService svc) {
        this.execSvc = null;
    }

    protected void unsetRequiredContextProvider(ServiceReference<JCAContextProvider> ref) {
        this.contextProviders.removeReference((Object)((String)ref.getProperty("type")), ref);
    }

    protected void unsetResourceAdapterService(ResourceAdapterService svc) {
        this.resourceAdapterSvc = null;
    }

    protected void unsetBeanValidationService(ServiceReference<Object> ref) {
        this.bvalRef.unsetReference(ref);
    }

    protected void unsetTranInflowManager(ServiceReference<TransactionInflowManager> ref) {
        this.tranInflowManagerRef.unsetReference(ref);
    }

    protected void unsetTranSyncRegistry(ServiceReference<TransactionSynchronizationRegistry> ref) {
        this.tranSyncRegistryRef.unsetReference(ref);
    }

    protected void unsetJcaSecurityContextService(ServiceReference<JCASecurityContext> ref) {
        this.jcaSecurityContextRef.unsetReference(ref);
    }

    protected void setFutureMonitor(FutureMonitor svc) {
        this.futureMonitorSvc = svc;
    }

    protected void unsetFutureMonitor(FutureMonitor svc) {
        this.futureMonitorSvc = null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -7225528254119056915L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.setProperty("com.ibm.ws390.jta.TransactionManager", "com.ibm.wsspi.zos.tx.RRSTXSynchronizationManager");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(5.class);
            }
        });
    }
}

