/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.management.security.ManagementRole;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AdministratorRole
implements ManagementRole {
    private static final TraceComponent tc = Tr.register(AdministratorRole.class);
    static final String CFG_KEY_USER = "user";
    static final String CFG_KEY_USER_ACCESSID = "user-access-id";
    static final String CFG_KEY_GROUP = "group";
    static final String CFG_KEY_GROUP_ACCESSID = "group-access-id";
    private final Set<String> users = new HashSet<String>();
    private final Set<String> groups = new HashSet<String>();
    static final long serialVersionUID = 2310864491181038844L;

    protected synchronized void activate(Map<String, Object> props) {
        this.resetBindings();
        this.updateBindings(props);
    }

    protected synchronized void modify(Map<String, Object> props) {
        this.resetBindings();
        this.updateBindings(props);
    }

    protected synchronized void deactivate() {
        this.resetBindings();
    }

    private void resetBindings() {
        this.users.clear();
        this.groups.clear();
    }

    private void updateBindings(Map<String, Object> props) {
        this.processProps(props, CFG_KEY_USER, this.users);
        this.processProps(props, CFG_KEY_USER_ACCESSID, this.users);
        this.processProps(props, CFG_KEY_GROUP, this.groups);
        this.processProps(props, CFG_KEY_GROUP_ACCESSID, this.groups);
    }

    private void processProps(Map<String, Object> props, String element, Set<String> entries) {
        HashSet<String> badEntries = new HashSet<String>();
        String[] cfgEntries = (String[])props.get(element);
        if (cfgEntries != null) {
            for (String entry : cfgEntries) {
                if (badEntries.contains(entry) || entry.trim().isEmpty()) continue;
                if (CFG_KEY_USER_ACCESSID.equals(element) || CFG_KEY_GROUP_ACCESSID.equals(element)) {
                    String updateAccessId = this.getCompleteAccessId(element, entry);
                    if (updateAccessId == null) {
                        if (!badEntries.contains(entry)) {
                            badEntries.add(entry);
                            continue;
                        }
                    } else {
                        entry = updateAccessId;
                    }
                }
                if (entries.add(entry)) continue;
                Tr.error((TraceComponent)tc, (String)"ROLE_ENTRY_DUPLICATE", (Object[])new Object[]{this.getRoleName(), element, entry});
                badEntries.add(entry);
                entries.remove(entry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Administrator role " + element + " binding"), (Object[])new Object[]{entries});
        }
    }

    private String getCompleteAccessId(String element, String accessId) {
        String updateAccessId = null;
        if (AccessIdUtil.isAccessId((String)accessId)) {
            return accessId;
        }
        String type = CFG_KEY_USER_ACCESSID.equals(element) ? CFG_KEY_USER : CFG_KEY_GROUP;
        updateAccessId = type + ":" + accessId;
        if (AccessIdUtil.isAccessId((String)updateAccessId)) {
            return updateAccessId;
        }
        Tr.error((TraceComponent)tc, (String)("Invalid " + element), (Object[])new Object[]{accessId});
        return null;
    }

    @Override
    public String getRoleName() {
        return "Administrator";
    }

    @Override
    public synchronized Set<String> getUsers() {
        return this.users;
    }

    @Override
    public synchronized Set<String> getGroups() {
        return this.groups;
    }
}

