/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.info.internal.AnnotationInfoImpl;
import com.ibm.ws.anno.info.internal.ClassInfoImpl;
import com.ibm.ws.anno.info.internal.FieldInfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreImpl;
import com.ibm.ws.anno.info.internal.MethodInfoImpl;
import com.ibm.ws.anno.info.internal.NonDelayedClassInfo;
import com.ibm.ws.anno.info.internal.PackageInfoImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DelayedClassInfo
extends ClassInfoImpl {
    private static final TraceComponent tc = Tr.register(DelayedClassInfo.class);
    public static final String CLASS_NAME = DelayedClassInfo.class.getName();
    protected String[] logParms;
    public static final int HASH_OFFSET = 0;
    public static final int EXTRA_DATA_OFFSET_0 = 1;
    public static final int EXTRA_DATA_OFFSET_1 = 2;
    protected NonDelayedClassInfo classInfo;
    protected boolean isArtificial;
    protected boolean isModifiersSet;
    protected String packageName;
    protected PackageInfoImpl packageInfo;
    protected boolean isJavaClass;
    private List<String> interfaceNames;
    protected Boolean isInterface;
    protected Boolean isAnnotationClass;
    protected String superclassName;
    protected ClassInfoImpl superclass;
    Boolean isEmptyDeclaredFields;
    protected Boolean isEmptyDeclaredConstructors;
    Boolean isEmptyDeclaredMethods;
    Boolean isEmptyMethods;
    protected Boolean isDeclaredAnnotationPresent;
    protected Boolean isAnnotationPresent;
    protected Boolean isFieldAnnotationPresent;
    protected Boolean isMethodAnnotationPresent;
    static final long serialVersionUID = 127533883928769065L;

    public DelayedClassInfo(String name, InfoStoreImpl infoStore) {
        super(name, 0, infoStore);
        this.packageName = this.getInfoStore().internPackageName(ClassInfoImpl.getPackageName(name));
        this.packageInfo = null;
        this.isJavaClass = ClassInfoImpl.isJavaClass(name);
        this.classInfo = null;
        this.isArtificial = false;
        if (tc.isDebugEnabled()) {
            this.setLogParms();
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Created for ", this.getHashText()), (Object[])new Object[0]);
        }
    }

    public String[] getLogParms() {
        return this.logParms;
    }

    protected String[] setLogParms() {
        this.logParms = new String[]{this.getHashText(), null, null};
        return this.logParms;
    }

    @Override
    public boolean isDelayedClass() {
        return true;
    }

    @Override
    public ClassInfoImpl asDelayedClass() {
        return this;
    }

    public void setClassInfo(NonDelayedClassInfo classInfo) {
        String[] useLogParms = this.getLogParms();
        if (useLogParms != null) {
            useLogParms[1] = this.classInfo != null ? this.classInfo.getHashText() : null;
            useLogParms[2] = classInfo != null ? classInfo.getHashText() : null;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] - Update class info [ {1} ] to [ {2} ]", this.logParms), (Object[])new Object[0]);
        }
        this.classInfo = classInfo;
    }

    public NonDelayedClassInfo getClassInfo() {
        String useName = this.getName();
        NonDelayedClassInfo useClassInfo = this.classInfo;
        if (useClassInfo != null) {
            if (!(useClassInfo.isJavaClass() || useClassInfo.isAnnotationPresent() || useClassInfo.isFieldAnnotationPresent() || useClassInfo.isMethodAnnotationPresent())) {
                this.getInfoStore().recordAccess(useClassInfo);
            }
            return useClassInfo;
        }
        useClassInfo = this.getInfoStore().resolveClassInfo(useName);
        String[] useLogParms = this.getLogParms();
        if (useLogParms != null) {
            useLogParms[1] = useName;
        }
        if (useClassInfo == null) {
            if (useLogParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] - Class not found [ {1} ]", useLogParms), (Object[])new Object[0]);
            }
            useClassInfo = new NonDelayedClassInfo(useName, this.getInfoStore());
            this.isArtificial = true;
            this.getInfoStore().getClassInfoCache().addClassInfo(useClassInfo);
        }
        useClassInfo.setDelayedClassInfo(this);
        this.classInfo = useClassInfo;
        if (useLogParms != null) {
            useLogParms[2] = this.classInfo.getHashText();
            if (this.isArtificial) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] as [ {2} ] ** ARTFICIAL **", useLogParms), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] as [ {2} ] ", useLogParms), (Object[])new Object[0]);
            }
        }
        return useClassInfo;
    }

    @Override
    public boolean isArtificial() {
        if (this.classInfo == null) {
            NonDelayedClassInfo useClassInfo = this.getClassInfo();
            ClassInfoImpl.consumeRef(useClassInfo);
        }
        return this.isArtificial;
    }

    @Override
    public int getModifiers() {
        if (!this.isModifiersSet) {
            this.setModifiers(this.getClassInfo().getModifiers());
            this.isModifiersSet = true;
        }
        return super.getModifiers();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public PackageInfoImpl getPackage() {
        if (this.packageInfo == null && this.packageName != null) {
            this.packageInfo = this.getInfoStore().getPackageInfo(this.packageName, true);
        }
        return this.packageInfo;
    }

    @Override
    public boolean isJavaClass() {
        return this.isJavaClass;
    }

    @Override
    public List<String> getInterfaceNames() {
        if (this.interfaceNames == null) {
            this.interfaceNames = this.getClassInfo().getInterfaceNames();
        }
        return this.interfaceNames;
    }

    public List<ClassInfoImpl> getInterfaces() {
        return this.getClassInfo().getInterfaces();
    }

    @Override
    public boolean isInterface() {
        if (this.isInterface == null) {
            this.isInterface = this.getClassInfo().isInterface();
        }
        return this.isInterface;
    }

    @Override
    public boolean isAnnotationClass() {
        if (this.isAnnotationClass == null) {
            this.isAnnotationClass = this.getClassInfo().isAnnotationClass();
        }
        return this.isAnnotationClass;
    }

    @Override
    public String getSuperclassName() {
        if (this.superclassName == null) {
            NonDelayedClassInfo useClassInfo = this.getClassInfo();
            this.superclassName = useClassInfo.getSuperclassName();
            if (this.superclassName != null || this.getName().equals("java.lang.Object") || useClassInfo.getName().equals("java.lang.Object") || !this.isInterface()) {
                // empty if block
            }
        }
        return this.superclassName;
    }

    @Override
    public ClassInfoImpl getSuperclass() {
        if (this.superclass == null) {
            String useSuperclassName = this.getSuperclassName();
            this.superclass = useSuperclassName != null ? this.getDelayableClassInfo(this.getSuperclassName()) : null;
        }
        return this.superclass;
    }

    @Override
    public boolean isInstanceOf(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        for (String iName : this.getInterfaceNames()) {
            if (!iName.equals(className)) continue;
            return true;
        }
        if (this.isInterface()) {
            return false;
        }
        ClassInfoImpl useSuperClass = this.getSuperclass();
        return useSuperClass != null && useSuperClass.isInstanceOf(className);
    }

    @Override
    public boolean isAssignableFrom(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        return this.getInfoStore().getDelayableClassInfo(className).isInstanceOf(this.getName());
    }

    public List<FieldInfoImpl> getDeclaredFields() {
        if (this.isEmptyDeclaredFields == null || !this.isEmptyDeclaredFields.booleanValue()) {
            List<FieldInfoImpl> useDeclaredFields = this.getClassInfo().getDeclaredFields();
            this.isEmptyDeclaredFields = useDeclaredFields.isEmpty();
            return useDeclaredFields;
        }
        return Collections.emptyList();
    }

    public List<MethodInfoImpl> getDeclaredConstructors() {
        if (this.isEmptyDeclaredConstructors == null || !this.isEmptyDeclaredConstructors.booleanValue()) {
            List<MethodInfoImpl> useDeclaredConstructors = this.getClassInfo().getDeclaredConstructors();
            this.isEmptyDeclaredConstructors = useDeclaredConstructors.isEmpty();
            return useDeclaredConstructors;
        }
        return Collections.emptyList();
    }

    public List<MethodInfoImpl> getDeclaredMethods() {
        if (this.isEmptyDeclaredMethods == null || !this.isEmptyDeclaredMethods.booleanValue()) {
            List<MethodInfoImpl> useDeclaredMethods = this.getClassInfo().getDeclaredMethods();
            this.isEmptyDeclaredMethods = useDeclaredMethods.isEmpty();
            return useDeclaredMethods;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MethodInfoImpl> getMethods() {
        if (this.isEmptyMethods == null || !this.isEmptyMethods.booleanValue()) {
            List<MethodInfoImpl> useMethods = this.getClassInfo().getMethods();
            this.isEmptyMethods = useMethods.isEmpty();
            return useMethods;
        }
        return Collections.emptyList();
    }

    @Override
    public List<AnnotationInfoImpl> getDeclaredAnnotations() {
        return this.getClassInfo().getDeclaredAnnotations();
    }

    @Override
    public boolean isDeclaredAnnotationPresent() {
        if (this.isDeclaredAnnotationPresent == null) {
            this.isDeclaredAnnotationPresent = this.getClassInfo().isDeclaredAnnotationPresent();
        }
        return this.isDeclaredAnnotationPresent;
    }

    @Override
    public boolean isDeclaredAnnotationPresent(String annotationName) {
        return this.getClassInfo().isDeclaredAnnotationPresent(annotationName);
    }

    @Override
    public AnnotationInfoImpl getDeclaredAnnotation(String annotationClassName) {
        return this.getClassInfo().getDeclaredAnnotation(annotationClassName);
    }

    @Override
    public boolean isAnnotationPresent() {
        if (this.isAnnotationPresent == null) {
            this.isAnnotationPresent = this.getClassInfo().isAnnotationPresent();
        }
        return this.isAnnotationPresent;
    }

    @Override
    public List<AnnotationInfoImpl> getAnnotations() {
        return this.getClassInfo().getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(String annotationName) {
        return this.getClassInfo().isAnnotationPresent(annotationName);
    }

    @Override
    public AnnotationInfoImpl getAnnotation(String annotationName) {
        return this.getClassInfo().getAnnotation(annotationName);
    }

    @Override
    public boolean isFieldAnnotationPresent() {
        if (this.isFieldAnnotationPresent == null) {
            this.isFieldAnnotationPresent = this.getClassInfo().isFieldAnnotationPresent();
        }
        return this.isFieldAnnotationPresent;
    }

    @Override
    public boolean isMethodAnnotationPresent() {
        if (this.isMethodAnnotationPresent == null) {
            this.isMethodAnnotationPresent = this.getClassInfo().isMethodAnnotationPresent();
        }
        return this.isMethodAnnotationPresent;
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Delayed Class [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  classInfo [ {0} ]", this.classInfo != null ? this.classInfo.getHashText() : null), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  isArtificial [ {0} ]", this.isArtificial), (Object[])new Object[0]);
        if (!logger.isDumpEnabled()) {
            return;
        }
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isModifiersSet [ {0} ]", this.isModifiersSet), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  modifiers [ {0} ]", this.modifiers), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  packageName [ {0} ]", this.packageName), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  packageInfo [ {0} ]", this.packageInfo != null ? this.packageInfo.getHashText() : null), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isJavaClass [ {0} ]", this.isJavaClass), (Object[])new Object[0]);
        if (this.interfaceNames != null) {
            for (String interfaceName : this.interfaceNames) {
                Tr.dump((TraceComponent)logger, (String)MessageFormat.format("    [ {0} ]", interfaceName), (Object[])new Object[0]);
            }
        }
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isInterface [ {0} ]", this.isInterface), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isAnnotationClass [ {0} ]", this.isAnnotationClass), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  superclassName [ {0} ]", this.superclassName), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  superclass [ {0} ]", this.superclass != null ? this.superclass.getHashText() : null), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isEmptyDeclaredFields [ {0} ]", this.isEmptyDeclaredFields), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isEmptyDeclaredConstructors [ {0} ]", this.isEmptyDeclaredConstructors), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isEmptyDeclaredMethods [ {0} ]", this.isEmptyDeclaredMethods), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isEmptyMethods [ {0} ]", this.isEmptyMethods), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isDeclaredAnnotationPresent [ {0} ]", this.isDeclaredAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isAnnotationPresent [ {0} ]", this.isAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isFieldAnnotationPresent [ {0} ]", this.isFieldAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)logger, (String)MessageFormat.format("  isMethodAnnotationPresent [ {0} ]", this.isMethodAnnotationPresent), (Object[])new Object[0]);
    }
}

