/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CDataEndEscapeFilterWriter
extends FilterWriter {
    private char c1;
    private char c2;
    private int pos = 0;

    public CDataEndEscapeFilterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.c1 = this.c2;
        this.c2 = (char)c;
        ++this.pos;
        if (this.pos > 2 && this.c1 == ']' && this.c2 == ']' && c == 62) {
            this.out.write("<![CDATA[]]]]><![CDATA[>");
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int index = off;
        StringBuilder sb = null;
        for (int i = 0; i < len; ++i) {
            char c = cbuf[off + i];
            if (this.c1 == ']' && this.c2 == ']' && c == '>') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(cbuf, index, i + 1 - (index - off));
                index = off + i + 1;
                sb.append("<![CDATA[]]]]><![CDATA[>");
            }
            this.c1 = this.c2;
            this.c2 = c;
            ++this.pos;
        }
        if (sb != null) {
            if (index < off + len) {
                sb.append(cbuf, index, off + len - index);
            }
            this.out.write(sb.toString());
        } else {
            this.out.write(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int index = off;
        StringBuilder sb = null;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(off + i);
            if (this.c1 == ']' && this.c2 == ']' && c == '>') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(str, index, i + 1 - (index - off));
                index = off + i + 1;
                sb.append("<![CDATA[]]]]><![CDATA[>");
            }
            this.c1 = this.c2;
            this.c2 = c;
            ++this.pos;
        }
        if (sb != null) {
            if (index < off + len) {
                sb.append(str, index, off + len - index);
            }
            this.out.write(sb.toString());
        } else {
            this.out.write(str, off, len);
        }
    }
}

