/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.util.Arrays;

public class FrameData
extends Frame {
    private int paddingLength = 0;
    private byte[] data;
    WsByteBuffer dataBuffer;

    public FrameData(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.DATA;
    }

    public FrameData(int streamId, byte[] data, int paddingLength, boolean endStream, boolean padded, boolean reserveBit) {
        super(streamId, data.length, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.data = data;
        if (data != null) {
            this.dataBuffer = this.getBuffer(data.length).put(data).flip();
        }
        this.paddingLength = paddingLength;
        this.PADDED_FLAG = padded;
        this.END_STREAM_FLAG = endStream;
        if (padded) {
            paddingLength = paddingLength > 255 ? 255 : paddingLength;
            this.payloadLength += paddingLength + 1;
        }
        this.frameType = FrameTypes.DATA;
        this.setInitialized();
    }

    public FrameData(int streamId, byte[] data, boolean endStream) {
        super(streamId, data.length, (byte)0, false, Frame.FrameDirection.WRITE);
        this.data = data;
        if (data != null) {
            this.dataBuffer = this.getBuffer(data.length).put(data).flip();
        }
        this.PADDED_FLAG = false;
        this.END_STREAM_FLAG = endStream;
        this.frameType = FrameTypes.DATA;
        if (data != null) {
            this.writeFrameLength += data.length;
        }
        this.setInitialized();
    }

    public FrameData(int streamId, WsByteBuffer data, int length, boolean endStream) {
        super(streamId, length, (byte)0, false, Frame.FrameDirection.WRITE);
        this.dataBuffer = data;
        this.PADDED_FLAG = false;
        this.END_STREAM_FLAG = endStream;
        this.frameType = FrameTypes.DATA;
        if (data != null) {
            this.writeFrameLength += data.remaining();
        }
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.setFlags();
        int payloadIndex = 0;
        try {
            if (this.PADDED_FLAG) {
                this.paddingLength = frp.grabNextByte() & 0xFF;
                ++payloadIndex;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("PADDED_FLAG on. paddedLength = " + this.paddingLength), (Object[])new Object[0]);
                }
            }
            this.data = new byte[this.payloadLength - this.paddingLength];
            int i = 0;
            while (payloadIndex++ < this.payloadLength - this.paddingLength) {
                this.data[i] = frp.grabNextByte();
                ++i;
            }
            for (i = 0; i < this.paddingLength; ++i) {
                frp.grabNextByte();
            }
            this.setInitialized();
        }
        catch (FrameSizeException e) {
            e.setConnectionError(false);
            throw e;
        }
    }

    @Override
    public WsByteBuffer buildFrameForWrite() {
        WsByteBuffer[] output = this.buildFrameArrayForWrite();
        int size = 0;
        for (WsByteBuffer b : output) {
            if (b == null) continue;
            size += b.remaining();
        }
        WsByteBuffer singleBuffer = this.getBuffer(size);
        singleBuffer.put(output);
        singleBuffer.flip();
        return singleBuffer;
    }

    public WsByteBuffer[] buildFrameArrayForWrite() {
        WsByteBuffer[] output;
        WsByteBuffer frameHeaders;
        int headerSize = 9;
        if (this.PADDED_FLAG) {
            headerSize = 10;
        }
        byte[] frame = (frameHeaders = this.getBuffer(headerSize)).hasArray() ? frameHeaders.array() : super.createFrameArray();
        this.setFrameHeaders(frame, (byte)0);
        int frameIndex = 9;
        if (this.PADDED_FLAG) {
            utils.Move8BitstoByteArray(this.paddingLength, frame, frameIndex);
            ++frameIndex;
        }
        frameHeaders.put(frame, 0, headerSize);
        frameHeaders.flip();
        if (this.PADDED_FLAG) {
            WsByteBuffer padding = this.getBuffer(this.paddingLength);
            for (int i = 0; i < this.paddingLength; ++i) {
                padding.put((byte)0);
            }
            padding.flip();
            output = new WsByteBuffer[]{frameHeaders, this.dataBuffer, padding};
        } else {
            output = new WsByteBuffer[]{frameHeaders, this.dataBuffer};
        }
        return output;
    }

    @Override
    protected void setFlags() {
        this.END_STREAM_FLAG = utils.getFlag(this.flags, 0);
        this.PADDED_FLAG = utils.getFlag(this.flags, 3);
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public byte[] getData() {
        return this.initialized ? this.data : null;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.streamId == 0) {
            throw new ProtocolException("DATA frame stream ID cannot be 0x0");
        }
        if (this.getPayloadLength() > settings.getMaxFrameSize()) {
            throw new FrameSizeException("DATA payload greater than allowed by the max frame size");
        }
        if (this.payloadLength > 0 && this.paddingLength > 0 && this.paddingLength >= this.payloadLength) {
            throw new ProtocolException("DATA padding length must be less than the length of the total payload");
        }
        if (this.paddingLength < 0) {
            throw new ProtocolException("DATA padding length is invalid");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameData)) {
            return false;
        }
        FrameData frameDataToCompare = (FrameData)object;
        if (!super.equals(frameDataToCompare)) {
            return false;
        }
        if (this.getPaddingLength() != frameDataToCompare.getPaddingLength()) {
            return false;
        }
        return Arrays.equals(this.getData(), frameDataToCompare.getData());
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("PaddingLength: " + this.getPaddingLength() + "\n");
        byte[] ba = this.getData();
        if (ba == null) {
            frameToString.append("Data: null");
        } else {
            int length = ba.length;
            if (length > 512) {
                length = 512;
            }
            StringBuffer sbuf = this.printCharArrayWithHex(ba, length);
            frameToString.append(sbuf.toString());
        }
        return frameToString.toString();
    }

    public StringBuffer printCharArrayWithHex(byte[] x, int length) {
        StringBuffer sb = new StringBuffer("Data: (up to first 512 btytes):\n");
        int count = 0;
        for (int i = 0; i < length; ++i) {
            byte b = x[i];
            char c = (char)b;
            if (++count % 64 == 0 && b != 10) {
                if (b == 13) {
                    sb.append("<CR>");
                    count = 0;
                    continue;
                }
                if (b > 0 && b < 127) {
                    sb.append(c);
                    count = 0;
                    continue;
                }
                sb.append(String.format("<0x%02X>", b) + " ");
                count = 0;
                continue;
            }
            if (b == 10) {
                sb.append("\n<LF>");
                count = 0;
                continue;
            }
            if (b == 13) {
                sb.append("<CR>");
                continue;
            }
            if (b > 0 && b < 127) {
                sb.append(c);
                continue;
            }
            sb.append(String.format("<0x%02X>", b) + " ");
        }
        return sb;
    }
}

