/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.source;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.logging.AccessLogForwarder;
import com.ibm.wsspi.http.logging.AccessLogRecordData;
import com.ibm.wsspi.http.logging.LogForwarderManager;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AccessLogSource
implements Source {
    private static final TraceComponent tc = Tr.register(AccessLogSource.class);
    private final String sourceName = "com.ibm.ws.http.logging.source.accesslog";
    private final String location = "memory";
    private static String USER_AGENT_HEADER = "User-Agent";
    private BufferManager bufferMgr = null;
    private AccessLogHandler accessLogHandler;
    static final long serialVersionUID = -8517833398304656141L;

    protected synchronized void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
    }

    public String getSourceName() {
        return "com.ibm.ws.http.logging.source.accesslog";
    }

    public String getLocation() {
        return "memory";
    }

    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.bufferMgr = bufferMgr;
        this.startSource();
    }

    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Un-setting buffer manager " + this), (Object[])new Object[0]);
        }
        this.stopSource();
        this.bufferMgr = null;
    }

    private void startSource() {
        this.accessLogHandler = new AccessLogHandler();
        LogForwarderManager.registerAccessLogForwarder(this.accessLogHandler);
    }

    private void stopSource() {
        LogForwarderManager.deregisterAccessLogForwarder(this.accessLogHandler);
        this.accessLogHandler = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class AccessLogHandler
    implements AccessLogForwarder {
        private final AtomicLong seq = new AtomicLong();
        static final long serialVersionUID = 6715811758680259629L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AccessLogHandler() {
        }

        @Override
        public void process(AccessLogRecordData recordData) {
            HttpRequestMessage request = recordData.getRequest();
            HttpResponseMessage response = recordData.getResponse();
            if (request != null) {
                AccessLogData accessLogData = new AccessLogData();
                long requestStartTimeVal = recordData.getStartTime();
                accessLogData.setRequestStartTime(requestStartTimeVal);
                accessLogData.setUriPath(request.getRequestURI());
                accessLogData.setRequestMethod(request.getMethod());
                accessLogData.setQueryString(request.getQueryString());
                accessLogData.setRequestHost(recordData.getLocalIP());
                accessLogData.setRequestPort(recordData.getLocalPort());
                accessLogData.setRemoteHost(recordData.getRemoteAddress());
                accessLogData.setUserAgent(request.getHeader(USER_AGENT_HEADER).asString());
                accessLogData.setRequestProtocol(request.getVersion());
                accessLogData.setBytesReceived(recordData.getBytesWritten());
                accessLogData.setResponseCode(response.getStatusCodeAsInt());
                accessLogData.setElapsedTime(recordData.getElapsedTime());
                accessLogData.setDatetime(recordData.getTimestamp());
                String sequenceVal = requestStartTimeVal + "_" + String.format("%013X", this.seq.incrementAndGet());
                accessLogData.setSequence(sequenceVal);
                accessLogData.setSourceType("com.ibm.ws.http.logging.source.accesslog");
                AccessLogSource.this.bufferMgr.add((Object)accessLogData);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added a event to buffer " + accessLogData), (Object[])new Object[0]);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AccessLogHandler.class);
        }
    }
}

