/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.yoko.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class SocketFactoryHelper
implements ExtendedConnectionHelper {
    private final TraceComponent tc;
    private static final Encoding CDR_1_2_ENCODING;
    private static String osName;
    protected ORB orb;
    protected Codec codec;
    static final long serialVersionUID = -8277594226424121291L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected SocketFactoryHelper(TraceComponent tc) {
        this.tc = tc;
    }

    @FFDCIgnore(value={IOException.class})
    protected IOException openSocket(final int port, int backlog, InetAddress address, ServerSocket socket, boolean soReuseAddr) {
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        IOException bindError = null;
        if (!soReuseAddr) {
            try {
                this.attemptSocketBind(socket, socketAddress, false, backlog);
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("Forced re-use==false bind attempt failed, ioe=" + e), (java.lang.Object[])new java.lang.Object[0]);
                }
                bindError = e;
            }
        } else {
            try {
                this.attemptSocketBind(socket, socketAddress, false, backlog);
                if (!SocketFactoryHelper.isWindows()) {
                    socket.setReuseAddress(true);
                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)"ServerSocket reuse set to true to allow for later override", (java.lang.Object[])new java.lang.Object[0]);
                    }
                }
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)this.tc, (String)("ServerSocket bind failed on first attempt with IOException: " + ioe.getMessage()), (java.lang.Object[])new java.lang.Object[0]);
                }
                bindError = ioe;
                try {
                    final String hostName = address == null ? "localhost" : address.getHostName();
                    InetSocketAddress testAddr = AccessController.doPrivileged(new PrivilegedAction<InetSocketAddress>(){
                        static final long serialVersionUID = -377341918955222203L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public InetSocketAddress run() {
                            return new InetSocketAddress(hostName, port);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                    if (!testAddr.isUnresolved()) {
                        SocketChannel testChannel = SocketChannel.open(testAddr);
                        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)this.tc, (String)"attempt to connect to port to check listen status worked, someone else is using the port!", (java.lang.Object[])new java.lang.Object[0]);
                        }
                        testChannel.close();
                    } else if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)("Test connection addr is unresolvable; " + testAddr), (java.lang.Object[])new java.lang.Object[0]);
                    }
                }
                catch (IOException testioe) {
                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)this.tc, (String)("attempt to connect to port to check listen status failed with IOException: " + testioe.getMessage()), (java.lang.Object[])new java.lang.Object[0]);
                    }
                    try {
                        this.attemptSocketBind(socket, socketAddress, true, backlog);
                        bindError = null;
                    }
                    catch (IOException newioe) {
                        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)this.tc, (String)("ServerSocket bind failed on second attempt with IOException: " + newioe.getMessage()), (java.lang.Object[])new java.lang.Object[0]);
                        }
                        bindError = newioe;
                    }
                }
            }
        }
        return bindError;
    }

    private void attemptSocketBind(ServerSocket serverSocket, SocketAddress address, boolean reuseflag, int backlog) throws IOException {
        serverSocket.setReuseAddress(reuseflag);
        serverSocket.bind(address, backlog);
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("ServerSocket bind worked, reuse=" + serverSocket.getReuseAddress()), (java.lang.Object[])new java.lang.Object[0]);
        }
    }

    private static String getOSName() {
        if (osName == null) {
            osName = System.getProperty("os.name", "unknown");
        }
        return osName;
    }

    private static boolean isWindows() {
        String name = SocketFactoryHelper.getOSName();
        return name.toLowerCase().startsWith("windows");
    }

    @FFDCIgnore(value={UnknownEncoding.class, InvalidName.class})
    public void init(ORB orb, String configName) {
        this.orb = orb;
        try {
            this.codec = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory")).create_codec(CDR_1_2_ENCODING);
        }
        catch (UnknownEncoding unknownEncoding) {
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
    }

    protected Socket createPlainSocket(String host, int port) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)this.tc, (String)("Creating plain endpoint to " + host + ":" + port), (java.lang.Object[])new java.lang.Object[0]);
        }
        return new Socket(host, port);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SocketFactoryHelper.class);
        CDR_1_2_ENCODING = new Encoding(0, 1, 2);
    }
}

