/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStatistics;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.ws.session.store.db.DatabaseHashMap;
import com.ibm.ws.session.store.db.DatabaseMRHelper;
import com.ibm.ws.session.store.db.DatabaseStore;
import com.ibm.ws.session.store.db.DatabaseStoreService;
import com.ibm.ws.session.store.db.LoggingUtil;
import com.ibm.wsspi.session.IStore;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;

public class DatabaseHashMapMR
extends DatabaseHashMap {
    String findProps;
    String upAnyProp;
    String insAnyProp;
    int smallPropType;
    int mediumPropType;
    int largePropType;
    boolean multirowInitialized = false;
    private static final long serialVersionUID = -1215532807296297361L;
    private static final String methodClassName = "DatabaseHashMapMR";
    private static final int HANDLE_PROPERTY_HITS = 0;
    private static final int GET_ALL_VALUES = 1;
    private static final int INIT_MULTIROW_DB_TYPES = 2;
    private static final String[] methodNames = new String[]{"handlePropertyHits", "getAllValues", "initMultirowDBTypes"};

    public DatabaseHashMapMR(IStore store, SessionManagerConfig smc, DatabaseStoreService databaseStoreService) {
        super(store, smc, databaseStoreService);
        this.appDataTablesPerThread = !this._smc.writeAllProperties() && !this._smc.getEnableTimeBasedWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMultirowDBTypes(Connection conn) throws SQLException {
        block13: {
            if (!this.usingOracle) {
                try (PreparedStatement testPS = null;){
                    testPS = conn.prepareStatement(this.upAnyProp);
                    this.smallPropType = testPS.getParameterMetaData().getParameterType(1);
                    this.mediumPropType = testPS.getParameterMetaData().getParameterType(2);
                    this.largePropType = testPS.getParameterMetaData().getParameterType(3);
                    this.multirowInitialized = true;
                }
            }
            boolean smallExists = false;
            boolean mediumExists = false;
            boolean largeExists = false;
            DatabaseMetaData dmd = conn.getMetaData();
            String tbName = this.tableName;
            String qualifierName = null;
            tbName = tbName.toUpperCase();
            if (this.dbid != null) {
                qualifierName = this.dbid.toUpperCase();
            }
            ResultSet rs1 = dmd.getColumns(null, qualifierName, tbName, "%");
            try {
                while (rs1.next()) {
                    String columnname = rs1.getString("COLUMN_NAME");
                    int columnType = rs1.getInt("DATA_TYPE");
                    if (columnname.equalsIgnoreCase("SMALL")) {
                        this.smallPropType = columnType;
                        smallExists = true;
                    }
                    if (columnname.equalsIgnoreCase("MEDIUM")) {
                        this.mediumPropType = columnType;
                        mediumExists = true;
                    }
                    if (!columnname.equalsIgnoreCase("LARGE")) continue;
                    this.largePropType = columnType;
                    largeExists = true;
                }
                if (smallExists && mediumExists && largeExists) {
                    this.multirowInitialized = true;
                    break block13;
                }
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[2], "DatabaseHashMap.wrongTableDef");
                throw new SQLException();
            }
            finally {
                DatabaseHashMapMR.closeResultSet(rs1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    boolean handlePropertyHits(BackedSession d2, Thread t, int len) {
        block113: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering("DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0]);
            }
            vEnum = null;
            doWrite = false;
            conn = null;
            id = d2.getId();
            propid = null;
            batchUpdatePS = null;
            batchInsertPS = null;
            batchDeletePS = null;
            insertBatch = new LinkedList<DatabaseMRHelper>();
            updateClose = false;
            insertClose = false;
            delClose = false;
            conn = this.getConnection(false);
            if (conn == null) {
                return true;
            }
            if (!this.multirowInitialized) {
                try {
                    this.initMultirowDBTypes(conn);
                }
                catch (SQLException e) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "problem getting types", e);
                    }
                    if (conn != null) {
                        this.closeConnection(conn);
                    }
                    return false;
                }
            }
            try {
                sht = null;
                if (this._smc.writeAllProperties()) {
                    ht = (Hashtable)d2.getSwappableData();
                    vEnum = ht.keys();
                    doWrite = true;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "doing app changes for ALL mSwappable Data " + ht.toString());
                    }
                } else if (d2.appDataChanges != null) {
                    if (this.appDataTablesPerThread) {
                        sht = (Hashtable)d2.appDataChanges.get(t);
                        if (sht != null) {
                            doWrite = true;
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "doing app changes for " + id + " on thread " + t);
                            }
                            vEnum = sht != null ? sht.keys() : new Hashtable<K, V>().keys();
                        }
                    } else {
                        doWrite = true;
                        vEnum = d2.appDataChanges.keys();
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "doing app changes for TimeBasedWrite");
                        }
                    }
                }
                if (doWrite) {
                    enumCount = 0;
                    batchUpdatePS = conn.prepareStatement(this.upAnyProp);
                    while (vEnum.hasMoreElements()) {
                        ++enumCount;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "enumCount is now " + enumCount);
                        }
                        startTime = System.currentTimeMillis();
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "about to do vEnum.nextElement");
                        }
                        if (id.equals(propid = (String)vEnum.nextElement())) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.WARNING, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "DatabaseHashMapMR.AttributeEqualsSessionIdWarning", propid);
                            continue;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "it worked and the propid is: " + propid);
                        }
                        baos = new ByteArrayOutputStream();
                        oos = this.createObjectOutputStream(baos);
                        oos.writeObject(d2.getSwappableData().get(propid));
                        oos.flush();
                        size = baos.size();
                        objbuf = baos.toByteArray();
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "size for " + propid + " is " + size);
                        }
                        oos.close();
                        baos.close();
                        rowsRet = false;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "before update " + propid + " for session " + id);
                        }
                        if (size <= this.smallColSize) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "storing in small which can handle up to " + this.smallColSize + " bytes");
                            }
                            if (!this.usingInformix) {
                                batchUpdatePS.setBytes(1, objbuf);
                                batchUpdatePS.setNull(2, this.mediumPropType);
                                batchUpdatePS.setNull(3, this.largePropType);
                            } else {
                                bis = new ByteArrayInputStream(objbuf);
                                batchUpdatePS.setBinaryStream(1, (InputStream)bis, objbuf.length);
                                batchUpdatePS.setNull(2, this.mediumPropType);
                                batchUpdatePS.setNull(3, this.largePropType);
                            }
                            batchUpdatePS.setString(4, id);
                            batchUpdatePS.setString(5, propid);
                            batchUpdatePS.setString(6, this.getAppName());
                            batchUpdatePS.addBatch();
                            helper = new DatabaseMRHelper();
                            helper.setId(id);
                            helper.setPropId(propid);
                            helper.setObject(objbuf);
                            if (this.usingInformix) {
                                helper.setUseStream(true);
                            }
                            helper.setAppName(this.getAppName());
                            helper.setSize(0);
                            insertBatch.add(helper);
                        } else if (size <= this.mediumColSize) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "storing in medium which can handle up to " + this.mediumColSize + " bytes");
                            }
                            if (!this.usingInformix && !this._smc.isUseOracleBlob()) {
                                batchUpdatePS.setNull(1, this.smallPropType);
                                batchUpdatePS.setBytes(2, objbuf);
                                batchUpdatePS.setNull(3, this.largePropType);
                            } else {
                                bis = new ByteArrayInputStream(objbuf);
                                batchUpdatePS.setNull(1, this.smallPropType);
                                batchUpdatePS.setBinaryStream(2, (InputStream)bis, objbuf.length);
                                batchUpdatePS.setNull(3, this.largePropType);
                            }
                            batchUpdatePS.setString(4, id);
                            batchUpdatePS.setString(5, propid);
                            batchUpdatePS.setString(6, this.getAppName());
                            batchUpdatePS.addBatch();
                            helper = new DatabaseMRHelper();
                            helper.setId(id);
                            helper.setPropId(propid);
                            helper.setObject(objbuf);
                            if (this.usingInformix || this._smc.isUseOracleBlob()) {
                                helper.setUseStream(true);
                            }
                            helper.setAppName(this.getAppName());
                            helper.setSize(1);
                            insertBatch.add(helper);
                        } else if (size <= this.largeColSize) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "storing in large which can handle up to " + this.largeColSize + " bytes");
                            }
                            if (!this.usingInformix) {
                                batchUpdatePS.setNull(1, this.smallPropType);
                                batchUpdatePS.setNull(2, this.mediumPropType);
                                batchUpdatePS.setBytes(3, objbuf);
                            } else {
                                bis = new ByteArrayInputStream(objbuf);
                                batchUpdatePS.setNull(1, this.smallPropType);
                                batchUpdatePS.setNull(2, this.mediumPropType);
                                batchUpdatePS.setBinaryStream(3, (InputStream)bis, objbuf.length);
                            }
                            batchUpdatePS.setString(4, id);
                            batchUpdatePS.setString(5, propid);
                            batchUpdatePS.setString(6, this.getAppName());
                            batchUpdatePS.addBatch();
                            helper = new DatabaseMRHelper();
                            helper.setId(id);
                            helper.setPropId(propid);
                            helper.setObject(objbuf);
                            if (this.usingInformix) {
                                helper.setUseStream(true);
                            }
                            helper.setAppName(this.getAppName());
                            helper.setSize(2);
                            insertBatch.add(helper);
                        } else {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "DatabaseHashMapMR.db2LongVarCharErr");
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "DatabaseHashMapMR.propertyTooBig", propid);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "after commit " + propid + " for session " + id);
                        }
                        if ((pmiStats = this._iStore.getSessionStatistics()) == null) continue;
                        pmiStats.writeTimes((long)objbuf.length, System.currentTimeMillis() - startTime);
                    }
                    updateCount = 0;
                    results = null;
                    if (enumCount > 0) {
                        results = batchUpdatePS.executeBatch();
                        if (this.usingOracle) {
                            updateCount = batchUpdatePS.getUpdateCount();
                        }
                    } else {
                        results = new int[]{};
                    }
                    batchUpdatePS.close();
                    updateClose = true;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "after " + results.length + " batch update(s), total update count : " + updateCount);
                    }
                    needToInsert = false;
                    batchInsertPSCount = results.length;
                    if (results[0] == -2 && updateCount > 0 && (this._smc.writeAllProperties() || batchInsertPSCount == updateCount)) {
                        batchInsertPSCount -= updateCount;
                    }
                    for (i = 0; i < batchInsertPSCount; ++i) {
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "For batch # " + (i + 1) + ", update result : " + results[i]);
                        }
                        if (results[i] > 0) continue;
                        if (!needToInsert) {
                            needToInsert = true;
                            batchInsertPS = conn.prepareStatement(this.insAnyProp);
                        }
                        updateRow = (DatabaseMRHelper)insertBatch.get(i);
                        batchInsertPS.setString(1, updateRow.getId());
                        batchInsertPS.setString(2, updateRow.getPropId());
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "Insert attribute " + updateRow.getPropId());
                        }
                        switch (updateRow.getSize()) {
                            case 0: {
                                if (!updateRow.isUseStream()) {
                                    batchInsertPS.setBytes(3, updateRow.getObject());
                                    batchInsertPS.setNull(4, this.mediumPropType);
                                    batchInsertPS.setNull(5, this.largePropType);
                                    break;
                                }
                                objbuf = updateRow.getObject();
                                bis = new ByteArrayInputStream(objbuf);
                                batchInsertPS.setBinaryStream(3, bis, objbuf.length);
                                batchInsertPS.setNull(4, this.mediumPropType);
                                batchInsertPS.setNull(5, this.largePropType);
                                break;
                            }
                            case 1: {
                                if (!updateRow.isUseStream()) {
                                    batchInsertPS.setNull(3, this.smallPropType);
                                    batchInsertPS.setBytes(4, updateRow.getObject());
                                    batchInsertPS.setNull(5, this.largePropType);
                                    break;
                                }
                                objbuf = updateRow.getObject();
                                bis = new ByteArrayInputStream(objbuf);
                                batchInsertPS.setNull(3, this.smallPropType);
                                batchInsertPS.setBinaryStream(4, bis, objbuf.length);
                                batchInsertPS.setNull(5, this.largePropType);
                                break;
                            }
                            case 2: {
                                if (!updateRow.isUseStream()) {
                                    batchInsertPS.setNull(3, this.smallPropType);
                                    batchInsertPS.setNull(4, this.mediumPropType);
                                    batchInsertPS.setBytes(5, updateRow.getObject());
                                    break;
                                }
                                objbuf = updateRow.getObject();
                                bis = new ByteArrayInputStream(objbuf);
                                batchInsertPS.setNull(3, this.smallPropType);
                                batchInsertPS.setNull(4, this.mediumPropType);
                                batchInsertPS.setBinaryStream(5, bis, objbuf.length);
                                break;
                            }
                        }
                        batchInsertPS.setString(6, updateRow.getAppName());
                        batchInsertPS.addBatch();
                    }
                    results = new int[]{};
                    if (needToInsert) {
                        block112: {
                            try {
                                results = batchInsertPS.executeBatch();
                            }
                            catch (BatchUpdateException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) break block112;
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "Continue insert due to BatchPerformanceWorkaround enabled");
                            }
                        }
                        batchInsertPS.close();
                        insertClose = true;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        problemCntr = 0;
                        for (Object i : (DatabaseMRHelper)results) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "Insert result : " + (int)i);
                            }
                            if (this.usingOracle && i == -2 || i >= 0) continue;
                            ++problemCntr;
                        }
                        if (problemCntr > 0) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "Problem updating/creating " + problemCntr + " attributes");
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "Exitting Loop ... all properties writes are done");
                    }
                    if (this.appDataTablesPerThread) {
                        if (d2.appDataChanges != null) {
                            d2.appDataChanges.remove(t);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "remove thread from appDataChanges for thread: " + t);
                        }
                    } else {
                        if (d2.appDataChanges != null) {
                            d2.appDataChanges.clear();
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "clearing appDataChanges");
                        }
                    }
                }
                vEnum2 = null;
                if (d2.appDataRemovals != null) {
                    if (!this.appDataTablesPerThread) {
                        vEnum2 = d2.appDataRemovals.keys();
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "doing app removals for " + id + " on ALL threads");
                        }
                    } else {
                        sht = (Hashtable)d2.appDataRemovals.get(t);
                        if (sht != null) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "doing app removals for " + id + " on thread " + t);
                            }
                            vEnum2 = sht != null ? sht.keys() : new Hashtable<K, V>().keys();
                        }
                    }
                    if (vEnum2 != null && vEnum2.hasMoreElements()) {
                        batchDeletePS = conn.prepareStatement(this.delProp);
                        while (vEnum2.hasMoreElements()) {
                            propid = (String)vEnum2.nextElement();
                            if (id.equals(propid)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "deleting prop " + propid + " for session " + id);
                            }
                            batchDeletePS.setString(1, id);
                            batchDeletePS.setString(2, propid);
                            batchDeletePS.setString(3, this.getAppName());
                            batchDeletePS.addBatch();
                            if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) continue;
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "after remove, before commit " + propid + " for session " + id);
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "after commit " + propid + " for session " + id);
                        }
                        results = batchDeletePS.executeBatch();
                        batchDeletePS.close();
                        delClose = true;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            problemCntr = 0;
                            for (int i : results) {
                                if (i > 0) continue;
                                ++problemCntr;
                            }
                            if (problemCntr > 0) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "There was a problem deleting " + problemCntr + " rows");
                            }
                        }
                    }
                    if (!this.appDataTablesPerThread) {
                        if (d2.appDataRemovals != null) {
                            d2.appDataRemovals.clear();
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "clearing appDataRemovals");
                        }
                    } else {
                        if (d2.appDataRemovals != null) {
                            d2.appDataRemovals.remove(t);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "remove thread from appDataRemovals: " + t);
                        }
                    }
                }
                if (updateClose || batchUpdatePS == null) break block113;
            }
            catch (SQLException se) {
                block114: {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMapMR.handlePropertyHits", (String)"428", (Object)d2);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "DatabaseHashMapMR.propHitErr");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "CommonMessage.exception", se);
                    if (updateClose || batchUpdatePS == null) break block114;
                    DatabaseHashMapMR.closeStatement(batchUpdatePS);
                }
                if (!insertClose && batchInsertPS != null) {
                    DatabaseHashMapMR.closeStatement(batchInsertPS);
                }
                if (!delClose && batchDeletePS != null) {
                    DatabaseHashMapMR.closeStatement(batchDeletePS);
                }
                if (conn != null) {
                    this.closeConnection(conn);
                }
            }
            catch (Exception ee) {
                block115: {
                    FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.session.store.db.DatabaseHashMapMR.handlePropertyHits", (String)"444", (Object)d2);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "DatabaseHashMapMR.propHitErr");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], "CommonMessage.exception", ee);
                    if (updateClose || batchUpdatePS == null) break block115;
                    {
                        catch (Throwable var27_45) {
                            if (!updateClose && batchUpdatePS != null) {
                                DatabaseHashMapMR.closeStatement(batchUpdatePS);
                            }
                            if (!insertClose && batchInsertPS != null) {
                                DatabaseHashMapMR.closeStatement(batchInsertPS);
                            }
                            if (!delClose && batchDeletePS != null) {
                                DatabaseHashMapMR.closeStatement(batchDeletePS);
                            }
                            if (conn != null) {
                                this.closeConnection(conn);
                            }
                            throw var27_45;
                        }
                    }
                    DatabaseHashMapMR.closeStatement(batchUpdatePS);
                }
                if (!insertClose && batchInsertPS != null) {
                    DatabaseHashMapMR.closeStatement(batchInsertPS);
                }
                if (!delClose && batchDeletePS != null) {
                    DatabaseHashMapMR.closeStatement(batchDeletePS);
                }
                if (conn != null) {
                    this.closeConnection(conn);
                } else {
                    ** GOTO lbl367
                }
            }
            DatabaseHashMapMR.closeStatement(batchUpdatePS);
        }
        if (!insertClose && batchInsertPS != null) {
            DatabaseHashMapMR.closeStatement(batchInsertPS);
        }
        if (!delClose && batchDeletePS != null) {
            DatabaseHashMapMR.closeStatement(batchDeletePS);
        }
        if (conn != null) {
            this.closeConnection(conn);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting("DatabaseHashMapMR", DatabaseHashMapMR.methodNames[0], true);
        }
        return true;
    }

    @Override
    protected void initializeSQL_Strings() {
        super.initializeSQL_Strings();
        this.findProps = "select propid, small, medium, large from " + this.tableName + "  where id = ? and propid <> ? and appname = ?";
        this.findAllKeys = "select propid from  " + this.tableName + "  where id = ? and propid <> id and appname = ?";
        this.upAnyProp = "update " + this.tableName + " set small = ?, medium = ?, large = ? where id = ? and propid = ? and appname = ?";
        this.insAnyProp = "insert into " + this.tableName + " (id, propid, small, medium, large, appname) values (?, ?, ?, ?, ?, ?)";
        this.insNoProp = "insert into " + this.tableName + " (id, propid, appname, listenercnt, lastaccess, creationtime, maxinactivetime, username) values (?, ?, ?, ?, ?, ?, ?, ?)";
        this.findProps = "select propid, small, medium, large from " + this.tableName + " where id = ? and propid <> ? and appname = ? ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected Object getAllValues(BackedSession sess) {
        Hashtable<String, Object> h;
        PreparedStatement s;
        Connection conn;
        block25: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[1]);
            }
            conn = this.getConnection(false);
            String id = sess.getId();
            if (conn == null) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], null);
                }
                return null;
            }
            long startTime = System.currentTimeMillis();
            long readSize = 0L;
            s = null;
            ResultSet rs = null;
            h = new Hashtable<String, Object>();
            try {
                s = conn.prepareStatement(this.findProps);
                s.setString(1, id);
                s.setString(2, id);
                s.setString(3, this.getAppName());
                rs = s.executeQuery();
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "querying database for properties");
                }
                while (rs.next()) {
                    if (sess.appDataRemovals != null && sess.appDataRemovals.containsKey(rs.getString("propid"))) {
                        if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) continue;
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "Found property: " + rs.getString("propid") + " in appDataRemovals, skipping db query for this prop");
                        continue;
                    }
                    if (sess.appDataChanges != null && sess.appDataChanges.containsKey(rs.getString("propid"))) {
                        if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) continue;
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "Found property: " + rs.getString("propid") + " in appDataChanges, skipping db query for this prop");
                        continue;
                    }
                    byte[] b = rs.getBytes("small");
                    if (b == null) {
                        b = rs.getBytes("medium");
                    }
                    if (b == null) {
                        b = rs.getBytes("large");
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(b);
                    BufferedInputStream bis = new BufferedInputStream(bais);
                    Object obj = null;
                    try {
                        obj = ((DatabaseStore)this.getIStore()).getLoader().loadObject((InputStream)bis);
                        readSize += (long)b.length;
                    }
                    catch (ClassNotFoundException ce) {
                        FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.session.store.db.DatabaseHashMapMR.getAllValues", (String)"864", (Object)sess);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "DatabaseHashMapMR.getSwappableListenersErr");
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.sessionid", id);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.exception", ce);
                    }
                    bis.close();
                    bais.close();
                    if (obj == null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "put prop in mSwappableData: " + rs.getString("propid"));
                    }
                    h.put(rs.getString("propid"), obj);
                }
                SessionStatistics pmiStats = this._iStore.getSessionStatistics();
                if (pmiStats != null) {
                    pmiStats.readTimes(readSize, System.currentTimeMillis() - startTime);
                }
                if (rs == null) break block25;
            }
            catch (SQLException se) {
                block26: {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMapMR.getAllValues", (String)"885", (Object)sess);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "DatabaseHashMapMR.checkListErr");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.object", sess.toString());
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.exception", se);
                    if (rs == null) break block26;
                    DatabaseHashMapMR.closeResultSet(rs);
                }
                if (s != null) {
                    DatabaseHashMapMR.closeStatement(s);
                }
                this.closeConnection(conn);
            }
            catch (Exception e) {
                block27: {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMapMR.getAllValues", (String)"892", (Object)sess);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "DatabaseHashMapMR.checkListErr");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.object", sess.toString());
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.exception", e);
                    if (rs == null) break block27;
                    {
                        catch (Throwable throwable) {
                            if (rs != null) {
                                DatabaseHashMapMR.closeResultSet(rs);
                            }
                            if (s != null) {
                                DatabaseHashMapMR.closeStatement(s);
                            }
                            this.closeConnection(conn);
                            throw throwable;
                        }
                    }
                    DatabaseHashMapMR.closeResultSet(rs);
                }
                if (s != null) {
                    DatabaseHashMapMR.closeStatement(s);
                }
                this.closeConnection(conn);
            }
            DatabaseHashMapMR.closeResultSet(rs);
        }
        if (s != null) {
            DatabaseHashMapMR.closeStatement(s);
        }
        this.closeConnection(conn);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[1], h);
        }
        return h;
    }
}

