/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JSONMetricWriter
implements OutputWriter {
    private final Writer writer;
    private static final TraceComponent tc = Tr.register(JSONMetricWriter.class);
    static final long serialVersionUID = 4577058910801044532L;

    public JSONMetricWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, IOException, EmptyRegistryException {
        this.serialize(this.getMetricsAsJson(registryName, metricName));
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        this.serialize(this.getMetricsAsJson(registryName));
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        JSONObject payload = new JSONObject();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                payload.put((Object)registryName, (Object)this.getMetricsAsJson(registryName));
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(payload);
    }

    private JSONObject getMetricsAsJson(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        return this.getJsonFromMetricMap(Util.getMetricsAsMap(registryName));
    }

    private JSONObject getMetricsAsJson(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        return this.getJsonFromMetricMap(Util.getMetricsAsMap(registryName, metricName));
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private JSONObject getJsonFromMetricMap(Map<String, Metric> metricMap) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Metric> entry : metricMap.entrySet()) {
            String metricName = entry.getKey();
            Metric metric = entry.getValue();
            if (Counter.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)((Counter)metric).getCount());
                continue;
            }
            if (Gauge.class.isInstance(metric)) {
                try {
                    jsonObject.put((Object)metricName, ((Gauge)metric).getValue());
                }
                catch (IllegalStateException illegalStateException) {}
                continue;
            }
            if (Timer.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getTimerNumbers((Timer)metric)));
                continue;
            }
            if (Histogram.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getHistogramNumbers((Histogram)metric)));
                continue;
            }
            if (Meter.class.isInstance(metric)) {
                jsonObject.put((Object)metricName, (Object)this.getJsonFromMap(Util.getMeterNumbers((Meter)metric)));
                continue;
            }
            Tr.event((TraceComponent)tc, (String)("Metric type '" + metric.getClass() + " for " + metricName + " is invalid."), (Object[])new Object[0]);
        }
        return jsonObject;
    }

    private JSONObject getJsonFromMap(Map<String, Number> map) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Number> entry : map.entrySet()) {
            jsonObject.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return jsonObject;
    }

    private void serialize(JSONObject payload) throws IOException {
        payload.serialize(this.writer);
    }
}

