/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsClientConfigInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientConfigInterceptor.class);
    static final long serialVersionUID = 7937836626500280001L;

    public LibertyJaxRsClientConfigInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        Object keepAlive = message.get((Object)"com.ibm.ws.jaxrs.client.keepalive.connection");
        Conduit conduit = message.getExchange().getConduit(message);
        if (conduit instanceof HTTPConduit) {
            HTTPClientPolicy clientPolicy = ((HTTPConduit)conduit).getClient();
            if (keepAlive != null) {
                String keepAliveString = keepAlive.toString();
                switch (keepAliveString.toLowerCase()) {
                    case "keep-alive": 
                    case "keepalive": {
                        clientPolicy.setConnection(ConnectionType.KEEP_ALIVE);
                        break;
                    }
                    case "close": {
                        clientPolicy.setConnection(ConnectionType.CLOSE);
                        break;
                    }
                    default: {
                        Tr.warning((TraceComponent)tc, (String)"warn_unknown_keepalive_setting", (Object[])new Object[]{keepAliveString, "keep-alive, close"});
                        clientPolicy.setConnection(ConnectionType.KEEP_ALIVE);
                        break;
                    }
                }
            } else {
                clientPolicy.setConnection(ConnectionType.KEEP_ALIVE);
            }
        }
    }
}

