/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.OidcLoginConfigImpl;
import java.util.Arrays;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.social.google", configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={SocialLoginConfig.class, JwtConsumerConfig.class}, property={"service.vendor=IBM", "type=googleLogin"})
public class GoogleLoginConfigImpl
extends OidcLoginConfigImpl {
    public static final TraceComponent tc = Tr.register(GoogleLoginConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final long serialVersionUID = 8432359051665684026L;

    @Override
    protected void setRequiredConfigAttributes(Map<String, Object> props) {
        this.clientId = this.getRequiredConfigAttribute(props, "clientId");
        this.clientSecret = this.getRequiredSerializableProtectedStringConfigAttribute(props, "clientSecret");
    }

    @Override
    protected void setOptionalConfigAttributes(Map<String, Object> props) throws SocialLoginException {
        this.authorizationEndpoint = this.configUtils.getConfigAttribute(props, "authorizationEndpoint");
        this.tokenEndpoint = this.configUtils.getConfigAttribute(props, "tokenEndpoint");
        this.jwksUri = this.configUtils.getConfigAttribute(props, "jwksUri");
        this.scope = this.configUtils.getConfigAttribute(props, "scope");
        this.userNameAttribute = this.configUtils.getConfigAttribute(props, "userNameAttribute");
        this.mapToUserRegistry = this.configUtils.getBooleanConfigAttribute(props, "mapToUserRegistry", this.mapToUserRegistry);
        this.sslRef = this.configUtils.getConfigAttribute(props, "sslRef");
        this.authFilterRef = this.configUtils.getConfigAttribute(props, "authFilterRef");
        this.isClientSideRedirectSupported = this.configUtils.getBooleanConfigAttribute(props, "isClientSideRedirectSupported", this.isClientSideRedirectSupported);
        this.displayName = this.configUtils.getConfigAttribute(props, "displayName");
        this.website = this.configUtils.getConfigAttribute(props, "website");
        this.tokenEndpointAuthMethod = this.configUtils.getConfigAttribute(props, "tokenEndpointAuthMethod");
        this.redirectToRPHostAndPort = this.configUtils.getConfigAttribute(props, "redirectToRPHostAndPort");
        this.issuer = this.configUtils.getConfigAttribute(props, "issuer");
        this.realmNameAttribute = this.configUtils.getConfigAttribute(props, "realmNameAttribute");
        this.groupNameAttribute = this.configUtils.getConfigAttribute(props, "groupNameAttribute");
        this.userUniqueIdAttribute = this.configUtils.getConfigAttribute(props, "userUniqueIdAttribute");
        this.clockSkewMsec = this.configUtils.getIntegerConfigAttribute(props, "clockSkew", this.clockSkewMsec);
        this.signatureAlgorithm = this.configUtils.getConfigAttribute(props, "signatureAlgorithm");
    }

    @Override
    protected void debug() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("" + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientId = " + this.clientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientSecret is null = " + (this.clientSecret == null)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authorizationEndpoint = " + this.authorizationEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpoint = " + this.tokenEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwksUri = " + this.jwksUri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("scope = " + this.scope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute = " + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapToUserRegistry = " + this.mapToUserRegistry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef = " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("builder = " + this.jwtRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("claims = " + (this.jwtClaims == null ? null : Arrays.toString(this.jwtClaims))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("isClientSideRedirectSupported = " + this.isClientSideRedirectSupported), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("displayName = " + this.displayName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("website = " + this.website), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointAuthMethod = " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectToRPHostAndPort = " + this.redirectToRPHostAndPort), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("issuer = " + this.issuer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmNameAttribute = " + this.realmNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupNameAttribute = " + this.groupNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userUniqueIdAttribute = " + this.userUniqueIdAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clockSkew = " + this.clockSkewMsec), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("signatureAlgorithm = " + this.signatureAlgorithm), (Object[])new Object[0]);
        }
    }

    @Override
    public String getSignatureAlgorithm() {
        if (this.jwksUri == null) {
            return null;
        }
        return this.signatureAlgorithm;
    }
}

