/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.SocialLoginService;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import com.ibm.ws.security.social.internal.SslRefInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.social.oidclogin", configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={SocialLoginConfig.class, JwtConsumerConfig.class}, property={"service.vendor=IBM", "type=oidcLogin"})
public class OidcLoginConfigImpl
extends Oauth2LoginConfigImpl
implements JwtConsumerConfig,
ConvergedClientConfig {
    public static final TraceComponent tc = Tr.register(OidcLoginConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    ConsumerUtils consumerUtils = null;
    JWKSet jwkSet = null;
    public static final String KEY_ISSUER = "issuer";
    String issuer = null;
    public static final String KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    String signatureAlgorithm = null;
    public static final String KEY_CLOCKSKEW = "clockSkew";
    int clockSkewMsec = 0;
    public static final String CFG_KEY_HOST_NAME_VERIFICATION_ENABLED = "hostNameVerificationEnabled";
    private boolean hostNameVerificationEnabled = true;
    public static final String KEY_TRUSTED_ALIAS = "trustAliasName";
    private String trustAliasName = null;
    static final long serialVersionUID = -4929822429554311314L;

    @Override
    protected void setRequiredConfigAttributes(Map<String, Object> props) {
        this.clientId = this.getRequiredConfigAttribute(props, "clientId");
        this.clientSecret = this.getRequiredSerializableProtectedStringConfigAttribute(props, "clientSecret");
    }

    @Override
    protected void setOptionalConfigAttributes(Map<String, Object> props) throws SocialLoginException {
        this.authorizationEndpoint = this.configUtils.getConfigAttribute(props, "authorizationEndpoint");
        this.tokenEndpoint = this.configUtils.getConfigAttribute(props, "tokenEndpoint");
        this.jwksUri = this.configUtils.getConfigAttribute(props, "jwksUri");
        this.scope = this.configUtils.getConfigAttribute(props, "scope");
        this.userNameAttribute = this.configUtils.getConfigAttribute(props, "userNameAttribute");
        this.mapToUserRegistry = this.configUtils.getBooleanConfigAttribute(props, "mapToUserRegistry", this.mapToUserRegistry);
        this.sslRef = this.configUtils.getConfigAttribute(props, "sslRef");
        this.authFilterRef = this.configUtils.getConfigAttribute(props, "authFilterRef");
        this.trustAliasName = this.configUtils.getConfigAttribute(props, KEY_TRUSTED_ALIAS);
        this.isClientSideRedirectSupported = this.configUtils.getBooleanConfigAttribute(props, "isClientSideRedirectSupported", this.isClientSideRedirectSupported);
        this.displayName = this.configUtils.getConfigAttribute(props, "displayName");
        this.website = this.configUtils.getConfigAttribute(props, "website");
        this.issuer = this.configUtils.getConfigAttribute(props, KEY_ISSUER);
        this.realmNameAttribute = this.configUtils.getConfigAttribute(props, "realmNameAttribute");
        this.groupNameAttribute = this.configUtils.getConfigAttribute(props, "groupNameAttribute");
        this.userUniqueIdAttribute = this.configUtils.getConfigAttribute(props, "userUniqueIdAttribute");
        this.clockSkewMsec = this.configUtils.getIntegerConfigAttribute(props, KEY_CLOCKSKEW, this.clockSkewMsec);
        this.signatureAlgorithm = this.configUtils.getConfigAttribute(props, KEY_SIGNATURE_ALGORITHM);
        this.tokenEndpointAuthMethod = this.configUtils.getConfigAttribute(props, "tokenEndpointAuthMethod");
        this.redirectToRPHostAndPort = this.configUtils.getConfigAttribute(props, "redirectToRPHostAndPort");
        this.hostNameVerificationEnabled = this.configUtils.getBooleanConfigAttribute(props, CFG_KEY_HOST_NAME_VERIFICATION_ENABLED, this.hostNameVerificationEnabled);
        this.nonce = true;
    }

    @Override
    protected void initializeMembersAfterConfigAttributesPopulated(Map<String, Object> props) throws SocialLoginException {
        this.initializeJwt(props);
        this.resetLazyInitializedMembers();
    }

    @Override
    protected void resetLazyInitializedMembers() {
        super.resetLazyInitializedMembers();
        this.responseType = "code";
        this.jwkSet = null;
        this.consumerUtils = null;
    }

    @Override
    protected void debug() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("" + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientId = " + this.clientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientSecret is null = " + (this.clientSecret == null)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authorizationEndpoint = " + this.authorizationEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpoint = " + this.tokenEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("jwksUri = " + this.jwksUri), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("scope = " + this.scope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute = " + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapToUserRegistry = " + this.mapToUserRegistry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef = " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("trustAliasName = " + this.trustAliasName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("builder = " + this.jwtRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("claims = " + (this.jwtClaims == null ? null : Arrays.toString(this.jwtClaims))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("isClientSideRedirectSupported = " + this.isClientSideRedirectSupported), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("displayName = " + this.displayName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("website = " + this.website), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("issuer = " + this.issuer), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("realmNameAttribute = " + this.realmNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("groupNameAttribute = " + this.groupNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userUniqueIdAttribute = " + this.userUniqueIdAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clockSkew = " + this.clockSkewMsec), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("signatureAlgorithm = " + this.signatureAlgorithm), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointAuthMethod = " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectToRPHostAndPort = " + this.redirectToRPHostAndPort), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostNameVerificationEnabled = " + this.hostNameVerificationEnabled), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("nonce = " + this.nonce), (Object[])new Object[0]);
        }
    }

    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    @Override
    public String getRealmNameAttribute() {
        return this.realmNameAttribute;
    }

    public String getId() {
        return this.getUniqueId();
    }

    public String getIssuer() {
        if ((this.issuer == null || this.issuer.length() == 0) && this.tokenEndpoint != null && this.tokenEndpoint.length() > "http://".length()) {
            String computedIssuer = null;
            if (this.tokenEndpoint.toLowerCase().startsWith("http")) {
                int lastpos = this.tokenEndpoint.lastIndexOf("/");
                computedIssuer = lastpos > "http://".length() ? this.tokenEndpoint.substring(0, lastpos) : this.tokenEndpoint;
                return computedIssuer;
            }
            return this.issuer;
        }
        return this.issuer;
    }

    @Sensitive
    public String getSharedKey() {
        return this.clientSecret;
    }

    public List<String> getAudiences() {
        ArrayList<String> audiences = new ArrayList<String>();
        String clientId = this.getClientId();
        if (clientId != null) {
            audiences.add(clientId);
        }
        return audiences;
    }

    public boolean isValidationRequired() {
        return false;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    public String getTrustStoreRef() {
        if (this.sslRefInfo == null) {
            SocialLoginService service = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (service == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Social login service is not available", (Object[])new Object[0]);
                }
                return null;
            }
            this.sslRefInfo = this.createSslRefInfoImpl(service);
        }
        try {
            return this.sslRefInfo.getTrustStoreName();
        }
        catch (SocialLoginException e) {
            e.logErrorMessage();
            return null;
        }
    }

    public String getTrustedAlias() {
        return this.trustAliasName;
    }

    public long getClockSkew() {
        return this.clockSkewMsec;
    }

    public boolean getJwkEnabled() {
        return this.jwksUri != null;
    }

    public String getJwkEndpointUrl() {
        return this.jwksUri;
    }

    public ConsumerUtils getConsumerUtils() {
        if (this.consumerUtils == null) {
            SocialLoginService socialLoginService = (SocialLoginService)this.socialLoginServiceRef.getService();
            if (socialLoginService != null) {
                this.consumerUtils = new ConsumerUtils(socialLoginService.getKeyStoreServiceRef());
            } else {
                Tr.warning((TraceComponent)tc, (String)"SERVICE_NOT_FOUND_JWT_CONSUMER_NOT_AVAILABLE", (Object[])new Object[]{this.uniqueId});
            }
        }
        return this.consumerUtils;
    }

    public JWKSet getJwkSet() {
        if (this.jwkSet == null) {
            this.jwkSet = new JWKSet();
        }
        return this.jwkSet;
    }

    public boolean getTokenReuse() {
        return false;
    }

    @Override
    protected SslRefInfoImpl createSslRefInfoImpl(SocialLoginService socialLoginService) {
        return new SslRefInfoImpl(socialLoginService.getSslSupport(), socialLoginService.getKeyStoreServiceRef(), this.sslRef, this.trustAliasName);
    }

    public boolean isSocial() {
        return true;
    }

    public OidcClientConfig getOidcClientConfig() {
        return null;
    }

    public String getInboundPropagation() {
        return "none";
    }

    public boolean getAccessTokenInLtpaCookie() {
        return false;
    }

    public boolean isAuthnSessionDisabled_propagation() {
        return false;
    }

    public long getClockSkewInSeconds() {
        return this.getClockSkew() / 1000L;
    }

    public String getAuthorizationEndpointUrl() {
        return this.getAuthorizationEndpoint();
    }

    public boolean createSession() {
        return false;
    }

    public long getAuthenticationTimeLimitInSeconds() {
        return 420L;
    }

    public boolean isHttpsRequired() {
        return true;
    }

    public boolean isClientSideRedirect() {
        return this.isClientSideRedirectSupported();
    }

    public String getContextPath() {
        return OidcLoginConfigImpl.getContextRoot();
    }

    public String getTokenEndpointUrl() {
        return this.getTokenEndpoint();
    }

    public String getSSLConfigurationName() {
        return this.getSslRef();
    }

    public String getRedirectUrlFromServerToClient() {
        return this.getRedirectToRPHostAndPort();
    }

    public String getRedirectUrlWithJunctionPath(String redirect_url) {
        return redirect_url;
    }

    public String getAuthContextClassReference() {
        return null;
    }

    public String getGrantType() {
        return "authorization_code";
    }

    public boolean isNonceEnabled() {
        return this.createNonce();
    }

    public String getPrompt() {
        return null;
    }

    public String[] getResources() {
        String resource = this.getResource();
        if (resource == null) {
            return null;
        }
        return resource.split(" ");
    }

    public String getOidcClientCookieName() {
        return null;
    }

    public String getIssuerIdentifier() {
        return this.getIssuer();
    }

    public boolean getUseAccessTokenAsIdToken() {
        return false;
    }

    public boolean isMapIdentityToRegistryUser() {
        return this.getMapToUserRegistry();
    }

    public boolean isIncludeCustomCacheKeyInSubject() {
        return false;
    }

    public boolean isIncludeIdTokenInSubject() {
        return true;
    }

    public boolean isDisableLtpaCookie() {
        return false;
    }

    public String getGroupIdentifier() {
        return this.getGroupNameAttribute();
    }

    public String getUserIdentifier() {
        return this.getUserNameAttribute();
    }

    public String getUserIdentityToCreateSubject() {
        return this.getUserNameAttribute();
    }

    public String getRealmIdentifier() {
        return this.getRealmNameAttribute();
    }

    public String getUniqueUserIdentifier() {
        return this.getUserUniqueIdAttribute();
    }

    public String getJsonWebKey() {
        return null;
    }

    public boolean allowedAllAudiences() {
        return false;
    }

    public boolean disableIssChecking() {
        return false;
    }

    public String getJwkClientId() {
        return null;
    }

    public String getJwkClientSecret() {
        return null;
    }
}

