/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.websphere.security.social.UserProfile;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.jwt.builder.utils.BuilderUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.CacheToken;
import com.ibm.ws.security.social.internal.utils.SocialHashUtils;
import com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator;
import com.ibm.ws.security.social.tai.TAIEncryptionUtils;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import com.ibm.wsspi.security.tai.TAIResult;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAISubjectUtils {
    public static final TraceComponent tc = Tr.register(TAISubjectUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private static Cache tokenCache = new Cache(50000, 600000L);
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    TAIEncryptionUtils taiEncryptionUtils = new TAIEncryptionUtils();
    private String username = null;
    @Sensitive
    private String accessToken = null;
    private JwtToken jwt = null;
    private JwtToken issuedJwt = null;
    @Sensitive
    private Map<String, Object> userApiResponseTokens = null;
    private String userApiResponse = null;
    static final long serialVersionUID = 9054878627471500539L;

    public TAISubjectUtils(AuthorizationCodeAuthenticator authzCodeAuthenticator) {
        this(authzCodeAuthenticator.getAccessToken(), authzCodeAuthenticator.getJwt(), authzCodeAuthenticator.getIssuedJwt(), authzCodeAuthenticator.getTokens(), authzCodeAuthenticator.getUserApiResponse());
    }

    public TAISubjectUtils(@Sensitive String accessToken, JwtToken jwt, JwtToken issuedJwt, @Sensitive Map<String, Object> userApiResponseTokens, String userApiResponse) {
        this.accessToken = accessToken;
        this.jwt = jwt;
        this.issuedJwt = issuedJwt;
        this.userApiResponseTokens = userApiResponseTokens;
        this.userApiResponse = userApiResponse;
    }

    @FFDCIgnore(value={SettingCustomPropertiesException.class})
    public TAIResult createResult(HttpServletResponse res, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException, SocialLoginException {
        Hashtable<String, Object> customProperties = new Hashtable();
        try {
            customProperties = this.setAllCustomProperties(clientConfig);
        }
        catch (SettingCustomPropertiesException e) {
            return this.taiWebUtils.sendToErrorPage(res, TAIResult.create((int)401));
        }
        Subject subject = this.buildSubject(clientConfig, customProperties);
        return TAIResult.create((int)200, (String)this.username, (Subject)subject);
    }

    Hashtable<String, Object> setAllCustomProperties(SocialLoginConfig config) throws SettingCustomPropertiesException {
        Hashtable<String, Object> customProperties = this.setUsernameAndCustomProperties(config);
        if (this.username == null) {
            Tr.error((TraceComponent)tc, (String)"USERNAME_NOT_FOUND", (Object[])new Object[0]);
            throw new SettingCustomPropertiesException();
        }
        if (this.accessToken == null) {
            Tr.error((TraceComponent)tc, (String)"ACCESS_TOKEN_MISSING", (Object[])new Object[]{this.username});
            throw new SettingCustomPropertiesException();
        }
        customProperties.put("com.ibm.wsspi.security.cred.securityName", this.username);
        customProperties.put("access_token", this.accessToken);
        return customProperties;
    }

    Hashtable<String, Object> setUsernameAndCustomProperties(SocialLoginConfig config) throws SettingCustomPropertiesException {
        if (this.userApiResponse != null) {
            return this.setUsernameAndCustomPropertiesUsingAttributeToSubjectMapping(config);
        }
        return this.setUsernameAndCustomPropertiesUsingJwt(config);
    }

    Hashtable<String, Object> setUsernameAndCustomPropertiesUsingAttributeToSubjectMapping(SocialLoginConfig config) throws SettingCustomPropertiesException {
        AttributeToSubject attributeToSubject = this.createAttributeToSubject(config);
        this.username = attributeToSubject.getMappedUser();
        if (!config.getMapToUserRegistry()) {
            return this.createCustomPropertiesFromSubjectMapping(config, attributeToSubject);
        }
        return new Hashtable<String, Object>();
    }

    AttributeToSubject createAttributeToSubject(SocialLoginConfig config) {
        return new AttributeToSubject(this.userApiResponse, config.getUserNameAttribute(), config.getUserUniqueIdAttribute(), config.getRealmName(), config.getRealmNameAttribute(), config.getGroupNameAttribute(), config.getMapToUserRegistry(), config.getUserApiResponseIdentifier());
    }

    Hashtable<String, Object> createCustomPropertiesFromSubjectMapping(SocialLoginConfig config, AttributeToSubject attributeToSubject) throws SettingCustomPropertiesException {
        List<String> groupsWithRealm;
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        String realm = this.getRealm(attributeToSubject, config);
        String uniqueID = this.getUserAccessId(attributeToSubject, realm);
        customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
        if (realm != null && !realm.isEmpty()) {
            customProperties.put("com.ibm.wsspi.security.cred.realm", realm);
        }
        if (!(groupsWithRealm = this.getGroupsListWithRealm(attributeToSubject, realm)).isEmpty()) {
            customProperties.put("com.ibm.wsspi.security.cred.groups", groupsWithRealm);
        }
        return customProperties;
    }

    Hashtable<String, Object> setUsernameAndCustomPropertiesUsingJwt(SocialLoginConfig config) throws SettingCustomPropertiesException {
        this.setUserNameFromJwtClaims(config);
        if (this.username != null && !config.getMapToUserRegistry()) {
            return this.createCustomPropertiesFromConfig(config);
        }
        return new Hashtable<String, Object>();
    }

    void setUserNameFromJwtClaims(SocialLoginConfig config) {
        Claims claims;
        if (this.jwt != null && (claims = this.jwt.getClaims()) != null) {
            this.username = (String)claims.get((Object)config.getUserNameAttribute());
        }
    }

    Hashtable<String, Object> createCustomPropertiesFromConfig(SocialLoginConfig config) throws SettingCustomPropertiesException {
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        String realm = this.getRealm(config);
        customProperties.put("com.ibm.wsspi.security.cred.realm", realm);
        String uniqueID = "user:" + realm + "/" + this.username;
        customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
        return customProperties;
    }

    String getRealm(AttributeToSubject attributeToSubject, SocialLoginConfig config) throws SettingCustomPropertiesException {
        String realm = attributeToSubject.getMappedRealm();
        if (realm == null) {
            realm = this.getDefaultRealmFromAuthorizationEndpoint(config);
        }
        return realm;
    }

    String getRealm(SocialLoginConfig config) throws SettingCustomPropertiesException {
        String realm = config.getRealmName();
        if (realm == null) {
            realm = this.getDefaultRealmFromAuthorizationEndpoint(config);
        }
        return realm;
    }

    String getDefaultRealmFromAuthorizationEndpoint(SocialLoginConfig config) throws SettingCustomPropertiesException {
        String authzEndpoint = this.getAuthorizationEndpoint(config);
        if (!this.isValidAuthorizationEndpoint(authzEndpoint)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authorization endpoint [" + authzEndpoint + "] is either empty or too short to be a valid URL"), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"REALM_NOT_FOUND", (Object[])new Object[0]);
            throw new SettingCustomPropertiesException();
        }
        return this.extractRealmFromAuthorizationEndpoint(authzEndpoint);
    }

    Subject buildSubject(SocialLoginConfig config, Hashtable<String, Object> customProperties) throws SocialLoginException {
        Subject subject = new Subject();
        if (this.jwt != null) {
            subject.getPrivateCredentials().add(this.jwt);
        }
        if (this.issuedJwt != null) {
            customProperties.put("issuedJwt", this.issuedJwt.compact());
        }
        subject.getPrivateCredentials().add(customProperties);
        String encryptedAccessToken = null;
        String accessTokenAlias = null;
        UserProfile userProfile = this.createUserProfile(config);
        if (userProfile != null) {
            encryptedAccessToken = userProfile.getEncryptedAccessToken();
            accessTokenAlias = userProfile.getAccessTokenAlias();
            subject.getPrivateCredentials().add(userProfile);
        }
        CacheToken cacheToken = this.createCacheToken(config);
        if (encryptedAccessToken != null) {
            tokenCache.put(encryptedAccessToken, (Object)cacheToken);
        }
        if (accessTokenAlias != null) {
            tokenCache.put(accessTokenAlias, (Object)cacheToken);
        }
        return subject;
    }

    @FFDCIgnore(value={Exception.class})
    UserProfile createUserProfile(SocialLoginConfig config) throws SocialLoginException {
        Hashtable<String, Object> customProperties = this.createCustomProperties(config, true);
        Claims claims = null;
        try {
            BuilderUtils builderUtils = new BuilderUtils();
            claims = builderUtils.parseJwtForClaims(this.userApiResponse);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new UserProfile(this.jwt, customProperties, claims);
    }

    Hashtable<String, Object> createCustomProperties(SocialLoginConfig config, boolean getRefreshAndIdTokens) throws SocialLoginException {
        if (this.userApiResponseTokens == null) {
            throw new SocialLoginException("SOCIAL_LOGIN_RESULT_MISSING_ACCESS_TOKEN", null, new Object[0]);
        }
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        String accessToken = this.getAccessTokenAndAddCustomProp(customProperties);
        if (getRefreshAndIdTokens) {
            this.addRefreshTokenCustomProp(customProperties);
            this.addIdTokenCustomProp(customProperties);
        }
        this.addAccessTokenLifetimeCustomProp(customProperties);
        this.addSocialMediaNameCustomProp(customProperties, config);
        this.addScopeCustomProp(customProperties, config);
        this.addEncryptedAccessTokenCustomProp(customProperties, config, accessToken);
        this.addAccessTokenAliasCustomProp(customProperties, accessToken);
        return customProperties;
    }

    String getAccessTokenAndAddCustomProp(Hashtable<String, Object> customProperties) throws SocialLoginException {
        String accessToken = (String)this.userApiResponseTokens.get("access_token");
        if (accessToken == null) {
            throw new SocialLoginException("SOCIAL_LOGIN_RESULT_MISSING_ACCESS_TOKEN", null, new Object[0]);
        }
        customProperties.put("access_token", accessToken);
        return accessToken;
    }

    void addRefreshTokenCustomProp(Hashtable<String, Object> customProperties) {
        String key = "refresh_token";
        String refreshToken = (String)this.userApiResponseTokens.get(key);
        this.addNonNullNonEmptyCustomProperty(customProperties, key, refreshToken);
    }

    void addIdTokenCustomProp(Hashtable<String, Object> customProperties) {
        String key = "id_token";
        String idToken = (String)this.userApiResponseTokens.get(key);
        this.addNonNullNonEmptyCustomProperty(customProperties, key, idToken);
    }

    void addAccessTokenLifetimeCustomProp(Hashtable<String, Object> customProperties) {
        String key = "expires_in";
        Long accessTokenLifeTime = (Long)this.userApiResponseTokens.get(key);
        if (accessTokenLifeTime != null) {
            customProperties.put(key, accessTokenLifeTime);
        }
    }

    void addSocialMediaNameCustomProp(Hashtable<String, Object> customProperties, SocialLoginConfig config) {
        String socialMediaName = config.getUniqueId();
        this.addNonNullNonEmptyCustomProperty(customProperties, "social_media", socialMediaName);
    }

    void addScopeCustomProp(Hashtable<String, Object> customProperties, SocialLoginConfig config) {
        String key = "scope";
        String scope = (String)this.userApiResponseTokens.get(key);
        if (!this.addNonNullNonEmptyCustomProperty(customProperties, key, scope) && (scope = config.getScope()) != null) {
            this.addNonNullNonEmptyCustomProperty(customProperties, key, scope);
        }
    }

    @FFDCIgnore(value={SocialLoginException.class})
    void addEncryptedAccessTokenCustomProp(Hashtable<String, Object> customProperties, SocialLoginConfig config, String accessToken) throws SocialLoginException {
        String encryptedAccessToken = null;
        try {
            encryptedAccessToken = this.taiEncryptionUtils.getEncryptedAccessToken(config, accessToken);
        }
        catch (SocialLoginException e) {
            throw new SocialLoginException("ERROR_GETTING_ENCRYPTED_ACCESS_TOKEN", e, new Object[]{config.getUniqueId(), e.getLocalizedMessage()});
        }
        this.addNonNullNonEmptyCustomProperty(customProperties, "encrypted_token", encryptedAccessToken);
    }

    void addAccessTokenAliasCustomProp(Hashtable<String, Object> customProperties, String accessToken) {
        String accessTokenAlias = SocialHashUtils.digest((String)accessToken);
        this.addNonNullNonEmptyCustomProperty(customProperties, "accessTokenAlias", accessTokenAlias);
    }

    CacheToken createCacheToken(SocialLoginConfig config) {
        String idToken;
        CacheToken cacheToken = new CacheToken(this.accessToken, config.getUniqueId());
        String string = idToken = this.userApiResponseTokens != null ? (String)this.userApiResponseTokens.get("id_token") : null;
        if (idToken != null && !idToken.trim().isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caching ID token", (Object[])new Object[0]);
            }
            cacheToken.setIdToken(idToken);
        }
        return cacheToken;
    }

    private String getUserAccessId(AttributeToSubject attributeToSubject, String realm) {
        String uniqueUser = attributeToSubject.getMappedUniqueUser();
        return new StringBuffer("user:").append(realm).append("/").append(uniqueUser).toString();
    }

    private List<String> getGroupsListWithRealm(AttributeToSubject attributeToSubject, String realm) {
        ArrayList<String> groupsWithRealm = new ArrayList<String>();
        ArrayList groups = attributeToSubject.getMappedGroups();
        if (groups != null && !groups.isEmpty()) {
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                String group = "group:" + realm + "/" + (String)it.next();
                groupsWithRealm.add(group);
            }
        }
        return groupsWithRealm;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    private String getAuthorizationEndpoint(SocialLoginConfig config) {
        try {
            return this.taiWebUtils.getAuthorizationEndpoint(config);
        }
        catch (SocialLoginException e) {
            e.logErrorMessage();
            return null;
        }
    }

    private boolean isValidAuthorizationEndpoint(String authzEndpoint) {
        int httpsStrLen = "https://".length();
        return authzEndpoint != null && !authzEndpoint.isEmpty() && authzEndpoint.length() > httpsStrLen;
    }

    private String extractRealmFromAuthorizationEndpoint(String authzEndpoint) {
        int httpsStrLen = "https://".length();
        String endpointWithSchemeRemoved = authzEndpoint.substring(httpsStrLen);
        int firstSlashIndex = endpointWithSchemeRemoved.indexOf("/", 0);
        String realm = null;
        realm = firstSlashIndex > 0 ? authzEndpoint.substring(0, firstSlashIndex + httpsStrLen) : authzEndpoint;
        return realm;
    }

    private boolean addNonNullNonEmptyCustomProperty(Hashtable<String, Object> customProperties, String key, String value) {
        if (value != null && !value.trim().isEmpty()) {
            customProperties.put(key, value);
            return true;
        }
        return false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class SettingCustomPropertiesException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SettingCustomPropertiesException() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SettingCustomPropertiesException.class);
        }
    }
}

