/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.HashUtils;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.social.Constants;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.ErrorHandlerImpl;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.OidcLoginConfigImpl;
import com.ibm.ws.security.social.internal.utils.SocialLoginRequest;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.twitter.TwitterConstants;
import com.ibm.ws.security.social.twitter.TwitterTokenServices;
import com.ibm.ws.security.social.web.utils.ConfigInfoJsonBuilder;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointServices {
    private static TraceComponent tc = Tr.register(EndpointServices.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static ConcurrentServiceReferenceMap<String, SocialLoginConfig> socialLoginConfigRef = null;
    static AtomicServiceReference<SecurityService> securityServiceRef = null;
    static transient ReferrerURLCookieHandler referrerURLCookieHandler = null;
    SocialWebUtils webUtils = new SocialWebUtils();
    static final long serialVersionUID = -2472219844156883056L;

    public static void setReferrerURLCookieHandler(ReferrerURLCookieHandler referrerURLCookieHandler) {
        EndpointServices.referrerURLCookieHandler = referrerURLCookieHandler;
    }

    public static void setActivatedSocialLoginConfigRef(ConcurrentServiceReferenceMap<String, SocialLoginConfig> socialLoginConfigRef) {
        EndpointServices.socialLoginConfigRef = socialLoginConfigRef;
    }

    public static void setActivatedSecurityServiceRef(AtomicServiceReference<SecurityService> securityServiceRef) {
        EndpointServices.securityServiceRef = securityServiceRef;
    }

    protected void activate(ComponentContext cc) {
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_ENDPOINT_SERVICE_ACTIVATED", (Object[])new Object[0]);
    }

    protected void deactivate(ComponentContext cc) {
    }

    protected void handleSocialLoginRequest(HttpServletRequest request, HttpServletResponse response) throws SocialLoginException {
        SocialLoginRequest socialLoginRequest = (SocialLoginRequest)request.getAttribute("SocialLoginRequest");
        if (socialLoginRequest == null) {
            throw new SocialLoginException("SOCIAL_LOGIN_INVALID_URL", null, new Object[]{request.getRequestURL().toString()});
        }
        this.handleSocialLoginRequest(request, response, socialLoginRequest);
    }

    /*
     * WARNING - void declaration
     */
    void handleSocialLoginRequest(HttpServletRequest request, HttpServletResponse response, SocialLoginRequest socialLoginRequest) throws SocialLoginException {
        if (socialLoginRequest.isRedirect()) {
            try {
                SocialLoginConfig config = socialLoginRequest.getSocialLoginConfig();
                if (config == null) {
                    throw new SocialLoginException("REDIRECT_NO_MATCHING_CONFIG", null, new Object[]{request.getRequestURL().toString()});
                }
                if (config.getClass().getName().contains(TwitterConstants.TWITTER_CONFIG_CLASS)) {
                    this.doTwitter(request, response, config);
                }
                this.doRedirect(request, response, config);
            }
            catch (Exception config) {
                void e;
                FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.security.social.web.EndpointServices", (String)"115", (Object)this, (Object[])new Object[]{request, response, socialLoginRequest});
                throw new SocialLoginException("ERROR_PROCESSING_REDIRECT", null, new Object[]{e.getMessage()});
            }
        } else if (socialLoginRequest.isLogout()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("logout:" + socialLoginRequest.getRequestUrl()), (Object[])new Object[0]);
            }
        } else if (socialLoginRequest.isWellknownConfig()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(".well-known/config:" + socialLoginRequest.getRequestUrl()), (Object[])new Object[0]);
            }
            this.handleSocialLoginAPIRequest(request, response);
        } else if (socialLoginRequest.isUnknown()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unknown URL:" + socialLoginRequest.getRequestUrl()), (Object[])new Object[0]);
            }
            throw new SocialLoginException("SOCIAL_LOGIN_INVALID_URL", null, new Object[]{socialLoginRequest.getRequestUrl()});
        }
    }

    protected Map<String, Object> getParameterMap(SocialLoginConfig socialLoginConfig) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(Constants.KEY_SOCIALLOGIN_SERVICE, socialLoginConfig);
        if (securityServiceRef != null) {
            results.put(Constants.KEY_SECURITY_SERVICE, securityServiceRef.getService());
        }
        return results;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    protected void doTwitter(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) throws IOException {
        TwitterTokenServices ts = this.getTwitterTokenServices();
        Map<String, Object> result = ts.getAccessToken(request, response, config);
        if (result == null) {
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        String token = (String)result.get("access_token");
        String tokenSecret = (String)result.get("access_token_secret");
        String state = this.getStateCookieValue(request, response);
        if (state == null || state.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_STATE_MISSING", (Object[])new Object[]{config.getUniqueId()});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        String requestUrl = this.getRequestUrlCookieValue(request, response, state);
        if (requestUrl == null || requestUrl.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"TWITTER_ORIGINAL_REQUEST_URL_MISSING_OR_EMPTY", (Object[])new Object[]{config.getUniqueId()});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        try {
            SocialUtil.validateEndpointWithQuery(requestUrl);
        }
        catch (SocialLoginException e) {
            Tr.error((TraceComponent)tc, (String)"REQUEST_URL_NOT_VALID", (Object[])new Object[]{requestUrl, e.getMessage()});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        this.cacheValueInCookie(request, response, "WASSocialAccessToken", token);
        this.cacheSensitiveValueInCookie(request, response, "WASSocialAccessTokenSecret", tokenSecret);
        response.sendRedirect(requestUrl);
    }

    @Trivial
    private String dumpMap(Map<String, String[]> m) {
        StringBuffer sb = new StringBuffer();
        sb.append(" --- request parameters: ---\n");
        for (String key : m.keySet()) {
            String[] values = m.get(key);
            sb.append(key + ": ");
            for (String s : values) {
                sb.append("[" + s + "] ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void doRedirect(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) throws IOException {
        String error;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.dumpMap(request.getParameterMap()), (Object[])new Object[0]);
        }
        if ((error = request.getParameter("error")) != null) {
            Tr.error((TraceComponent)tc, (String)"REDIRECT_REQUEST_CONTAINED_ERROR", (Object[])new Object[]{request.getParameter("error"), request.getParameter("error_description"), request.getParameter("error_uri")});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        String state = request.getParameter("state");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("state is " + state), (Object[])new Object[0]);
        }
        if (state == null || state.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The state is null", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"STATE_NULL_OR_MISMATCHED", (Object[])new Object[0]);
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        if (config instanceof OidcLoginConfigImpl) {
            this.finishOidcRedirect(request, response, config);
        } else {
            this.finishOAuthRedirect(request, response, config);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finishOAuthRedirect(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) throws IOException {
        String stateCookie;
        String state = request.getParameter("state");
        if (!state.equals(stateCookie = this.getStateCookieValue(request, response))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The state mismatches", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"STATE_NULL_OR_MISMATCHED", (Object[])new Object[0]);
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        String requestUrl = this.getRequestUrlCookieValue(request, response, state);
        if (requestUrl == null || requestUrl.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"requestURL is null or empty", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"REQUEST_URL_NULL_OR_EMPTY", (Object[])new Object[0]);
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"requestURL is not null or empty", (Object[])new Object[0]);
        }
        try {
            SocialUtil.validateEndpointWithQuery(requestUrl);
        }
        catch (SocialLoginException socialLoginException) {
            void e;
            FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.web.EndpointServices", (String)"284", (Object)this, (Object[])new Object[]{request, response, config});
            Tr.error((TraceComponent)tc, (String)"REQUEST_URL_NOT_VALID", (Object[])new Object[]{requestUrl, e.getMessage()});
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        String code = request.getParameter("code");
        if (code == null || code.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"code parameter in request is null or empty, return internal error", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"CODE_PARAMETER_NULL_OR_EMPTY", (Object[])new Object[0]);
            ErrorHandlerImpl.getInstance().handleErrorResponse(response);
            return;
        }
        this.cacheValueInCookie(request, response, "WASSocialState", code);
        response.sendRedirect(requestUrl);
    }

    private void finishOidcRedirect(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig config) throws IOException {
        String state = request.getParameter("state");
        String cookieName = "WASReqURLOidc" + HashUtils.getStrHashCode((String)state);
        Cookie[] cookies = request.getCookies();
        String requestUrl = CookieHelper.getCookieValue((Cookie[])cookies, (String)cookieName);
        OidcClientUtil.invalidateReferrerURLCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)cookieName);
        if (tc.isDebugEnabled() && requestUrl != null) {
            Tr.debug((TraceComponent)tc, (String)("requestUrl: " + requestUrl), (Object[])new Object[0]);
        }
        if (requestUrl == null || requestUrl.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_REQUEST_NO_COOKIE", (Object[])new Object[]{request.getRequestURL()});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(500);
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"requestURL is not null or empty", (Object[])new Object[0]);
        }
        String clientId = null;
        int iPrefix = request.getRequestURI().lastIndexOf("/");
        if (iPrefix > -1) {
            clientId = request.getRequestURI().substring(iPrefix + 1);
        }
        String oidcClientId = null;
        if (state.length() > 24) {
            oidcClientId = state.substring(24);
        }
        String code = request.getParameter("code");
        String idToken = request.getParameter("id_token");
        if (code == null && idToken == null) {
            throw new UnsupportedOperationException();
        }
        OidcLoginConfigImpl oc = (OidcLoginConfigImpl)config;
        this.sendToRedirectUrl(request, response, requestUrl, state, clientId, oidcClientId, idToken, oc);
    }

    private void sendToRedirectUrl(HttpServletRequest request, HttpServletResponse response, String requestUrl, String state, String clientId, String oidcClientId, String id_token, ConvergedClientConfig config) throws IOException {
        String sessionState = request.getParameter("session_state");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Request info: state: " + state + " session_state: " + sessionState), (Object[])new Object[0]);
        }
        boolean isHttpsRequest = requestUrl.toLowerCase().startsWith("https");
        new OidcClientUtil();
        OidcClientUtil.setCookieForRequestParameter((HttpServletRequest)request, (HttpServletResponse)response, (String)clientId, (String)state, (boolean)isHttpsRequest, (ConvergedClientConfig)config);
        if (oidcClientId != null && !oidcClientId.isEmpty() || id_token != null) {
            throw new UnsupportedOperationException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("... expect to be redirected by the browser:" + requestUrl), (Object[])new Object[0]);
        }
        response.sendRedirect(requestUrl);
    }

    protected String getStateCookieValue(HttpServletRequest request, HttpServletResponse response) {
        return this.webUtils.getAndClearCookie(request, response, "WASSocialState");
    }

    protected String getRequestUrlCookieValue(HttpServletRequest request, HttpServletResponse response, String state) {
        String reqUrlCookieName = "WASReqUrlSocial_" + state.hashCode();
        String requestUrl = this.webUtils.getAndClearCookie(request, response, reqUrlCookieName);
        requestUrl = this.decodeAndNormalizeRequestUrl(requestUrl);
        if (tc.isDebugEnabled() && requestUrl != null) {
            Tr.debug((TraceComponent)tc, (String)("The restored request Url: " + requestUrl), (Object[])new Object[0]);
        }
        return requestUrl;
    }

    String decodeAndNormalizeRequestUrl(String requestUrl) {
        try {
            requestUrl = URLDecoder.decode(requestUrl, "UTF-8");
            requestUrl = requestUrl.replaceAll(" ", "%20");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.web.EndpointServices", (String)"392", (Object)this, (Object[])new Object[]{requestUrl});
        }
        return requestUrl;
    }

    protected void cacheValueInCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, String value) {
        if (value == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Value to store in cookie is null, so no cookie will be created", (Object[])new Object[0]);
            }
            return;
        }
        if (referrerURLCookieHandler == null) {
            referrerURLCookieHandler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
        }
        Cookie c = referrerURLCookieHandler.createCookie(cookieName, value, req);
        resp.addCookie(c);
    }

    protected void cacheSensitiveValueInCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, @Sensitive String value) {
        if (value == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Value to store in cookie is null, so no cookie will be created", (Object[])new Object[0]);
            }
            return;
        }
        if (referrerURLCookieHandler == null) {
            referrerURLCookieHandler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
        }
        Cookie c = referrerURLCookieHandler.createCookie(cookieName, value, req);
        resp.addCookie(c);
    }

    protected void handleSocialLoginAPIRequest(HttpServletRequest request, HttpServletResponse response) {
        JSONObject json = this.getAllSocialLoginConfigs();
        this.writeToResponse(json, response);
    }

    /*
     * WARNING - void declaration
     */
    private void writeToResponse(JSONObject json, HttpServletResponse response) {
        block5: {
            if (json == null || json.toString() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Provided JSON object is null", (Object[])new Object[0]);
                }
                ErrorHandlerImpl.getInstance().handleErrorResponse(response);
                return;
            }
            this.addNoCacheHeaders(response);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("socialLoginConfigs json :" + json.toString()), (Object[])new Object[0]);
            }
            response.setStatus(200);
            try {
                PrintWriter pw = response.getWriter();
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                pw.write(json.toString());
                pw.flush();
                pw.close();
            }
            catch (IOException pw) {
                void e;
                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.social.web.EndpointServices", (String)"461", (Object)this, (Object[])new Object[]{json, response});
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Caught an exception attempting to get the response writer: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
    }

    private void addNoCacheHeaders(HttpServletResponse response) {
        String cacheControlValue = response.getHeader("Cache-Control");
        cacheControlValue = cacheControlValue != null && !cacheControlValue.isEmpty() ? cacheControlValue + ", " + "no-store" : "no-store";
        response.setHeader("Cache-Control", cacheControlValue);
        response.setHeader("Pragma", "no-cache");
    }

    JSONObject getAllSocialLoginConfigs() {
        if (socialLoginConfigRef == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Social login config reference not set", (Object[])new Object[0]);
            }
            return new JSONObject();
        }
        Iterator configIt = socialLoginConfigRef.getServices();
        ConfigInfoJsonBuilder configJsonBuilder = new ConfigInfoJsonBuilder(configIt);
        return configJsonBuilder.buildJsonResponse();
    }

    protected TwitterTokenServices getTwitterTokenServices() {
        return new TwitterTokenServices();
    }
}

