/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TimeoutImpl {
    private static final TraceComponent tc = Tr.register(TimeoutImpl.class);
    private final String id;
    private final TimeoutPolicy timeoutPolicy;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Future<?> future;
    private boolean timedout = false;
    private boolean stopped = false;
    private long start;
    private long targetEnd;
    private Runnable timeoutTask;
    static final long serialVersionUID = 7115888473534024017L;

    public TimeoutImpl(String id, TimeoutPolicy timeoutPolicy, ScheduledExecutorService scheduledExecutorService) {
        this.id = id;
        this.timeoutPolicy = timeoutPolicy;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void start(Thread targetThread) {
        Runnable timeoutTask = () -> targetThread.interrupt();
        this.start(timeoutTask);
    }

    public void start(QueuedFuture<?> queuedFuture) {
        Runnable timeoutTask = () -> queuedFuture.internalCancel();
        this.start(timeoutTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        this.lock.writeLock().lock();
        try {
            if (!this.stopped) {
                long now = System.nanoTime();
                long remaining = this.targetEnd - now;
                boolean bl = this.timedout = remaining <= 1000000L;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    this.debugTime("!Start  {0}", this.start);
                    this.debugTime("!Target {0}", this.targetEnd);
                    this.debugTime("!Now    {0}", now);
                    this.debugTime("!Remain {0}", remaining);
                }
                if (this.timedout) {
                    this.debugRelativeTime("Timeout!");
                    this.timeoutTask.run();
                } else {
                    this.debugTime("Premature Timeout!", remaining);
                    this.start(this.timeoutTask, remaining);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void start(Runnable timeoutTask) {
        long timeout = this.timeoutPolicy.getTimeout().toNanos();
        this.start(timeoutTask, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Runnable timeoutTask, long remainingNanos) {
        this.lock.writeLock().lock();
        try {
            this.timeoutTask = timeoutTask;
            this.start = System.nanoTime();
            this.targetEnd = this.start + remainingNanos;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debugTime(">Start  {0}", this.start);
                this.debugTime(">Target {0}", this.targetEnd);
                this.debugTime(">Now    {0}", this.start);
                this.debugTime(">Remain {0}", remainingNanos);
            }
            Runnable task = () -> this.timeout();
            if (remainingNanos > 1000000L) {
                this.future = this.scheduledExecutorService.schedule(task, remainingNanos, TimeUnit.NANOSECONDS);
            } else {
                task.run();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void stop() {
        this.lock.writeLock().lock();
        try {
            this.debugRelativeTime("Stop!");
            this.stopped = true;
            if (this.future != null && !this.future.isDone()) {
                this.debugRelativeTime("Cancelling");
                this.future.cancel(true);
            }
            this.future = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void stop(boolean exceptionOnTimeout) {
        this.stop();
        if (exceptionOnTimeout) {
            this.check();
        }
    }

    public void restart() {
        this.lock.writeLock().lock();
        try {
            if (this.timeoutTask == null) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
            this.stop();
            this.stopped = false;
            this.start(this.timeoutTask);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartOnNewThread(Thread newThread) {
        this.lock.writeLock().lock();
        try {
            if (this.timeoutTask == null) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
            this.stop();
            this.stopped = false;
            long remaining = this.check();
            Runnable timeoutTask = () -> newThread.interrupt();
            this.start(timeoutTask, remaining);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long check() {
        long remaining = 0L;
        this.lock.readLock().lock();
        try {
            if (this.timedout) {
                boolean wasInterrupted = Thread.interrupted();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (wasInterrupted) {
                        Tr.debug((TraceComponent)tc, (String)"{0}: Throwing timeout exception and clearing interrupted flag", (Object[])new Object[]{this.getDescriptor()});
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"{0}: Throwing timeout exception", (Object[])new Object[]{this.getDescriptor()});
                    }
                }
                throw new TimeoutException(Tr.formatMessage((TraceComponent)tc, (String)"timeout.occurred.CWMFT0000E", (Object[])new Object[0]));
            }
            long now = System.nanoTime();
            remaining = this.targetEnd - now;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                this.debugTime("?Start ", this.start);
                this.debugTime("?Target", this.targetEnd);
                this.debugTime("?Now   ", now);
                this.debugTime("?Remain", remaining);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return remaining;
    }

    @Trivial
    public String toString() {
        return this.getDescriptor();
    }

    @Trivial
    public String getDescriptor() {
        return "Timeout[" + this.id + "]";
    }

    @Trivial
    private void debugRelativeTime(String message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            FTDebug.debugRelativeTime((TraceComponent)tc, (String)this.getDescriptor(), (String)message, (long)this.start);
        }
    }

    @Trivial
    private void debugTime(String message, long nanos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            FTDebug.debugTime((TraceComponent)tc, (String)this.getDescriptor(), (String)message, (long)nanos);
        }
    }

    @Trivial
    private void debugTime(String message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.debugTime(message, System.nanoTime());
        }
    }
}

