/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.impl.CircuitBreakerImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.async.AsyncInnerExecutorImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.async.QueuedFuture;
import com.ibm.ws.microprofile.faulttolerance.impl.sync.SynchronousExecutorImpl;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.PolicyExecutorProvider;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.SyncFailsafe;
import net.jodah.failsafe.function.CheckedFunction;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AsyncOuterExecutorImpl<R>
extends SynchronousExecutorImpl<Future<R>> {
    private static final TraceComponent tc = Tr.register(AsyncOuterExecutorImpl.class);
    private final AsyncInnerExecutorImpl<Future<R>> nestedExecutor = new AsyncInnerExecutorImpl();
    private final BulkheadPolicy bulkheadPolicy;
    private final WSContextService contextService;
    private final ExecutorService executorService;
    private static final Map<String, ?>[] THREAD_CONTEXT_PROVIDERS = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.classloader.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.javaee.metadata.context.provider"), Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    static final long serialVersionUID = -6010422175911062666L;

    public AsyncOuterExecutorImpl(RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, WSContextService contextService, PolicyExecutorProvider policyExecutorProvider, ScheduledExecutorService scheduledExecutorService, MetricRecorder metricRecorder) {
        super(retryPolicy, circuitBreakerPolicy, timeoutPolicy, bulkheadPolicy, fallbackPolicy, scheduledExecutorService, metricRecorder);
        this.bulkheadPolicy = bulkheadPolicy;
        this.contextService = contextService;
        if (policyExecutorProvider != null) {
            PolicyExecutor policyExecutor = policyExecutorProvider.create("FaultTolerance_" + UUID.randomUUID().toString());
            if (this.bulkheadPolicy != null) {
                int maxThreads = bulkheadPolicy.getMaxThreads();
                int queueSize = bulkheadPolicy.getQueueSize();
                policyExecutor.maxConcurrency(maxThreads);
                policyExecutor.maxQueueSize(queueSize);
                metricRecorder.setBulkheadQueuePopulationSupplier(() -> queueSize - policyExecutor.queueCapacityRemaining());
                metricRecorder.setBulkheadConcurentExecutionCountSupplier(() -> ((PolicyExecutor)policyExecutor).getRunningTaskCount());
            }
            this.executorService = policyExecutor;
        } else if ("true".equalsIgnoreCase(System.getProperty("com.ibm.ws.microprofile.faulttolerance.jse"))) {
            int maxThreads = Integer.MAX_VALUE;
            int queueSize = 1000;
            if (this.bulkheadPolicy != null) {
                maxThreads = bulkheadPolicy.getMaxThreads();
                queueSize = bulkheadPolicy.getQueueSize();
            }
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueSize, true);
            this.executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, Executors.defaultThreadFactory());
        } else {
            throw new FaultToleranceException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
        }
    }

    @Override
    protected void executionComplete(ExecutionContextImpl executionContext, Throwable t) {
        if (t != null) {
            executionContext.onFullExecutionComplete(t);
        }
    }

    @Override
    public Future<R> execute(Callable<Future<R>> callable, ExecutionContext executionContext) {
        ExecutionContextImpl context = (ExecutionContextImpl)executionContext;
        CircuitBreakerImpl breaker = context.getCircuitBreaker();
        if (breaker != null && !breaker.allowsExecution()) {
            context.start();
            context.end();
            context.onMainExecutionComplete((Throwable)new net.jodah.failsafe.CircuitBreakerOpenException());
            if (context.getFallbackPolicy() != null) {
                return this.callFallback(context);
            }
            throw new CircuitBreakerOpenException();
        }
        return super.execute(callable, executionContext);
    }

    @Override
    protected void configureFailsafe(SyncFailsafe<Future<R>> failsafe, ExecutionContextImpl executionContextImpl) {
        failsafe.onRetry(t -> executionContextImpl.onRetry((Throwable)t));
        failsafe.onComplete((r, t) -> {
            if (t != null) {
                executionContextImpl.onMainExecutionComplete((Throwable)t);
            }
        });
        if (executionContextImpl.getFallbackPolicy() != null) {
            CheckedFunction fallback = t -> {
                executionContextImpl.onMainExecutionComplete((Throwable)t);
                return (Future)executionContextImpl.getFallbackPolicy().getFallbackFunction().execute((Object)executionContextImpl);
            };
            failsafe = (SyncFailsafe)failsafe.withFallback(fallback);
        }
    }

    @Override
    protected Callable<Future<R>> createTask(Callable<Future<R>> callable, final ExecutionContextImpl executionContext) {
        final Callable<Future> innerTask = () -> {
            executionContext.onUnqueued();
            Long startTime = System.nanoTime();
            try {
                Future<R> future;
                Future<R> future2 = future = this.nestedExecutor.execute(callable, (ExecutionContext)executionContext);
                return future2;
            }
            finally {
                this.metricRecorder.recordBulkheadExecutionTime(System.nanoTime() - startTime);
            }
        };
        Callable outerTask = new Callable<Future<R>>(){
            static final long serialVersionUID = -6707791524105022282L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={RejectedExecutionException.class})
            public Future<R> call() {
                ThreadContextDescriptor threadContext = null;
                if (AsyncOuterExecutorImpl.this.contextService != null) {
                    threadContext = AsyncOuterExecutorImpl.this.contextService.captureThreadContext(new HashMap(), THREAD_CONTEXT_PROVIDERS);
                }
                QueuedFuture queuedFuture = new QueuedFuture(innerTask, executionContext, threadContext);
                try {
                    executionContext.onQueued();
                    queuedFuture.start(AsyncOuterExecutorImpl.this.executorService);
                    AsyncOuterExecutorImpl.this.metricRecorder.incrementBulkeadAcceptedCount();
                }
                catch (RejectedExecutionException e) {
                    executionContext.close();
                    AsyncOuterExecutorImpl.this.metricRecorder.incrementBulkheadRejectedCount();
                    BulkheadException bulkheadException = new BulkheadException(Tr.formatMessage((TraceComponent)tc, (String)"bulkhead.no.threads.CWMFT0001E", (Object[])new Object[]{FTDebug.formatMethod((Method)executionContext.getMethod())}), (Throwable)e);
                    AsyncOuterExecutorImpl.this.reportFailure(executionContext, (Exception)bulkheadException);
                    throw bulkheadException;
                }
                return queuedFuture;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
        return outerTask;
    }

    @FFDCIgnore(value={Throwable.class})
    private Future<R> callFallback(ExecutionContextImpl context) {
        try {
            return (Future)context.getFallbackPolicy().getFallbackFunction().execute((Object)context);
        }
        catch (Throwable t) {
            throw new ExecutionException(t);
        }
    }

    private void reportFailure(ExecutionContextImpl context, Exception ex) {
        CircuitBreakerImpl breaker = context.getCircuitBreaker();
        if (breaker != null && breaker.isFailure(null, ex)) {
            try {
                Failsafe.with((CircuitBreaker)breaker).run(() -> {
                    throw ex;
                });
            }
            catch (FailsafeException | CircuitBreakerOpenException throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.faulttolerance.impl.async.AsyncOuterExecutorImpl", (String)"288", (Object)this, (Object[])new Object[]{context, ex});
            }
        }
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        super.close();
        this.nestedExecutor.close();
    }
}

