/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.sync;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.sync.SimpleTaskRunner;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SemaphoreTaskRunner<R>
extends SimpleTaskRunner<R> {
    private static final TraceComponent tc = Tr.register(SemaphoreTaskRunner.class);
    private final Semaphore semaphore;
    private final MetricRecorder metricRecorder;
    private final int maxThreads;
    static final long serialVersionUID = -7807538549679758041L;

    public SemaphoreTaskRunner(BulkheadPolicy bulkheadPolicy, MetricRecorder metricRecorder) {
        this.maxThreads = bulkheadPolicy.getMaxThreads();
        this.semaphore = new Semaphore(bulkheadPolicy.getMaxThreads());
        this.metricRecorder = metricRecorder;
        metricRecorder.setBulkheadConcurentExecutionCountSupplier(this::getConcurrentExecutions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R runTask(Callable<R> callable, ExecutionContextImpl executionContext) throws Exception {
        boolean acquired;
        R result = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Acquiring semaphore for {0}", (Object[])new Object[]{executionContext.getDescriptor()});
        }
        if (!(acquired = this.semaphore.tryAcquire())) {
            this.metricRecorder.incrementBulkheadRejectedCount();
            throw new BulkheadException(Tr.formatMessage((TraceComponent)tc, (String)"bulkhead.no.threads.CWMFT0001E", (Object[])new Object[]{FTDebug.formatMethod((Method)executionContext.getMethod())}));
        }
        long startTime = System.nanoTime();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Obtained semaphore for {0}", (Object[])new Object[]{executionContext.getDescriptor()});
            }
            this.metricRecorder.incrementBulkeadAcceptedCount();
            result = super.runTask(callable, executionContext);
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Releasing semaphore for {0}", (Object[])new Object[]{executionContext.getDescriptor()});
            }
            this.metricRecorder.recordBulkheadExecutionTime(System.nanoTime() - startTime);
            this.semaphore.release();
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Releasing semaphore for {0}", (Object[])new Object[]{executionContext.getDescriptor()});
        }
        this.metricRecorder.recordBulkheadExecutionTime(System.nanoTime() - startTime);
        this.semaphore.release();
        return result;
    }

    private long getConcurrentExecutions() {
        return this.maxThreads - this.semaphore.availablePermits();
    }
}

