/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import org.apache.yoko.orb.OB.Assert;
import org.omg.PortableServer.Servant;

class TableEntry {
    private Servant servant_;
    static final int ACTIVATE_PENDING = 0;
    static final int ACTIVE = 1;
    static final int DEACTIVATE_PENDING = 2;
    static final int DEACTIVATED = 3;
    private int state_ = 0;
    private int outstandingRequests_ = 0;

    TableEntry() {
    }

    void setServant(Servant s) {
        Assert._OB_assert(this.servant_ == null && s != null && this.state_ == 0);
        this.servant_ = s;
    }

    void clearServant() {
        Assert._OB_assert(this.state_ == 3 && this.outstandingRequests_ == 0);
        this.servant_ = null;
    }

    Servant getServant() {
        Assert._OB_assert(this.state_ == 1 || this.state_ == 2);
        return this.servant_;
    }

    int state() {
        return this.state_;
    }

    void setActive() {
        this.state_ = 1;
        this.notifyAll();
    }

    void setDeactivatePending() {
        this.state_ = 2;
        this.notifyAll();
    }

    void setDeactivated() {
        this.state_ = 3;
        this.notifyAll();
    }

    void waitForStateChange() {
        int state = this.state_;
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.state_ == state);
    }

    int getOutstandingRequests() {
        return this.outstandingRequests_;
    }

    void incOutstandingRequest() {
        ++this.outstandingRequests_;
    }

    int decOutstandingRequest() {
        return --this.outstandingRequests_;
    }
}

