/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.metagen;

import com.ibm.websphere.metatype.MetaTypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.annotations.ModuleAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.jca.utils.Utils;
import com.ibm.ws.jca.utils.exception.ResourceAdapterInstallException;
import com.ibm.ws.jca.utils.metagen.ChildAliasSelector;
import com.ibm.ws.jca.utils.metagen.DeploymentDescriptorParser;
import com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor;
import com.ibm.ws.jca.utils.metagen.internal.MetaGenConfig;
import com.ibm.ws.jca.utils.metagen.internal.MetaGenInstance;
import com.ibm.ws.jca.utils.metagen.internal.XmlFileSet;
import com.ibm.ws.jca.utils.xml.metatype.Metatype;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeAd;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeAdOption;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeDesignate;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeObject;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeOcd;
import com.ibm.ws.jca.utils.xml.ra.RaActivationSpec;
import com.ibm.ws.jca.utils.xml.ra.RaAdminObject;
import com.ibm.ws.jca.utils.xml.ra.RaConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.RaConnectionDefinition;
import com.ibm.ws.jca.utils.xml.ra.RaConnector;
import com.ibm.ws.jca.utils.xml.ra.RaDescription;
import com.ibm.ws.jca.utils.xml.ra.RaDisplayName;
import com.ibm.ws.jca.utils.xml.ra.RaInboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageListener;
import com.ibm.ws.jca.utils.xml.ra.RaOutboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaRequiredConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.RaResourceAdapter;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpConfigOption;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpIbmuiGroups;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConfigProperty;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConnector;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaMessageListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.Referenceable;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.TransactionContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetatypeGenerator {
    private static final TraceComponent tc = Tr.register(MetatypeGenerator.class);
    private static final Set<String> INTERFACE_NAMES_TO_SKIP = new HashSet<String>(Arrays.asList(BeanInfo.class.getName(), Cloneable.class.getName(), Comparable.class.getName(), Externalizable.class.getName(), Iterable.class.getName(), Referenceable.class.getName(), javax.resource.Referenceable.class.getName(), ResourceAdapterAssociation.class.getName(), Serializable.class.getName(), Wrapper.class.getName()));
    private final List<String> buildTimeWarnings = new LinkedList<String>();
    private Metatype masterMetatype;
    private MetaGenConfig config;
    private String generalAdapterName = null;
    private Map<String, String> suffixOverridesByIntf;
    private Map<String, String> suffixOverridesByImpl;
    private Map<String, String> suffixOverridesByBoth;
    private final MetaTypeFactory metaTypeFactoryService;
    ClassLoader raClassLoader = null;
    ModuleAnnotations moduleAnnotations;
    List<String> classNames = new ArrayList<String>();
    static final long serialVersionUID = 1404242485501199540L;

    private MetatypeGenerator(MetaTypeFactory mtpService) {
        this.metaTypeFactoryService = mtpService;
    }

    private void addInterfaces(MetatypeOcd ocd, String interfaceName) throws ClassNotFoundException {
        StringBuilder interfacesString;
        HashSet<String> interfaceNames;
        block5: {
            interfaceNames = new HashSet<String>();
            interfaceNames.add(interfaceName);
            interfacesString = new StringBuilder(interfaceName);
            LinkedList interfacesToProcess = new LinkedList();
            if (this.raClassLoader != null) {
                try {
                    Class cl = this.raClassLoader.loadClass(interfaceName);
                    while (cl != null) {
                        for (Class<?> ifc : cl.getInterfaces()) {
                            interfaceName = ifc.getName();
                            if (INTERFACE_NAMES_TO_SKIP.contains(interfaceName) || !interfaceNames.add(interfaceName)) continue;
                            interfacesToProcess.add(ifc);
                            interfacesString.append(',').append(interfaceName);
                        }
                        cl = (Class)interfacesToProcess.poll();
                    }
                }
                catch (ClassNotFoundException cl) {
                    FFDCFilter.processException((Throwable)cl, (String)"com.ibm.ws.jca.utils.metagen.MetatypeGenerator", (String)"170", (Object)this, (Object[])new Object[]{ocd, interfaceName});
                    Tr.warning((TraceComponent)tc, (String)"J2CA9919.class.not.found", (Object[])new Object[]{interfaceName, this.generalAdapterName});
                    if (this.config.isRuntime()) break block5;
                    this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9919.class.not.found", (Object[])new Object[]{interfaceName, this.generalAdapterName}));
                }
            }
        }
        MetatypeAd ad = new MetatypeAd(this.metaTypeFactoryService);
        ad.setId("creates.objectClass");
        ad.setType("String");
        ad.setDefault(interfacesString.toString());
        ad.setFinal(true);
        ad.setCardinality(interfaceNames.size());
        ad.setName("internal");
        ad.setDescription("internal use only");
        ocd.addMetatypeAd(ad);
    }

    public static Metatype generateMetatype(Map<String, Object> configProps, MetaTypeFactory mtpService) throws Exception {
        return new MetatypeGenerator(mtpService).generateMetatypeInternal(configProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private Metatype generateMetatypeInternal(Map<String, Object> configProps) throws Exception {
        long start = System.nanoTime();
        try {
            this.setup(configProps);
            this.buildMetatype();
            this.postBuild(configProps);
            for (String warning : this.buildTimeWarnings) {
                PrintStream.class.getMethod("println", String.class).invoke((Object)System.out, warning);
            }
        }
        catch (Throwable throwable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                long duration = (System.nanoTime() - start) / 1000000L;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Metatype for resource adapter " + this.generalAdapterName + " generated in " + (float)duration / 1000.0f + " seconds"), (Object[])new Object[]{this.masterMetatype == null ? null : this.masterMetatype.toMetatypeString(true)});
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            long duration = (System.nanoTime() - start) / 1000000L;
            Tr.event((Object)this, (TraceComponent)tc, (String)("Metatype for resource adapter " + this.generalAdapterName + " generated in " + (float)duration / 1000.0f + " seconds"), (Object[])new Object[]{this.masterMetatype == null ? null : this.masterMetatype.toMetatypeString(true)});
        }
        return this.masterMetatype;
    }

    private void buildMetatype() throws InvalidPropertyException, UnavailableException, ResourceAdapterInternalException, ClassNotFoundException {
        WlpIbmuiGroups ibmuiGroups;
        MetaGenInstance instance = this.config.getInstance();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Building metatype for:", (Object[])new Object[]{instance});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"adapterName", (Object[])new Object[]{instance.adapterName});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"raXmlFile", (Object[])new Object[]{instance.xmlFileSet.raXmlFile});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"wlpRaXmlFile", (Object[])new Object[]{instance.xmlFileSet.wlpRaXmlFile});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"parsedXml", (Object[])new Object[]{instance.xmlFileSet.parsedXml});
            Tr.debug((Object)this, (TraceComponent)tc, (String)"parsedWlpXml", (Object[])new Object[]{instance.xmlFileSet.parsedWlpXml});
        }
        if (instance.xmlFileSet.parsedWlpXml != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"combining ra and wlp xmls", (Object[])new Object[0]);
            }
            DeploymentDescriptorParser.combineWlpAndRaXmls(instance.adapterName, instance.xmlFileSet.parsedXml, instance.xmlFileSet.parsedWlpXml);
        }
        if ((ibmuiGroups = instance.xmlFileSet.parsedXml.getWlpIbmuiGroups()) != null) {
            this.config.setIbmuiGroups(ibmuiGroups);
            instance.metatype.setIbmuiGroupOrder(ibmuiGroups.getGroupOrder());
        }
        instance.metatype.setOriginatingRaConnector(instance.xmlFileSet.parsedXml);
        this.buildResourceAdapters(instance);
        this.buildConnectionFactories(instance);
        this.buildAdminObjects(instance);
        this.buildMessageListeners(instance);
        instance.markAsProcessed();
    }

    private void buildResourceAdapters(MetaGenInstance instance) throws ResourceAdapterInternalException, InvalidPropertyException, ClassNotFoundException {
        String modName;
        List<String> requiredWorkContexts;
        String pid;
        String raAlias;
        RaResourceAdapter adapter = instance.xmlFileSet.parsedXml.getResourceAdapter();
        if (adapter.getResourceAdapterClass() != null) {
            this.validateClassImplementsInterface(adapter.getResourceAdapterClass(), ResourceAdapter.class);
        }
        MetatypeDesignate designate = new MetatypeDesignate();
        MetatypeObject object = new MetatypeObject();
        MetatypeOcd ocd = new MetatypeOcd(this.metaTypeFactoryService);
        if (instance.adapterName.equals("wmqJms")) {
            raAlias = "wmqJmsClient";
            pid = "com.ibm.ws.jca." + raAlias;
            ocd.setAlias(raAlias);
        } else {
            raAlias = "properties." + instance.adapterName;
            pid = "com.ibm.ws.jca.resourceAdapter." + raAlias;
            if (!this.config.get(".installedByDropins", Boolean.FALSE).booleanValue()) {
                boolean isRAREmbeddedInApp = this.config.get("rar.embedded.in.app", null) != null;
                ocd.setChildAlias(raAlias);
                String parentPID = isRAREmbeddedInApp ? "com.ibm.ws.jca.embeddedResourceAdapter" : ("wasJms".equals(instance.adapterName) || "wmqJms".equals(instance.adapterName) ? "com.ibm.ws.jca.bundleResourceAdapter" : "com.ibm.ws.jca.resourceAdapter");
                ocd.setParentPID(parentPID);
            }
        }
        designate.setInternalInformation(Utils.ConstructType.ResourceAdapter, adapter);
        designate.setFactoryPid(pid);
        object.setOcdref(pid);
        designate.setObject(object);
        instance.metatype.addDesignate(designate);
        ocd.setId(pid);
        RaConnector connector = instance.xmlFileSet.parsedXml;
        String displayName = adapter.getName();
        if (displayName == null) {
            for (RaDisplayName dname : connector.getDisplayName()) {
                if ("en".equalsIgnoreCase(dname.getLang())) {
                    displayName = dname.getValue();
                    break;
                }
                displayName = dname.getValue();
            }
            displayName = displayName == null ? instance.adapterName + " Properties" : instance.adapterName + " (" + displayName + ") Properties";
            String version = connector.getResourceAdapterVersion();
            if (version != null && version.length() > 0) {
                displayName = displayName + ", Version " + version;
            }
        }
        ocd.setName(displayName);
        String description = adapter.getDescription();
        String descFromConnector = "";
        for (Description desc : connector.getDescriptions()) {
            if (desc.getLang().equals("en")) {
                descFromConnector = desc.getValue();
                break;
            }
            descFromConnector = desc.getValue();
        }
        ocd.setDescription(description == null ? descFromConnector : description);
        ocd.setExtends("com.ibm.ws.jca.resourceAdapter.properties");
        object.setMatchingOcd(ocd);
        ocd.addInternalMetatypeAd("contextService.target", this.config.get("contextService.target", "(service.pid=com.ibm.ws.context.manager)"));
        ocd.addInternalMetatypeAd("executorService.target", "(service.pid=com.ibm.ws.threading)");
        ocd.addInternalMetatypeAd("id", instance.adapterName);
        ocd.addInternalMetatypeAd("resourceAdapterService.target", "(id=" + instance.adapterName + ')');
        if (adapter.getResourceAdapterClass() != null) {
            ocd.addInternalMetatypeAd("resourceadapter-class", adapter.getResourceAdapterClass());
        }
        if ((requiredWorkContexts = instance.metatype.getOriginatingRaConnector().getRequiredWorkContext()) != null && requiredWorkContexts.size() > 0) {
            HashSet<String> types = new HashSet<String>();
            types.add(HintsContext.class.getName());
            StringBuilder filter = new StringBuilder(85);
            for (int i = 0; i < requiredWorkContexts.size(); ++i) {
                String workContextType = requiredWorkContexts.get(i);
                if (ExecutionContext.class.getName().equals(workContextType)) {
                    workContextType = TransactionContext.class.getName();
                }
                if (!types.add(workContextType)) continue;
                filter.append("(type=").append(workContextType).append(')');
            }
            int numRequiredWorkContexts = types.size() - 1;
            if (numRequiredWorkContexts > 0) {
                if (numRequiredWorkContexts > 1) {
                    filter.insert(0, "(|").append(')');
                }
                ocd.addInternalMetatypeAd("requiredContextProvider.target", filter.toString());
                MetatypeAd ad = new MetatypeAd(this.metaTypeFactoryService);
                ad.setId("requiredContextProvider.cardinality.minimum");
                ad.setType("Integer");
                ad.setDefault(Integer.toString(numRequiredWorkContexts));
                ad.setFinal(true);
                ad.setName("internal");
                ad.setDescription("internal use only");
                ocd.addMetatypeAd(ad);
            }
        }
        RaOutboundResourceAdapter outbound = adapter.getOutboundResourceAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"outbound is:", (Object[])new Object[]{outbound});
        }
        if (outbound != null) {
            String transactionSupport = outbound.getTransactionSupport();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"outbound transaction support:", (Object[])new Object[]{transactionSupport});
            }
            if (transactionSupport != null) {
                ocd.addInternalMetatypeAd("transaction-support", transactionSupport);
            }
            if (outbound.getReauthenticationSupport() != null) {
                MetatypeAd reauthSupport = new MetatypeAd(this.metaTypeFactoryService);
                reauthSupport.setId("reauthentication-support");
                reauthSupport.setType("Boolean");
                reauthSupport.setFinal(true);
                reauthSupport.setDefault(outbound.getReauthenticationSupport());
                reauthSupport.setName("internal");
                reauthSupport.setDescription("internal use only");
                ocd.addMetatypeAd(reauthSupport);
            }
        }
        if ((modName = instance.getModuleName()) == null) {
            modName = connector.getModuleName();
        }
        if (modName != null) {
            ocd.addInternalMetatypeAd("module-name", modName);
        }
        for (RaConfigProperty configProperty : adapter.getConfigProperties()) {
            MetatypeAd ad = this.convertRaConfigPropertyToMetatypeAd(instance.adapterName, configProperty, Utils.ConstructType.ResourceAdapter);
            if (ad == null || ocd.addMetatypeAd(ad)) continue;
            Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName});
            if (this.config.isRuntime()) continue;
            this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName}));
        }
        instance.metatype.addOcd(ocd);
    }

    private void buildConnectionFactories(MetaGenInstance instance) throws ClassNotFoundException, InvalidPropertyException, ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        RaResourceAdapter adapter = instance.xmlFileSet.parsedXml.getResourceAdapter();
        RaOutboundResourceAdapter outboundAdapter = adapter.getOutboundResourceAdapter();
        if (outboundAdapter == null) {
            return;
        }
        String baseExtendsAlias = instance.adapterName;
        ChildAliasSelector childAliasSelector = new ChildAliasSelector();
        HashMap<RaConnectionDefinition, MetatypeOcd> deferred = new HashMap<RaConnectionDefinition, MetatypeOcd>();
        HashMap<String, String> connectionDefinitionsValidation = new HashMap<String, String>();
        for (RaConnectionDefinition raConnectionDefinition : outboundAdapter.getConnectionDefinitions()) {
            boolean isGeneric;
            String cfFactoryPid;
            this.validateClassImplementsInterface(raConnectionDefinition.getManagedConnectionFactoryClass(), ManagedConnectionFactory.class);
            String cfInterface = raConnectionDefinition.getConnectionFactoryInterface();
            String cfImpl = raConnectionDefinition.getConnectionFactoryImplClass();
            String parentPid = raConnectionDefinition.getConnectionFactoryParentPid();
            String cfOcdRef = cfFactoryPid = parentPid + ".properties." + baseExtendsAlias + '.' + cfInterface;
            if (connectionDefinitionsValidation.get(cfInterface) != null) {
                throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9920.duplicate.type", (Object[])new Object[]{cfInterface, "<connection-definition>", "@ConnectionDefinition"}));
            }
            connectionDefinitionsValidation.put(cfInterface, cfImpl);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Building connection factory: " + cfFactoryPid), (Object[])new Object[0]);
            }
            MetatypeDesignate designate = new MetatypeDesignate();
            MetatypeObject object = new MetatypeObject();
            designate.setInternalInformation(Utils.ConstructType.ConnectionFactory, raConnectionDefinition);
            designate.setFactoryPid(cfFactoryPid);
            object.setOcdref(cfOcdRef);
            designate.setObject(object);
            instance.metatype.getDesignates().add(designate);
            MetatypeOcd ocd = new MetatypeOcd(this.metaTypeFactoryService);
            ocd.setId(cfOcdRef);
            String suffixOverride = this.suffixOverridesByBoth.get(cfInterface + '-' + cfImpl);
            if (suffixOverride == null && (suffixOverride = this.suffixOverridesByImpl.get(cfImpl)) == null && (suffixOverride = this.suffixOverridesByIntf.get(cfInterface)) == null) {
                suffixOverride = raConnectionDefinition.getAliasSuffix();
            }
            boolean bl = isGeneric = RaConnectionDefinition.parentPids.get(cfInterface) == null;
            if (suffixOverride == null && isGeneric) {
                deferred.put(raConnectionDefinition, ocd);
            } else {
                if (suffixOverride == null || suffixOverride.length() == 0) {
                    ocd.setName(instance.adapterName + " Properties");
                    ocd.setExtendsAlias(baseExtendsAlias);
                    suffixOverride = "";
                } else {
                    ocd.setName(instance.adapterName + ' ' + suffixOverride + " Properties");
                    ocd.setExtendsAlias(baseExtendsAlias + '.' + suffixOverride);
                }
                if (isGeneric) {
                    childAliasSelector.reserve(suffixOverride, ocd);
                }
            }
            ocd.setExtends(parentPid + ".properties");
            if (raConnectionDefinition.getName() != null) {
                ocd.setName(raConnectionDefinition.getName());
            }
            ocd.setDescription(raConnectionDefinition.getDescription() != null ? raConnectionDefinition.getDescription() : "Properties for " + cfInterface + " (" + instance.adapterName + ')');
            object.setMatchingOcd(ocd);
            this.addInterfaces(ocd, raConnectionDefinition.getConnectionFactoryInterface());
            ocd.addInternalMetatypeAd("managedconnectionfactory-class", raConnectionDefinition.getManagedConnectionFactoryClass());
            ocd.addInternalMetatypeAd("resourceAdapterConfig.id", instance.adapterName);
            for (RaConfigProperty configProperty : raConnectionDefinition.getConfigProperties()) {
                MetatypeAd ad = this.convertRaConfigPropertyToMetatypeAd(instance.adapterName, configProperty, Utils.ConstructType.ConnectionFactory);
                if (ad == null || ocd.addMetatypeAd(ad)) continue;
                Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName}));
            }
            instance.metatype.getOcds().add(ocd);
        }
        for (Map.Entry entry : deferred.entrySet()) {
            MetatypeOcd ocd = (MetatypeOcd)entry.getValue();
            String cfInterface = ((RaConnectionDefinition)entry.getKey()).getConnectionFactoryInterface();
            String cfInterfaceSimpleName = cfInterface.substring(cfInterface.lastIndexOf(46) + 1);
            String cfImpl = ((RaConnectionDefinition)entry.getKey()).getConnectionFactoryImplClass();
            String cfImplSimpleName = cfImpl.substring(cfImpl.lastIndexOf(46) + 1);
            ArrayList<String> preferredAliasSuffixes = new ArrayList<String>(4);
            preferredAliasSuffixes.add("");
            if (!cfInterfaceSimpleName.equals(cfImplSimpleName)) {
                preferredAliasSuffixes.add(cfInterfaceSimpleName);
            }
            preferredAliasSuffixes.add(cfImplSimpleName);
            preferredAliasSuffixes.add(cfInterface);
            childAliasSelector.rank(ocd, preferredAliasSuffixes);
        }
        childAliasSelector.assign(instance.adapterName, baseExtendsAlias);
    }

    private void buildAdminObjects(MetaGenInstance instance) throws ClassNotFoundException, InvalidPropertyException, ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        RaResourceAdapter adapter = instance.xmlFileSet.parsedXml.getResourceAdapter();
        String baseExtendsAlias = instance.adapterName;
        HashMap<String, ChildAliasSelector> childAliasSelectors = new HashMap<String, ChildAliasSelector>();
        HashMap<RaAdminObject, MetatypeOcd> deferred = new HashMap<RaAdminObject, MetatypeOcd>();
        HashMap<String, String> adminObjectsValidation = new HashMap<String, String>();
        for (RaAdminObject raAdminObject : adapter.getAdminObjects()) {
            String aoFactoryPid;
            String aoInterface = raAdminObject.getMetaAdminObjectInterface();
            String aoImpl = raAdminObject.getAdminObjectClass();
            String aoInterfaceAndImpl = aoInterface + '-' + aoImpl;
            String parentPid = raAdminObject.getParentPid();
            String aoOcdRef = aoFactoryPid = parentPid + ".properties." + baseExtendsAlias + '.' + aoInterfaceAndImpl;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Building admin object: " + aoFactoryPid), (Object[])new Object[0]);
            }
            if (adminObjectsValidation.get(aoInterfaceAndImpl) != null) {
                throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9920.duplicate.type", (Object[])new Object[]{aoInterface, "<adminobject-interface>", "@AdministeredObject"}));
            }
            adminObjectsValidation.put(aoInterfaceAndImpl, aoImpl);
            MetatypeDesignate designate = new MetatypeDesignate();
            MetatypeObject object = new MetatypeObject();
            designate.setInternalInformation(Utils.ConstructType.AdminObject, raAdminObject);
            designate.setFactoryPid(aoFactoryPid);
            object.setOcdref(aoOcdRef);
            designate.setObject(object);
            instance.metatype.getDesignates().add(designate);
            MetatypeOcd ocd = new MetatypeOcd(this.metaTypeFactoryService);
            ocd.setId(aoOcdRef);
            String suffixOverride = this.suffixOverridesByBoth.get(aoInterfaceAndImpl);
            if (suffixOverride == null && (suffixOverride = this.suffixOverridesByImpl.get(aoImpl)) == null && (suffixOverride = this.suffixOverridesByIntf.get(aoInterface)) == null) {
                suffixOverride = raAdminObject.getAliasSuffix();
            }
            if (suffixOverride == null) {
                deferred.put(raAdminObject, ocd);
            } else {
                if (suffixOverride.length() == 0) {
                    ocd.setName(instance.adapterName + " Properties");
                    ocd.setExtendsAlias(baseExtendsAlias);
                } else {
                    ocd.setName(instance.adapterName + ' ' + suffixOverride + " Properties");
                    ocd.setExtendsAlias(baseExtendsAlias + '.' + suffixOverride);
                }
                ChildAliasSelector childAliasSelector = (ChildAliasSelector)childAliasSelectors.get(parentPid);
                if (childAliasSelector == null) {
                    childAliasSelector = new ChildAliasSelector();
                    childAliasSelectors.put(parentPid, childAliasSelector);
                }
                childAliasSelector.reserve(suffixOverride, ocd);
            }
            ocd.setExtends(parentPid + ".properties");
            if (raAdminObject.getName() != null) {
                ocd.setName(raAdminObject.getName());
            }
            ocd.setDescription(raAdminObject.getDescription() != null ? raAdminObject.getDescription() : "Properties for " + aoInterface + " implementation " + aoImpl + " (" + instance.adapterName + ')');
            object.setMatchingOcd(ocd);
            this.addInterfaces(ocd, raAdminObject.getMetaAdminObjectInterface());
            ocd.addInternalMetatypeAd("adminobject-class", raAdminObject.getAdminObjectClass());
            ocd.addInternalMetatypeAd("resourceAdapterConfig.id", instance.adapterName);
            for (RaConfigProperty configProperty : raAdminObject.getConfigProperties()) {
                MetatypeAd ad = this.convertRaConfigPropertyToMetatypeAd(instance.adapterName, configProperty, Utils.ConstructType.AdminObject);
                if (ad == null || ocd.addMetatypeAd(ad)) continue;
                Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName}));
            }
            instance.metatype.getOcds().add(ocd);
        }
        for (Map.Entry entry : deferred.entrySet()) {
            boolean isGeneric;
            RaAdminObject adminObject = (RaAdminObject)entry.getKey();
            MetatypeOcd ocd = (MetatypeOcd)entry.getValue();
            String parentPid = adminObject.getParentPid();
            String aoImpl = adminObject.getAdminObjectClass();
            String aoInterface = adminObject.getMetaAdminObjectInterface();
            String aoImplSimpleName = aoImpl.substring(aoImpl.lastIndexOf(46) + 1);
            String aoInterfaceSimpleName = aoInterface.substring(aoInterface.lastIndexOf(46) + 1);
            ChildAliasSelector childAliasSelector = (ChildAliasSelector)childAliasSelectors.get(parentPid);
            if (childAliasSelector == null) {
                childAliasSelector = new ChildAliasSelector();
                childAliasSelectors.put(parentPid, childAliasSelector);
            }
            ArrayList<String> preferredAliasSuffixes = new ArrayList<String>(5);
            preferredAliasSuffixes.add("");
            boolean bl = isGeneric = RaAdminObject.parentPids.get(aoInterface) == null;
            if (isGeneric && !aoInterfaceSimpleName.equals(aoImplSimpleName)) {
                preferredAliasSuffixes.add(aoInterfaceSimpleName);
            }
            preferredAliasSuffixes.add(aoImplSimpleName);
            if (isGeneric) {
                preferredAliasSuffixes.add(aoInterfaceSimpleName + '-' + aoImplSimpleName);
                preferredAliasSuffixes.add(aoInterface + '-' + aoImpl);
            } else {
                preferredAliasSuffixes.add(aoImpl);
            }
            childAliasSelector.rank(ocd, preferredAliasSuffixes);
        }
        for (ChildAliasSelector childAliasSelector : childAliasSelectors.values()) {
            childAliasSelector.assign(instance.adapterName, baseExtendsAlias);
        }
    }

    private void buildMessageListeners(MetaGenInstance instance) throws InvalidPropertyException, UnavailableException, ClassNotFoundException, ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        RaResourceAdapter adapter = instance.xmlFileSet.parsedXml.getResourceAdapter();
        RaInboundResourceAdapter inboundAdapter = adapter.getInboundResourceAdapter();
        if (inboundAdapter == null) {
            return;
        }
        RaMessageAdapter messageAdapter = inboundAdapter.getMessageAdapter();
        if (messageAdapter == null) {
            return;
        }
        String baseExtendsAlias = instance.adapterName;
        ChildAliasSelector childAliasSelector = new ChildAliasSelector();
        HashMap<RaMessageListener, MetatypeOcd> deferred = new HashMap<RaMessageListener, MetatypeOcd>();
        HashMap<String, String> messageListenersValidation = new HashMap<String, String>();
        for (RaMessageListener raMessageListener : messageAdapter.getMessageListeners()) {
            boolean isGeneric;
            String mlFactoryPid;
            String mlInterface = raMessageListener.getMessageListenerType();
            String asImpl = raMessageListener.getActivationSpec().getActivationSpecClass();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("message listener type: " + mlInterface), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("message listener activation spec: " + asImpl), (Object[])new Object[0]);
            }
            if (messageListenersValidation.get(mlInterface) != null) {
                throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9920.duplicate.type", (Object[])new Object[]{mlInterface, "<messagelistener-type>", "@Activation"}));
            }
            messageListenersValidation.put(mlInterface, asImpl);
            String parentPid = raMessageListener.getMessageListenerParentPid();
            String mlOcdRef = mlFactoryPid = parentPid + ".properties." + baseExtendsAlias + '.' + mlInterface;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Building message listener: " + mlFactoryPid), (Object[])new Object[0]);
            }
            MetatypeDesignate designate = new MetatypeDesignate();
            MetatypeObject object = new MetatypeObject();
            designate.setInternalInformation(Utils.ConstructType.MessageListener, raMessageListener);
            designate.setFactoryPid(mlFactoryPid);
            object.setOcdref(mlOcdRef);
            designate.setObject(object);
            instance.metatype.addDesignate(designate);
            MetatypeOcd ocd = new MetatypeOcd(this.metaTypeFactoryService);
            ocd.setId(mlOcdRef);
            String suffixOverride = this.suffixOverridesByBoth.get(mlInterface + '-' + asImpl);
            if (suffixOverride == null && (suffixOverride = this.suffixOverridesByImpl.get(asImpl)) == null && (suffixOverride = this.suffixOverridesByIntf.get(mlInterface)) == null) {
                suffixOverride = raMessageListener.getAliasSuffix();
            }
            boolean bl = isGeneric = RaMessageListener.parentPids.get(mlInterface) == null;
            if (suffixOverride == null && isGeneric) {
                deferred.put(raMessageListener, ocd);
            } else {
                if (suffixOverride == null || suffixOverride.length() == 0) {
                    ocd.setName(instance.adapterName + " Properties");
                    ocd.setExtendsAlias(baseExtendsAlias);
                    suffixOverride = "";
                } else {
                    ocd.setName(instance.adapterName + ' ' + suffixOverride + " Properties");
                    ocd.setExtendsAlias(baseExtendsAlias + '.' + suffixOverride);
                }
                if (isGeneric) {
                    childAliasSelector.reserve(suffixOverride, ocd);
                }
            }
            ocd.setExtends(parentPid + ".properties");
            if (raMessageListener.getName() != null) {
                ocd.setName(raMessageListener.getName());
            }
            ocd.setDescription(raMessageListener.getDescription() != null ? raMessageListener.getDescription() : "Properties for " + mlInterface + " (" + instance.adapterName + ')');
            object.setMatchingOcd(ocd);
            RaActivationSpec activationSpec = raMessageListener.getActivationSpec();
            this.validateClassImplementsInterface(activationSpec.getActivationSpecClass(), ActivationSpec.class);
            ocd.addInternalMetatypeAd("activationspec-class", activationSpec.getActivationSpecClass());
            ocd.addInternalMetatypeAd("resourceAdapterConfig.id", instance.adapterName);
            RaConfigProperty destinationProp = null;
            for (RaConfigProperty raConfigProperty : activationSpec.getConfigProperties()) {
                if (!"destination".equals(raConfigProperty.getName())) continue;
                destinationProp = raConfigProperty;
                break;
            }
            if (destinationProp != null) {
                destinationProp.isProcessed = false;
                MetatypeAd destinationRef = new MetatypeAd(this.metaTypeFactoryService);
                destinationRef.setId("destinationRef");
                destinationRef.setType("String");
                destinationRef.setReferencePid("com.ibm.ws.jca.adminObject.supertype");
                destinationRef.setIbmType("pid");
                destinationRef.setCardinality(0);
                destinationRef.setRequired(Boolean.TRUE.equals(destinationProp.getRequired()));
                destinationRef.setName("Destination");
                destinationRef.setDescription("Destination");
                destinationRef.setNLSKey(destinationProp.getNLSKey());
                ocd.addMetatypeAd(destinationRef);
            }
            StringBuilder requiredPropNames = new StringBuilder();
            for (RaRequiredConfigProperty requiredConfigProperty : activationSpec.getRequiredConfigProperties()) {
                MetatypeAd ad;
                String requiredPropName = requiredConfigProperty.getConfigPropertyName();
                if (requiredPropNames.length() > 0) {
                    requiredPropNames.append(',');
                }
                requiredPropNames.append(requiredPropName);
                RaConfigProperty configProperty = activationSpec.getConfigPropertyById(requiredPropName);
                if (configProperty == null && instance.xmlFileSet.parsedWlpXml != null) {
                    WlpRaMessageListener wlpMessageListener = instance.xmlFileSet.parsedWlpXml.getMessageListener(raMessageListener.getMessageListenerType());
                    if (wlpMessageListener != null) {
                        WlpRaConfigProperty wlpConfigProperty = wlpMessageListener.getActivationSpec().getConfigPropertyById(requiredPropName);
                        if (wlpConfigProperty != null) {
                            MetatypeAd ad2;
                            configProperty = new RaConfigProperty();
                            configProperty.copyWlpSettings(wlpConfigProperty);
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Configuration property was found in wlp-ra.xml, not ra.xml", (Object[])new Object[0]);
                            }
                            if ((ad2 = this.convertRaConfigPropertyToMetatypeAd(instance.adapterName, configProperty, Utils.ConstructType.MessageListener)) == null || ocd.addMetatypeAd(ad2)) continue;
                            Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad2.getID(), instance.adapterName});
                            if (this.config.isRuntime()) continue;
                            this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad2.getID(), instance.adapterName}));
                            continue;
                        }
                        Tr.warning((TraceComponent)tc, (String)"J2CA9905.required.prop.missing", (Object[])new Object[]{requiredPropName, instance.adapterName});
                        if (this.config.isRuntime()) continue;
                        this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9905.required.prop.missing", (Object[])new Object[]{requiredPropName, instance.adapterName}));
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"J2CA9905.required.prop.missing", (Object[])new Object[]{requiredPropName, instance.adapterName});
                    if (this.config.isRuntime()) continue;
                    this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9905.required.prop.missing", (Object[])new Object[]{requiredPropName, instance.adapterName}));
                    continue;
                }
                if (configProperty == null || configProperty.isProcessed || (ad = this.convertRaConfigPropertyToMetatypeAd(instance.adapterName, configProperty, Utils.ConstructType.MessageListener)) == null) continue;
                if (ocd.addMetatypeAd(ad)) {
                    configProperty.isProcessed = true;
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName}));
            }
            if (requiredPropNames.length() > 0) {
                MetatypeAd metatypeAd = new MetatypeAd(this.metaTypeFactoryService);
                metatypeAd.setId("required-config-property");
                metatypeAd.setType("String");
                metatypeAd.setDefault(requiredPropNames.toString());
                metatypeAd.setCardinality(10000);
                metatypeAd.setFinal(true);
                metatypeAd.setName("internal");
                metatypeAd.setDescription("internal use only");
                ocd.addMetatypeAd(metatypeAd);
            }
            for (RaConfigProperty configProperty : activationSpec.getConfigProperties()) {
                MetatypeAd ad = this.convertRaConfigPropertyToMetatypeAd(instance.adapterName, configProperty, Utils.ConstructType.MessageListener);
                if (ad == null || ocd.addMetatypeAd(ad)) continue;
                Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{ad.getID(), instance.adapterName}));
            }
            instance.metatype.addOcd(ocd);
        }
        for (Map.Entry entry : deferred.entrySet()) {
            MetatypeOcd ocd = (MetatypeOcd)entry.getValue();
            String mlInterface = ((RaMessageListener)entry.getKey()).getMessageListenerType();
            String mlInterfaceSimpleName = mlInterface.substring(mlInterface.lastIndexOf(46) + 1);
            String asImpl = ((RaMessageListener)entry.getKey()).getActivationSpec().getActivationSpecClass();
            String asImplSimpleName = asImpl.substring(asImpl.lastIndexOf(46) + 1);
            ArrayList<String> preferredAliasSuffixes = new ArrayList<String>(4);
            preferredAliasSuffixes.add("");
            if (!mlInterfaceSimpleName.equals(asImplSimpleName)) {
                preferredAliasSuffixes.add(mlInterfaceSimpleName);
            }
            preferredAliasSuffixes.add(asImplSimpleName);
            preferredAliasSuffixes.add(mlInterface);
            childAliasSelector.rank(ocd, preferredAliasSuffixes);
        }
        childAliasSelector.assign(instance.adapterName, baseExtendsAlias);
    }

    private void validateClassImplementsInterface(String className, Class<?> interfaceClass) throws ResourceAdapterInternalException, ClassNotFoundException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.config.isRuntime()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Check class " + className + " implements " + interfaceClass.getName() + " interface."), (Object[])new Object[0]);
            }
            Class<?> cl = this.raClassLoader.loadClass(className);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("loaded class : " + cl), (Object[])new Object[0]);
            }
            boolean interfaceFound = false;
            boolean examineSuperClass = true;
            while (examineSuperClass) {
                if (this.lookForInterface(cl, interfaceClass)) {
                    interfaceFound = true;
                    examineSuperClass = false;
                    break;
                }
                if (examineSuperClass) {
                    cl = cl.getSuperclass();
                }
                if (cl != null) continue;
                examineSuperClass = false;
            }
            if (!interfaceFound) {
                throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9903.required.rainterface.missing", (Object[])new Object[]{className, interfaceClass.getName()}));
            }
        }
    }

    private boolean lookForInterface(Class<?> cl, Class<?> interfaceClass) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Class<?>[] interfaces = cl.getInterfaces();
        if (interfaces.length == 0) {
            return false;
        }
        for (Class<?> intf : interfaces) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Check interface " + intf.getName()), (Object[])new Object[0]);
            }
            if (intf == interfaceClass) {
                return true;
            }
            if (!this.lookForInterface(intf, interfaceClass)) continue;
            return true;
        }
        return false;
    }

    private MetatypeAd convertRaConfigPropertyToMetatypeAd(String adapterName, RaConfigProperty configProperty, Utils.ConstructType cType) throws InvalidPropertyException {
        if (configProperty.isProcessed) {
            return null;
        }
        MetatypeAd ad_configProperty = new MetatypeAd(this.metaTypeFactoryService);
        ad_configProperty.setId(configProperty.getName());
        if (configProperty.getWlpDefault() != null) {
            ad_configProperty.setDefault(configProperty.getWlpDefault());
        } else if (configProperty.getDefault() != null) {
            ad_configProperty.setDefault(configProperty.getDefault());
        } else if (configProperty.getRequired() != null) {
            ad_configProperty.setRequired(configProperty.getRequired());
        } else {
            ad_configProperty.setRequired(false);
        }
        if (configProperty.getConfidential() != null && configProperty.getConfidential().booleanValue()) {
            ad_configProperty.setIbmType("password");
        }
        if (configProperty.getIgnore() != null && configProperty.getIgnore().booleanValue()) {
            ad_configProperty.setName("internal");
            ad_configProperty.setDescription("internal use only");
            ad_configProperty.setFinal(true);
        } else {
            String name;
            ad_configProperty.setName(configProperty.getName());
            String cpDesc = null;
            for (RaDescription raDesc : configProperty.getDescription()) {
                if ("en".equalsIgnoreCase(raDesc.getLang())) {
                    cpDesc = raDesc.getValue();
                    break;
                }
                cpDesc = raDesc.getValue();
            }
            if (cpDesc != null) {
                ad_configProperty.setDescription(cpDesc);
            }
            ad_configProperty.setFinal(configProperty.getIbmFinal());
            if ((cType == Utils.ConstructType.ConnectionFactory || cType == Utils.ConstructType.MessageListener) && ("PASSWORD".equals(name = configProperty.getName().toUpperCase()) || "USER".equals(name) || "USERNAME".equals(name))) {
                if (cType == Utils.ConstructType.ConnectionFactory) {
                    ad_configProperty.setRecommendAuthAliasUsage(true);
                } else {
                    return null;
                }
            }
            ad_configProperty.setMax(configProperty.getMax());
            ad_configProperty.setMin(configProperty.getMin());
            if (configProperty.getConfigOptions() != null) {
                List<WlpConfigOption> options = configProperty.getConfigOptions();
                for (WlpConfigOption option : options) {
                    MetatypeAdOption ad_option = new MetatypeAdOption();
                    ad_option.setLabel(option.getLabel());
                    ad_option.setValue(option.getValue());
                    ad_option.setNLSKey(option.getNLSKey());
                    ad_configProperty.getOptions().add(ad_option);
                }
            }
            ad_configProperty.setIbmuiGroup(configProperty.getIbmuiGroup());
        }
        String wlpCustomType = configProperty.getWlpType();
        if (wlpCustomType == null) {
            String type = configProperty.getType();
            ad_configProperty.setType(type == null ? "String" : MetatypeAd.getTypeName(type));
        } else if (MetatypeAd.TYPES.get(wlpCustomType) != null) {
            ad_configProperty.setType(wlpCustomType);
        } else {
            ad_configProperty.setIbmType(wlpCustomType);
            ad_configProperty.setType("String");
        }
        if (configProperty.isOptionLabelNLSDisabled()) {
            ad_configProperty.disableOptionLabelNLS();
        }
        ad_configProperty.setNLSKey(configProperty.getNLSKey());
        return ad_configProperty;
    }

    private void mergeMetatypes(Metatype metatype1, Metatype metatype2) {
        List<MetatypeDesignate> m2Designates = metatype2.getDesignates();
        for (MetatypeDesignate m2Designate : m2Designates) {
            MetatypeOcd m2Ocd;
            MetatypeOcd m1MatchingOcd;
            MetatypeDesignate m1MatchingDesignate = m2Designate.getFactoryPid() != null ? metatype1.getDesignateByFactoryPid(m2Designate.getFactoryPid()) : metatype1.getDesignateByPid(m2Designate.getPid());
            if (m1MatchingDesignate != null || (m1MatchingOcd = metatype1.getOcdById((m2Ocd = metatype2.getOcdById(m2Designate.getObject().getOcdref())).getId())) != null) continue;
            metatype1.addDesignate(m2Designate);
            metatype1.addOcd(m2Ocd);
        }
    }

    private void setup(Map<String, Object> configProps) throws IOException, JAXBException, SAXException, ParserConfigurationException, ClassNotFoundException, ResourceAdapterInternalException, UnableToAdaptException, InstantiationException, InvalidPropertyException, UnavailableException, ResourceAdapterInstallException {
        this.config = new MetaGenConfig(configProps);
        this.generalAdapterName = this.config.getInstance().adapterName;
        this.suffixOverridesByIntf = this.config.get("suffix.overrides.by.interface", Collections.emptyMap());
        this.suffixOverridesByImpl = this.config.get("suffix.overrides.by.impl", Collections.emptyMap());
        this.suffixOverridesByBoth = this.config.get("suffix.overrides.by.both", Collections.emptyMap());
        if (!this.config.isRuntime()) {
            DeploymentDescriptorParser.init();
        } else {
            this.raClassLoader = this.config.getRarClassLoader();
        }
        MetaGenInstance instance = this.config.getInstance();
        if (this.config.getGenerationMode() == MetaGenConfig.GenerationMode.ExplicitMode) {
            instance.xmlFileSet.parsedXml = (RaConnector)DeploymentDescriptorParser.parseResourceAdapterXml(Utils.getFileInputStreamPrivileged(instance.xmlFileSet.raXmlFile), "ra.xml", false);
            if (instance.xmlFileSet.wlpRaXmlFile != null) {
                instance.xmlFileSet.parsedWlpXml = (WlpRaConnector)DeploymentDescriptorParser.parseResourceAdapterXml(Utils.getFileInputStreamPrivileged(instance.xmlFileSet.wlpRaXmlFile), "wlp-ra.xml", false);
            }
        } else if (this.config.getGenerationMode() == MetaGenConfig.GenerationMode.RarMode) {
            this.parseResourceAdapterXmlsFromRar(instance.adapterName, instance.xmlFileSet, instance.getModuleName());
        }
    }

    private void postBuild(Map<String, Object> configProps) throws IOException, JAXBException, InvalidPropertyException {
        this.masterMetatype = this.config.getInstance().metatype;
        this.translateAndBuildNLSFile();
        this.writeMetatypeToFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBuildtimeRarClasses(final XmlFileSet xmlFileSet) throws IOException, JAXBException, SAXException, ParserConfigurationException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        final AtomicReference exceptionRef = new AtomicReference();
        JarFile rar = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){
            static final long serialVersionUID = 8454329768977876857L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public JarFile run() {
                try {
                    return new JarFile(xmlFileSet.rarFile);
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jca.utils.metagen.MetatypeGenerator$1", (String)"1310", (Object)this, (Object[])new Object[0]);
                    exceptionRef.set(e);
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        if (exceptionRef.get() != null) {
            throw (IOException)exceptionRef.get();
        }
        try {
            Enumeration<JarEntry> entries = rar.entries();
            ArrayList<String> classNames = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory()) continue;
                String fileName = entryName.substring(entry.getName().lastIndexOf(47) + 1);
                int dotClassIndex = entryName.indexOf(".class");
                if (fileName.endsWith(".class")) {
                    String className = entryName.replaceAll("/", "\\.");
                    classNames.add(className.substring(0, dotClassIndex));
                    continue;
                }
                if (fileName.equals("ra.xml")) {
                    xmlFileSet.rarRaXmlFilePath = entry.getName();
                    xmlFileSet.parsedXml = (RaConnector)DeploymentDescriptorParser.parseResourceAdapterXml(rar.getInputStream(entry), "ra.xml", false);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ra.xml: " + xmlFileSet.parsedXml), (Object[])new Object[0]);
                    continue;
                }
                if (!fileName.equals("wlp-ra.xml")) continue;
                xmlFileSet.rarWlpRaXmlFilePath = entry.getName();
                xmlFileSet.parsedWlpXml = (WlpRaConnector)DeploymentDescriptorParser.parseResourceAdapterXml(rar.getInputStream(entry), "wlp-ra.xml", false);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("wlp-ra.xml: " + xmlFileSet.parsedWlpXml), (Object[])new Object[0]);
            }
        }
        finally {
            rar.close();
        }
    }

    private void parseResourceAdapterXmlsFromRar(String adapterName, XmlFileSet xmlFileSet, String moduleName) throws IOException, JAXBException, SAXException, ParserConfigurationException, ClassNotFoundException, ResourceAdapterInternalException, UnableToAdaptException, InvalidPropertyException, UnavailableException, ResourceAdapterInstallException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (!this.config.isRuntime()) {
            this.getBuildtimeRarClasses(xmlFileSet);
            for (String s : this.classNames) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("className: " + s), (Object[])new Object[0]);
            }
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("config.useAnnotations: " + this.config.useAnnotations()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("config.getRarClassLoader: " + this.config.getRarClassLoader()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("xmlFileSet.parsedXml: " + xmlFileSet.parsedXml), (Object[])new Object[0]);
        }
        if (this.config.useAnnotations()) {
            this.moduleAnnotations = (ModuleAnnotations)this.config.getRarContainer().adapt(ModuleAnnotations.class);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleAnnotations: " + this.moduleAnnotations), (Object[])new Object[0]);
            }
            RAAnnotationProcessor processor = new RAAnnotationProcessor(adapterName, xmlFileSet.parsedXml, this.config.getRarClassLoader(), this.moduleAnnotations, this.classNames);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processor:", (Object[])new Object[]{processor});
            }
            RaConnector parsedXml = processor.getProcessedConnector();
            if (xmlFileSet.parsedXml == null && !processor.isAnnotatedConnector()) {
                throw new ResourceAdapterInstallException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9943.missing.connector.dd", (Object[])new Object[]{adapterName}));
            }
            xmlFileSet.parsedXml = parsedXml;
        } else if (xmlFileSet.parsedXml == null) {
            throw new ResourceAdapterInstallException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9943.missing.connector.dd", (Object[])new Object[]{adapterName}));
        }
        if (this.config.isRuntime()) {
            this.processJavaBeanProperties(xmlFileSet.parsedXml);
        }
    }

    void processJavaBeanProperties(RaConnector connector) throws ResourceAdapterInternalException {
        RaMessageAdapter messageAdapter;
        RaOutboundResourceAdapter outboundAdapter;
        RaResourceAdapter adapter = connector.getResourceAdapter();
        String adapterClassName = adapter.getResourceAdapterClass();
        if (adapterClassName != null) {
            this.processJavaBeanProperties(adapterClassName, adapter.getConfigProperties(), true);
        }
        if ((outboundAdapter = adapter.getOutboundResourceAdapter()) != null) {
            for (RaConnectionDefinition connectionFactory : outboundAdapter.getConnectionDefinitions()) {
                this.processJavaBeanProperties(connectionFactory.getManagedConnectionFactoryClass(), connectionFactory.getConfigProperties(), false);
            }
        }
        for (RaAdminObject adminObject : adapter.getAdminObjects()) {
            this.processJavaBeanProperties(adminObject.getAdminObjectClass(), adminObject.getConfigProperties(), false);
        }
        RaInboundResourceAdapter inboundAdapter = adapter.getInboundResourceAdapter();
        if (inboundAdapter != null && (messageAdapter = inboundAdapter.getMessageAdapter()) != null) {
            for (RaMessageListener messageListener : messageAdapter.getMessageListeners()) {
                RaActivationSpec activationSpec = messageListener.getActivationSpec();
                this.processJavaBeanProperties(activationSpec.getActivationSpecClass(), activationSpec.getConfigProperties(), false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processJavaBeanProperties(String className, @Sensitive List<RaConfigProperty> propertyList, boolean processDefaults) throws ResourceAdapterInternalException {
        BeanInfo beanInfo;
        Class<?> klass;
        try {
            klass = this.config.getRarClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e;
            Object[] objectArray = new Object[3];
            objectArray[0] = className;
            objectArray[1] = "<sensitive java.util.List>";
            objectArray[2] = processDefaults;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jca.utils.metagen.MetatypeGenerator", (String)"1471", (Object)this, (Object[])objectArray);
            e.getClass();
            Tr.warning((TraceComponent)tc, (String)"J2CA9919.class.not.found", (Object[])new Object[]{className, this.generalAdapterName});
            return;
        }
        try {
            beanInfo = Introspector.getBeanInfo(klass);
        }
        catch (IntrospectionException introspectionException) {
            void e;
            Object[] objectArray = new Object[3];
            objectArray[0] = className;
            objectArray[1] = "<sensitive java.util.List>";
            objectArray[2] = processDefaults;
            FFDCFilter.processException((Throwable)introspectionException, (String)"com.ibm.ws.jca.utils.metagen.MetatypeGenerator", (String)"1480", (Object)this, (Object[])objectArray);
            throw new ResourceAdapterInternalException((Throwable)e);
        }
        HashSet<String> beanPropNames = new HashSet<String>();
        HashMap<String, RaConfigProperty> propertyMap = null;
        Object bean = null;
        for (PropertyDescriptor propDesc : beanInfo.getPropertyDescriptors()) {
            Method readMethod;
            if (propDesc.getWriteMethod() == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"skipping read only property", (Object[])new Object[]{propDesc});
                continue;
            }
            String propName = MetatypeGenerator.toCamelCase(propDesc.getName());
            Class<?> propType = propDesc.getPropertyType();
            if (!beanPropNames.add(propName)) {
                Tr.warning((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{propName, this.config.getInstance().adapterName});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9918.attrdef.already.processed", (Object[])new Object[]{propName, this.config.getInstance().adapterName}));
                continue;
            }
            if (propType.isPrimitive()) {
                propType = MetatypeAd.getBoxedType(propType);
            } else if (!MetatypeAd.isTypeClassName(propType.getName())) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"skipping property with unsupported type", (Object[])new Object[]{propDesc});
                continue;
            }
            if (propertyMap == null) {
                propertyMap = new HashMap<String, RaConfigProperty>();
                for (RaConfigProperty property : propertyList) {
                    propertyMap.put(property.getName().toUpperCase(), property);
                }
            }
            RaConfigProperty property = (RaConfigProperty)propertyMap.get(propName.toUpperCase());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processing property", (Object[])new Object[]{propDesc, property});
            }
            if (property == null) {
                property = new RaConfigProperty();
                property.setName(propName);
                propertyList.add(property);
            }
            if (!propName.equals(property.getName())) {
                property.setName(propName);
            }
            if (property.getType() == null) {
                property.setType(propType.getName());
            }
            if (processDefaults && property.getDefault() == null && (readMethod = propDesc.getReadMethod()) != null) {
                Object defaultValue;
                if (bean == null) {
                    try {
                        bean = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception exception) {
                        void e;
                        Object[] objectArray = new Object[3];
                        objectArray[0] = className;
                        objectArray[1] = "<sensitive java.util.List>";
                        objectArray[2] = processDefaults;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jca.utils.metagen.MetatypeGenerator", (String)"1551", (Object)this, (Object[])objectArray);
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        Tr.warning((TraceComponent)tc, (String)"J2CA9936.default.value.error", (Object[])new Object[]{propName, className, this.generalAdapterName, cause.toString()});
                        continue;
                    }
                }
                try {
                    defaultValue = readMethod.invoke(bean, new Object[0]);
                }
                catch (Exception cause) {
                    void e;
                    Object[] objectArray = new Object[3];
                    objectArray[0] = className;
                    objectArray[1] = "<sensitive java.util.List>";
                    objectArray[2] = processDefaults;
                    FFDCFilter.processException((Throwable)cause, (String)"com.ibm.ws.jca.utils.metagen.MetatypeGenerator", (String)"1561", (Object)this, (Object[])objectArray);
                    Throwable cause2 = e instanceof InvocationTargetException ? e.getCause() : e;
                    Tr.warning((TraceComponent)tc, (String)"J2CA9936.default.value.error", (Object[])new Object[]{propName, className, this.generalAdapterName, cause2.toString()});
                    continue;
                }
                if (defaultValue != null) {
                    property.setDefault(defaultValue.toString());
                }
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"updated property", (Object[])new Object[]{property});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetatypeToFile() throws IOException, JAXBException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.config.getMetatypeOutputFile() == null) {
            return;
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Output path: " + this.config.getMetatypeOutputFile().getAbsolutePath()), (Object[])new Object[0]);
        }
        if (this.config.getMetatypeInputFile() != null && Utils.doesFileExistPrivileged(this.config.getMetatypeInputFile())) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Input metatype.xml found; merging with generated metatype", (Object[])new Object[0]);
            }
            FileInputStream customInput = Utils.getFileInputStreamPrivileged(this.config.getMetatypeInputFile());
            Metatype custom = null;
            JAXBContext customContext = JAXBContext.newInstance((Class[])new Class[]{Metatype.class});
            Unmarshaller customUnmarshaller = customContext.createUnmarshaller();
            try {
                custom = (Metatype)customUnmarshaller.unmarshal((InputStream)customInput);
            }
            finally {
                customInput.close();
            }
            this.mergeMetatypes(this.masterMetatype, custom);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.config.getMetatypeOutputFile()));){
            writer.write(this.masterMetatype.toMetatypeString(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateAndBuildNLSFile() throws IOException {
        File nlsFile;
        if (!this.config.doTranslate()) {
            return;
        }
        HashMap<String, String> originalNLSMap = new HashMap<String, String>();
        ArrayList<String> ibmuiGroups = new ArrayList<String>();
        ArrayList<String> commonKeys = new ArrayList<String>();
        boolean nlsOutputFilePresent = this.config.getNLSOutputFile() != null;
        StringBuilder nls = null;
        if (nlsOutputFilePresent) {
            nls = new StringBuilder();
            nls.append("# Licensed Materials - Property of IBM").append(Utils.NEW_LINE);
            nls.append("#").append(Utils.NEW_LINE);
            nls.append("# \"Restricted Materials of IBM\"").append(Utils.NEW_LINE);
            nls.append("#").append(Utils.NEW_LINE);
            nls.append("# Copyright IBM Corp. ").append(Calendar.getInstance().get(1)).append(" All Rights Reserved.").append(Utils.NEW_LINE);
            nls.append("#").append(Utils.NEW_LINE);
            nls.append("# US Government Users Restricted Rights - Use, duplication or").append(Utils.NEW_LINE);
            nls.append("# disclosure restricted by GSA ADP Schedule Contract with").append(Utils.NEW_LINE);
            nls.append("# IBM Corp.").append(Utils.NEW_LINE);
            nls.append("#").append(Utils.NEW_LINE);
            nls.append("# -------------------------------------------------------------------------------------------------").append(Utils.NEW_LINE);
            nls.append("#").append(Utils.NEW_LINE);
        }
        if ((nlsFile = this.config.getNLSInputFile()) != null) {
            try (Iterator reader = new BufferedReader(new FileReader(nlsFile));){
                String line;
                while ((line = ((BufferedReader)((Object)reader)).readLine()) != null) {
                    String msg;
                    if ((line = line.trim()).startsWith("# ") || line.length() <= 1) continue;
                    if (line.startsWith("#")) {
                        if (!nlsOutputFilePresent) continue;
                        nls.append(line).append(Utils.NEW_LINE);
                        continue;
                    }
                    int index = line.indexOf(61);
                    String key = line.substring(0, index);
                    if (originalNLSMap.put(key, msg = line.substring(index + 1)) == null) continue;
                    Tr.warning((TraceComponent)tc, (String)"J2CA9916.duplicate.nls.key", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, key});
                    if (this.config.isRuntime()) continue;
                    this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9916.duplicate.nls.key", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, key}));
                }
            }
        }
        if (nlsOutputFilePresent) {
            nls.append("#").append(Utils.NEW_LINE).append(Utils.NEW_LINE);
        }
        for (MetatypeDesignate designate : this.masterMetatype.getDesignates()) {
            String desc;
            String message;
            String name;
            MetatypeOcd ocd = designate.getObject().getMatchingOcd();
            ocd.sort(true);
            String nameKey = null;
            String descKey = null;
            boolean isCommon = false;
            if (nlsOutputFilePresent) {
                nls.append(Utils.NEW_LINE);
            }
            if (designate.getChildOcdType() == Utils.ConstructType.AdminObject) {
                if (nlsOutputFilePresent) {
                    nls.append("# Administered Object: ");
                }
                nameKey = ((RaAdminObject)designate.getMatchingRaXmlObject()).getNLSKey();
            } else if (designate.getChildOcdType() == Utils.ConstructType.ConnectionFactory) {
                if (nlsOutputFilePresent) {
                    nls.append("# Connection Factory: ");
                }
                nameKey = ((RaConnectionDefinition)designate.getMatchingRaXmlObject()).getNLSKey();
            } else if (designate.getChildOcdType() == Utils.ConstructType.MessageListener) {
                if (nlsOutputFilePresent) {
                    nls.append("# Message Listener: ");
                }
                nameKey = ((RaMessageListener)designate.getMatchingRaXmlObject()).getNLSKey();
            } else if (designate.getChildOcdType() == Utils.ConstructType.ResourceAdapter) {
                if (nlsOutputFilePresent) {
                    nls.append("# Resource Adapter: ");
                }
                nameKey = ((RaResourceAdapter)designate.getMatchingRaXmlObject()).getNLSKey();
            } else if (designate.getChildOcdType() == Utils.ConstructType.Unknown && nlsOutputFilePresent) {
                nls.append("# Other Object: ");
            }
            if (nlsOutputFilePresent) {
                nls.append(designate.getDesignateID()).append(Utils.NEW_LINE);
            }
            if (!ocd.getName().equals("internal")) {
                if (nameKey == null) {
                    nameKey = ocd.getId();
                }
                if (nameKey.startsWith("[common]")) {
                    isCommon = true;
                    nameKey = nameKey.substring("[common]".length() + 1).trim();
                }
                name = ocd.getName();
                message = (String)originalNLSMap.get(nameKey);
                ocd.setName("%" + nameKey);
                if (isCommon) {
                    if (!commonKeys.contains(nameKey)) {
                        commonKeys.add(nameKey);
                    }
                } else if (message != null && !message.isEmpty()) {
                    if (nlsOutputFilePresent) {
                        nls.append(nameKey).append('=').append(message).append(Utils.NEW_LINE);
                    }
                } else if (nlsOutputFilePresent && name != null && !name.isEmpty()) {
                    nls.append(nameKey).append('=').append(name).append(Utils.NEW_LINE);
                } else {
                    Tr.warning((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, nameKey});
                    if (!this.config.isRuntime()) {
                        this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, nameKey}));
                    }
                }
                descKey = nameKey + ".desc";
                desc = ocd.getDescription();
                message = (String)originalNLSMap.get(descKey);
                ocd.setDescription("%" + descKey);
                if (isCommon) {
                    if (!commonKeys.contains(descKey)) {
                        commonKeys.add(descKey);
                    }
                } else if (message != null && !message.isEmpty()) {
                    if (nlsOutputFilePresent) {
                        nls.append(descKey).append('=').append(message).append(Utils.NEW_LINE);
                    }
                } else if (nlsOutputFilePresent && desc != null && !desc.isEmpty()) {
                    nls.append(descKey).append('=').append(desc).append(Utils.NEW_LINE);
                } else {
                    Tr.warning((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, descKey});
                    if (!this.config.isRuntime()) {
                        this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, descKey}));
                    }
                }
            }
            String nlsUigroup = "(default)";
            for (MetatypeAd ad : ocd.getMetatypeAds()) {
                String uigroup = ad.getIbmUigroup();
                if (uigroup != null && !uigroup.isEmpty() && !uigroup.equals("(default)")) {
                    WlpIbmuiGroups ibmuiGroupsObj;
                    String groupNLSKey;
                    if (nlsOutputFilePresent && !nlsUigroup.equals(uigroup)) {
                        nlsUigroup = uigroup;
                        nls.append("# ").append(designate.getDesignateID()).append(" UI group '").append(uigroup).append("' AD element keys:").append(Utils.NEW_LINE);
                    }
                    String string = groupNLSKey = (ibmuiGroupsObj = this.config.getIbmuiGroups()) != null ? ibmuiGroupsObj.getGroupNLSKey(uigroup) : null;
                    if (this.config.isIbmuiGroupScopeGlobal()) {
                        String global_groupName = (groupNLSKey != null ? groupNLSKey : uigroup) + ".name";
                        String global_groupDesc = (groupNLSKey != null ? groupNLSKey : uigroup) + ".description";
                        if (!ibmuiGroups.contains(global_groupName)) {
                            ibmuiGroups.add(global_groupName);
                        }
                        if (!ibmuiGroups.contains(global_groupDesc)) {
                            ibmuiGroups.add(global_groupDesc);
                        }
                    } else if (this.config.isIbmuiGroupScopeOcd()) {
                        String ocd_groupName = (groupNLSKey != null ? groupNLSKey : uigroup) + "." + ocd.getId() + ".name";
                        String ocd_groupDesc = (groupNLSKey != null ? groupNLSKey : uigroup) + "." + ocd.getId() + ".description";
                        if (!ibmuiGroups.contains(ocd_groupName)) {
                            ibmuiGroups.add(ocd_groupName);
                        }
                        if (!ibmuiGroups.contains(ocd_groupDesc)) {
                            ibmuiGroups.add(ocd_groupDesc);
                        }
                    }
                }
                name = ad.getName();
                desc = ad.getDescription();
                if (name == null || name != null && !name.equals("internal")) {
                    nameKey = ad.getNLSKey();
                    if (nameKey == null) {
                        nameKey = ocd.getId() + "." + ad.getID();
                    }
                    if (nameKey.startsWith("[common]")) {
                        isCommon = true;
                        nameKey = nameKey.substring("[common]".length() + 1).trim();
                    } else {
                        isCommon = false;
                    }
                    message = (String)originalNLSMap.get(nameKey);
                    ad.setName("%" + nameKey);
                    if (isCommon) {
                        if (!commonKeys.contains(nameKey)) {
                            commonKeys.add(nameKey);
                        }
                    } else if (message != null && !message.isEmpty()) {
                        if (nlsOutputFilePresent) {
                            nls.append(nameKey).append('=').append(message).append(Utils.NEW_LINE);
                        }
                    } else if (nlsOutputFilePresent && name != null && !name.isEmpty()) {
                        nls.append(nameKey).append('=').append(name).append(Utils.NEW_LINE);
                    } else {
                        Tr.warning((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, nameKey});
                        if (!this.config.isRuntime()) {
                            this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, nameKey}));
                        }
                    }
                    descKey = nameKey + ".desc";
                    message = (String)originalNLSMap.get(descKey);
                    ad.setDescription("%" + descKey);
                    if (isCommon) {
                        if (ad.isAuthAliasUsageRecommended()) {
                            descKey = descKey + "*";
                        }
                        if (!commonKeys.contains(descKey)) {
                            commonKeys.add(descKey);
                        }
                    } else if (message != null && !message.isEmpty()) {
                        if (nlsOutputFilePresent) {
                            if (ad.isAuthAliasUsageRecommended() && !message.contains("It is recommended to use a container managed authentication alias instead of configuring this property")) {
                                nls.append(descKey).append('=').append(message).append(" (").append("It is recommended to use a container managed authentication alias instead of configuring this property").append(')').append(Utils.NEW_LINE);
                            } else {
                                nls.append(descKey).append('=').append(message).append(Utils.NEW_LINE);
                            }
                        }
                    } else if (nlsOutputFilePresent && desc != null && !desc.isEmpty()) {
                        if (ad.isAuthAliasUsageRecommended() && !desc.contains("It is recommended to use a container managed authentication alias instead of configuring this property")) {
                            nls.append(descKey).append('=').append(desc).append(" (").append("It is recommended to use a container managed authentication alias instead of configuring this property").append(')').append(Utils.NEW_LINE);
                        } else {
                            nls.append(descKey).append('=').append(desc).append(Utils.NEW_LINE);
                        }
                    } else {
                        if (nlsOutputFilePresent && ad.isAuthAliasUsageRecommended()) {
                            nls.append(descKey).append('=').append('(').append("It is recommended to use a container managed authentication alias instead of configuring this property").append(')').append(Utils.NEW_LINE);
                        }
                        Tr.warning((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, descKey});
                        if (!this.config.isRuntime()) {
                            this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, descKey}));
                        }
                    }
                }
                if (ad.getOptions().isEmpty() || ad.isOptionLabelNLSDisabled()) continue;
                int labelIndex = 0;
                for (MetatypeAdOption option : ad.getOptions()) {
                    if (option.getValue().equals(option.getLabel())) continue;
                    String labelKey = option.getNLSKey();
                    if (labelKey == null) {
                        labelKey = nameKey + ".option" + labelIndex++;
                    }
                    if (labelKey.startsWith("[common]")) {
                        isCommon = true;
                        labelKey = labelKey.substring("[common]".length() + 1).trim();
                    } else {
                        isCommon = false;
                    }
                    message = (String)originalNLSMap.get(labelKey);
                    option.setLabel('%' + labelKey);
                    if (isCommon) {
                        if (!commonKeys.contains(labelKey)) {
                            commonKeys.add(labelKey);
                        }
                    } else if (message != null && !message.isEmpty()) {
                        if (nlsOutputFilePresent) {
                            nls.append(labelKey).append('=').append(message);
                        }
                    } else if (nlsOutputFilePresent) {
                        nls.append(option.getLabel());
                    }
                    if (!nlsOutputFilePresent) continue;
                    nls.append(Utils.NEW_LINE);
                }
            }
        }
        if (!ibmuiGroups.isEmpty()) {
            Collections.sort(ibmuiGroups);
            if (nlsOutputFilePresent) {
                nls.append(Utils.NEW_LINE).append("# UI Groups").append(Utils.NEW_LINE);
            }
            for (String uigroup : ibmuiGroups) {
                String message;
                if (nlsOutputFilePresent) {
                    nls.append(uigroup).append('=');
                }
                if ((message = (String)originalNLSMap.get(uigroup)) != null && !message.isEmpty()) {
                    if (!nlsOutputFilePresent) continue;
                    nls.append(message).append(Utils.NEW_LINE);
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, uigroup});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, uigroup}));
            }
        }
        if (!commonKeys.isEmpty()) {
            Collections.sort(commonKeys);
            if (nlsOutputFilePresent) {
                nls.append(Utils.NEW_LINE).append("# Common Messages").append(Utils.NEW_LINE);
            }
            for (String key : commonKeys) {
                String message;
                boolean authAlias = false;
                if (key.endsWith("*")) {
                    key = key.substring(0, key.length() - 1);
                    authAlias = true;
                }
                if (nlsOutputFilePresent) {
                    nls.append(key).append('=');
                }
                if ((message = (String)originalNLSMap.get(key)) != null && !message.isEmpty()) {
                    if (!nlsOutputFilePresent) continue;
                    if (authAlias && !message.contains("It is recommended to use a container managed authentication alias instead of configuring this property")) {
                        nls.append(message).append(" (").append("It is recommended to use a container managed authentication alias instead of configuring this property").append(')').append(Utils.NEW_LINE);
                        continue;
                    }
                    nls.append(message).append(Utils.NEW_LINE);
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, key});
                if (this.config.isRuntime()) continue;
                this.buildTimeWarnings.add(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9917.missing.nls.msg", (Object[])new Object[]{nlsFile.getCanonicalPath(), this.generalAdapterName, key}));
            }
        }
        if (nlsOutputFilePresent) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Writing NLS keys/messages to file: " + this.config.getNLSOutputFile().getAbsolutePath()), (Object[])new Object[0]);
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.config.getNLSOutputFile()));){
                writer.write(nls.toString());
            }
        }
    }

    @Trivial
    public static final String toCamelCase(String input) {
        if (input == null || input.length() == 0 || Character.isLowerCase(input.charAt(0)) || input.length() > 1 && Character.isUpperCase(input.charAt(1))) {
            return input;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toLowerCase(input.charAt(0)));
        sb.append(input.substring(1));
        return sb.toString();
    }
}

