/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.metatype;

import com.ibm.websphere.metatype.AttributeDefinitionProperties;
import com.ibm.websphere.metatype.MetaTypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.Utils;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeAdOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.osgi.service.metatype.AttributeDefinition;

@Trivial
public class MetatypeAd {
    private static final TraceComponent tc = Tr.register(MetatypeAd.class);
    public static final Map<String, Integer> TYPES = new HashMap<String, Integer>();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_BOXED = new HashMap();
    private final MetaTypeFactory metaTypeProviderFactory;
    private static final Set<String> FRACT_NUMBER_TYPES;
    private static final Set<String> WHOLE_NUMBER_TYPES;
    private String id;
    private Boolean required;
    private String type;
    private String ibmType;
    private List<String> cachedDefaultValue;
    private String defaultValue;
    private String name;
    private String description;
    private Boolean ibmFinal;
    private String ibmReference;
    private String ibmService;
    private Integer cardinality;
    private String min;
    private String max;
    @XmlElement(name="Option")
    private final List<MetatypeAdOption> options = new LinkedList<MetatypeAdOption>();
    private String ibmuiGroup;
    private boolean recommendAuthAliasUsage = false;
    private boolean disableOptionLabelNLS = false;
    private String nlsKey;

    public MetatypeAd(MetaTypeFactory mtpService) {
        this.metaTypeProviderFactory = mtpService;
    }

    public static boolean isTypeClassName(String className) {
        return MetatypeAd.getTypeName(className) != null;
    }

    public static String getTypeName(String className) {
        String typeName;
        if (className.startsWith("java.lang.") && TYPES.containsKey(typeName = className.substring("java.lang.".length()))) {
            return typeName;
        }
        return null;
    }

    public static Class<?> getBoxedType(Class<?> primitiveType) {
        return PRIMITIVE_TO_BOXED.get(primitiveType);
    }

    public void setNLSKey(String nlsKey) {
        this.nlsKey = nlsKey;
    }

    public String getNLSKey() {
        return this.nlsKey;
    }

    public void disableOptionLabelNLS() {
        this.disableOptionLabelNLS = true;
    }

    public boolean isOptionLabelNLSDisabled() {
        return this.disableOptionLabelNLS;
    }

    public void setRecommendAuthAliasUsage(boolean recommendAuthAliasUsage) {
        this.recommendAuthAliasUsage = recommendAuthAliasUsage;
    }

    public boolean isAuthAliasUsageRecommended() {
        return this.recommendAuthAliasUsage;
    }

    @XmlAttribute(name="group", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/ui/v1.0.0")
    public void setIbmuiGroup(String ibmuiGroup) {
        this.ibmuiGroup = ibmuiGroup;
    }

    public String getIbmUigroup() {
        return this.ibmuiGroup;
    }

    public List<MetatypeAdOption> getOptions() {
        return this.options;
    }

    @XmlAttribute(name="min")
    public void setMin(String min) {
        this.min = min;
    }

    @XmlAttribute(name="max")
    public void setMax(String max) {
        this.max = max;
    }

    @XmlAttribute(name="final", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setFinal(Boolean ibmFinal) {
        this.ibmFinal = ibmFinal;
    }

    public boolean isFinal() {
        return this.ibmFinal != null && this.ibmFinal != false;
    }

    @XmlAttribute(name="id")
    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute(name="required")
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @XmlAttribute(name="type")
    public void setType(String type) {
        this.type = type;
    }

    @XmlAttribute(name="type", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setIbmType(String ibmType) {
        this.ibmType = ibmType;
    }

    @XmlAttribute(name="default")
    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
        this.cachedDefaultValue = null;
    }

    @XmlAttribute(name="name")
    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name="reference", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setReferencePid(String ibmReference) {
        this.ibmReference = ibmReference;
    }

    @XmlAttribute(name="service", namespace="http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")
    public void setService(String ibmService) {
        this.ibmService = ibmService;
    }

    @XmlAttribute(name="cardinality")
    public void setCardinality(Integer cardinality) {
        this.cardinality = cardinality;
        this.cachedDefaultValue = null;
    }

    public int getCardinality() {
        return this.cardinality == null ? 0 : this.cardinality;
    }

    public boolean getRequired() {
        return this.required != null && this.required != false;
    }

    public int getType() {
        Integer t = this.ibmType == null ? TYPES.get(this.type) : this.metaTypeProviderFactory.getIBMType(this.ibmType);
        return t == null ? -1 : t;
    }

    public String[] getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        if (this.cardinality == null || Math.abs(this.cardinality) == 1) {
            return new String[]{this.defaultValue};
        }
        if (this.cachedDefaultValue == null) {
            this.cachedDefaultValue = MetatypeAd.parse(this.defaultValue);
        }
        return this.cachedDefaultValue.toArray(new String[this.cachedDefaultValue.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReferencePid() {
        return this.ibmReference;
    }

    public String getService() {
        return this.ibmService;
    }

    private static List<String> parse(String value) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = null;
        int length = value.length();
        int start = 0;
        int comma = value.indexOf(44, 0);
        while (start >= 0) {
            String part = value.substring(start, comma < 0 ? length : comma);
            if (part.length() > 0 && part.charAt(part.length() - 1) == '\\') {
                if (buffer == null) {
                    buffer = new StringBuilder();
                }
                buffer.append(part.substring(0, part.length() - 1)).append(',');
            } else {
                parts.add(buffer == null ? part : buffer.append(part).toString());
                buffer = null;
            }
            start = comma < 0 ? -1 : comma + 1;
            comma = comma == length ? -1 : value.indexOf(44, comma + 1);
        }
        if (buffer != null) {
            parts.add(buffer.toString());
        }
        return parts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('{');
        sb.append("id='").append(this.id).append("' ");
        if (this.cardinality != null) {
            sb.append("cardinality='").append(this.cardinality).append("' ");
        }
        if (this.defaultValue != null) {
            sb.append("defaultValue='").append(this.defaultValue).append("' ");
        }
        if (this.description != null) {
            sb.append("description='").append(this.description).append("' ");
        }
        if (this.ibmFinal != null) {
            sb.append("ibmFinal='").append(this.ibmFinal).append("' ");
        }
        if (this.ibmReference != null) {
            sb.append("ibmReference='").append(this.ibmReference).append("' ");
        }
        if (this.ibmType != null) {
            sb.append("ibmType='").append(this.ibmType).append("' ");
        }
        if (this.ibmuiGroup != null) {
            sb.append("ibmuiGroup='").append(this.ibmuiGroup).append("' ");
        }
        if (this.max != null) {
            sb.append("max='").append(this.max).append("' ");
        }
        if (this.min != null) {
            sb.append("min='").append(this.min).append("' ");
        }
        if (this.name != null) {
            sb.append("name='").append(this.name).append("' ");
        }
        if (this.required != null) {
            sb.append("required='").append(this.required).append("' ");
        }
        if (this.type != null) {
            sb.append("type='").append(this.type).append("' ");
        }
        if (this.nlsKey != null) {
            sb.append("nlsKey='").append(this.nlsKey).append("' ");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options=[");
            for (int i = 0; i < this.options.size(); ++i) {
                sb.append(this.options.get(i));
                if (i + 1 == this.options.size()) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    private String xmlSafeAttrString(String unsafe) {
        if (unsafe.matches(".*[<\"].*")) {
            unsafe = unsafe.replaceAll("<", "&lt;");
            unsafe = unsafe.replaceAll("\"", "&quot;");
        }
        return unsafe;
    }

    public String toMetatypeString(int padSpaces) {
        String buffer = Utils.getSpaceBufferString(padSpaces);
        String subBuffer = Utils.getSpaceBufferString(padSpaces + 1);
        StringBuilder sb = new StringBuilder(buffer).append("<AD ");
        sb.append("id=\"").append(this.id).append("\" type=\"").append("Character".equals(this.type) ? "Char" : this.type).append("\" ");
        if (this.ibmType != null) {
            sb.append("ibm:type=\"").append(this.ibmType).append("\" ");
        }
        if (this.required != null) {
            sb.append("required=\"").append(this.required).append("\" ");
        }
        if (this.ibmFinal != null) {
            sb.append("ibm:final=\"").append(this.ibmFinal).append("\" ");
        }
        if (this.defaultValue != null) {
            sb.append("default=\"").append(this.defaultValue).append("\" ");
        }
        if (this.ibmReference != null) {
            sb.append("ibm:reference=\"").append(this.ibmReference).append("\" ");
        }
        if (this.cardinality != null) {
            sb.append("cardinality=\"").append(this.cardinality).append("\" ");
        }
        if (this.ibmuiGroup != null) {
            sb.append("ibmui:group=\"").append(this.ibmuiGroup).append("\" ");
        }
        if (this.min != null) {
            sb.append("min=\"").append(this.min).append("\" ");
        }
        if (this.max != null) {
            sb.append("max=\"").append(this.max).append("\" ");
        }
        if (this.name != null) {
            sb.append("name=\"").append(this.name).append("\" ");
        }
        if (this.description != null) {
            sb.append("description=\"").append(this.xmlSafeAttrString(this.description)).append("\" ");
        }
        if (this.options == null || this.options.isEmpty()) {
            sb.append("/>");
        } else {
            sb.append(">").append(Utils.NEW_LINE);
            for (MetatypeAdOption option : this.options) {
                sb.append(subBuffer).append(option.toMetatypeString(0)).append(Utils.NEW_LINE);
            }
            sb.append(buffer).append("</AD>");
        }
        return sb.toString();
    }

    public String getID() {
        return this.id;
    }

    public String[] getOptionLabels() {
        if (this.options.isEmpty()) {
            return null;
        }
        String[] labels = new String[this.options.size()];
        for (int i = 0; i < this.options.size(); ++i) {
            labels[i] = this.options.get(i).getLabel();
        }
        return labels;
    }

    public String[] getOptionValues() {
        if (this.options.isEmpty()) {
            return null;
        }
        String[] values = new String[this.options.size()];
        for (int i = 0; i < this.options.size(); ++i) {
            values[i] = this.options.get(i).getValue();
        }
        return values;
    }

    public String validate(String value) {
        if (this.min != null || this.max != null) {
            if (WHOLE_NUMBER_TYPES.contains(this.type)) {
                long val = Long.parseLong(value);
                if (this.min != null && val < Long.parseLong(this.min)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9930.value.too.small", (Object[])new Object[]{value, this.min, this.id});
                }
                if (this.max != null && val > Long.parseLong(this.max)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9931.value.too.large", (Object[])new Object[]{value, this.max, this.id});
                }
            } else if (FRACT_NUMBER_TYPES.contains(this.type)) {
                double val = Double.parseDouble(value);
                if (this.min != null && val < Double.parseDouble(this.min)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9930.value.too.small", (Object[])new Object[]{value, this.min, this.id});
                }
                if (this.max != null && val > Double.parseDouble(this.max)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9931.value.too.large", (Object[])new Object[]{value, this.max, this.id});
                }
            } else if ("String".equals(this.type)) {
                if (this.min != null && value.length() < Integer.parseInt(this.min)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9932.value.too.short", (Object[])new Object[]{value, this.min, this.id});
                }
                if (this.max != null && value.length() > Integer.parseInt(this.max)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9933.value.too.long", (Object[])new Object[]{value, this.max, this.id});
                }
            } else if ("Character".equals(this.type)) {
                char val = value.charAt(0);
                if (this.min != null && val < this.min.charAt(0)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9930.value.too.small", (Object[])new Object[]{value, this.min, this.id});
                }
                if (this.max != null && val > this.max.charAt(0)) {
                    return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9931.value.too.large", (Object[])new Object[]{value, this.max, this.id});
                }
            }
        }
        if (!this.options.isEmpty()) {
            boolean found = false;
            for (MetatypeAdOption option : this.options) {
                if (!option.getValue().equals(value)) continue;
                found = true;
                break;
            }
            if (!found) {
                return Tr.formatMessage((TraceComponent)tc, (String)"J2CA9934.not.a.valid.option", (Object[])new Object[]{value, this.id, Arrays.asList(this.getOptionValues())});
            }
        }
        return "";
    }

    public AttributeDefinition getAttributeDefinition() {
        AttributeDefinitionProperties props = new AttributeDefinitionProperties(this.getID());
        props.setOptionLabels(this.getOptionLabels());
        props.setOptionValues(this.getOptionValues());
        props.setReferencePid(this.getReferencePid());
        props.setService(this.getService());
        props.setDescription(this.getDescription());
        props.setName(this.getName());
        props.setDefaultValue(this.getDefaultValue());
        props.setType(this.getType());
        props.setFinal(this.isFinal());
        props.setCardinality(this.getCardinality());
        return this.metaTypeProviderFactory.createAttributeDefinition(props);
    }

    static {
        TYPES.put("Boolean", 11);
        TYPES.put("Byte", 6);
        TYPES.put("Character", 5);
        TYPES.put("Double", 7);
        TYPES.put("Float", 8);
        TYPES.put("Integer", 3);
        TYPES.put("Long", 2);
        TYPES.put("Short", 4);
        TYPES.put("String", 1);
        PRIMITIVE_TO_BOXED.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_BOXED.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_BOXED.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_BOXED.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_BOXED.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_BOXED.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_BOXED.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_BOXED.put(Short.TYPE, Short.class);
        FRACT_NUMBER_TYPES = new HashSet<String>(Arrays.asList("Double", "Float"));
        WHOLE_NUMBER_TYPES = new HashSet<String>(Arrays.asList("Byte", "Integer", "Long", "Short"));
    }
}

