/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.notification;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.converter.NotificationRecord;
import com.ibm.ws.jmx.connector.datatypes.NotificationArea;
import com.ibm.ws.jmx.connector.datatypes.NotificationRegistration;
import com.ibm.ws.jmx.connector.datatypes.NotificationSettings;
import com.ibm.ws.jmx.connector.datatypes.ServerNotificationRegistration;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationArea;
import com.ibm.ws.jmx.connector.server.rest.notification.ServerNotification;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NotificationManager {
    private final Map<Integer, ClientNotificationArea> inboxes = new ConcurrentHashMap<Integer, ClientNotificationArea>();
    private int clientIDGenerator = Integer.MIN_VALUE;
    private static final TraceComponent tc = Tr.register(NotificationManager.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.RESTServerMessages");
    static final long serialVersionUID = 2886235798362685728L;

    private NotificationManager() {
    }

    public static NotificationManager getNotificationManager() {
        return NotificationManagerSingleton.SINGLETON;
    }

    public NotificationArea createNotificationArea(RESTRequest request, String basePath, NotificationSettings notificationSettings) {
        this.cleanUp(request);
        int clientID = this.getNewClientID();
        ClientNotificationArea newInbox = new ClientNotificationArea(notificationSettings.deliveryInterval, notificationSettings.inboxExpiry, clientID);
        this.inboxes.put(clientID, newInbox);
        NotificationArea newArea = new NotificationArea();
        newArea.clientURL = basePath + clientID;
        newArea.inboxURL = newArea.clientURL + "/inbox";
        newArea.registrationsURL = newArea.clientURL + "/registrations";
        newArea.serverRegistrationsURL = newArea.clientURL + "/serverRegistrations";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created notification area for client ID " + clientID), (Object[])new Object[0]);
        }
        return newArea;
    }

    public String[] getRegisteredClientNotifications(RESTRequest request, int clientID, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, converter);
        return clientArea.getRegisteredListeners(request, converter);
    }

    public NotificationFilter[] getRegisteredFilters(RESTRequest request, int clientID, String objectName, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, converter);
        return clientArea.getRegisteredFilters(request, objectName, converter);
    }

    /*
     * WARNING - void declaration
     */
    public String addClientNotification(RESTRequest request, int clientID, NotificationRegistration notificationRegistration, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, converter);
        clientArea.addClientNotificationListener(request, notificationRegistration, converter);
        String encodedObjectName = null;
        try {
            encodedObjectName = URLEncoder.encode(notificationRegistration.objectName.getCanonicalName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager", (String)"132", (Object)this, (Object[])new Object[]{request, clientID, notificationRegistration, converter});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
        }
        String registrationURL = "/IBMJMXConnectorREST/notifications/" + clientID + "/registrations/" + encodedObjectName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Client[" + clientID + "] registered a client-side notification for ObjectName " + notificationRegistration.objectName.getCanonicalName()), (Object[])new Object[0]);
        }
        return registrationURL;
    }

    public void updateClientNotification(RESTRequest request, int clientID, String objectNameStr, NotificationFilter[] filters, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        clientArea.updateClientNotificationListener(request, objectNameStr, filters, converter);
    }

    public void removeClientNotification(RESTRequest request, ObjectName objectName, int clientID) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        clientArea.removeClientNotificationListener(request, objectName);
    }

    public NotificationRecord[] getClientInbox(int clientID) {
        ClientNotificationArea inbox = this.getInboxIfAvailable(clientID, null);
        return inbox.fetchNotifications();
    }

    public void handleServerNotificationRegistration(RESTRequest request, int clientID, ServerNotificationRegistration serverNotificationRegistration, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, converter);
        if (serverNotificationRegistration.operation == ServerNotificationRegistration.Operation.RemoveAll) {
            clientArea.removeServerNotificationListener(request, serverNotificationRegistration, true, converter, false);
        } else if (serverNotificationRegistration.operation == ServerNotificationRegistration.Operation.Add) {
            clientArea.addServerNotificationListener(request, serverNotificationRegistration, converter);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Added server-side notification", (Object[])new Object[0]);
            }
        } else {
            clientArea.removeServerNotificationListener(request, serverNotificationRegistration, false, converter, false);
        }
    }

    public String addServerNotificationHTTP(RESTRequest request, int clientID, ServerNotificationRegistration serverNotificationRegistration, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, converter);
        serverNotificationRegistration.filterID = clientArea.getParamId(serverNotificationRegistration.filter);
        serverNotificationRegistration.handbackID = clientArea.getParamId(serverNotificationRegistration.handback);
        clientArea.addServerNotificationListener(request, serverNotificationRegistration, converter);
        String returningURL = "/IBMJMXConnectorREST/notifications/" + clientID + "/serverRegistrations/" + RESTHelper.URLEncoder(serverNotificationRegistration.objectName.getCanonicalName(), converter) + "/listeners/" + RESTHelper.URLEncoder(serverNotificationRegistration.listener.getCanonicalName(), converter) + "/ids/" + serverNotificationRegistration.filterID + "_" + serverNotificationRegistration.handbackID;
        return returningURL;
    }

    public ServerNotificationRegistration getSpecificServerRegistration(RESTRequest request, int clientID, String source_objName, String listener_objName, String registrationID) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        List<ServerNotification> registrations = clientArea.getServerRegistrations(request, source_objName);
        if (registrations != null) {
            String[] artifacts = registrationID.split("_");
            int filterID = Integer.parseInt(artifacts[0]);
            int handbackID = Integer.parseInt(artifacts[1]);
            for (ServerNotification registration : registrations) {
                if (!registration.listener.getCanonicalName().equals(listener_objName) || registration.filter != filterID || registration.handback != handbackID) continue;
                ServerNotificationRegistration returningRegistration = new ServerNotificationRegistration();
                returningRegistration.filter = (NotificationFilter)clientArea.getObject(filterID, null, null);
                returningRegistration.handback = clientArea.getObject(handbackID, null, null);
                return returningRegistration;
            }
        }
        return null;
    }

    public void deleteServerRegistrationHTTP(RESTRequest request, int clientID, ServerNotificationRegistration serverNotificationRegistration, String registrationID, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        if (registrationID != null) {
            String[] artifacts = registrationID.split("_");
            int filterID = Integer.parseInt(artifacts[0]);
            int handbackID = Integer.parseInt(artifacts[1]);
            serverNotificationRegistration.filterID = filterID;
            serverNotificationRegistration.handbackID = handbackID;
        }
        clientArea.removeServerNotificationListener(request, serverNotificationRegistration, serverNotificationRegistration.operation == ServerNotificationRegistration.Operation.RemoveAll, converter, true);
    }

    public void deleteRegisteredListeners(RESTRequest request, int clientID, ObjectName source_objName, JSONConverter converter) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        clientArea.removeAllListeners(request, source_objName, converter);
    }

    public String[] getRegisteredIDs(RESTRequest request, int clientID, String source_objName, String listener_objName) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        List<ServerNotification> registrations = clientArea.getServerRegistrations(request, source_objName);
        if (registrations != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (ServerNotification registration : registrations) {
                if (!registration.listener.getCanonicalName().equals(listener_objName)) continue;
                ids.add(registration.filter + "_" + registration.handback);
            }
            return ids.toArray(new String[ids.size()]);
        }
        return null;
    }

    public String[] getRegisteredListeners(RESTRequest request, int clientID, String source_objName) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        List<ServerNotification> registrations = clientArea.getServerRegistrations(request, source_objName);
        if (registrations != null) {
            ArrayList<String> listeners = new ArrayList<String>();
            for (ServerNotification registration : registrations) {
                listeners.add(registration.listener.getCanonicalName());
            }
            return listeners.toArray(new String[listeners.size()]);
        }
        return null;
    }

    public void cleanUp(RESTRequest request, int clientID) {
        ClientNotificationArea inbox = this.inboxes.get(clientID);
        if (inbox != null) {
            inbox.cleanUp(request);
            this.inboxes.remove(clientID);
        }
    }

    public void removeAllClientRegistrations(RESTRequest request, int clientID) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        clientArea.remoteClientRegistrations(request);
    }

    public void removeAllServerRegistrations(RESTRequest request, int clientID) {
        ClientNotificationArea clientArea = this.getInboxIfAvailable(clientID, null);
        clientArea.remoteServerRegistrations(request);
    }

    public void cleanUp(RESTRequest request) {
        Iterator<Map.Entry<Integer, ClientNotificationArea>> clients = this.inboxes.entrySet().iterator();
        while (clients.hasNext()) {
            Map.Entry<Integer, ClientNotificationArea> client = clients.next();
            ClientNotificationArea inbox = client.getValue();
            if (!inbox.timedOut()) continue;
            inbox.cleanUp(request);
            Tr.warning((TraceComponent)tc, (String)"jmx.connector.server.rest.notification.timeout.warning", (Object[])new Object[]{client.getKey()});
            clients.remove();
        }
    }

    private ClientNotificationArea getInboxIfAvailable(int clientID, JSONConverter converter) {
        ClientNotificationArea inbox = this.inboxes.get(clientID);
        if (inbox == null) {
            throw ErrorHelper.createRESTHandlerJsonException(new RuntimeException("The requested clientID is no longer available because it timed out."), converter, 410);
        }
        return inbox;
    }

    private synchronized int getNewClientID() {
        if (this.clientIDGenerator + 1 >= Integer.MAX_VALUE) {
            int limit = -2147483548;
            for (int i = Integer.MIN_VALUE; i < -2147483548; ++i) {
                if (this.inboxes.get(i) != null) continue;
                return i;
            }
            Tr.warning((TraceComponent)tc, (String)"jmx.connector.server.rest.notification.limit.warning", (Object[])new Object[0]);
            throw ErrorHelper.createRESTHandlerJsonException(new RuntimeException("The server has reached its limit of new client notifications."), JSONConverter.getConverter(), 503);
        }
        return this.clientIDGenerator++;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class NotificationManagerSingleton {
        public static final NotificationManager SINGLETON;
        static final long serialVersionUID = -3608162339672319066L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private NotificationManagerSingleton() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NotificationManagerSingleton.class);
            SINGLETON = new NotificationManager();
        }
    }
}

