/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.archaius.composite;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.archaius.composite.ConfigListener;
import com.ibm.ws.microprofile.config.archaius.composite.Futures;
import com.ibm.ws.microprofile.config.interfaces.ConfigStartException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PollingDynamicConfig
implements Closeable {
    private static final TraceComponent tc = Tr.register(PollingDynamicConfig.class);
    private final CopyOnWriteArrayList<ConfigListener> listeners = new CopyOnWriteArrayList();
    private volatile Map<String, String> current = new HashMap<String, String>();
    private final AtomicBoolean busy = new AtomicBoolean();
    private Future<?> future;
    private final ScheduledExecutorService executor;
    private final long interval;
    private final TimeUnit units;
    private boolean localExecutor = false;
    private final String id;
    private final ConfigSource source;
    static final long serialVersionUID = -2205835976698310037L;

    public PollingDynamicConfig(ConfigSource source, ScheduledExecutorService executor, long refreshInterval) {
        this.source = source;
        this.id = source.getName();
        this.interval = refreshInterval;
        this.units = TimeUnit.MILLISECONDS;
        if (executor == null) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.localExecutor = true;
        } else {
            this.executor = executor;
        }
        this.future = this.start();
    }

    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyConfigUpdated() {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated();
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConfigStartException.class})
    private Future<?> start() {
        Future future = null;
        boolean startUpFailure = false;
        try {
            this.update();
        }
        catch (ConfigStartException cse) {
            startUpFailure = true;
        }
        catch (Exception cse) {
            void e;
            FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.microprofile.config.archaius.composite.PollingDynamicConfig", (String)"117", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"start: Initial Update failed: {0}. Exception: {1}", (Object[])new Object[]{this, e});
            }
            future = Futures.immediateFailure((Exception)e);
        }
        if (!startUpFailure && future == null && this.interval > 0L) {
            future = this.executor.scheduleWithFixedDelay(new Runnable(){
                static final long serialVersionUID = 6043576029299877291L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    block4: {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"start: Scheduled Update starting: {0}", (Object[])new Object[]{this});
                            }
                            PollingDynamicConfig.this.update();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"start", (Object[])new Object[]{"Scheduled Update completed: {0}", this});
                            }
                        }
                        catch (Exception exception) {
                            void e;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.config.archaius.composite.PollingDynamicConfig$1", (String)"139", (Object)this, (Object[])new Object[0]);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"start", (Object[])new Object[]{"Scheduled Update failed: {0}. Exception: {1}", this, e});
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }, this.interval, this.interval, this.units);
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConfigStartException.class})
    private void update() throws Exception {
        if (this.busy.compareAndSet(false, true)) {
            try {
                HashMap<String, String> updated = new HashMap<String, String>();
                Map props = this.source.getProperties();
                if (props != null) {
                    updated.putAll(props);
                }
                if (!updated.equals(this.current)) {
                    this.current = updated;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"update: Contents of ConfigSource {0} has changed.", (Object[])new Object[]{this});
                    }
                    this.notifyConfigUpdated();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"update: Contents of ConfigSource {0} has NOT changed.", (Object[])new Object[]{this});
                }
            }
            catch (ConfigStartException cse) {
                throw cse;
            }
            catch (Exception cse) {
                void e;
                FFDCFilter.processException((Throwable)cse, (String)"com.ibm.ws.microprofile.config.archaius.composite.PollingDynamicConfig", (String)"184", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"update: Exception updating dynamic source: {0}. Exception: {1}", (Object[])new Object[]{this, e});
                }
                throw e;
            }
            finally {
                this.busy.set(false);
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.future != null) {
                boolean cancelled;
                if (!(this.future.isDone() || this.future.isCancelled() || (cancelled = this.future.cancel(true)))) {
                    if (this.future.isDone() || this.future.isCancelled()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"PollingDynamicConfig lost race in future cancel: {0}", (Object[])new Object[]{this});
                        }
                    } else if (tc.isWarningEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)"future.update.not.cancelled.CWMCG0016E", (Object[])new Object[]{this});
                    }
                }
                this.future = null;
            }
        }
        finally {
            if (this.localExecutor) {
                this.executor.shutdown();
            }
        }
    }

    @Trivial
    protected boolean containsKey(String key) {
        return this.current.containsKey(key);
    }

    @Trivial
    protected String getRawProperty(String key) {
        String rawValue = this.source.getValue(key);
        if (rawValue != null) {
            this.current.put(key, rawValue);
        }
        return rawValue;
    }

    @Trivial
    protected Iterator<String> getKeys() {
        return this.current.keySet().iterator();
    }

    @Trivial
    public String toString() {
        return this.getSourceID();
    }

    @Trivial
    public String getSourceID() {
        return this.id;
    }
}

