/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.converters.ExtendedGenericConverter;
import com.ibm.ws.microprofile.config.converters.PriorityConverter;
import com.ibm.ws.microprofile.config.converters.PriorityConverterMap;
import com.ibm.ws.microprofile.config.impl.ConversionStatus;
import com.ibm.ws.microprofile.config.interfaces.ConfigException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.commons.lang3.ClassUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConversionManager {
    private static final TraceComponent tc = Tr.register(ConversionManager.class);
    private final PriorityConverterMap converters;
    private final WeakReference<ClassLoader> classLoader;
    static final long serialVersionUID = 5080891623463934666L;

    public ConversionManager(PriorityConverterMap converters, ClassLoader classLoader) {
        this.converters = converters;
        this.converters.setUnmodifiable();
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    protected ConversionStatus simpleConversion(String rawString, Type type, Class<?> genericSubType) {
        PriorityConverter converter;
        ConversionStatus status = new ConversionStatus();
        if (this.converters.hasType(type) && (converter = this.converters.getConverter(type)) != null) {
            Object converted = null;
            try {
                converted = converter instanceof ExtendedGenericConverter ? ((ExtendedGenericConverter)((Object)converter)).convert(rawString, genericSubType, this, (ClassLoader)this.classLoader.get()) : converter.convert(rawString);
                status.setConverted(converted);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.microprofile.config.impl.ConversionManager", (String)"67", (Object)this, (Object[])new Object[]{rawString, type, genericSubType});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"simpleConversion: A converter ''{0}'', for type ''{1}'', sub type ''{2}'' and raw String '{3}' threw an exception: {4}.", (Object[])new Object[]{converter, type, genericSubType, rawString, e});
                }
                throw e;
            }
            catch (Throwable e) {
                void t;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.impl.ConversionManager", (String)"73", (Object)this, (Object[])new Object[]{rawString, type, genericSubType});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"simpleConversion: A converter ''{0}'', for type ''{1}'', sub type ''{2}'' and raw String ''{3}'' threw an exception: {4}.", (Object[])new Object[]{converter, type, genericSubType, rawString, t});
                }
                throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"conversion.exception.CWMCG0007E", (Object[])new Object[]{type, rawString, t.getMessage()}), (Throwable)t);
            }
            if (status.isConverterFound() && status.getConverted() == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"simpleConversion: The converted value is null. The rawString is {0}", (Object[])new Object[]{rawString});
            }
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convert(String rawString, Type type) {
        Type genericTypeArg;
        Object value = null;
        if (!(type instanceof ParameterizedType)) return this.convert(rawString, type, null);
        ParameterizedType pType = (ParameterizedType)type;
        Type[] aTypes = pType.getActualTypeArguments();
        Type type2 = genericTypeArg = aTypes.length == 1 ? aTypes[0] : null;
        if (!(genericTypeArg instanceof Class)) throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"generic.type.variables.notsupported.CWMCG0018E", (Object[])new Object[]{type, genericTypeArg}));
        Class genericClassArg = (Class)genericTypeArg;
        return this.convert(rawString, pType.getRawType(), genericClassArg);
    }

    protected Object convert(String rawString, Type type, Class<?> genericSubType) {
        ConversionStatus status;
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isPrimitive()) {
            type = ClassUtils.primitiveToWrapper((Class)clazz);
        }
        if (!(status = this.simpleConversion(rawString, type, genericSubType)).isConverterFound() && type instanceof Class) {
            Class requestedClazz = (Class)type;
            if (requestedClazz.isArray()) {
                Object[] wrappedArray;
                Class arrayType;
                Class conversionType = arrayType = requestedClazz.getComponentType();
                if (arrayType.isPrimitive()) {
                    conversionType = ClassUtils.primitiveToWrapper(arrayType);
                }
                Object value = wrappedArray = this.convertArray(rawString, conversionType);
                if (arrayType.isPrimitive()) {
                    value = ConversionManager.toPrimitiveArray(wrappedArray, arrayType);
                }
                status.setConverted(value);
            }
            if (!status.isConverterFound()) {
                status = this.implicitConverters(rawString, requestedClazz);
            }
            if (!status.isConverterFound()) {
                status = this.convertCompatible(rawString, requestedClazz);
            }
        }
        if (!status.isConverterFound()) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"could.not.find.converter.CWMCG0014E", (Object[])new Object[]{type.getTypeName()}));
        }
        Object converted = status.getConverted();
        return converted;
    }

    protected static <T> Object toPrimitiveArray(Object[] array, Class<T> primitiveType) {
        Object primArray = Array.newInstance(primitiveType, array.length);
        for (int i = 0; i < array.length; ++i) {
            Array.set(primArray, i, array[i]);
        }
        return primArray;
    }

    protected <T> ConversionStatus implicitConverters(String rawString, Class<T> requestedClazz) {
        return new ConversionStatus();
    }

    protected ConversionStatus convertCompatible(String rawString, Class<?> type) {
        ConversionStatus status = new ConversionStatus();
        for (PriorityConverter con : this.converters.getAll()) {
            TypeVariable typeVariable;
            Type key = con.getType();
            if (key instanceof Class) {
                Class clazz = (Class)key;
                if (!type.isAssignableFrom(clazz)) continue;
                Object converted = this.convert(rawString, key);
                status.setConverted(converted);
                break;
            }
            if (!(key instanceof TypeVariable) || !(status = this.convertGenericClazz(rawString, type, typeVariable = (TypeVariable)key)).isConverterFound()) continue;
            break;
        }
        return status;
    }

    private <T> ConversionStatus convertGenericClazz(String rawString, Class<T> type, TypeVariable<?> typeVariable) {
        AnnotatedType[] bounds;
        ConversionStatus status = new ConversionStatus();
        for (AnnotatedType bound : bounds = typeVariable.getAnnotatedBounds()) {
            Class bClazz;
            Type bType = bound.getType();
            if (!(bType instanceof Class) || !(bClazz = (Class)bType).isAssignableFrom(type)) continue;
            Object converted = this.convert(rawString, typeVariable);
            status.setConverted(converted);
            break;
        }
        return status;
    }

    public <T> T[] convertArray(String rawString, Class<T> arrayType) {
        String[] elements = ConversionManager.split(rawString);
        T[] array = this.convertArray(elements, arrayType);
        return array;
    }

    public <T> T[] convertArray(String[] elements, Class<T> arrayType) {
        Object[] array = (Object[])Array.newInstance(arrayType, elements.length);
        for (int i = 0; i < elements.length; ++i) {
            array[i] = this.convert(elements[i], arrayType);
        }
        return array;
    }

    public static String[] split(String rawString) {
        String[] elements = null;
        if (rawString != null) {
            elements = rawString.split("(?<!\\\\),");
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = elements[i].replaceAll("\\\\,", ",");
            }
        } else {
            elements = new String[]{};
        }
        return elements;
    }
}

