/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.IincInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.InsnList;
import org.eclipse.persistence.internal.libraries.asm.tree.JumpInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LabelNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LookupSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TableSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;
import org.eclipse.persistence.internal.libraries.asm.tree.VarInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Frame;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Interpreter;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Subroutine;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Value;

public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int insnListSize;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] inInstructionsToProcess;
    private int[] instructionsToProcess;
    private int numInstructionsToProcess;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String owner, MethodNode method) throws AnalyzerException {
        if ((method.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.insnList = method.instructions;
        this.insnListSize = this.insnList.size();
        this.handlers = new List[this.insnListSize];
        this.frames = new Frame[this.insnListSize];
        this.subroutines = new Subroutine[this.insnListSize];
        this.inInstructionsToProcess = new boolean[this.insnListSize];
        this.instructionsToProcess = new int[this.insnListSize];
        this.numInstructionsToProcess = 0;
        int i = 0;
        while (i < method.tryCatchBlocks.size()) {
            TryCatchBlockNode tryCatchBlock = method.tryCatchBlocks.get(i);
            int startIndex = this.insnList.indexOf(tryCatchBlock.start);
            int endIndex = this.insnList.indexOf(tryCatchBlock.end);
            int j = startIndex;
            while (j < endIndex) {
                List<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tryCatchBlock);
                ++j;
            }
            ++i;
        }
        Subroutine main = new Subroutine(null, method.maxLocals, null);
        ArrayList<AbstractInsnNode> jsrInsns = new ArrayList<AbstractInsnNode>();
        this.findSubroutine(0, main, jsrInsns);
        HashMap<LabelNode, Subroutine> jsrSubroutines = new HashMap<LabelNode, Subroutine>();
        while (!jsrInsns.isEmpty()) {
            JumpInsnNode jsrInsn = (JumpInsnNode)jsrInsns.remove(0);
            Subroutine subroutine = (Subroutine)jsrSubroutines.get(jsrInsn.label);
            if (subroutine == null) {
                subroutine = new Subroutine(jsrInsn.label, method.maxLocals, jsrInsn);
                jsrSubroutines.put(jsrInsn.label, subroutine);
                this.findSubroutine(this.insnList.indexOf(jsrInsn.label), subroutine, jsrInsns);
                continue;
            }
            subroutine.callers.add(jsrInsn);
        }
        int i2 = 0;
        while (i2 < this.insnListSize) {
            if (this.subroutines[i2] != null && this.subroutines[i2].start == null) {
                this.subroutines[i2] = null;
            }
            ++i2;
        }
        Frame<V> currentFrame = this.computeInitialFrame(owner, method);
        this.merge(0, currentFrame, null);
        this.init(owner, method);
        while (this.numInstructionsToProcess > 0) {
            int insnIndex = this.instructionsToProcess[--this.numInstructionsToProcess];
            Frame<V> oldFrame = this.frames[insnIndex];
            Subroutine subroutine = this.subroutines[insnIndex];
            this.inInstructionsToProcess[insnIndex] = false;
            AbstractInsnNode insnNode = null;
            try {
                insnNode = method.instructions.get(insnIndex);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insnIndex + 1, oldFrame, subroutine);
                    this.newControlFlowEdge(insnIndex, insnIndex + 1);
                } else {
                    currentFrame.init(oldFrame).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : new Subroutine(subroutine);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode jumpInsn = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insnIndex + 1, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, insnIndex + 1);
                        }
                        int jumpInsnIndex = this.insnList.indexOf(jumpInsn.label);
                        if (insnOpcode == 168) {
                            this.merge(jumpInsnIndex, currentFrame, new Subroutine(jumpInsn.label, method.maxLocals, jumpInsn));
                        } else {
                            this.merge(jumpInsnIndex, currentFrame, subroutine);
                        }
                        this.newControlFlowEdge(insnIndex, jumpInsnIndex);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(lookupSwitchInsn.dflt);
                        this.merge(targetInsnIndex, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        int i3 = 0;
                        while (i3 < lookupSwitchInsn.labels.size()) {
                            targetInsnIndex = this.insnList.indexOf(lookupSwitchInsn.labels.get(i3));
                            this.merge(targetInsnIndex, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, targetInsnIndex);
                            ++i3;
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf(tableSwitchInsn.dflt);
                        this.merge(targetInsnIndex, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        int i4 = 0;
                        while (i4 < tableSwitchInsn.labels.size()) {
                            targetInsnIndex = this.insnList.indexOf(tableSwitchInsn.labels.get(i4));
                            this.merge(targetInsnIndex, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, targetInsnIndex);
                            ++i4;
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a sub routine");
                        }
                        int i5 = 0;
                        while (i5 < subroutine.callers.size()) {
                            JumpInsnNode caller = subroutine.callers.get(i5);
                            int jsrInsnIndex = this.insnList.indexOf(caller);
                            if (this.frames[jsrInsnIndex] != null) {
                                this.merge(jsrInsnIndex + 1, this.frames[jsrInsnIndex], currentFrame, this.subroutines[jsrInsnIndex], subroutine.localsUsed);
                                this.newControlFlowEdge(insnIndex, jsrInsnIndex + 1);
                            }
                            ++i5;
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.localsUsed[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.localsUsed[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.localsUsed[var] = true;
                            }
                        }
                        this.merge(insnIndex + 1, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, insnIndex + 1);
                    }
                }
                List<TryCatchBlockNode> insnHandlers = this.handlers[insnIndex];
                if (insnHandlers == null) continue;
                int i6 = 0;
                while (i6 < insnHandlers.size()) {
                    TryCatchBlockNode tryCatchBlock = insnHandlers.get(i6);
                    Type catchType = tryCatchBlock.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlock.type);
                    if (this.newControlFlowExceptionEdge(insnIndex, tryCatchBlock)) {
                        Frame<V> handler = new Frame<V>(oldFrame);
                        handler.clearStack();
                        handler.push(this.interpreter.newValue(catchType));
                        this.merge(this.insnList.indexOf(tryCatchBlock.handler), handler, subroutine);
                    }
                    ++i6;
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insnIndex + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insnIndex + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int insnIndex, Subroutine subroutine, List<AbstractInsnNode> jsrInsns) throws AnalyzerException {
        int currentInsnIndex = insnIndex;
        while (true) {
            LabelNode l;
            int i;
            if (currentInsnIndex < 0 || currentInsnIndex >= this.insnListSize) {
                throw new AnalyzerException(null, "Execution can fall off the end of the code");
            }
            if (this.subroutines[currentInsnIndex] != null) {
                return;
            }
            this.subroutines[currentInsnIndex] = new Subroutine(subroutine);
            AbstractInsnNode currentInsn = this.insnList.get(currentInsnIndex);
            if (currentInsn instanceof JumpInsnNode) {
                if (currentInsn.getOpcode() == 168) {
                    jsrInsns.add(currentInsn);
                } else {
                    JumpInsnNode jumpInsn = (JumpInsnNode)currentInsn;
                    this.findSubroutine(this.insnList.indexOf(jumpInsn.label), subroutine, jsrInsns);
                }
            } else if (currentInsn instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)currentInsn;
                this.findSubroutine(this.insnList.indexOf(tableSwitchInsn.dflt), subroutine, jsrInsns);
                i = tableSwitchInsn.labels.size() - 1;
                while (i >= 0) {
                    l = tableSwitchInsn.labels.get(i);
                    this.findSubroutine(this.insnList.indexOf(l), subroutine, jsrInsns);
                    --i;
                }
            } else if (currentInsn instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)currentInsn;
                this.findSubroutine(this.insnList.indexOf(lookupSwitchInsn.dflt), subroutine, jsrInsns);
                i = lookupSwitchInsn.labels.size() - 1;
                while (i >= 0) {
                    l = lookupSwitchInsn.labels.get(i);
                    this.findSubroutine(this.insnList.indexOf(l), subroutine, jsrInsns);
                    --i;
                }
            }
            List<TryCatchBlockNode> insnHandlers = this.handlers[currentInsnIndex];
            if (insnHandlers != null) {
                i = 0;
                while (i < insnHandlers.size()) {
                    TryCatchBlockNode tryCatchBlock = insnHandlers.get(i);
                    this.findSubroutine(this.insnList.indexOf(tryCatchBlock.handler), subroutine, jsrInsns);
                    ++i;
                }
            }
            switch (currentInsn.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++currentInsnIndex;
        }
    }

    private Frame<V> computeInitialFrame(String owner, MethodNode method) {
        Frame<V> frame = this.newFrame(method.maxLocals, method.maxStack);
        int currentLocal = 0;
        if ((method.access & 8) == 0) {
            Type ownerType = Type.getObjectType(owner);
            frame.setLocal(currentLocal++, this.interpreter.newValue(ownerType));
        }
        Type[] argumentTypes = Type.getArgumentTypes(method.desc);
        int i = 0;
        while (i < argumentTypes.length) {
            frame.setLocal(currentLocal++, this.interpreter.newValue(argumentTypes[i]));
            if (argumentTypes[i].getSize() == 2) {
                frame.setLocal(currentLocal++, this.interpreter.newValue(null));
            }
            ++i;
        }
        while (currentLocal < method.maxLocals) {
            frame.setLocal(currentLocal++, this.interpreter.newValue(null));
        }
        frame.setReturn(this.interpreter.newValue(Type.getReturnType(method.desc)));
        return frame;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int insnIndex) {
        return this.handlers[insnIndex];
    }

    protected void init(String owner, MethodNode method) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int insnIndex, int successorIndex) {
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, int successorIndex) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, TryCatchBlockNode tryCatchBlock) {
        return this.newControlFlowExceptionEdge(insnIndex, this.insnList.indexOf(tryCatchBlock.handler));
    }

    private void merge(int insnIndex, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean changed;
        Frame<V> oldFrame = this.frames[insnIndex];
        if (oldFrame == null) {
            this.frames[insnIndex] = this.newFrame(frame);
            changed = true;
        } else {
            changed = oldFrame.merge(frame, this.interpreter);
        }
        Subroutine oldSubroutine = this.subroutines[insnIndex];
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insnIndex] = new Subroutine(subroutine);
                changed = true;
            }
        } else if (subroutine != null) {
            changed |= oldSubroutine.merge(subroutine);
        }
        if (changed && !this.inInstructionsToProcess[insnIndex]) {
            this.inInstructionsToProcess[insnIndex] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = insnIndex;
        }
    }

    private void merge(int insnIndex, Frame<V> frameBeforeJsr, Frame<V> frameAfterRet, Subroutine subroutineBeforeJsr, boolean[] localsUsed) throws AnalyzerException {
        boolean changed;
        frameAfterRet.merge(frameBeforeJsr, localsUsed);
        Frame<V> oldFrame = this.frames[insnIndex];
        if (oldFrame == null) {
            this.frames[insnIndex] = this.newFrame(frameAfterRet);
            changed = true;
        } else {
            changed = oldFrame.merge(frameAfterRet, this.interpreter);
        }
        Subroutine oldSubroutine = this.subroutines[insnIndex];
        if (oldSubroutine != null && subroutineBeforeJsr != null) {
            changed |= oldSubroutine.merge(subroutineBeforeJsr);
        }
        if (changed && !this.inInstructionsToProcess[insnIndex]) {
            this.inInstructionsToProcess[insnIndex] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = insnIndex;
        }
    }
}

