/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConcurrentObjectPool<T> {
    private final AtomicReference<T>[] m_array;
    private final AtomicInteger m_get;
    private final AtomicInteger m_put;
    private final int m_arraySize;
    private static final int LIMIT = Integer.MAX_VALUE;
    static final long serialVersionUID = 4501692949102740736L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConcurrentObjectPool(int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("pool size is too small");
        }
        this.m_get = new AtomicInteger(0);
        this.m_put = new AtomicInteger(0);
        this.m_arraySize = poolSize + 1;
        this.m_array = new AtomicReference[this.m_arraySize];
        for (int i = 0; i < this.m_arraySize; ++i) {
            this.m_array[i] = new AtomicReference<Object>(null);
        }
    }

    public T get() {
        int index;
        AtomicReference<T> reference;
        T object;
        int g;
        do {
            int p = this.m_put.get();
            g = this.m_get.get();
            if (g < p) continue;
            if (p >= Integer.MAX_VALUE) {
                this.m_get.set(0);
                this.m_put.set(0);
            }
            return null;
        } while (!this.m_get.compareAndSet(g, g + 1) || (object = (reference = this.m_array[index = g % this.m_arraySize]).get()) == null || !reference.compareAndSet(object, null));
        return object;
    }

    public boolean put(T object) {
        int index;
        AtomicReference<T> reference;
        int p;
        if (object == null) {
            throw new IllegalArgumentException("returning null object to pool");
        }
        do {
            int g = this.m_get.get();
            p = this.m_put.get();
            if (p >= Integer.MAX_VALUE) {
                return false;
            }
            if (p - g < this.m_arraySize - 1) continue;
            return false;
        } while (!this.m_put.compareAndSet(p, p + 1) || !(reference = this.m_array[index = p % this.m_arraySize]).compareAndSet(null, object));
        return true;
    }

    public String toString() {
        return "ConcurrentObjectPool-" + System.identityHashCode(this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ConcurrentObjectPool.class);
    }
}

