/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.OperatingSystemException;
import com.ibm.ws.kernel.service.util.OperatingSystemType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OperatingSystem {
    private static final TraceComponent tc = Tr.register(OperatingSystem.class);
    private static final OperatingSystem instance = new OperatingSystem();
    private final OperatingSystemType osType = OperatingSystem.parseOperatingSystemType();
    private static int cachedPageSize = -1;
    static final long serialVersionUID = 2146516632008671522L;

    public static OperatingSystem instance() {
        return instance;
    }

    public OperatingSystemType getOperatingSystemType() {
        return this.osType;
    }

    private static OperatingSystemType parseOperatingSystemType() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if ((osName = osName.toLowerCase().replaceAll("/", "")).contains("linux")) {
                return OperatingSystemType.Linux;
            }
            if (osName.contains("mac") || osName.contains("darwin")) {
                return OperatingSystemType.Mac;
            }
            if (osName.contains("aix")) {
                return OperatingSystemType.AIX;
            }
            if (osName.contains("win")) {
                return OperatingSystemType.Windows;
            }
            if (osName.contains("400")) {
                return OperatingSystemType.IBMi;
            }
            if (osName.contains("os390") || osName.contains("zos")) {
                return OperatingSystemType.zOS;
            }
            if (osName.contains("hp")) {
                return OperatingSystemType.HPUX;
            }
            if (osName.contains("solaris") || osName.contains("sun")) {
                return OperatingSystemType.Solaris;
            }
        }
        return OperatingSystemType.Unknown;
    }

    public static synchronized int getPageSize() throws OperatingSystemException {
        if (cachedPageSize == -1) {
            switch (OperatingSystem.instance().getOperatingSystemType()) {
                case AIX: 
                case HPUX: 
                case IBMi: 
                case Linux: 
                case Mac: 
                case Solaris: 
                case zOS: {
                    cachedPageSize = OperatingSystem.getPageSizePOSIX();
                    break;
                }
                default: {
                    throw new OperatingSystemException(Tr.formatMessage((TraceComponent)tc, (String)"os.pagesize.unavailable", (Object[])new Object[0]));
                }
            }
        }
        return cachedPageSize;
    }

    private static int getPageSizePOSIX() throws OperatingSystemException {
        List<String> getconfLines = OperatingSystem.executeProgram("/usr/bin/getconf", "PAGE_SIZE");
        return Integer.parseInt(getconfLines.get(0).trim());
    }

    public static List<String> executeProgram(String ... commandLine) throws OperatingSystemException {
        return OperatingSystem.executeProgramWithInput(null, commandLine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={IOException.class, InterruptedException.class})
    public static List<String> executeProgramWithInput(String input, String ... commandLine) throws OperatingSystemException {
        try {
            int returnCode;
            ArrayList<String> lines;
            Process process;
            block68: {
                InputStream is;
                block69: {
                    block62: {
                        OutputStream os;
                        block63: {
                            ProcessBuilder builder = new ProcessBuilder(new String[0]);
                            builder.command(commandLine);
                            process = builder.start();
                            if (input == null) break block62;
                            os = process.getOutputStream();
                            Throwable throwable4 = null;
                            try {
                                block60: {
                                    OutputStreamWriter osw;
                                    block61: {
                                        osw = new OutputStreamWriter(os);
                                        Throwable throwable5 = null;
                                        try {
                                            block58: {
                                                BufferedWriter bw;
                                                block59: {
                                                    bw = new BufferedWriter(osw);
                                                    Throwable throwable6 = null;
                                                    try {
                                                        bw.write(input);
                                                        bw.flush();
                                                        if (bw == null) break block58;
                                                        if (throwable6 == null) break block59;
                                                    }
                                                    catch (Throwable throwable8) {
                                                        try {
                                                            FFDCFilter.processException((Throwable)throwable8, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"154", null, (Object[])new Object[]{input, commandLine});
                                                            throwable6 = throwable8;
                                                            throw throwable8;
                                                        }
                                                        catch (Throwable throwable9) {
                                                            if (bw == null) throw throwable9;
                                                            if (throwable6 == null) {
                                                                bw.close();
                                                                throw throwable9;
                                                            }
                                                            try {
                                                                bw.close();
                                                                throw throwable9;
                                                            }
                                                            catch (Throwable throwable10) {
                                                                FFDCFilter.processException((Throwable)throwable10, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"157", null, (Object[])new Object[]{input, commandLine});
                                                                throwable6.addSuppressed(throwable10);
                                                                throw throwable9;
                                                            }
                                                        }
                                                    }
                                                    try {
                                                        bw.close();
                                                    }
                                                    catch (Throwable throwable7) {
                                                        FFDCFilter.processException((Throwable)throwable7, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"157", null, (Object[])new Object[]{input, commandLine});
                                                        throwable6.addSuppressed(throwable7);
                                                    }
                                                    break block58;
                                                }
                                                bw.close();
                                            }
                                            if (osw == null) break block60;
                                            if (throwable5 == null) break block61;
                                        }
                                        catch (Throwable throwable12) {
                                            try {
                                                FFDCFilter.processException((Throwable)throwable12, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"153", null, (Object[])new Object[]{input, commandLine});
                                                throwable5 = throwable12;
                                                throw throwable12;
                                            }
                                            catch (Throwable throwable13) {
                                                if (osw == null) throw throwable13;
                                                if (throwable5 == null) {
                                                    osw.close();
                                                    throw throwable13;
                                                }
                                                try {
                                                    osw.close();
                                                    throw throwable13;
                                                }
                                                catch (Throwable throwable14) {
                                                    FFDCFilter.processException((Throwable)throwable14, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"158", null, (Object[])new Object[]{input, commandLine});
                                                    throwable5.addSuppressed(throwable14);
                                                    throw throwable13;
                                                }
                                            }
                                        }
                                        try {
                                            osw.close();
                                        }
                                        catch (Throwable throwable11) {
                                            FFDCFilter.processException((Throwable)throwable11, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"158", null, (Object[])new Object[]{input, commandLine});
                                            throwable5.addSuppressed(throwable11);
                                        }
                                        break block60;
                                    }
                                    osw.close();
                                }
                                if (os == null) break block62;
                                if (throwable4 == null) break block63;
                            }
                            catch (Throwable throwable16) {
                                try {
                                    FFDCFilter.processException((Throwable)throwable16, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"152", null, (Object[])new Object[]{input, commandLine});
                                    throwable4 = throwable16;
                                    throw throwable16;
                                }
                                catch (Throwable throwable17) {
                                    if (os == null) throw throwable17;
                                    if (throwable4 == null) {
                                        os.close();
                                        throw throwable17;
                                    }
                                    try {
                                        os.close();
                                        throw throwable17;
                                    }
                                    catch (Throwable throwable18) {
                                        FFDCFilter.processException((Throwable)throwable18, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"159", null, (Object[])new Object[]{input, commandLine});
                                        throwable4.addSuppressed(throwable18);
                                        throw throwable17;
                                    }
                                }
                            }
                            try {
                                os.close();
                            }
                            catch (Throwable throwable15) {
                                FFDCFilter.processException((Throwable)throwable15, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"159", null, (Object[])new Object[]{input, commandLine});
                                throwable4.addSuppressed(throwable15);
                            }
                            break block62;
                        }
                        os.close();
                    }
                    lines = new ArrayList<String>();
                    is = process.getInputStream();
                    Throwable throwable = null;
                    try {
                        block66: {
                            InputStreamReader isr;
                            block67: {
                                isr = new InputStreamReader(is);
                                Throwable throwable2 = null;
                                try {
                                    block64: {
                                        BufferedReader br;
                                        block65: {
                                            br = new BufferedReader(isr);
                                            Throwable throwable3 = null;
                                            try {
                                                String line;
                                                while ((line = br.readLine()) != null) {
                                                    lines.add(line);
                                                }
                                                if (br == null) break block64;
                                                if (throwable3 == null) break block65;
                                            }
                                            catch (Throwable throwable20) {
                                                try {
                                                    FFDCFilter.processException((Throwable)throwable20, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"165", null, (Object[])new Object[]{input, commandLine});
                                                    throwable3 = throwable20;
                                                    throw throwable20;
                                                }
                                                catch (Throwable throwable21) {
                                                    if (br == null) throw throwable21;
                                                    if (throwable3 == null) {
                                                        br.close();
                                                        throw throwable21;
                                                    }
                                                    try {
                                                        br.close();
                                                        throw throwable21;
                                                    }
                                                    catch (Throwable throwable22) {
                                                        FFDCFilter.processException((Throwable)throwable22, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"170", null, (Object[])new Object[]{input, commandLine});
                                                        throwable3.addSuppressed(throwable22);
                                                        throw throwable21;
                                                    }
                                                }
                                            }
                                            try {
                                                br.close();
                                            }
                                            catch (Throwable throwable19) {
                                                FFDCFilter.processException((Throwable)throwable19, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"170", null, (Object[])new Object[]{input, commandLine});
                                                throwable3.addSuppressed(throwable19);
                                            }
                                            break block64;
                                        }
                                        br.close();
                                    }
                                    if (isr == null) break block66;
                                    if (throwable2 == null) break block67;
                                }
                                catch (Throwable throwable24) {
                                    try {
                                        FFDCFilter.processException((Throwable)throwable24, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"164", null, (Object[])new Object[]{input, commandLine});
                                        throwable2 = throwable24;
                                        throw throwable24;
                                    }
                                    catch (Throwable throwable25) {
                                        if (isr == null) throw throwable25;
                                        if (throwable2 == null) {
                                            isr.close();
                                            throw throwable25;
                                        }
                                        try {
                                            isr.close();
                                            throw throwable25;
                                        }
                                        catch (Throwable throwable26) {
                                            FFDCFilter.processException((Throwable)throwable26, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"171", null, (Object[])new Object[]{input, commandLine});
                                            throwable2.addSuppressed(throwable26);
                                            throw throwable25;
                                        }
                                    }
                                }
                                try {
                                    isr.close();
                                }
                                catch (Throwable throwable23) {
                                    FFDCFilter.processException((Throwable)throwable23, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"171", null, (Object[])new Object[]{input, commandLine});
                                    throwable2.addSuppressed(throwable23);
                                }
                                break block66;
                            }
                            isr.close();
                        }
                        if (is == null) break block68;
                        if (throwable == null) break block69;
                    }
                    catch (Throwable throwable28) {
                        try {
                            FFDCFilter.processException((Throwable)throwable28, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"163", null, (Object[])new Object[]{input, commandLine});
                            throwable = throwable28;
                            throw throwable28;
                        }
                        catch (Throwable throwable29) {
                            if (is == null) throw throwable29;
                            if (throwable == null) {
                                is.close();
                                throw throwable29;
                            }
                            try {
                                is.close();
                                throw throwable29;
                            }
                            catch (Throwable throwable30) {
                                FFDCFilter.processException((Throwable)throwable30, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"172", null, (Object[])new Object[]{input, commandLine});
                                throwable.addSuppressed(throwable30);
                                throw throwable29;
                            }
                        }
                    }
                    try {
                        is.close();
                    }
                    catch (Throwable throwable27) {
                        FFDCFilter.processException((Throwable)throwable27, (String)"com.ibm.ws.kernel.service.util.OperatingSystem", (String)"172", null, (Object[])new Object[]{input, commandLine});
                        throwable.addSuppressed(throwable27);
                    }
                    break block68;
                }
                is.close();
            }
            if ((returnCode = process.waitFor()) == 0) return lines;
            throw new OperatingSystemException(Tr.formatMessage((TraceComponent)tc, (String)"os.execute.error", (Object[])new Object[]{commandLine, returnCode, lines}));
        }
        catch (IOException e) {
            throw new OperatingSystemException(e);
        }
        catch (InterruptedException e) {
            throw new OperatingSystemException(e);
        }
    }
}

