/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.microprofile.metrics.monitor.MonitorCounter;
import com.ibm.ws.microprofile.metrics.monitor.MonitorGauge;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MonitorMetrics {
    private static final TraceComponent tc = Tr.register(MonitorMetrics.class);
    protected String objectName;
    private String mbeanStatsName;
    private MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private Set<String> metricNames;
    static final long serialVersionUID = -2315988316600056351L;

    public MonitorMetrics(String objectName) {
        this.objectName = objectName;
        this.metricNames = new HashSet<String>();
    }

    public void createMetrics(SharedMetricRegistries sharedMetricRegistry, String[][] data) {
        MetricRegistry registry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.VENDOR.getName());
        for (String[] metricData : data) {
            String metricName = this.getMetricName(metricData[0]);
            MetricType type = MetricType.valueOf((String)metricData[3]);
            if (MetricType.COUNTER.equals((Object)type)) {
                registry.register(new Metadata(metricName, metricData[1], metricData[2], type, metricData[4]), (Metric)new MonitorCounter(this.mbs, this.objectName, metricData[5]));
                this.metricNames.add(metricName);
                Tr.debug((TraceComponent)tc, (String)("Registered " + metricName), (Object[])new Object[0]);
                continue;
            }
            if (MetricType.GAUGE.equals((Object)type)) {
                MonitorGauge mg = metricData[6] == null ? new MonitorGauge(this.mbs, this.objectName, metricData[5]) : new MonitorGauge(this.mbs, this.objectName, metricData[5], metricData[6]);
                registry.register(new Metadata(metricName, metricData[1], metricData[2], type, metricData[4]), mg);
                this.metricNames.add(metricName);
                Tr.debug((TraceComponent)tc, (String)("Registered " + metricName), (Object[])new Object[0]);
                continue;
            }
            Tr.debug((TraceComponent)tc, (String)("Falied to register " + metricName + " because of invalid type " + type), (Object[])new Object[0]);
        }
    }

    private String getMBeanStatsName() {
        if (this.mbeanStatsName == null) {
            this.mbeanStatsName = "unknown";
            for (String subString : this.objectName.split(",")) {
                if (!(subString = subString.trim()).contains("name=")) continue;
                this.mbeanStatsName = subString.split("=")[1];
                this.mbeanStatsName = this.mbeanStatsName.replaceAll(" ", "_");
                this.mbeanStatsName = this.mbeanStatsName.replaceAll("/", "_");
                break;
            }
        }
        return this.mbeanStatsName;
    }

    private String getMetricName(String name) {
        return name.replace("%s", this.getMBeanStatsName());
    }

    public void unregisterMetrics(SharedMetricRegistries sharedMetricRegistry) {
        MetricRegistry registry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.VENDOR.getName());
        for (String metricName : this.metricNames) {
            boolean rc = registry.remove(metricName);
            Tr.debug((TraceComponent)tc, (String)("Unregistered " + metricName + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
        this.metricNames.clear();
    }
}

