/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.ejb.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.ejb.impl.AbstractEjbEndpointService;
import com.ibm.ws.cdi.ejb.impl.InterceptorChain;
import com.ibm.ws.cdi.internal.interfaces.WebSphereEjbServices;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.jboss.weld.serialization.spi.BeanIdentifier;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EJBCDIInterceptorWrapper
implements Serializable {
    private static final TraceComponent tc = Tr.register(EJBCDIInterceptorWrapper.class);
    @Inject
    BeanManager beanManager;
    private final ConcurrentHashMap<BeanIdentifier, Object> activeInterceptors = new ConcurrentHashMap();
    static final long serialVersionUID = -5367087917382782149L;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Object rc = this.invokeInterceptors(invocation, InterceptionType.AROUND_INVOKE);
        return rc;
    }

    @AroundTimeout
    public Object aroundTimeout(InvocationContext invocation) throws Exception {
        Object rc = this.invokeInterceptors(invocation, InterceptionType.AROUND_TIMEOUT);
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    @PostConstruct
    public void postConstruct(InvocationContext invocation) {
        try {
            this.invokeInterceptors(invocation, InterceptionType.POST_CONSTRUCT);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.ejb.impl.EJBCDIInterceptorWrapper", (String)"68", (Object)this, (Object[])new Object[]{invocation});
            Tr.error((TraceComponent)tc, (String)"lifecycle.interceptor.exception.CWOWB2001E", (Object[])new Object[]{InterceptionType.POST_CONSTRUCT, e});
            throw new UndeclaredThrowableException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreDestroy
    public void preDestroy(InvocationContext invocation) {
        try {
            this.invokeInterceptors(invocation, InterceptionType.PRE_DESTROY);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.ejb.impl.EJBCDIInterceptorWrapper", (String)"78", (Object)this, (Object[])new Object[]{invocation});
            Tr.error((TraceComponent)tc, (String)"lifecycle.interceptor.exception.CWOWB2001E", (Object[])new Object[]{InterceptionType.PRE_DESTROY, e});
            throw new UndeclaredThrowableException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostActivate
    public void postActivate(InvocationContext invocation) {
        try {
            this.invokeInterceptors(invocation, InterceptionType.POST_ACTIVATE);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.ejb.impl.EJBCDIInterceptorWrapper", (String)"88", (Object)this, (Object[])new Object[]{invocation});
            Tr.error((TraceComponent)tc, (String)"lifecycle.interceptor.exception.CWOWB2001E", (Object[])new Object[]{InterceptionType.POST_ACTIVATE, e});
            throw new UndeclaredThrowableException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PrePassivate
    public void prePassivate(InvocationContext invocation) {
        try {
            this.invokeInterceptors(invocation, InterceptionType.PRE_PASSIVATE);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.ejb.impl.EJBCDIInterceptorWrapper", (String)"98", (Object)this, (Object[])new Object[]{invocation});
            Tr.error((TraceComponent)tc, (String)"lifecycle.interceptor.exception.CWOWB2001E", (Object[])new Object[]{InterceptionType.PRE_PASSIVATE, e});
            throw new UndeclaredThrowableException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @AroundConstruct
    public Object aroundConstruct(InvocationContext invocation) {
        Object rc = null;
        try {
            rc = this.invokeInterceptors(invocation, InterceptionType.AROUND_CONSTRUCT);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.cdi.ejb.impl.EJBCDIInterceptorWrapper", (String)"109", (Object)this, (Object[])new Object[]{invocation});
            Tr.error((TraceComponent)tc, (String)"lifecycle.interceptor.exception.CWOWB2001E", (Object[])new Object[]{InterceptionType.AROUND_CONSTRUCT, e});
            throw new UndeclaredThrowableException((Throwable)e);
        }
        return rc;
    }

    private Object invokeInterceptors(InvocationContext invocation, InterceptionType interceptionType) throws Exception {
        Object rc = null;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName j2eeName = cmd.getJ2EEName();
        String applicationID = j2eeName.getApplication();
        WebSphereEjbServices webSphereEjbServices = AbstractEjbEndpointService._getWebSphereEjbServices(applicationID);
        List interceptors = webSphereEjbServices.getInterceptors(j2eeName, invocation.getMethod(), interceptionType);
        InterceptorChain chain = new InterceptorChain(interceptionType, invocation, interceptors, this.beanManager, this.activeInterceptors);
        rc = chain.proceed();
        return rc;
    }
}

