/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpUtils {
    static final long serialVersionUID = -3730018647898566882L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public HttpPost createHttpPostMethod(String url, List<NameValuePair> commonHeaders) {
        if (url == null) {
            return null;
        }
        HttpPost postMethod = new HttpPost(url);
        this.addHeadersToHttpObject((HttpRequestBase)postMethod, commonHeaders);
        return postMethod;
    }

    public HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) {
        if (url == null) {
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        this.addHeadersToHttpObject((HttpRequestBase)getMethod, commonHeaders);
        return getMethod;
    }

    void addHeadersToHttpObject(HttpRequestBase requestObject, List<NameValuePair> headers) {
        if (headers == null) {
            return;
        }
        for (NameValuePair nvp : headers) {
            requestObject.addHeader(nvp.getName(), nvp.getValue());
        }
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification) {
        CloseableHttpClient client = null;
        if (url != null && url.startsWith("http:")) {
            client = HttpClientBuilder.create().build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    public HttpClient createHTTPClient(SSLSocketFactory sslSocketFactory, String url, boolean isHostnameVerification, String baUser, @Sensitive String baPassword) {
        CloseableHttpClient client = null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(baUser, baPassword));
        if (url != null && url.toLowerCase().startsWith("http:")) {
            client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        } else {
            SSLConnectionSocketFactory connectionFactory = null;
            connectionFactory = !isHostnameVerification ? new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new AllowAllHostnameVerifier()) : new SSLConnectionSocketFactory(sslSocketFactory, (X509HostnameVerifier)new StrictHostnameVerifier());
            client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory).build();
        }
        return client;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(HttpUtils.class);
    }
}

