/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JavaScriptUtils {
    private static final TraceComponent tc = Tr.register(JavaScriptUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    static final long serialVersionUID = -5137266341465588683L;

    public String getJavaScriptHtmlTagStart() {
        return "<script type=\"text/javascript\" language=\"javascript\">";
    }

    public String getJavaScriptHtmlTagEnd() {
        return "</script>";
    }

    public String getJavaScriptHtmlCookieString(String name, String value) {
        return this.getJavaScriptHtmlCookieString(name, value, null);
    }

    public String getJavaScriptHtmlCookieString(String name, String value, Map<String, String> cookieProperties) {
        return this.createJavaScriptHtmlCookieString(name, value, cookieProperties, true);
    }

    public String getUnencodedJavaScriptHtmlCookieString(String name, String value) {
        return this.getUnencodedJavaScriptHtmlCookieString(name, value, null);
    }

    public String getUnencodedJavaScriptHtmlCookieString(String name, String value, Map<String, String> cookieProperties) {
        return this.createJavaScriptHtmlCookieString(name, value, cookieProperties, false);
    }

    public String getHtmlCookieString(String name, String value) {
        return this.getHtmlCookieString(name, value, null);
    }

    public String getHtmlCookieString(String name, String value, Map<String, String> cookieProperties) {
        return this.createHtmlCookieString(name, value, cookieProperties, true);
    }

    public String getUnencodedHtmlCookieString(String name, String value) {
        return this.getUnencodedHtmlCookieString(name, value, null);
    }

    public String getUnencodedHtmlCookieString(String name, String value, Map<String, String> cookieProperties) {
        return this.createHtmlCookieString(name, value, cookieProperties, false);
    }

    public String getJavaScriptForRedirect(String reqUrlCookieName, String redirectUrl) throws Exception {
        return this.getJavaScriptForRedirect(reqUrlCookieName, redirectUrl, null);
    }

    public String getJavaScriptForRedirect(String reqUrlCookieName, String redirectUrl, Map<String, String> cookieProperties) throws Exception {
        String javascript = this.createJavaScriptForRedirectCookie(reqUrlCookieName, cookieProperties) + "\n";
        javascript = javascript + this.createJavaScriptStringToPerformRedirect(redirectUrl) + "\n";
        return this.wrapInJavascriptHtmlTags(javascript);
    }

    private String createJavaScriptHtmlCookieString(String name, String value, Map<String, String> cookieProperties, boolean htmlEncodeNameAndValue) {
        String result = "document.cookie=\"";
        result = htmlEncodeNameAndValue ? result + this.getHtmlCookieString(name, value, cookieProperties) : result + this.getUnencodedHtmlCookieString(name, value, cookieProperties);
        result = result + "\";";
        return result;
    }

    private String createHtmlCookieString(String name, String value, Map<String, String> cookieProperties, boolean htmlEncodeNameAndValue) {
        if (name == null || name.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cannot create a cookie string because the cookie name [" + name + "] was null or empty."), (Object[])new Object[0]);
            }
            return "";
        }
        String cookieString = this.createHtmlCookiePropertyString(name, value, htmlEncodeNameAndValue);
        cookieString = cookieString + this.createHtmlCookiePropertiesString(cookieProperties);
        return cookieString;
    }

    private String createHtmlCookiePropertiesString(Map<String, String> props) {
        String propertyString = "";
        if (props == null) {
            return propertyString;
        }
        for (Map.Entry<String, String> property : props.entrySet()) {
            String propString = this.createHtmlCookiePropertyString(property.getKey(), property.getValue());
            if (propString == null || propString.isEmpty()) continue;
            propertyString = propertyString + " " + propString;
        }
        return propertyString;
    }

    private String createHtmlCookiePropertyString(String name, String value) {
        return this.createHtmlCookiePropertyString(name, value, true);
    }

    private String createHtmlCookiePropertyString(String name, String value, boolean htmlEncodeNameAndValue) {
        String propertyString;
        if (name == null || name.isEmpty()) {
            return "";
        }
        String string = propertyString = htmlEncodeNameAndValue ? WebUtils.htmlEncode(name) : name;
        if (value != null) {
            propertyString = propertyString + "=" + (htmlEncodeNameAndValue ? WebUtils.htmlEncode(value) : value);
        }
        propertyString = propertyString + ";";
        return propertyString;
    }

    private String wrapInJavascriptHtmlTags(String javascript) {
        return this.getJavaScriptHtmlTagStart() + "\n" + javascript + "\n" + this.getJavaScriptHtmlTagEnd();
    }

    private String createJavaScriptForRedirectCookie(String cookieName, Map<String, String> cookieProperties) {
        if (cookieName == null || cookieName.isEmpty()) {
            return "";
        }
        String jsLocationVarName = "loc";
        String result = "var " + jsLocationVarName + "=window.location.href;\n";
        result = result + "document.cookie=\"" + this.createHtmlCookiePropertyString(WebUtils.htmlEncode(cookieName), "\"+encodeURI(" + jsLocationVarName + ")+\"", false);
        result = cookieProperties == null ? result + this.createHtmlCookiePropertiesString(this.getDefaultCookieProperties()) : result + this.createHtmlCookiePropertiesString(cookieProperties);
        result = result + "\";";
        return result;
    }

    private Map<String, String> getDefaultCookieProperties() {
        HashMap<String, String> cookieProperties = new HashMap<String, String>();
        cookieProperties.put("path", "/");
        WebAppSecurityConfig webAppSecurityConfig = this.getWebAppSecurityConfig();
        if (webAppSecurityConfig != null && webAppSecurityConfig.getSSORequiresSSL()) {
            cookieProperties.put("secure", null);
        }
        return cookieProperties;
    }

    private String createJavaScriptStringToPerformRedirect(String redirectUrl) throws Exception {
        if (!WebUtils.validateUriFormat(redirectUrl)) {
            throw new Exception(Tr.formatMessage((TraceComponent)tc, (String)"JAVASCRIPT_REDIRECT_URL_NOT_VALID", (Object[])new Object[]{redirectUrl}));
        }
        return "window.location.replace(\"" + WebUtils.htmlEncode(redirectUrl) + "\");";
    }

    WebAppSecurityConfig getWebAppSecurityConfig() {
        return WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
    }
}

