/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.sql.Driver;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class JDBCDrivers {
    private static final TraceComponent tc = Tr.register(JDBCDrivers.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final int DATA_SOURCE = 0;
    public static final int CONNECTION_POOL_DATA_SOURCE = 1;
    public static final int XA_DATA_SOURCE = 2;
    public static final int NUM_DATA_SOURCE_INTERFACES = 3;
    private static final Map<String, String[]> classNamesByKey = new LinkedHashMap<String, String[]>();
    private static final Map<String, String[]> classNamesByPID = new HashMap<String, String[]>();
    static final SecureAction priv;

    private static final boolean contains(Collection<String> list, String value) {
        for (String item : list) {
            if (!item.contains(value)) continue;
            return true;
        }
        return false;
    }

    static String getConnectionPoolDataSourceClassName(Collection<String> fileNames) {
        for (Map.Entry<String, String[]> entry : classNamesByKey.entrySet()) {
            if (!JDBCDrivers.contains(fileNames, entry.getKey())) continue;
            String[] classNames = entry.getValue();
            return classNames == null ? null : classNames[1];
        }
        return null;
    }

    static String getConnectionPoolDataSourceClassName(String vendorPropertiesPID) {
        String[] classNames = classNamesByPID.get(vendorPropertiesPID);
        return classNames == null ? null : classNames[1];
    }

    static String getDataSourceClassName(Collection<String> fileNames) {
        for (Map.Entry<String, String[]> entry : classNamesByKey.entrySet()) {
            if (!JDBCDrivers.contains(fileNames, entry.getKey())) continue;
            String[] classNames = entry.getValue();
            return classNames == null ? null : classNames[0];
        }
        return null;
    }

    static String getDataSourceClassName(String vendorPropertiesPID) {
        String[] classNames = classNamesByPID.get(vendorPropertiesPID);
        return classNames == null ? null : classNames[0];
    }

    static String getXADataSourceClassName(Collection<String> fileNames) {
        for (Map.Entry<String, String[]> entry : classNamesByKey.entrySet()) {
            if (!JDBCDrivers.contains(fileNames, entry.getKey())) continue;
            String[] classNames = entry.getValue();
            return classNames == null ? null : classNames[2];
        }
        return null;
    }

    static String getXADataSourceClassName(String vendorPropertiesPID) {
        String[] classNames = classNamesByPID.get(vendorPropertiesPID);
        return classNames == null ? null : classNames[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractMap.SimpleEntry<Integer, String> inferDataSourceClassFromDriver(ClassLoader loader, Set<String> searched, int ... types) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"infer from driver", (Object[])new Object[]{loader, Arrays.toString(types)});
        }
        if (loader == null) {
            loader = priv.getContextClassLoader();
        }
        Object[] found = new String[3];
        int preferredType = types[0];
        ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class, loader);
        if (serviceLoader != null) {
            ArrayList<Driver> drivers = new ArrayList<Driver>();
            for (Driver driver : serviceLoader) {
                if (driver.getClass().getName().startsWith("sun.")) continue;
                drivers.add(driver);
            }
            Iterator<Driver> it = drivers.iterator();
            block10: while (found[preferredType] == null && it.hasNext()) {
                int i;
                Driver driver;
                driver = it.next();
                String driverClassName = driver.getClass().getName();
                String driverPackage = null;
                int lastDot = driverClassName.lastIndexOf(46);
                if (lastDot > 0) {
                    int dot = driverClassName.lastIndexOf(46, lastDot - 1);
                    dot = dot <= 10 ? lastDot : dot;
                    driverPackage = driverClassName.substring(0, dot);
                    searched.add(driverPackage);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("infer from " + driverClassName), (Object[])new Object[]{driverPackage});
                    }
                    Iterator<String[]> c = classNamesByKey.values().iterator();
                    while (found[preferredType] == null && c.hasNext()) {
                        String[] classNames = c.next();
                        for (int t = 0; t < types.length && found[preferredType] == null; ++t) {
                            int type = types[t];
                            if (found[type] != null || classNames[type] == null || !classNames[type].startsWith(driverPackage)) continue;
                            try {
                                loader.loadClass(classNames[type]);
                                found[type] = classNames[type];
                                if (!trace || !tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("found type " + type + ": " + classNames[type]), (Object[])new Object[0]);
                                continue;
                            }
                            catch (ClassNotFoundException x) {
                                if (!trace || !tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)(classNames[type] + " not found on " + loader), (Object[])new Object[0]);
                            }
                        }
                    }
                }
                if (found[preferredType] == null) {
                    for (int type : types) {
                        if (type == 0 && found[type] == null) {
                            found[type] = JDBCDrivers.tryToLoad(DataSource.class, loader, driverClassName.replace("Driver", "DataSource"));
                            continue;
                        }
                        if (type == 1 && found[type] == null) {
                            found[type] = JDBCDrivers.tryToLoad(ConnectionPoolDataSource.class, loader, driverClassName.replace("Driver", "ConnectionPoolDataSource"), driverClassName.replace("Driver", "DataSource"));
                            continue;
                        }
                        if (type != 2 || found[type] != null) continue;
                        found[type] = JDBCDrivers.tryToLoad(XADataSource.class, loader, driverClassName.replace("Driver", "XADataSource"), driverClassName.replace("Driver", "DataSource"));
                    }
                }
                if (found[preferredType] != null || driverPackage == null) continue;
                String driverFile = loader.getResource(driverClassName.replace('.', '/') + ".class").getFile();
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Driver impl file", (Object[])new Object[]{driverFile});
                }
                if ((i = driverFile.indexOf(33)) <= 0) continue;
                try {
                    driverPackage = driverPackage.replace('.', '/');
                    int start = driverFile.startsWith("file:") ? 5 : 0;
                    String jarFile = driverFile.substring(start, i);
                    ZipInputStream zin = new ZipInputStream(new FileInputStream(jarFile));
                    block14: while (true) {
                        ZipEntry entry;
                        while (found[preferredType] == null && (entry = zin.getNextEntry()) != null) {
                            String name = entry.getName();
                            if (!name.contains(driverPackage) || !name.contains("DataSource") || !name.endsWith(".class")) continue;
                            name = name.substring(name.indexOf(driverPackage), name.lastIndexOf(46)).replace('/', '.');
                            try {
                                Class<?> c = loader.loadClass(name);
                                if (CommonDataSource.class.isAssignableFrom(c)) {
                                    if (trace && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("checking " + name), (Object[])new Object[0]);
                                    }
                                    if (found[0] == null && DataSource.class.isAssignableFrom(c)) {
                                        found[0] = name;
                                    }
                                    if (found[1] == null && ConnectionPoolDataSource.class.isAssignableFrom(c)) {
                                        found[1] = name;
                                    }
                                    if (found[2] != null || !XADataSource.class.isAssignableFrom(c)) continue block14;
                                    found[2] = name;
                                    continue block14;
                                }
                                if (!trace || !tc.isDebugEnabled()) continue block14;
                                Tr.debug((TraceComponent)tc, (String)(name + " not a data source"), (Object[])new Object[0]);
                                continue block14;
                            }
                            catch (ClassNotFoundException x) {
                                if (!trace || !tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)(name + " not found on " + loader), (Object[])new Object[0]);
                            }
                        }
                        continue block10;
                        {
                            continue block14;
                            break;
                        }
                        break;
                    }
                    finally {
                        zin.close();
                    }
                }
                catch (IOException x) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Error reading JDBC driver binary", (Object[])new Object[]{AdapterUtil.stackTraceToString(x)});
                }
            }
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"found data sources", (Object[])found);
        }
        for (int type : types) {
            if (found[type] == null) continue;
            return new AbstractMap.SimpleEntry<Integer, Object>(type, found[type]);
        }
        return null;
    }

    private static String tryToLoad(Class<?> type, ClassLoader loader, String ... classNames) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        for (String className : classNames) {
            try {
                Class<?> c = loader.loadClass(className);
                boolean isInstance = type.isAssignableFrom(c);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(className + " is " + (isInstance ? "" : "not ") + "an instance of " + type.getName()), (Object[])new Object[0]);
                }
                if (!type.isAssignableFrom(c)) continue;
                return className;
            }
            catch (ClassNotFoundException x) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(className + " not found on " + loader), (Object[])new Object[0]);
            }
        }
        return null;
    }

    static {
        String[] classes = new String[]{"com.ibm.db2.jcc.DB2DataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource", "com.ibm.db2.jcc.DB2XADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.db2.jcc", classes);
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.informix.jcc", classes);
        classNamesByKey.put("DB2JCC", classes);
        classes = new String[]{"oracle.ucp.jdbc.PoolDataSourceImpl", null, "oracle.ucp.jdbc.PoolXADataSourceImpl"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.oracle.ucp", classes);
        classNamesByKey.put("UCP.JAR", classes);
        classes = new String[]{"oracle.jdbc.pool.OracleDataSource", "oracle.jdbc.pool.OracleConnectionPoolDataSource", "oracle.jdbc.xa.client.OracleXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.oracle", classes);
        classNamesByKey.put("OJDBC", classes);
        classes = new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDataSource", "com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.microsoft.sqlserver", classes);
        classNamesByKey.put("MSSQL-JDBC", classes);
        classNamesByKey.put("SQLJDBC", classes);
        classes = new String[]{"com.informix.jdbcx.IfxDataSource", "com.informix.jdbcx.IfxConnectionPoolDataSource", "com.informix.jdbcx.IfxXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.informix", classes);
        classNamesByKey.put("IFXJDBC", classes);
        classes = new String[]{"org.apache.derby.jdbc.ClientDataSource40", "org.apache.derby.jdbc.ClientConnectionPoolDataSource40", "org.apache.derby.jdbc.ClientXADataSource40"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.derby.client", classes);
        classNamesByKey.put("DERBYCLIENT.JAR", classes);
        classes = new String[]{"org.apache.derby.jdbc.EmbeddedDataSource40", "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource40", "org.apache.derby.jdbc.EmbeddedXADataSource40"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.derby.embedded", classes);
        classNamesByKey.put("DERBY", classes);
        classes = new String[]{"com.ibm.as400.access.AS400JDBCDataSource", "com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.as400.access.AS400JDBCXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.db2.i.toolbox", classes);
        classNamesByKey.put("JT400.JAR", classes);
        classes = new String[]{"com.ibm.db2.jdbc.app.UDBDataSource", "com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.db2.jdbc.app.UDBXADataSource"};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.db2.i.native", classes);
        classNamesByKey.put("DB2_CLASSES", classes);
        String className = "org.mariadb.jdbc.MySQLDataSource";
        classes = new String[]{className, className, className};
        classNamesByKey.put("MARIADB-JAVA-CLIENT", classes);
        classes = new String[]{"com.mysql.jdbc.jdbc2.optional.MysqlDataSource", "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource", "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource"};
        classNamesByKey.put("MYSQL-CONNECTOR-JAVA-2", classes);
        classNamesByKey.put("MYSQL-CONNECTOR-JAVA-3", classes);
        classNamesByKey.put("MYSQL-CONNECTOR-JAVA-5", classes);
        classes = new String[]{"com.mysql.cj.jdbc.MysqlDataSource", "com.mysql.cj.jdbc.MysqlConnectionPoolDataSource", "com.mysql.cj.jdbc.MysqlXADataSource"};
        classNamesByKey.put("MYSQL-CONNECTOR-JAVA-", classes);
        classes = new String[]{"com.sybase.jdbc4.jdbc.SybDataSource", "com.sybase.jdbc4.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc4.jdbc.SybXADataSource"};
        classNamesByKey.put("JCONN4", classes);
        classes = new String[]{"com.sybase.jdbc3.jdbc.SybDataSource", "com.sybase.jdbc3.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc3.jdbc.SybXADataSource"};
        classNamesByKey.put("JCONN3", classes);
        classes = new String[]{"com.sybase.jdbc2.jdbc.SybDataSource", "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc2.jdbc.SybXADataSource"};
        classNamesByKey.put("JCONN2", classes);
        classes = new String[]{"solid.jdbc.SolidDataSource", "solid.jdbc.SolidConnectionPoolDataSource", "solid.jdbc.xa.SolidXADataSource"};
        classNamesByKey.put("SOLIDDRIVER", classes);
        className = "com.ddtek.jdbcx.sqlserver.SQLServerDataSource";
        classes = new String[]{className, className, className};
        classNamesByPID.put("com.ibm.ws.jdbc.dataSource.properties.datadirect.sqlserver", classes);
        classNamesByKey.put("SQLSERVER.JAR", classes);
        className = "com.ddtek.jdbcx.oracle.OracleDataSource";
        classes = new String[]{className, className, className};
        classNamesByKey.put("ORACLE.JAR", classes);
        className = "com.ddtek.jdbcx.sequelink.SequeLinkDataSource";
        classes = new String[]{className, className, className};
        classNamesByKey.put("SLJC.JAR", classes);
        classes = new String[]{"org.postgresql.ds.PGSimpleDataSource", "org.postgresql.ds.PGConnectionPoolDataSource", "org.postgresql.xa.PGXADataSource"};
        classNamesByKey.put("POSTGRESQL", classes);
        className = "org.h2.jdbcx.JdbcDataSource";
        classes = new String[]{className, className, className};
        classNamesByKey.put("H2-", classes);
        priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    }
}

