/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance11.cdi;

import com.ibm.tx.jta.cdi.interceptors.TransactionalInterceptor;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.microprofile.faulttolerance11.cdi.AnnotatedTypeWrapper;
import com.ibm.ws.microprofile.faulttolerance11.cdi.FaultTolerance;
import com.ibm.ws.microprofile.faulttolerance11.cdi.FaultToleranceInterceptor;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.AsynchronousConfig;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.BulkheadConfig;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.CircuitBreakerConfig;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.FTGlobalConfig;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.FallbackConfig;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.RetryConfig;
import com.ibm.ws.microprofile.faulttolerance11.cdi.config.TimeoutConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={WebSphereCDIExtension.class}, immediate=true)
public class FaultToleranceCDIExtension
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(FaultToleranceCDIExtension.class);
    private static final String shuffleInterceptorsPropertyName = "com.ibm.ws.microprofile.faulttolerance.before.transactional";
    static final long serialVersionUID = 6173013106377459674L;

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        AnnotatedType bindingType = beanManager.createAnnotatedType(FaultTolerance.class);
        beforeBeanDiscovery.addInterceptorBinding(bindingType);
        AnnotatedType interceptorType = beanManager.createAnnotatedType(FaultToleranceInterceptor.class);
        beforeBeanDiscovery.addAnnotatedType(interceptorType, interceptorType != null ? interceptorType.getClass().getName() + ": " + interceptorType.getClass().hashCode() : "");
        AnnotatedType executorCleanup = beanManager.createAnnotatedType(FaultToleranceInterceptor.ExecutorCleanup.class);
        beforeBeanDiscovery.addAnnotatedType(executorCleanup, executorCleanup != null ? executorCleanup.getClass().getName() + ": " + executorCleanup.getClass().hashCode() : "");
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Asynchronous.class, Fallback.class, Timeout.class, CircuitBreaker.class, Retry.class, Bulkhead.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) {
        HashSet interceptedMethods = new HashSet();
        boolean interceptedClass = false;
        AsynchronousConfig classLevelAsync = null;
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Class clazz = processAnnotatedType.getAnnotatedType().getJavaClass();
        Set annotations = annotatedType.getAnnotations();
        for (Annotation annotation : annotations) {
            if (!FTGlobalConfig.ALL_ANNOTATIONS.contains(annotation.annotationType())) continue;
            if (FTGlobalConfig.isAnnotationEnabled(annotation, clazz)) {
                interceptedClass = true;
                if (annotation.annotationType() == Asynchronous.class) {
                    AsynchronousConfig asynchronousConfig = new AsynchronousConfig(clazz, (Asynchronous)annotation);
                    asynchronousConfig.validate();
                    classLevelAsync = asynchronousConfig;
                    continue;
                }
                if (annotation.annotationType() == Retry.class) {
                    RetryConfig retry = new RetryConfig(clazz, (Retry)annotation);
                    retry.validate();
                    continue;
                }
                if (annotation.annotationType() == Timeout.class) {
                    TimeoutConfig timeout = new TimeoutConfig(clazz, (Timeout)annotation);
                    timeout.validate();
                    continue;
                }
                if (annotation.annotationType() == CircuitBreaker.class) {
                    CircuitBreakerConfig circuitBreaker = new CircuitBreakerConfig(clazz, (CircuitBreaker)annotation);
                    circuitBreaker.validate();
                    continue;
                }
                if (annotation.annotationType() != Bulkhead.class) continue;
                BulkheadConfig bulkhead = new BulkheadConfig(clazz, (Bulkhead)annotation);
                bulkhead.validate();
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Annotation {0} on {1} was disabled and will be ignored", (Object[])new Object[]{annotation.annotationType().getSimpleName(), clazz.getCanonicalName()});
        }
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod method : methods) {
            boolean needsIntercepting = this.processMethod(method, clazz, classLevelAsync);
            if (!needsIntercepting) continue;
            interceptedMethods.add(method);
        }
        if (interceptedClass || !interceptedMethods.isEmpty()) {
            this.addFaultToleranceAnnotation(beanManager, processAnnotatedType, interceptedClass, interceptedMethods);
        }
    }

    private <T> boolean processMethod(AnnotatedMethod<T> method, Class<?> clazz, Asynchronous classLevelAsync) {
        Method javaMethod = method.getJavaMember();
        if (javaMethod.isBridge()) {
            return false;
        }
        if (classLevelAsync != null) {
            AsynchronousConfig asynchronous = new AsynchronousConfig(javaMethod, clazz, classLevelAsync);
            asynchronous.validate();
        }
        boolean needsIntercepting = false;
        Set annotations = method.getAnnotations();
        for (Annotation annotation : annotations) {
            if (!FTGlobalConfig.ALL_ANNOTATIONS.contains(annotation.annotationType())) continue;
            if (FTGlobalConfig.isAnnotationEnabled(annotation, clazz, method.getJavaMember())) {
                needsIntercepting = true;
                if (annotation.annotationType() == Asynchronous.class) {
                    AsynchronousConfig asynchronous = new AsynchronousConfig(javaMethod, clazz, (Asynchronous)annotation);
                    asynchronous.validate();
                    continue;
                }
                if (annotation.annotationType() == Fallback.class) {
                    FallbackConfig fallback = new FallbackConfig(javaMethod, clazz, (Fallback)annotation);
                    fallback.validate();
                    continue;
                }
                if (annotation.annotationType() == Retry.class) {
                    RetryConfig retry = new RetryConfig(javaMethod, clazz, (Retry)annotation);
                    retry.validate();
                    continue;
                }
                if (annotation.annotationType() == Timeout.class) {
                    TimeoutConfig timeout = new TimeoutConfig(javaMethod, clazz, (Timeout)annotation);
                    timeout.validate();
                    continue;
                }
                if (annotation.annotationType() == CircuitBreaker.class) {
                    CircuitBreakerConfig circuitBreaker = new CircuitBreakerConfig(javaMethod, clazz, (CircuitBreaker)annotation);
                    circuitBreaker.validate();
                    continue;
                }
                if (annotation.annotationType() != Bulkhead.class) continue;
                BulkheadConfig bulkhead = new BulkheadConfig(javaMethod, clazz, (Bulkhead)annotation);
                bulkhead.validate();
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Annotation {0} on {1} was disabled and will be ignored", (Object[])new Object[]{annotation.annotationType().getSimpleName(), clazz.getCanonicalName() + "." + method.getJavaMember().getName()});
        }
        return needsIntercepting;
    }

    private <T> void addFaultToleranceAnnotation(BeanManager beanManager, ProcessAnnotatedType<T> processAnnotatedType, boolean interceptedClass, Set<AnnotatedMethod<?>> interceptedMethods) {
        AnnotatedTypeWrapper wrapper = new AnnotatedTypeWrapper(beanManager, processAnnotatedType.getAnnotatedType(), interceptedClass, interceptedMethods);
        processAnnotatedType.setAnnotatedType(wrapper);
    }

    public void afterTypeDiscovery(@Observes AfterTypeDiscovery atd) {
        if (ConfigProvider.getConfig().getOptionalValue(shuffleInterceptorsPropertyName, Boolean.class).orElse(false).booleanValue()) {
            int faultToleranceInterceptorIndex = -1;
            int transactionalInterceptorIndex = -1;
            int interceptorIndex = 0;
            Iterator iterator = atd.getInterceptors().iterator();
            while (iterator.hasNext() && (faultToleranceInterceptorIndex < 0 || transactionalInterceptorIndex < 0)) {
                Class i = (Class)iterator.next();
                if (FaultToleranceInterceptor.class.equals((Object)i)) {
                    faultToleranceInterceptorIndex = interceptorIndex;
                } else if (transactionalInterceptorIndex < 0 && TransactionalInterceptor.class.isAssignableFrom(i)) {
                    transactionalInterceptorIndex = interceptorIndex;
                }
                ++interceptorIndex;
            }
            if (faultToleranceInterceptorIndex >= 0 && transactionalInterceptorIndex >= 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reordering fault tolerance with respect to @Transactional", (Object[])new Object[0]);
                }
                Class c = (Class)atd.getInterceptors().remove(faultToleranceInterceptorIndex);
                atd.getInterceptors().add(transactionalInterceptorIndex, c);
            }
        }
    }
}

