/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.schemagen.internal.DelegatingXMLStreamWriter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class IndentingXMLStreamWriter
extends DelegatingXMLStreamWriter {
    private static final String DEFAULT_INDENT = "    ";
    private static final String LINE_SEPARATOR;
    private final Writer writer;
    private String identString = "    ";
    private int depth = 0;
    private TextElement textElement = TextElement.NONE;
    static final long serialVersionUID = 5699845899267940482L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IndentingXMLStreamWriter(XMLStreamWriter xmlWriter, Writer writer) {
        super(xmlWriter);
        this.writer = writer;
    }

    public void setIndentString(String identString) {
        this.identString = identString;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        super.writeEndDocument();
        this.indent();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.indent();
        super.writeEmptyElement(localName);
        this.textElement = TextElement.NONE;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.indent();
        super.writeEmptyElement(namespaceURI, localName);
        this.textElement = TextElement.NONE;
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.indent();
        super.writeEmptyElement(prefix, localName, namespaceURI);
        this.textElement = TextElement.NONE;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        --this.depth;
        if (this.textElement != TextElement.TEXT) {
            this.indent();
        }
        this.textElement = TextElement.NONE;
        super.writeEndElement();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.indent();
        super.writeStartElement(localName);
        ++this.depth;
        this.textElement = TextElement.START_ELEMENT;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.indent();
        super.writeStartElement(namespaceURI, localName);
        ++this.depth;
        this.textElement = TextElement.START_ELEMENT;
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.indent();
        super.writeStartElement(prefix, localName, namespaceURI);
        ++this.depth;
        this.textElement = TextElement.START_ELEMENT;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        super.writeCharacters(text, start, len);
        if (this.textElement == TextElement.START_ELEMENT) {
            this.textElement = TextElement.TEXT;
        } else if (this.textElement != TextElement.TEXT) {
            this.textElement = TextElement.NONE;
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        super.writeCharacters(text);
        if (this.textElement == TextElement.START_ELEMENT) {
            this.textElement = TextElement.TEXT;
        } else if (this.textElement != TextElement.TEXT) {
            this.textElement = TextElement.NONE;
        }
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        super.writeCData(data);
        this.textElement = TextElement.NONE;
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        super.writeComment(data);
        this.textElement = TextElement.NONE;
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        super.writeProcessingInstruction(target, data);
        this.textElement = TextElement.NONE;
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        super.writeProcessingInstruction(target);
        this.textElement = TextElement.NONE;
    }

    /*
     * WARNING - void declaration
     */
    private void indent() throws XMLStreamException {
        this.flush();
        try {
            this.writeCharacters(" ");
            this.writer.write(LINE_SEPARATOR);
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write(this.identString);
            }
        }
        catch (IOException i) {
            void e;
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.config.schemagen.internal.IndentingXMLStreamWriter", (String)"160", (Object)this, (Object[])new Object[0]);
            throw new XMLStreamException((Throwable)e);
        }
    }

    private static String getLineSeparator() {
        String separator = IndentingXMLStreamWriter.getSystemProperty("line.separator");
        if (separator != null && (separator.equals("\n") || separator.equals("\r") || separator.equals("\r\n"))) {
            return separator;
        }
        return "\n";
    }

    private static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -3534473633455676851L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(name);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IndentingXMLStreamWriter.class);
        LINE_SEPARATOR = IndentingXMLStreamWriter.getLineSeparator();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class TextElement
    extends Enum<TextElement> {
        public static final /* enum */ TextElement NONE;
        public static final /* enum */ TextElement START_ELEMENT;
        public static final /* enum */ TextElement TEXT;
        private static final /* synthetic */ TextElement[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static TextElement[] values() {
            return (TextElement[])$VALUES.clone();
        }

        public static TextElement valueOf(String name) {
            return Enum.valueOf(TextElement.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(TextElement.class);
            NONE = new TextElement();
            START_ELEMENT = new TextElement();
            TEXT = new TextElement();
            $VALUES = new TextElement[]{NONE, START_ELEMENT, TEXT};
        }
    }
}

