/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.schemagen.internal.AppInfoEntry;
import com.ibm.ws.config.schemagen.internal.SchemaGenConstants;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinitionImpl;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinition;
import com.ibm.ws.config.xml.internal.metatype.ExtendedObjectClassDefinitionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class TypeBuilder {
    private static final TraceComponent tc = Tr.register(TypeBuilder.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final boolean ignoreErrors;
    private final Set<String> ignoredPids;
    private final Locale locale;
    private final Map<String, OCDType> ocdTypeMap;
    private final Map<String, OCDTypeReference> pidTypeMap;
    private final Map<String, OCDTypeReference> internalPidTypeMap;
    private final Map<String, List<OCDType>> aliasMap;
    private final Set<OCDType> children = new HashSet<OCDType>();
    private final boolean isRuntime;
    static final long serialVersionUID = 4441786150280398825L;

    public TypeBuilder(boolean ignoreErrors, Set<String> ignoredPids, Locale locale, boolean isRuntime) {
        this.ignoreErrors = ignoreErrors;
        this.ignoredPids = ignoredPids;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.ocdTypeMap = new LinkedHashMap<String, OCDType>();
        this.pidTypeMap = new LinkedHashMap<String, OCDTypeReference>();
        this.internalPidTypeMap = new LinkedHashMap<String, OCDTypeReference>();
        this.aliasMap = new LinkedHashMap<String, List<OCDType>>();
        this.isRuntime = isRuntime;
    }

    private void buildTypes(MetaTypeInformation metatype, String[] pids, boolean factoryPids) {
        if (pids == null) {
            return;
        }
        for (String pid : pids) {
            OCDTypeReference existingType;
            boolean isIBMFinalSetForIdField;
            if (this.ignoredPids != null && this.ignoredPids.contains(pid)) continue;
            ObjectClassDefinition ocd = metatype.getObjectClassDefinition(pid, this.locale.toString());
            OCDType type = null;
            if (this.ocdTypeMap.containsKey(pid)) continue;
            Bundle bundle = metatype.getBundle();
            String bundleLocation = bundle != null ? bundle.getLocation() : null;
            ExtendedObjectClassDefinitionImpl extOCD = ExtendedObjectClassDefinitionImpl.newExtendedObjectClassDefinition(ocd, bundleLocation);
            type = new OCDType(metatype, pid, extOCD);
            this.ocdTypeMap.put(pid, type);
            String aliasName = extOCD.getAlias();
            if (aliasName != null) {
                this.addAlias(aliasName, type);
            }
            this.processExtensions(pid, type);
            if (factoryPids) {
                type.setHasFactoryReference(true);
            }
            if (isIBMFinalSetForIdField = this.processAttributes(ocd)) {
                type.setHasFactoryReference(false);
                type.setHasIBMFinalWithDefault(true);
            }
            if ("internal".equalsIgnoreCase(ocd.getName())) {
                existingType = this.pidTypeMap.get(pid);
                if (existingType == null) {
                    this.internalPidTypeMap.put(pid, new OCDTypeReference(type, factoryPids));
                    continue;
                }
                this.error("schemagen.duplicate.pid", pid);
                continue;
            }
            existingType = this.pidTypeMap.get(pid);
            if (existingType == null) {
                this.pidTypeMap.put(pid, new OCDTypeReference(type, factoryPids));
                continue;
            }
            this.error("schemagen.duplicate.pid", pid);
        }
    }

    private void processExtensions(String pid, OCDType type) {
        String localization;
        ExtendedObjectClassDefinition ocd = type.getObjectClassDefinition();
        type.setSupportsExtensions(ocd.supportsExtensions());
        String parentPid = ocd.getParentPID();
        if (parentPid != null) {
            if (type.getAliasName() == null && type.getChildAliasName() == null) {
                this.error("schemagen.alias.required", pid);
                return;
            }
            if (type.isInternal()) {
                return;
            }
            type.setParentPids(SchemaGenConstants.COMMA_PATTERN.split(parentPid));
            this.children.add(type);
        }
        if ((localization = ocd.getLocalization()) != null) {
            ResourceBundle resourceBundle = this.getResourceBundle(type.metatype.getBundle(), localization);
            type.setResourceBundle(resourceBundle);
        }
    }

    private void error(String message, Object ... args) {
        if (!this.isRuntime) {
            Tr.error((TraceComponent)tc, (String)message, (Object[])args);
        }
        if (!this.ignoreErrors) {
            throw new RuntimeException("Error during schema generation");
        }
    }

    public void buildStart() {
    }

    public void build(MetaTypeInformation metatype) {
        this.buildTypes(metatype, metatype.getPids(), false);
        this.buildTypes(metatype, metatype.getFactoryPids(), true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Bundle mb = metatype.getBundle();
            if (mb != null) {
                Tr.debug((TraceComponent)tc, (String)("Currently processing metatype from bundle " + mb.getSymbolicName() + "_" + mb.getVersion()), (Object[])new Object[0]);
            }
            Tr.debug((TraceComponent)tc, (String)("Pids processed: " + Arrays.toString(metatype.getPids())), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Factory Pids processed: " + Arrays.toString(metatype.getFactoryPids())), (Object[])new Object[0]);
        }
    }

    public void buildComplete() {
        this.processExtends();
        this.buildNestedTypeInfo();
        this.processPidReferences();
    }

    private void processExtends() {
        for (OCDType type : this.ocdTypeMap.values()) {
            OCDType parentType;
            String parentPid = type.getObjectClassDefinition().getExtends();
            if (parentPid == null || (parentType = this.ocdTypeMap.get(parentPid)) == null) continue;
            parentType.addExtension(type);
        }
    }

    private void buildNestedTypeInfo() {
        for (OCDType child : this.children) {
            if (!child.getHasFactoryReference()) {
                this.error("schemagen.invalid.child", child.getObjectClassDefinition().getID());
                continue;
            }
            String[] parentPids = child.getParentPids();
            if (parentPids.length == 1 && parentPids[0].length() == 0) {
                for (Map.Entry entry : this.pidTypeMap.entrySet()) {
                    OCDTypeReference ocdReference = (OCDTypeReference)entry.getValue();
                    OCDType parent = ocdReference.getOCDType();
                    if (!parent.getSupportsExtensions()) continue;
                    parent.addChild(child);
                }
                continue;
            }
            for (String parentPid : parentPids) {
                OCDTypeReference ocdReference = this.pidTypeMap.get(parentPid);
                if (ocdReference == null && (ocdReference = this.internalPidTypeMap.get(parentPid)) == null) {
                    this.error("schemagen.invalid.parent", parentPid, child.getObjectClassDefinition().getID());
                    continue;
                }
                OCDType parent = ocdReference.getOCDType();
                if (!parent.getSupportsExtensions()) {
                    this.error("schemagen.noextensions", parentPid, child.getObjectClassDefinition().getID());
                }
                parent.addChild(child);
            }
        }
    }

    private void processPidReferences() {
        for (Map.Entry<String, OCDTypeReference> pidEntry : this.pidTypeMap.entrySet()) {
            ExtendedObjectClassDefinition ocd = pidEntry.getValue().getOCDType().getObjectClassDefinition();
            for (Map.Entry<String, ExtendedAttributeDefinition> attributeEntry : ocd.getAttributeMap().entrySet()) {
                ExtendedAttributeDefinition attributeDef = attributeEntry.getValue();
                if (attributeDef.getType() != 1001 && (attributeDef.getType() != 1 || attributeDef.getUIReference() == null)) continue;
                ArrayList<String> referencePids = new ArrayList<String>();
                if (attributeDef.getUIReference() != null) {
                    referencePids.addAll(attributeDef.getUIReference());
                } else if (attributeDef.getReferencePid() != null) {
                    referencePids.add(attributeDef.getReferencePid());
                } else if (attributeDef.getService() != null) {
                    referencePids.addAll(this.getServiceMatches(attributeDef.getService()));
                } else {
                    this.error("schemagen.bad.reference.extension", attributeDef.getID());
                    continue;
                }
                for (String referencePid : referencePids) {
                    OCDTypeReference ocdReference = this.pidTypeMap.get(referencePid);
                    if (ocdReference == null && (ocdReference = this.internalPidTypeMap.get(referencePid)) == null) {
                        this.error("schemagen.bad.reference.pid", referencePid);
                        continue;
                    }
                    ocdReference.getOCDType().setPidReferenced(true);
                }
            }
        }
    }

    public boolean processAttributes(ObjectClassDefinition ocd) {
        AttributeDefinition[] attributeList;
        boolean response = false;
        for (AttributeDefinition ad : attributeList = ocd.getAttributeDefinitions(-1)) {
            String[] defaultValue = ad.getDefaultValue();
            ExtendedAttributeDefinitionImpl ead = new ExtendedAttributeDefinitionImpl(ad);
            if (!ad.getID().equalsIgnoreCase("id") || !ead.isFinal() || defaultValue == null || defaultValue.length <= 0) continue;
            response = true;
        }
        return response;
    }

    protected Collection<String> getServiceMatches(String service) {
        if (service == null) {
            return Collections.emptyList();
        }
        ArrayList<String> pids = new ArrayList<String>();
        for (OCDType ocd : this.getTypes()) {
            List<String> objectClass = ocd.getObjectClassDefinition().getObjectClass();
            if (objectClass == null || !objectClass.contains(service)) continue;
            pids.add(ocd.pid);
        }
        return pids;
    }

    private void addAlias(String aliasName, OCDType type) {
        List<OCDType> aliases = this.aliasMap.get(aliasName);
        if (aliases == null) {
            aliases = new ArrayList<OCDType>();
            this.aliasMap.put(aliasName, aliases);
        }
        aliases.add(type);
    }

    public Collection<OCDType> getTypes() {
        return this.ocdTypeMap.values();
    }

    public Map<String, OCDTypeReference> getPidTypeMap() {
        return this.pidTypeMap;
    }

    public Map<String, OCDTypeReference> getInternalPidTypeMap() {
        return this.internalPidTypeMap;
    }

    public OCDTypeReference getPidType(String pid) {
        return this.pidTypeMap.get(pid);
    }

    public OCDTypeReference getInternalPidType(String pid) {
        return this.internalPidTypeMap.get(pid);
    }

    public Map<String, List<OCDType>> getAliasMap() {
        return this.aliasMap;
    }

    private URL findResourceBundle(Bundle bundle, String baseName, String locale) {
        int pos;
        String lookupName = locale != null && locale.length() > 0 ? baseName + "_" + locale + ".properties" : baseName + ".properties";
        URL rbName = bundle.getEntry(lookupName);
        if (rbName == null && locale != null && (pos = locale.lastIndexOf(95)) != -1) {
            rbName = this.findResourceBundle(bundle, baseName, locale.substring(0, pos));
        }
        return rbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={IOException.class})
    private ResourceBundle getResourceBundle(Bundle bundle, String baseName) {
        URL rbName = this.findResourceBundle(bundle, baseName, this.locale.toString());
        if (rbName == null) {
            rbName = this.findResourceBundle(bundle, baseName, null);
        }
        if (rbName != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Loading resource bundle from " + rbName), (Object[])new Object[0]);
            }
            InputStream in = null;
            in = rbName.openStream();
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(in);
            if (in == null) return propertyResourceBundle;
            try {
                in.close();
                return propertyResourceBundle;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.schemagen.internal.TypeBuilder", (String)"396", (Object)this, (Object[])new Object[]{bundle, baseName});
            }
            return propertyResourceBundle;
            catch (IOException e) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getResourceBundle(). Exception while loading resource bundle. Message = " + e.getMessage()), (Object[])new Object[0]);
                    }
                    if (in == null) return null;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.schemagen.internal.TypeBuilder", (String)"396", (Object)this, (Object[])new Object[]{bundle, baseName});
                    }
                    throw throwable;
                }
                try {
                    in.close();
                    return null;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.config.schemagen.internal.TypeBuilder", (String)"396", (Object)this, (Object[])new Object[]{bundle, baseName});
                }
                return null;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return null;
        Tr.debug((TraceComponent)tc, (String)("Resource bundle not found for " + baseName), (Object[])new Object[0]);
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class OCDType {
        private final MetaTypeInformation metatype;
        private final ExtendedObjectClassDefinition ocd;
        private boolean hasFactoryReference;
        private boolean supportsExtensions;
        private String[] parentPids;
        private boolean pidReferenced;
        private Set<OCDType> children;
        private Set<OCDType> extensions;
        private List<AppInfoEntry> appInfo;
        private Set<String> groups;
        private ResourceBundle resourceBundle;
        private final String pid;
        private final List<String> excludedChildren;
        private boolean hasIBMFinalWithDefault;
        static final long serialVersionUID = -941164942245878518L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OCDType(MetaTypeInformation metatype, String pid, ExtendedObjectClassDefinition ocd) {
            this.metatype = metatype;
            this.ocd = ocd;
            this.pid = pid;
            this.excludedChildren = new ArrayList<String>();
            String excludedChildrenRaw = ocd.getExcludedChildren();
            if (excludedChildrenRaw != null) {
                for (String childPid : excludedChildrenRaw.split(",")) {
                    if (childPid == null) continue;
                    this.excludedChildren.add(childPid.trim());
                }
            }
        }

        public void addExtension(OCDType type) {
            if (this.extensions == null) {
                this.extensions = new LinkedHashSet<OCDType>();
            }
            this.extensions.add(type);
        }

        public Set<OCDType> getExtensions() {
            return this.extensions == null ? Collections.emptySet() : this.extensions;
        }

        public boolean isInternal() {
            return "internal".equals(this.ocd.getName());
        }

        public ExtendedObjectClassDefinition getObjectClassDefinition() {
            return this.ocd;
        }

        public MetaTypeInformation getMetaTypeInformation() {
            return this.metatype;
        }

        public boolean getHasFactoryReference() {
            return this.hasFactoryReference;
        }

        public void setHasFactoryReference(boolean hasFactoryReference) {
            this.hasFactoryReference = hasFactoryReference;
        }

        public String getAliasName() {
            return this.ocd.getAlias();
        }

        public String getChildAliasName() {
            return this.ocd.getChildAlias();
        }

        public void setSupportsExtensions(boolean supportsExtensions) {
            this.supportsExtensions = supportsExtensions;
        }

        public boolean getSupportsExtensions() {
            return this.supportsExtensions;
        }

        public void setPidReferenced(boolean pidReferenced) {
            this.pidReferenced = pidReferenced;
        }

        public boolean isPidReferenced() {
            return this.pidReferenced;
        }

        public void setParentPids(String[] parentPids) {
            this.parentPids = parentPids;
        }

        public String[] getParentPids() {
            return this.parentPids;
        }

        public boolean getHasExtraProperties() {
            return this.ocd.hasExtraProperties();
        }

        public String getAction() {
            return this.ocd.getAction();
        }

        public boolean hasParentPids() {
            return this.parentPids != null && this.parentPids.length > 0;
        }

        public boolean getHasIBMFinalWithDefault() {
            return this.hasIBMFinalWithDefault;
        }

        public void setHasIBMFinalWithDefault(boolean hasIBMFinalWithDefault) {
            this.hasIBMFinalWithDefault = hasIBMFinalWithDefault;
        }

        List<String> getExcludedChildren() {
            return this.excludedChildren;
        }

        public void addChild(OCDType type) {
            if (this.children == null) {
                this.children = new LinkedHashSet<OCDType>();
            }
            if (!this.excludedChildren.contains(type.getTypeName())) {
                this.children.add(type);
                if (this.extensions != null) {
                    for (OCDType t : this.extensions) {
                        t.addChild(type);
                    }
                }
            }
        }

        public Collection<OCDType> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children;
        }

        public String getTypeName() {
            return this.pid;
        }

        protected void setResourceBundle(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        private void initAppInfo() {
            if (this.appInfo == null) {
                this.appInfo = new ArrayList<AppInfoEntry>();
                String name = this.ocd.getName();
                if (name != null) {
                    this.appInfo.add(AppInfoEntry.createLabelTag(name, null));
                }
                if (this.ocd.hasExtraProperties()) {
                    this.appInfo.add(AppInfoEntry.createExtraPropertiesTag());
                }
            }
        }

        public void addAppInfoEntry(AppInfoEntry entry) {
            this.initAppInfo();
            this.appInfo.add(entry);
        }

        public AppInfoEntry[] getAppInfoEntries() {
            this.initAppInfo();
            AppInfoEntry[] entries = new AppInfoEntry[this.appInfo.size()];
            return this.appInfo.toArray(entries);
        }

        public void addGroup(String group) {
            if (this.groups == null) {
                this.groups = new LinkedHashSet<String>();
                this.groups.add(group);
                this.addAppInfoEntry(this.createGroupDeclaration(group));
            } else if (!this.groups.contains(group)) {
                this.groups.add(group);
                this.addAppInfoEntry(this.createGroupDeclaration(group));
            }
        }

        private AppInfoEntry createGroupDeclaration(String group) {
            String label = this.getTranslatedText(this.getLabelKeys(group));
            String description = this.getTranslatedText(this.getDescriptionKeys(group));
            return AppInfoEntry.createGroupDeclarationTag(group, label, description);
        }

        public String[] getLabelKeys(String prefix) {
            return new String[]{prefix + "." + this.ocd.getID() + ".name", prefix + ".name"};
        }

        public String[] getDescriptionKeys(String prefix) {
            return new String[]{prefix + "." + this.ocd.getID() + ".description", prefix + ".description"};
        }

        @FFDCIgnore(value={MissingResourceException.class})
        public String getTranslatedText(String ... keys) {
            if (this.resourceBundle == null) {
                return null;
            }
            for (String key : keys) {
                try {
                    return this.resourceBundle.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                }
            }
            if (keys.length == 1) {
                return keys[0];
            }
            return Arrays.toString(keys);
        }

        public int getXsdAny() {
            return this.ocd.getXsdAny();
        }

        public String getExtendsAlias() {
            return this.ocd.getExtendsAlias();
        }

        public boolean isBeta() {
            return this.ocd.isBeta();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OCDType.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class OCDTypeReference {
        private final OCDType ocdType;
        private final boolean isFactoryReference;
        static final long serialVersionUID = 2172307495875050420L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OCDTypeReference(OCDType ocdType, boolean isFactoryReference) {
            this.ocdType = ocdType;
            this.isFactoryReference = isFactoryReference;
        }

        public OCDType getOCDType() {
            return this.ocdType;
        }

        public String getOcdTypeName() {
            return this.ocdType.getTypeName();
        }

        public boolean isFactoryReference() {
            return this.isFactoryReference;
        }

        public boolean isInternal() {
            return this.ocdType.isInternal();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(OCDTypeReference.class);
        }
    }
}

