/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.metatype;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.config.xml.internal.metatype.MetaTypeFactoryImpl;
import com.ibm.ws.config.xml.internal.metatype.WSAttributeDefinitionImpl;
import com.ibm.ws.config.xml.internal.schema.AttributeDefinitionSpecification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.metatype.EquinoxAttributeDefinition;
import org.osgi.service.metatype.AttributeDefinition;

@Trivial
public class ExtendedAttributeDefinitionImpl
implements ExtendedAttributeDefinition {
    private final AttributeDefinition delegate;
    private int cachedType;
    private String group;
    private boolean isFinal;
    private boolean isFlat;
    private boolean isUnique;
    private String referencePid;
    private String service;
    private String serviceFilter;
    private String rename;
    private String requiresFalse;
    private String requiresTrue;
    private String uniqueCategory;
    private String variable;
    private String copyOf;
    private boolean resolveVariables = true;
    private List<String> uiReference;
    private boolean beta;

    public ExtendedAttributeDefinitionImpl(AttributeDefinition ad) {
        this.delegate = ad;
        this.cachedType = ad.getType();
        if (ad instanceof EquinoxAttributeDefinition) {
            this.initFromEquinoxAD();
        } else if (ad instanceof WSAttributeDefinitionImpl) {
            this.initFromWSAD();
        }
    }

    private void initFromEquinoxAD() {
        EquinoxAttributeDefinition delegate = (EquinoxAttributeDefinition)this.delegate;
        Set supportedExtensions = delegate.getExtensionUris();
        if (supportedExtensions != null && supportedExtensions.contains("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0")) {
            Map extensions = delegate.getExtensionAttributes("http://www.ibm.com/xmlns/appservers/osgi/metatype/v1.0.0");
            String typeStr = (String)extensions.get("type");
            if (typeStr != null) {
                Integer cachedType = MetaTypeFactoryImpl.IBM_TYPES.get(typeStr);
                if (cachedType != null) {
                    this.cachedType = cachedType;
                } else {
                    throw new NullPointerException("Unrecognized ibm type: '" + typeStr + "' in AD " + delegate.getID());
                }
            }
            this.isFinal = extensions.get("final") != null;
            this.isFlat = extensions.get("flat") != null;
            this.copyOf = (String)extensions.get("copyOf");
            this.isUnique = extensions.get("unique") != null;
            this.referencePid = (String)extensions.get("reference");
            this.service = (String)extensions.get("service");
            this.serviceFilter = (String)extensions.get("serviceFilter");
            this.rename = (String)extensions.get("rename");
            this.uniqueCategory = (String)extensions.get("unique");
            this.variable = (String)extensions.get("variable");
            this.beta = "true".equals(extensions.get("beta"));
            String variableResolution = (String)extensions.get("variableSubstitution");
            if (variableResolution != null && "false".equalsIgnoreCase(variableResolution)) {
                this.resolveVariables = false;
            }
        }
        if (supportedExtensions != null && supportedExtensions.contains("http://www.ibm.com/xmlns/appservers/osgi/metatype/ui/v1.0.0")) {
            Map uiExtensions = delegate.getExtensionAttributes("http://www.ibm.com/xmlns/appservers/osgi/metatype/ui/v1.0.0");
            this.group = (String)uiExtensions.get("group");
            this.requiresFalse = (String)uiExtensions.get("requiresFalse");
            this.requiresTrue = (String)uiExtensions.get("requiresTrue");
            if (uiExtensions.get("uiReference") != null) {
                this.uiReference = Arrays.asList(((String)uiExtensions.get("uiReference")).split("[, ]+"));
            }
        }
    }

    private void initFromWSAD() {
        WSAttributeDefinitionImpl delegate = (WSAttributeDefinitionImpl)this.delegate;
        this.isFinal = delegate.isFinal();
        this.isFlat = delegate.isFlat();
        this.copyOf = delegate.getCopyOf();
        this.isUnique = delegate.isUnique();
        this.referencePid = delegate.getReferencePid();
        this.service = delegate.getService();
        this.serviceFilter = delegate.getServiceFilter();
        this.uniqueCategory = delegate.getUnique();
        this.variable = delegate.getVariable();
    }

    public String toString() {
        return super.toString() + '[' + this.delegate.getID() + ']';
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getID() {
        return this.delegate.getID();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public int getCardinality() {
        return this.delegate.getCardinality();
    }

    public int getType() {
        return this.cachedType;
    }

    @Override
    public String getReferencePid() {
        return this.referencePid;
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public String getServiceFilter() {
        return this.serviceFilter;
    }

    @Override
    public boolean isBeta() {
        return this.beta;
    }

    @Override
    public String getCopyOf() {
        return this.copyOf;
    }

    public String[] getOptionValues() {
        return this.delegate.getOptionValues();
    }

    public String[] getOptionLabels() {
        return this.delegate.getOptionLabels();
    }

    public String validate(String value) {
        return this.delegate.validate(value);
    }

    public String[] getDefaultValue() {
        return this.delegate.getDefaultValue();
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isFlat() {
        return this.isFlat;
    }

    @Override
    public String getUniqueCategory() {
        return this.uniqueCategory;
    }

    @Override
    public String getRequiresTrue() {
        return this.requiresTrue;
    }

    @Override
    public String getRequiresFalse() {
        return this.requiresFalse;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public AttributeDefinition getDelegate() {
        return this.delegate;
    }

    @Override
    public String getRename() {
        return this.rename;
    }

    @Override
    public Set<String> getExtensionUris() {
        return this.delegate instanceof EquinoxAttributeDefinition ? ((EquinoxAttributeDefinition)this.delegate).getExtensionUris() : Collections.emptySet();
    }

    @Override
    public Map<String, String> getExtensions(String extensionUri) {
        return this.delegate instanceof EquinoxAttributeDefinition ? ((EquinoxAttributeDefinition)this.delegate).getExtensionAttributes(extensionUri) : Collections.emptyMap();
    }

    @Override
    public String getAttributeName() {
        if (this.delegate instanceof AttributeDefinitionSpecification) {
            return ((AttributeDefinitionSpecification)this.delegate).getAttributeName();
        }
        return this.delegate.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o instanceof ExtendedAttributeDefinitionImpl) {
            return this.delegate == ((ExtendedAttributeDefinitionImpl)o).delegate;
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode() + 1;
    }

    @Override
    public boolean resolveVariables() {
        return this.resolveVariables;
    }

    @Override
    public List<String> getUIReference() {
        return this.uiReference;
    }
}

