/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.EntityMappingsScannerResults;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsDefinition;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IEntityMappings;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScanner;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScannerResults;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.EncapsulatedData;
import com.ibm.ws.jpa.diagnostics.utils.encapsulation.EncapsulatedDataGroup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.persistence.spi.PersistenceUnitInfo;

public class JPAORMDiagnostics {
    private static final TraceComponent tc = Tr.register(JPAORMDiagnostics.class, (String)"JPAORM", (String)"com.ibm.ws.jpa.jpa");
    private static boolean jpaDumpEnabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.ibm.websphere.persistence.enablejpadump");
        }
    });

    public static void writeJPAORMDiagnostics(PersistenceUnitInfo pui, InputStream pxmlIS, PrintWriter out) {
        if (!jpaDumpEnabled || pui == null || out == null) {
            return;
        }
        JPAORMDiagnostics.generateJPAORMDiagnostics(pui, pxmlIS, out);
    }

    public static void writeJPAORMDiagnostics(PersistenceUnitInfo pui, InputStream pxmlIS) {
        block3: {
            block2: {
                if (pui == null) break block2;
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) break block3;
            }
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("##### BEGIN JPA ORM Diagnostics");
        JPAORMDiagnostics.generateJPAORMDiagnostics(pui, pxmlIS, pw);
        pw.println("##### END JPA ORM Diagnostics");
        Tr.debug((TraceComponent)tc, (String)"JPAORMDiagnostics Dump", (Object[])new Object[]{baos.toString()});
    }

    /*
     * WARNING - void declaration
     */
    private static void generateJPAORMDiagnostics(PersistenceUnitInfo pui, InputStream pxmlIS, PrintWriter out) {
        try {
            void var9_16;
            if (pui == null) {
                return;
            }
            PersistenceUnitScannerResults pusr = PersistenceUnitScanner.scanPersistenceUnit(pui);
            String puName = pusr.getPersistenceUnitName();
            List<EntityMappingsScannerResults> clsScanResultsList = pusr.getClassScannerResults();
            List<EntityMappingsDefinition> entityMappingDefList = pusr.getEntityMappingsDefinitionsList();
            int totalClassesScanned = 0;
            if (clsScanResultsList != null && clsScanResultsList.size() > 0) {
                for (EntityMappingsScannerResults entityMappingsScannerResults : clsScanResultsList) {
                    if (entityMappingsScannerResults.getCit() == null) continue;
                    totalClassesScanned += entityMappingsScannerResults.getCit().getClassInfo().size();
                }
            }
            out.println("Total Classes Included in Analysis: " + totalClassesScanned);
            out.print("Entity Mappings Found ");
            if (entityMappingDefList != null && entityMappingDefList.size() > 0) {
                out.print("(" + entityMappingDefList.size() + ") :");
                boolean first = true;
                for (EntityMappingsDefinition emd : entityMappingDefList) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(", ");
                    }
                    out.print(emd.getSource());
                }
            } else {
                out.print(": (none)");
            }
            out.println();
            EncapsulatedDataGroup edg = EncapsulatedDataGroup.createEncapsulatedDataGroup("ORMDiagnostics", "ORMDiagnostics");
            int n = 0;
            edg.setProperty("execution.environment", "WebSphere Liberty");
            edg.setProperty("Persistence Unit Name", puName);
            edg.setProperty("Persistence Unit Root", pui.getPersistenceUnitRootUrl().toString());
            edg.setProperty("Persistence Schema Version", pui.getPersistenceXMLSchemaVersion());
            List jpaFileURLList = pui.getJarFileUrls();
            int jarUrlCount = 0;
            if (jpaFileURLList != null && jpaFileURLList.size() > 0) {
                for (Object url : jpaFileURLList) {
                    edg.setProperty("jar_file_" + ++jarUrlCount, ((URL)url).toString());
                }
            }
            ++var9_16;
            edg.putDataItem(EncapsulatedData.createEncapsulatedData("persistence.xml", Integer.toString(n), JPAORMDiagnostics.readInputStream(pxmlIS)));
            EncapsulatedDataGroup edgClassScanner = EncapsulatedDataGroup.createEncapsulatedDataGroup("ClassScanner", "ClassScanner");
            edg.putDataSubGroup(edgClassScanner);
            for (EntityMappingsScannerResults emsr : clsScanResultsList) {
                void var9_17;
                byte[] data = emsr.produceXML();
                String name = emsr.getTargetArchive().toString();
                String idStr = Integer.toString((int)(++var9_17));
                EncapsulatedData ed = EncapsulatedData.createEncapsulatedData(name, idStr, data);
                edgClassScanner.putDataItem(ed);
            }
            EncapsulatedDataGroup edgEntityMappings = EncapsulatedDataGroup.createEncapsulatedDataGroup("EntityMappings", "EntityMappings");
            edg.putDataSubGroup(edgEntityMappings);
            for (EntityMappingsDefinition emd : entityMappingDefList) {
                void var9_18;
                IEntityMappings em = emd.getEntityMappings();
                String name = emd.getSource().toString();
                String idStr = Integer.toString((int)(++var9_18));
                byte[] ormXmlData = JPAORMDiagnostics.readInputStream(emd.getSource().openStream());
                EncapsulatedData ed = EncapsulatedData.createEncapsulatedData(name, idStr, ormXmlData);
                edgEntityMappings.putDataItem(ed);
            }
            out.println();
            out.println("### Persistence Unit, ORM Mapping File, JPA Entity Class Signature Dump ###");
            edg.write(out);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(JPAORMDiagnostics.class.getName() + ".generateJPAORMDiagnostics"), (String)"120");
        }
    }

    private static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read = -1;
        while ((read = is.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        is.close();
        return baos.toByteArray();
    }
}

