/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.class_scanner.ano;

import com.ibm.ws.jpa.diagnostics.class_scanner.ano.AsmHelper;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.AsmObjectValueAnalyzer;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.ClassScannerException;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.InnerOuterResolver;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationValueType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ArrayEntryType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ArrayInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ExceptionType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ExceptionsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.FieldInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.FieldsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.InnerClassesType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.InterfacesType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.MethodInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.MethodsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ModifiersType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ParameterType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ParametersType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ValueInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ValueType;
import java.math.BigInteger;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class AsmClassAnalyzer {
    private static final String JavaLangObject = "java.lang.Object";
    private final byte[] bytecode;
    private final InnerOuterResolver ioResolver;
    private final ClassInfoType cit = new ClassInfoType();

    public static final ClassInfoType analyzeClass(String targetClass, byte[] bytecode, InnerOuterResolver ioResolver) throws ClassScannerException {
        if (bytecode == null || bytecode.length == 0) {
            throw new ClassScannerException("Bytecode is required.");
        }
        AsmClassAnalyzer ca = new AsmClassAnalyzer(bytecode, ioResolver);
        return ca.analyze();
    }

    private AsmClassAnalyzer(byte[] bytecode, InnerOuterResolver ioResolver) {
        this.bytecode = bytecode;
        this.ioResolver = ioResolver;
    }

    private ClassInfoType analyze() throws ClassScannerException {
        ClassReader cr = new ClassReader(this.bytecode);
        CAClassVisitor cacv = new CAClassVisitor();
        cr.accept((ClassVisitor)cacv, 0);
        return this.cit;
    }

    private class CAElementAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationValueType aet;
        private final String name;

        public CAElementAnnotationVisitor(AnnotationValueType aet, String name) {
            super(393216);
            this.aet = aet;
            this.name = name;
        }

        public void visit(String name, Object value) {
            ArrayInstanceType arit;
            super.visit(name, value);
            ValueInstanceType vit = AsmObjectValueAnalyzer.processValue(value);
            ValueInstanceType arrVit = this.aet.getValue();
            if (arrVit == null) {
                arrVit = new ValueInstanceType();
                arrVit.setType(ValueType.ARRAY);
                this.aet.setValue(arrVit);
            }
            if ((arit = arrVit.getArray()) == null) {
                arit = new ArrayInstanceType();
                arrVit.setArray(arit);
                arit.setLength(0);
                arit.setType(vit.getType());
            } else if (arit.getEntry().size() > 0 && !vit.getType().equals((Object)arit.getType())) {
                arit.setType(ValueType.UNKNOWN);
            }
            List<ArrayEntryType> aetList = arit.getEntry();
            int index = aetList.size();
            ArrayEntryType aret = new ArrayEntryType();
            aret.setIndex(index);
            aret.setValue(vit);
            arit.getEntry().add(aret);
            arit.setLength(arit.getEntry().size());
        }

        public void visitEnum(String name, String desc, String value) {
            ArrayInstanceType arit;
            super.visitEnum(name, desc, value);
            ValueInstanceType vit = AsmObjectValueAnalyzer.processEnum(name, desc, value);
            ValueInstanceType arrVit = this.aet.getValue();
            if (arrVit == null) {
                arrVit = new ValueInstanceType();
                arrVit.setType(ValueType.ARRAY);
                this.aet.setValue(arrVit);
            }
            if ((arit = arrVit.getArray()) == null) {
                arit = new ArrayInstanceType();
                arrVit.setArray(arit);
                arit.setLength(0);
                arit.setType(vit.getType());
            } else if (arit.getEntry().size() > 0 && !vit.getType().equals((Object)arit.getType())) {
                arit.setType(ValueType.UNKNOWN);
            }
            List<ArrayEntryType> aetList = arit.getEntry();
            int index = aetList.size();
            ArrayEntryType aret = new ArrayEntryType();
            aret.setIndex(index);
            aret.setValue(vit);
            arit.getEntry().add(aret);
            arit.setLength(arit.getEntry().size());
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            super.visitAnnotation(name, desc);
            AnnotationsType at = this.aet.getAnnotations();
            if (at == null) {
                at = new AnnotationsType();
                this.aet.setAnnotations(at);
            }
            List<AnnotationInfoType> eList = at.getAnnotation();
            AnnotationInfoType ait = new AnnotationInfoType();
            eList.add(ait);
            ait.setName(name);
            Type type = Type.getType((String)desc);
            if (type != null) {
                String processedName = AsmHelper.normalizeClassName(type.getClassName());
                ait.setName(AsmHelper.extractSimpleClassName(processedName));
                ait.setType(processedName);
            }
            return new CAAnnotationVisitor(ait, desc, false);
        }

        public AnnotationVisitor visitArray(String name) {
            return super.visitArray(name);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    private class CAAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationInfoType ait;
        private final String desc;
        private final boolean visible;
        final List<AnnotationValueType> eList;

        public CAAnnotationVisitor(AnnotationInfoType ait, String desc, boolean visible) {
            super(393216);
            this.ait = ait;
            this.desc = desc;
            this.visible = visible;
            this.eList = ait.getAnnoKeyVal();
        }

        private AnnotationValueType newAVT() {
            AnnotationValueType avt = new AnnotationValueType();
            this.eList.add(avt);
            return avt;
        }

        private AnnotationValueType newAVT(String name) {
            AnnotationValueType avt = this.newAVT();
            avt.setName(name);
            return avt;
        }

        public void visit(String name, Object value) {
            super.visit(name, value);
            AnnotationValueType avt = this.newAVT(name);
            avt.setValue(AsmObjectValueAnalyzer.processValue(value));
        }

        public void visitEnum(String name, String desc, String value) {
            super.visitEnum(name, desc, value);
            AnnotationValueType avt = this.newAVT(name);
            avt.setValue(AsmObjectValueAnalyzer.processEnum(name, desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            AnnotationVisitor av = super.visitAnnotation(name, desc);
            AnnotationValueType avt = this.newAVT(name);
            AnnotationInfoType ait = new AnnotationInfoType();
            avt.setAnnotation(ait);
            Type type = Type.getType((String)desc);
            if (type != null) {
                String processedName = AsmHelper.normalizeClassName(type.getClassName());
                ait.setName(AsmHelper.extractSimpleClassName(processedName));
                ait.setType(processedName);
            }
            return new CAAnnotationVisitor(ait, desc, this.visible);
        }

        public AnnotationVisitor visitArray(String name) {
            super.visitArray(name);
            AnnotationValueType avt = this.newAVT(name);
            CAElementAnnotationVisitor av = new CAElementAnnotationVisitor(avt, name);
            return av;
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    private class CAMethodVisitor
    extends MethodVisitor {
        private final MethodInfoType mit;

        public CAMethodVisitor(MethodInfoType mit) {
            super(393216);
            this.mit = mit;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationsType annosType = this.mit.getAnnotations();
            if (annosType == null) {
                annosType = new AnnotationsType();
                this.mit.setAnnotations(annosType);
            }
            List<AnnotationInfoType> annoList = annosType.getAnnotation();
            AnnotationInfoType ait = new AnnotationInfoType();
            annoList.add(ait);
            Type type = Type.getType((String)desc);
            if (type != null) {
                String processedName = AsmHelper.normalizeClassName(type.getClassName());
                ait.setName(AsmHelper.extractSimpleClassName(processedName));
                ait.setType(processedName);
            }
            return new CAAnnotationVisitor(ait, desc, visible);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    private class CAFieldVisitor
    extends FieldVisitor {
        final FieldInfoType fit;

        public CAFieldVisitor(FieldInfoType fit) {
            super(393216);
            this.fit = fit;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationsType annosType = this.fit.getAnnotations();
            if (annosType == null) {
                annosType = new AnnotationsType();
                this.fit.setAnnotations(annosType);
            }
            List<AnnotationInfoType> annoList = annosType.getAnnotation();
            AnnotationInfoType ait = new AnnotationInfoType();
            annoList.add(ait);
            Type type = Type.getType((String)desc);
            if (type != null) {
                String processedName = AsmHelper.normalizeClassName(type.getClassName());
                ait.setName(AsmHelper.extractSimpleClassName(processedName));
                ait.setType(processedName);
            }
            return new CAAnnotationVisitor(ait, desc, visible);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return super.visitTypeAnnotation(typeRef, typePath, desc, visible);
        }

        public void visitAttribute(Attribute attr) {
            super.visitAttribute(attr);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    private class CAClassVisitor
    extends ClassVisitor {
        public CAClassVisitor() {
            super(393216);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            String adjustedName = AsmHelper.normalizeClassName(name);
            AsmClassAnalyzer.this.cit.setClassName(adjustedName);
            AsmClassAnalyzer.this.cit.setPackageName(AsmHelper.extractPackageName(adjustedName));
            if (AsmClassAnalyzer.this.cit.getPackageName() != null && !AsmClassAnalyzer.this.cit.getPackageName().isEmpty()) {
                AsmClassAnalyzer.this.cit.setName(adjustedName.substring(AsmClassAnalyzer.this.cit.getPackageName().length() + 1));
            } else {
                AsmClassAnalyzer.this.cit.setName(adjustedName);
            }
            if (superName != null) {
                AsmClassAnalyzer.this.cit.setSuperclassName(AsmHelper.normalizeClassName(superName));
            } else {
                AsmClassAnalyzer.this.cit.setSuperclassName(AsmClassAnalyzer.JavaLangObject);
            }
            ModifiersType modTypes = new ModifiersType();
            modTypes.getModifier().addAll(AsmHelper.resolveAsmOpcode(AsmHelper.RoleFilter.CLASS, access));
            AsmClassAnalyzer.this.cit.setModifiers(modTypes);
            if (interfaces != null && interfaces.length > 0) {
                InterfacesType it = new InterfacesType();
                AsmClassAnalyzer.this.cit.setInterfaces(it);
                for (String iface : interfaces) {
                    it.getInterface().add(iface);
                }
            }
            AsmClassAnalyzer.this.cit.setVersion(version);
            AsmClassAnalyzer.this.cit.setIsAnonymous(false);
            AsmClassAnalyzer.this.cit.setIsEnum((access & 0x4000) != 0);
            AsmClassAnalyzer.this.cit.setIsInterface((access & 0x200) != 0);
            AsmClassAnalyzer.this.cit.setIsSynthetic((access & 0x1000) != 0);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationsType annosType = AsmClassAnalyzer.this.cit.getAnnotations();
            if (annosType == null) {
                annosType = new AnnotationsType();
                AsmClassAnalyzer.this.cit.setAnnotations(annosType);
            }
            List<AnnotationInfoType> annoList = annosType.getAnnotation();
            AnnotationInfoType ait = new AnnotationInfoType();
            annoList.add(ait);
            Type type = Type.getType((String)desc);
            if (type != null) {
                String processedName = AsmHelper.normalizeClassName(type.getClassName());
                ait.setName(AsmHelper.extractSimpleClassName(processedName));
                ait.setType(processedName);
            }
            return new CAAnnotationVisitor(ait, desc, visible);
        }

        public void visitAttribute(Attribute attr) {
            super.visitAttribute(attr);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldsType ft = AsmClassAnalyzer.this.cit.getFields();
            if (ft == null) {
                ft = new FieldsType();
                AsmClassAnalyzer.this.cit.setFields(ft);
            }
            List<FieldInfoType> fieldList = ft.getField();
            FieldInfoType fit = new FieldInfoType();
            fieldList.add(fit);
            fit.setName(name);
            if (desc != null) {
                Type type = Type.getType((String)desc);
                fit.setType(AsmHelper.normalizeClassName(type.getClassName()));
            }
            ModifiersType modTypes = new ModifiersType();
            modTypes.getModifier().addAll(AsmHelper.resolveAsmOpcode(AsmHelper.RoleFilter.FIELD, access));
            fit.setModifiers(modTypes);
            fit.setIsSynthetic((access & 0x1000) != 0);
            return new CAFieldVisitor(fit);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodsType mt = AsmClassAnalyzer.this.cit.getMethods();
            if (mt == null) {
                mt = new MethodsType();
                AsmClassAnalyzer.this.cit.setMethods(mt);
            }
            List<MethodInfoType> methodList = mt.getMethod();
            MethodInfoType mit = new MethodInfoType();
            methodList.add(mit);
            mit.setMethodName(name);
            mit.setIsCtor("<init>".equals(name));
            if (desc != null) {
                Type type = Type.getType((String)desc);
                Type[] argTypes = type.getArgumentTypes();
                if (argTypes != null && argTypes.length > 0) {
                    ParametersType pt = mit.getParameters();
                    if (pt == null) {
                        pt = new ParametersType();
                        mit.setParameters(pt);
                    }
                    List<ParameterType> parmList = pt.getParameter();
                    Type[] typeArray = argTypes;
                    int n = typeArray.length;
                    for (int i = 0; i < n; ++i) {
                        Type argType = typeArray[i];
                        ParameterType parmType = new ParameterType();
                        parmList.add(parmType);
                        parmType.setType(AsmHelper.normalizeClassName(argType.getClassName()));
                        parmType.setIsPrimitive(AsmHelper.isPrimitiveType(argType));
                        if (argType.getSort() == 9) {
                            parmType.setIsArray(true);
                            parmType.setArrayDimensions(BigInteger.valueOf(argType.getDimensions()));
                            parmType.setType(AsmHelper.normalizeClassName(argType.getElementType().getClassName()));
                        } else {
                            parmType.setIsArray(false);
                        }
                        parmType.setIsSynthetic(false);
                    }
                }
                Type returnType = type.getReturnType();
                mit.setReturnType(AsmHelper.normalizeClassName(returnType.getClassName()));
            }
            ModifiersType modTypes = new ModifiersType();
            modTypes.getModifier().addAll(AsmHelper.resolveAsmOpcode(AsmHelper.RoleFilter.METHOD, access));
            mit.setModifiers(modTypes);
            if (exceptions != null && exceptions.length > 0) {
                ExceptionsType et = mit.getExceptions();
                if (et == null) {
                    et = new ExceptionsType();
                    mit.setExceptions(et);
                }
                List<ExceptionType> exList = et.getException();
                for (String cName : exceptions) {
                    ExceptionType exType = new ExceptionType();
                    exList.add(exType);
                    exType.setExceptionType(AsmHelper.normalizeClassName(cName));
                }
            }
            return new CAMethodVisitor(mit);
        }

        public void visitEnd() {
            super.visitEnd();
        }

        public void visitOuterClass(String owner, String name, String desc) {
            super.visitOuterClass(owner, name, desc);
            if (AsmClassAnalyzer.this.ioResolver != null) {
                AsmClassAnalyzer.this.ioResolver.addUnresolvedOuterClassReference(AsmClassAnalyzer.this.cit, AsmHelper.normalizeClassName(owner));
            }
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(name, outerName, innerName, access);
            if (outerName == null || !AsmHelper.normalizeClassName(outerName).equals(AsmClassAnalyzer.this.cit.getClassName())) {
                return;
            }
            InnerClassesType ict = AsmClassAnalyzer.this.cit.getInnerclasses();
            if (ict == null) {
                ict = new InnerClassesType();
                AsmClassAnalyzer.this.cit.setInnerclasses(ict);
            }
            List<ClassInfoType> innerClassesList = ict.getInnerclass();
            ClassInfoType innerCit = new ClassInfoType();
            innerClassesList.add(innerCit);
            innerCit.setClassName(AsmHelper.normalizeClassName(name));
            if (AsmClassAnalyzer.this.ioResolver != null) {
                AsmClassAnalyzer.this.ioResolver.addUnresolvedInnerClassReference(AsmClassAnalyzer.this.cit, innerCit.getClassName());
            }
        }
    }
}

