/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.class_scanner.ano;

import com.ibm.ws.jpa.diagnostics.class_scanner.ano.AsmClassAnalyzer;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.ClassScannerException;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.EntityMappingsScannerResults;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.InnerOuterResolver;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInformationType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.InnerClassesType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public final class EntityMappingsScanner {
    private final URL targetArchive;
    private final ClassLoader scannerCL;
    private final InnerOuterResolver ioResolver = new InnerOuterResolver();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final byte[] buffer = new byte[4096];

    public static EntityMappingsScannerResults scanTargetArchive(URL targetArchive, ClassLoader scannerCL) throws ClassScannerException {
        if (targetArchive == null || scannerCL == null) {
            throw new ClassScannerException("EntityMappingsScanner.scanTargetArchive cannot accept null arguments.");
        }
        EntityMappingsScanner ems = new EntityMappingsScanner(targetArchive, scannerCL);
        ClassInformationType cit = ems.scanTargetArchive();
        return new EntityMappingsScannerResults(cit, targetArchive);
    }

    private EntityMappingsScanner(URL targetArchive, ClassLoader scannerCL) {
        this.targetArchive = targetArchive;
        this.scannerCL = scannerCL;
    }

    private ClassInformationType scanTargetArchive() throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        String urlProtocol = this.targetArchive.getProtocol();
        if ("file".equalsIgnoreCase(urlProtocol)) {
            try {
                Path taPath = Paths.get(this.targetArchive.toURI());
                if (Files.isDirectory(taPath, new LinkOption[0])) {
                    citSet.addAll(this.processExplodedJarFormat(taPath));
                }
                System.err.println("Unexploded Archive Path");
            }
            catch (URISyntaxException e) {
                throw new ClassScannerException(e);
            }
        } else {
            citSet.addAll(this.processJarFormatInputStreamURL(this.targetArchive));
        }
        this.processInnerClasses(citSet);
        ClassInformationType cit = new ClassInformationType();
        List<ClassInfoType> citList = cit.getClassInfo();
        citList.addAll(citSet);
        this.ioResolver.resolve(citList);
        return cit;
    }

    /*
     * WARNING - void declaration
     */
    private void processInnerClasses(Set<ClassInfoType> citSet) throws ClassScannerException {
        HashSet<ClassInfoType> innerClassSet = new HashSet<ClassInfoType>();
        for (ClassInfoType classInfoType : citSet) {
            String string = classInfoType.getClassName();
            if (!string.contains("$")) continue;
            innerClassSet.add(classInfoType);
        }
        if (innerClassSet.size() == 0) {
            return;
        }
        ArrayList innerClassDepthList = new ArrayList();
        for (ClassInfoType classInfoType : innerClassSet) {
            String innerClassName = classInfoType.getClassName();
            String outerClassName = innerClassName.substring(0, innerClassName.lastIndexOf("$"));
            int depth = 1;
            for (char c : outerClassName.toCharArray()) {
                if ('$' != c) continue;
                ++depth;
            }
            if (innerClassDepthList.size() < depth) {
                for (int i = depth - innerClassDepthList.size(); i > 0; --i) {
                    innerClassDepthList.add(new HashSet());
                }
            }
            HashSet innerClassDepthSet = (HashSet)innerClassDepthList.get(depth - 1);
            innerClassDepthSet.add(classInfoType);
        }
        if (innerClassDepthList.size() > 1) {
            void var4_7;
            int n = innerClassDepthList.size() - 1;
            while (var4_7 >= true) {
                HashSet hashSet = (HashSet)innerClassDepthList.get((int)var4_7);
                HashSet innerClassesAtHigherDepth = (HashSet)innerClassDepthList.get((int)(var4_7 - true));
                for (ClassInfoType cit : hashSet) {
                    String innerClassName = cit.getClassName();
                    String outerClassName = innerClassName.substring(0, innerClassName.lastIndexOf("$"));
                    ClassInfoType higherInnerClass = null;
                    for (ClassInfoType uIC : innerClassesAtHigherDepth) {
                        if (!uIC.getClassName().equals(outerClassName)) continue;
                        higherInnerClass = uIC;
                        break;
                    }
                    if (higherInnerClass == null) continue;
                    InnerClassesType ict = higherInnerClass.getInnerclasses();
                    if (ict == null) {
                        ict = new InnerClassesType();
                        higherInnerClass.setInnerclasses(ict);
                    }
                    List<ClassInfoType> innerClassList = ict.getInnerclass();
                    ClassInfoType replaceThis = null;
                    for (ClassInfoType iclCit : innerClassList) {
                        if (!iclCit.getClassName().equals(innerClassName)) continue;
                        replaceThis = iclCit;
                        break;
                    }
                    if (replaceThis == null) {
                        innerClassList.remove(replaceThis);
                    }
                    innerClassList.add(cit);
                }
                --var4_7;
            }
        }
        HashSet hashSet = (HashSet)innerClassDepthList.get(0);
        for (ClassInfoType innerCit : hashSet) {
            String innerClassName = innerCit.getClassName();
            String outerClassName = innerClassName.substring(0, innerClassName.lastIndexOf("$"));
            Object object = citSet.iterator();
            while (object.hasNext()) {
                ClassInfoType cit = (ClassInfoType)object.next();
                if (!cit.getClassName().equals(outerClassName)) continue;
                InnerClassesType ict = cit.getInnerclasses();
                if (ict == null) {
                    ict = new InnerClassesType();
                    cit.setInnerclasses(ict);
                }
                List<ClassInfoType> innerClassList = ict.getInnerclass();
                ClassInfoType replaceThis = null;
                for (ClassInfoType iclCit : innerClassList) {
                    if (!iclCit.getClassName().equals(innerClassName)) continue;
                    replaceThis = iclCit;
                    break;
                }
                if (replaceThis != null) {
                    innerClassList.remove(replaceThis);
                }
                innerClassList.add(innerCit);
            }
        }
        citSet.removeAll(innerClassSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<ClassInfoType> processExplodedJarFormat(Path path) throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        final HashSet archiveFiles = new HashSet();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Files.isRegularFile(file, new LinkOption[0]) && Files.size(file) > 0L && file.getFileName().toString().endsWith(".class")) {
                        archiveFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            for (Path p : archiveFiles) {
                String cName = path.relativize(p).toString().replace("/", ".");
                cName = cName.substring(0, cName.length() - 6);
                try {
                    InputStream is = Files.newInputStream(p, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        citSet.add(this.scanByteCodeFromInputStream(cName, is));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (Throwable t) {
                    throw new ClassScannerException(t);
                    return citSet;
                }
            }
        }
        catch (ClassScannerException cse) {
            throw cse;
        }
        catch (Throwable t) {
            throw new ClassScannerException(t);
        }
    }

    private Set<ClassInfoType> processJarFormatInputStreamURL(URL jarURL) throws ClassScannerException {
        HashSet<ClassInfoType> citSet = new HashSet<ClassInfoType>();
        try (JarInputStream jis = new JarInputStream(jarURL.openStream(), false);){
            JarEntry jarEntry = null;
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                String name = jarEntry.getName();
                if (name == null || !name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6).replace("/", ".");
                citSet.add(this.scanByteCodeFromInputStream(name, jis));
            }
        }
        catch (Throwable t) {
            throw new ClassScannerException(t);
        }
        return citSet;
    }

    private ClassInfoType scanByteCodeFromInputStream(String cName, InputStream is) throws ClassScannerException {
        this.baos.reset();
        try {
            int bytesRead = 0;
            while ((bytesRead = is.read(this.buffer, 0, 4096)) > -1) {
                if (bytesRead <= 0) continue;
                this.baos.write(this.buffer, 0, bytesRead);
            }
            byte[] classByteCode = this.baos.toByteArray();
            this.baos.reset();
            return AsmClassAnalyzer.analyzeClass(cName, classByteCode, this.ioResolver);
        }
        catch (Throwable t) {
            throw new ClassScannerException(t);
        }
    }
}

