/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.puscanner;

import com.ibm.ws.jpa.diagnostics.class_scanner.ano.ClassScannerException;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.EntityMappingsScanner;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.EntityMappingsScannerResults;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.AnnotationsType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInfoType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ClassInformationType;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsDefinition;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsException;
import com.ibm.ws.jpa.diagnostics.ormparser.EntityMappingsFactory;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IEmbeddable;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IEntity;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IEntityMappings;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IMappedSuperclass;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IPersistenceUnitDefaults;
import com.ibm.ws.jpa.diagnostics.ormparser.entitymapping.IPersistenceUnitMetadata;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScannerException;
import com.ibm.ws.jpa.diagnostics.puscanner.PersistenceUnitScannerResults;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;

public final class PersistenceUnitScanner {
    private final PersistenceUnitInfo pUnit;
    private final ClassLoader tempCL;
    private final URL puRoot;
    private final List<URL> jarFileList = new ArrayList<URL>();
    final List<EntityMappingsDefinition> entityMappingsDefinitionsList = new ArrayList<EntityMappingsDefinition>();
    final List<EntityMappingsScannerResults> classScannerResults = new ArrayList<EntityMappingsScannerResults>();

    public static PersistenceUnitScannerResults scanPersistenceUnit(PersistenceUnitInfo pUnit) throws PersistenceUnitScannerException {
        if (pUnit == null) {
            throw new PersistenceUnitScannerException("Cannot accept a null value for PersistenceUnitInfo argument.");
        }
        PersistenceUnitScanner puScanner = new PersistenceUnitScanner(pUnit);
        return puScanner.scan();
    }

    private PersistenceUnitScanner(PersistenceUnitInfo pUnit) {
        this.pUnit = pUnit;
        this.tempCL = pUnit.getNewTempClassLoader();
        this.puRoot = pUnit.getPersistenceUnitRootUrl();
        if (pUnit.getJarFileUrls() != null) {
            this.jarFileList.addAll(pUnit.getJarFileUrls());
        }
    }

    private PersistenceUnitScannerResults scan() throws PersistenceUnitScannerException {
        this.scanEntityMappings();
        this.scanClasses();
        this.trim();
        return new PersistenceUnitScannerResults(this.pUnit, this.entityMappingsDefinitionsList, this.classScannerResults);
    }

    private void scanEntityMappings() throws PersistenceUnitScannerException {
        HashSet<URL> mappingFilesLocated = new HashSet<URL>();
        try {
            mappingFilesLocated.addAll(this.findORMResources("META-INF/orm.xml"));
            List puiMappingFiles = this.pUnit.getMappingFileNames();
            if (puiMappingFiles != null && !puiMappingFiles.isEmpty()) {
                for (String mappingFile : puiMappingFiles) {
                    if ("META-INF/orm.xml".equals(mappingFile)) continue;
                    mappingFilesLocated.addAll(this.findORMResources(mappingFile));
                }
            }
            for (URL mappingFileURL : mappingFilesLocated) {
                EntityMappingsDefinition emapdef = EntityMappingsFactory.parseEntityMappings(mappingFileURL);
                this.entityMappingsDefinitionsList.add(emapdef);
            }
        }
        catch (IOException ioe) {
            throw new PersistenceUnitScannerException(ioe);
        }
        catch (EntityMappingsException eme) {
            throw new PersistenceUnitScannerException(eme);
        }
    }

    private void scanClasses() throws PersistenceUnitScannerException {
        try {
            this.classScannerResults.add(EntityMappingsScanner.scanTargetArchive(this.puRoot, this.tempCL));
            for (URL jarFileURL : this.jarFileList) {
                this.classScannerResults.add(EntityMappingsScanner.scanTargetArchive(jarFileURL, this.tempCL));
            }
        }
        catch (ClassScannerException cse) {
            throw new PersistenceUnitScannerException(cse);
        }
    }

    private List<URL> findORMResources(String ormFileName) throws IOException {
        boolean isMetaInfoOrmXML = "META-INF/orm.xml".equals(ormFileName);
        ArrayList<URL> retArr = new ArrayList<URL>();
        Enumeration<URL> ormEnum = this.pUnit.getClassLoader().getResources(ormFileName);
        while (ormEnum.hasMoreElements()) {
            URL url = ormEnum.nextElement();
            String urlExtern = url.toExternalForm();
            if (!isMetaInfoOrmXML) {
                retArr.add(url);
                continue;
            }
            if (urlExtern.startsWith(this.puRoot.toExternalForm())) {
                retArr.add(url);
                continue;
            }
            for (URL jarUrl : this.jarFileList) {
                String jarExtern = jarUrl.toExternalForm();
                if (!urlExtern.startsWith(jarExtern)) continue;
                retArr.add(url);
            }
        }
        return retArr;
    }

    private void trim() {
        HashSet<String> trimSet;
        List citList;
        boolean excludeUnlistedClasses = this.pUnit.excludeUnlistedClasses();
        List managedClassNames = this.pUnit.getManagedClassNames();
        boolean xmlMetaDataComplete = this.checkXMLMetadataComplete();
        HashSet<String> persistenceAwareClassSet = new HashSet<String>();
        HashSet<String> ormDefinedEntitySet = new HashSet<String>();
        HashSet<String> metadataCompleteEntitySet = new HashSet<String>();
        HashSet<String> ormDefinedEmbeddableSet = new HashSet<String>();
        HashSet<String> metadataCompleteEmbeddableSet = new HashSet<String>();
        HashSet<String> ormDefinedMappedSuperclassSet = new HashSet<String>();
        HashSet<String> metadataCompleteMappedSuperclassSet = new HashSet<String>();
        for (EntityMappingsDefinition emd : this.entityMappingsDefinitionsList) {
            IEntityMappings entityMappings = emd.getEntityMappings();
            this.parseORMXMLDocument(entityMappings, persistenceAwareClassSet, ormDefinedEntitySet, metadataCompleteEntitySet, ormDefinedEmbeddableSet, metadataCompleteEmbeddableSet, ormDefinedMappedSuperclassSet, metadataCompleteMappedSuperclassSet);
        }
        HashMap<String, List<ClassInfoType>> allClassMap = new HashMap<String, List<ClassInfoType>>();
        HashMap<ClassInfoType, EntityMappingsScannerResults> citEmsrMap = new HashMap<ClassInfoType, EntityMappingsScannerResults>();
        for (EntityMappingsScannerResults emsr : this.classScannerResults) {
            ClassInformationType citInfo = emsr.getCit();
            citList = citInfo.getClassInfo();
            if (citList == null || citList.size() == 0) continue;
            for (ClassInfoType cit : citList) {
                String className = cit.getClassName();
                ArrayList<ClassInfoType> cList = (ArrayList<ClassInfoType>)allClassMap.get(className);
                if (cList == null) {
                    cList = new ArrayList<ClassInfoType>();
                    allClassMap.put(className, cList);
                }
                cList.add(cit);
                citEmsrMap.put(cit, emsr);
            }
        }
        if (!xmlMetaDataComplete) {
            if (excludeUnlistedClasses) {
                trimSet = new HashSet(allClassMap.keySet());
                trimSet.removeAll(persistenceAwareClassSet);
                trimSet.removeAll(managedClassNames);
                this.removeScannedClassEntries(trimSet, allClassMap, citEmsrMap);
            } else {
                trimSet = new HashSet(allClassMap.keySet());
                trimSet.removeAll(persistenceAwareClassSet);
                trimSet.removeAll(managedClassNames);
                for (String className : allClassMap.keySet()) {
                    if (persistenceAwareClassSet.contains(className) || managedClassNames.contains(className)) continue;
                    citList = (List)allClassMap.get(className);
                    boolean hasJpaAnnotations = false;
                    block4: for (ClassInfoType cit : citList) {
                        AnnotationsType ait = cit.getAnnotations();
                        if (ait == null) continue;
                        for (AnnotationInfoType aInfT : ait.getAnnotation()) {
                            String type = aInfT.getType();
                            if (type == null || !type.startsWith("javax.persistence.")) continue;
                            hasJpaAnnotations = true;
                            break block4;
                        }
                    }
                    if (!hasJpaAnnotations) continue;
                    trimSet.add(className);
                }
                this.removeScannedClassEntries(trimSet, allClassMap, citEmsrMap);
            }
        } else {
            trimSet = new HashSet<String>(allClassMap.keySet());
            trimSet.removeAll(persistenceAwareClassSet);
            this.removeScannedClassEntries(trimSet, allClassMap, citEmsrMap);
        }
    }

    private void removeScannedClassEntries(Set<String> classNamesToRemove, Map<String, List<ClassInfoType>> allClassMap, Map<ClassInfoType, EntityMappingsScannerResults> citEmsrMap) {
        for (String className : classNamesToRemove) {
            List<ClassInfoType> citList = allClassMap.get(className);
            for (ClassInfoType cit : citList) {
                EntityMappingsScannerResults emsr = citEmsrMap.get(cit);
                ClassInformationType c = emsr.getCit();
                List<ClassInfoType> cList = c.getClassInfo();
                cList.remove(cit);
            }
        }
    }

    private boolean checkXMLMetadataComplete() {
        boolean xmlMetaDataComplete = false;
        for (EntityMappingsDefinition emd : this.entityMappingsDefinitionsList) {
            IEntityMappings entityMappings = emd.getEntityMappings();
            IPersistenceUnitMetadata puMetaData = entityMappings.getIPersistenceUnitMetadata();
            if (puMetaData == null || !puMetaData.isXmlMappingMetadataComplete()) continue;
            xmlMetaDataComplete = true;
        }
        return xmlMetaDataComplete;
    }

    private void parseORMXMLDocument(IEntityMappings entityMappings, Set<String> persistenceAwareClassSet, Set<String> ormDefinedEntitySet, Set<String> metadataCompleteEntitySet, Set<String> ormDefinedEmbeddableSet, Set<String> metadataCompleteEmbeddableSet, Set<String> ormDefinedMappedSuperclassSet, Set<String> metadataCompleteMappedSuperclassSet) {
        List<IMappedSuperclass> list;
        List<IEmbeddable> embeddableList;
        List<IEntity> entityList;
        IPersistenceUnitDefaults puDefaults;
        IPersistenceUnitMetadata puMetaData = entityMappings.getIPersistenceUnitMetadata();
        if (puMetaData != null && (puDefaults = puMetaData.getIPersistenceUnitDefaults()) != null) {
            persistenceAwareClassSet.addAll(puDefaults._getEntityListeners());
        }
        if ((entityList = entityMappings.getEntityList()) != null && entityList.size() > 0) {
            for (IEntity iEntity : entityList) {
                String className = iEntity.getClazz();
                persistenceAwareClassSet.add(className);
                ormDefinedEntitySet.add(className);
                if (Boolean.TRUE.equals(iEntity.isMetadataComplete())) {
                    metadataCompleteEntitySet.add(className);
                }
                if (iEntity._getIDClass() != null) {
                    persistenceAwareClassSet.add(iEntity._getIDClass());
                }
                persistenceAwareClassSet.addAll(iEntity._getConverters());
                persistenceAwareClassSet.addAll(iEntity._getEntityListeners());
                persistenceAwareClassSet.addAll(iEntity._getNamedEntityGraphClasses());
                persistenceAwareClassSet.addAll(iEntity._getNamedNativeQueryClasses());
                persistenceAwareClassSet.addAll(iEntity._getSQLResultSetClasses());
            }
        }
        if ((embeddableList = entityMappings.getEmbeddableList()) != null && embeddableList.size() > 0) {
            for (IEmbeddable embeddable : embeddableList) {
                String className = embeddable.getClazz();
                persistenceAwareClassSet.add(className);
                ormDefinedEmbeddableSet.add(className);
                if (!Boolean.TRUE.equals(embeddable.isMetadataComplete())) continue;
                metadataCompleteEmbeddableSet.add(className);
            }
        }
        if ((list = entityMappings.getMappedSuperclassList()) != null && list.size() > 0) {
            for (IMappedSuperclass msc : list) {
                String className = msc.getClazz();
                persistenceAwareClassSet.add(className);
                ormDefinedMappedSuperclassSet.add(className);
                if (msc._getIDClass() != null) {
                    persistenceAwareClassSet.add(msc._getIDClass());
                }
                if (!Boolean.TRUE.equals(msc.isMetadataComplete())) continue;
                metadataCompleteMappedSuperclassSet.add(className);
            }
        }
    }
}

