/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.mongo.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.mongo.MongoChangeListener;
import com.ibm.ws.mongo.internal.MongoService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.mongo.mongoDB", configurationPolicy=ConfigurationPolicy.REQUIRE, service={ResourceFactory.class, ApplicationRecycleComponent.class}, property={"service.vendor=IBM", "creates.objectClass=com.mongodb.DB"})
public class MongoDBService
implements ResourceFactory,
ApplicationRecycleComponent,
MongoChangeListener {
    private static final TraceComponent tc = Tr.register(MongoDBService.class);
    private static final String DATABASE_NAME = "databaseName";
    private static final String JNDI_NAME = "jndiName";
    private static final String APP_RECYCLE_SERVICE = "appRecycleService";
    private volatile MongoService mongo;
    private final AtomicReference<ComponentContext> cctx = new AtomicReference();
    @Reference(name="appRecycleService")
    private ApplicationRecycleCoordinator appRecycleSvcRef;
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    static final long serialVersionUID = -7405957570668979089L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("MongoDBService activate: jndiName=" + props.get(JNDI_NAME) + ", database=" + props.get(DATABASE_NAME)), (Object[])new Object[0]);
        }
        this.mongo.registerChangeListener(this);
        this.cctx.set(context);
    }

    public Object createResource(ResourceInfo resourceInfo) throws Exception {
        ComponentContext context = this.cctx.get();
        String databaseName = (String)context.getProperties().get(DATABASE_NAME);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("MongoDBService createResource: database=" + databaseName + ", " + context), (Object[])new Object[0]);
        }
        Object dbInstance = this.mongo.getDB(databaseName);
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return dbInstance;
    }

    @Deactivate
    protected void deactivate(ComponentContext context, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("MongoDBService deactivate: jndiName=" + props.get(JNDI_NAME) + ", database=" + props.get(DATABASE_NAME)), (Object[])new Object[0]);
        }
        this.mongo.unregisterChangeListener(this);
        this.cctx.set(null);
    }

    @Reference(name="mongo", target="(id=unbound)", policyOption=ReferencePolicyOption.GREEDY)
    protected void setMongoService(MongoService mongoService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setMongoService: " + this.mongo + " -> " + mongoService), (Object[])new Object[0]);
        }
        this.mongo = mongoService;
    }

    protected void unsetMongoService(MongoService mongoService) {
        if (mongoService == this.mongo) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unsetMongoService: " + this.mongo + " -> " + null), (Object[])new Object[0]);
            }
            this.mongo = null;
        }
    }

    @Trivial
    public ApplicationRecycleContext getContext() {
        return null;
    }

    @Trivial
    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDependentApplications: " + members), (Object[])new Object[0]);
        }
        return members;
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> props) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Dictionary oldProps = this.cctx.get().getProperties();
            Tr.debug((Object)this, (TraceComponent)tc, (String)("MongoDBService modified: jndiName: " + oldProps.get(JNDI_NAME) + " -> " + props.get(JNDI_NAME) + ", database: " + oldProps.get(DATABASE_NAME) + " -> " + props.get(DATABASE_NAME)), (Object[])new Object[0]);
        }
        this.cctx.set(context);
        if (!this.applications.isEmpty()) {
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("recycling applications: " + members), (Object[])new Object[0]);
            }
            this.appRecycleSvcRef.recycleApplications(members);
        }
    }

    @Override
    public void changeOccurred() {
        if (!this.applications.isEmpty()) {
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("recycling applications: " + members), (Object[])new Object[0]);
            }
            this.appRecycleSvcRef.recycleApplications(members);
        }
    }
}

