/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.ejb.NamedMethod;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class DDUtil {
    private static final TraceComponent tc = Tr.register(DDUtil.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public static boolean methodParamsMatch(List<String> typeNames, Class<?>[] types) {
        if (typeNames.size() != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            String typeName = typeNames.get(i);
            int typeNameEnd = typeName.length();
            Class<?> type = types[i];
            while (type.isArray()) {
                if (typeNameEnd < 2 || typeName.charAt(--typeNameEnd) != ']' || typeName.charAt(--typeNameEnd) != '[') {
                    return false;
                }
                type = type.getComponentType();
            }
            if (type.getName().regionMatches(0, typeName, 0, typeNameEnd)) continue;
            return false;
        }
        return true;
    }

    public static Method findMethod(NamedMethod beanMethod, Method[] allMethods) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMethod", (Object[])new Object[0]);
        }
        String methodName = beanMethod.getMethodName();
        List<String> parms = beanMethod.getMethodParamList();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NamedMethod method name = " + methodName + ", parameter list = " + parms), (Object[])new Object[0]);
        }
        if (parms == null) {
            parms = Collections.emptyList();
        }
        for (Method m : allMethods) {
            if (!m.getName().equals(methodName) || !DDUtil.methodParamsMatch(parms, m.getParameterTypes())) continue;
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("returning: " + m.toGenericString()));
            }
            return m;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(methodName + " not found, returning null"));
        }
        return null;
    }
}

