/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.parsers.Parser;
import com.ibm.ws.repository.parsers.ParserBase;
import com.ibm.ws.repository.parsers.exceptions.RepositoryArchiveException;
import com.ibm.ws.repository.resources.writeable.AdminScriptResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.resources.writeable.WritableResourceFactory;
import java.io.File;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AdminScriptParser
extends ParserBase
implements Parser<AdminScriptResourceWritable> {
    public static final String PROP_LANGUAGE = "script.language";
    static final long serialVersionUID = -4924954414059425904L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public AdminScriptResourceWritable parseFileToResource(File assetFile, File metadataFile, String contentUrl) throws RepositoryException {
        ParserBase.ArtifactMetadata artifactMetadata = this.explodeArtifact(assetFile, metadataFile);
        if (artifactMetadata == null) {
            throw new RepositoryArchiveException("Unable to find sibling metadata zip for " + assetFile.getName() + " so do not have the required information", assetFile);
        }
        AdminScriptResourceWritable resource = WritableResourceFactory.createAdminScript(null);
        this.setCommonFieldsFromSideZip(artifactMetadata, (RepositoryResourceWritable)resource);
        this.checkPropertySet("provider", artifactMetadata);
        this.checkPropertySet(PROP_LANGUAGE, artifactMetadata);
        resource.setProviderName(this.getProviderName(artifactMetadata));
        resource.setScriptLanguage(artifactMetadata.getProperty(PROP_LANGUAGE));
        resource.setAppliesTo(this.getAppliesTo(artifactMetadata));
        resource.setRequireFeature(this.getRequiresFeature(artifactMetadata));
        this.addContent((RepositoryResourceWritable)resource, assetFile, assetFile.getName(), artifactMetadata, contentUrl);
        return resource;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AdminScriptParser.class);
    }
}

