/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.filter.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthFilterConfig {
    private static final TraceComponent tc = Tr.register(AuthFilterConfig.class);
    public static final String KEY_ID = "id";
    public static final String KEY_WEB_APP = "webApp";
    static final String KEY_REQUEST_URL = "requestUrl";
    public static final String KEY_URL_PATTERN = "urlPattern";
    static final String KEY_REMOTE_ADDRESS = "remoteAddress";
    public static final String KEY_IP = "ip";
    static final String KEY_HOST = "host";
    public static final String KEY_NAME = "name";
    static final String KEY_USER_AGENT = "userAgent";
    public static final String KEY_AGENT = "agent";
    public static final String KEY_MATCH_TYPE = "matchType";
    public static final String MATCH_TYPE_EQUALS = "equals";
    public static final String MATCH_TYPE_CONTAINS = "contains";
    public static final String MATCH_TYPE_NOT_CONTAIN = "notContain";
    public static final String MATCH_TYPE_GREATER_THAN = "greaterThan";
    public static final String MATCH_TYPE_LESS_THAN = "lessThan";
    private String id;
    private List<Properties> webApps = null;
    private List<Properties> requestUrls = null;
    private List<Properties> remoteAddresses = null;
    private List<Properties> hosts = null;
    private List<Properties> userAgents = null;
    private boolean hasFilter = false;
    static final long serialVersionUID = -377699200424126255L;

    public AuthFilterConfig(Map<String, Object> props) {
        this.processFlatConfig(props);
    }

    protected void processFlatConfig(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.id = (String)props.get(KEY_ID);
        if (this.id == null || this.id.length() == 0) {
            Tr.error((TraceComponent)tc, (String)"AUTH_FILTER_MISSING_ID", (Object[])new Object[]{props.toString()});
            return;
        }
        Map<String, List<Map<String, Object>>> authFilterNestedElements = Nester.nest(props, KEY_WEB_APP, KEY_REQUEST_URL, KEY_REMOTE_ADDRESS, KEY_HOST, KEY_USER_AGENT);
        if (!authFilterNestedElements.isEmpty()) {
            this.webApps = this.processElementProps(authFilterNestedElements, KEY_WEB_APP, KEY_NAME, KEY_MATCH_TYPE);
            this.requestUrls = this.processElementProps(authFilterNestedElements, KEY_REQUEST_URL, KEY_URL_PATTERN, KEY_MATCH_TYPE);
            this.remoteAddresses = this.processElementProps(authFilterNestedElements, KEY_REMOTE_ADDRESS, KEY_IP, KEY_MATCH_TYPE);
            this.hosts = this.processElementProps(authFilterNestedElements, KEY_HOST, KEY_NAME, KEY_MATCH_TYPE);
            this.userAgents = this.processElementProps(authFilterNestedElements, KEY_USER_AGENT, KEY_AGENT, KEY_MATCH_TYPE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("id: " + this.id), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("webApps: " + this.webApps), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("requestUrls: " + this.requestUrls), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("remoteAddresses: " + this.remoteAddresses), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hosts: " + this.hosts), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userAgents: " + this.userAgents), (Object[])new Object[0]);
        }
        this.hasFilter = this.hasAnyFilterConfig();
    }

    public List<Properties> processElementProps(Map<String, List<Map<String, Object>>> listOfNestedElements, String elementName, String ... attrKeys) {
        ArrayList<Properties> listOfProps = new ArrayList<Properties>();
        List<Map<String, Object>> listOfElementMaps = listOfNestedElements.get(elementName);
        if (listOfElementMaps != null && !listOfElementMaps.isEmpty()) {
            for (Map<String, Object> elementProps : listOfElementMaps) {
                Properties properties = this.getElementProperties(elementProps, elementName, attrKeys);
                if (properties == null || properties.isEmpty()) continue;
                listOfProps.add(properties);
            }
        }
        return listOfProps;
    }

    private Properties getElementProperties(Map<String, Object> configProps, String elementName, String ... attrKeys) {
        Properties properties = new Properties();
        for (String attrKey : attrKeys) {
            String value = (String)configProps.get(attrKey);
            if (value == null || value.length() <= 0) continue;
            value = (String)this.getValue(value);
            properties.put(attrKey, value);
        }
        if (properties.isEmpty() || properties.size() != attrKeys.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The authFilter element " + elementName + " specified in the server.xml file is missing one or more of these attributes " + this.printAttrKeys(attrKeys)), (Object[])new Object[0]);
            }
            return null;
        }
        return properties;
    }

    private String printAttrKeys(String ... attrKeys) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("(");
        for (String attrKey : attrKeys) {
            strBuff.append(attrKey);
            strBuff.append(", ");
        }
        int currentIndex = strBuff.lastIndexOf(",");
        strBuff.delete(currentIndex, currentIndex + 2);
        strBuff.append(")");
        return strBuff.toString();
    }

    private Object getValue(Object value) {
        if (value instanceof String) {
            return ((String)value).trim();
        }
        return value;
    }

    protected boolean hasAnyFilterConfig() {
        boolean result = false;
        if (this.webApps != null && !this.webApps.isEmpty() || this.requestUrls != null && !this.requestUrls.isEmpty() || this.remoteAddresses != null && !this.remoteAddresses.isEmpty() || this.hosts != null && !this.hosts.isEmpty() || this.userAgents != null && !this.userAgents.isEmpty()) {
            result = true;
        } else {
            Tr.info((TraceComponent)tc, (String)"AUTH_FILTER_NOT_CONFIG", (Object[])new Object[0]);
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public List<Properties> getWebApps() {
        return this.webApps;
    }

    public List<Properties> getRequestUrls() {
        return this.requestUrls;
    }

    public List<Properties> getHosts() {
        return this.hosts;
    }

    public List<Properties> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public List<Properties> getUserAgents() {
        return this.userAgents;
    }

    public boolean hasFilterConfig() {
        return this.hasFilter;
    }
}

