/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.filter.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.internal.AuthFilterConfig;
import com.ibm.ws.security.authentication.filter.internal.ContainsCondition;
import com.ibm.ws.security.authentication.filter.internal.EqualCondition;
import com.ibm.ws.security.authentication.filter.internal.FilterException;
import com.ibm.ws.security.authentication.filter.internal.GreaterCondition;
import com.ibm.ws.security.authentication.filter.internal.ICondition;
import com.ibm.ws.security.authentication.filter.internal.IRequestInfo;
import com.ibm.ws.security.authentication.filter.internal.IValue;
import com.ibm.ws.security.authentication.filter.internal.LessCondition;
import com.ibm.ws.security.authentication.filter.internal.NotContainsCondition;
import com.ibm.ws.security.authentication.filter.internal.OrCondition;
import com.ibm.ws.security.authentication.filter.internal.ValueAddressRange;
import com.ibm.ws.security.authentication.filter.internal.ValueIPAddress;
import com.ibm.ws.security.authentication.filter.internal.ValueString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CommonFilter {
    private static final TraceComponent tc = Tr.register(CommonFilter.class);
    private boolean processAll = false;
    static final String REMOTE_ADDRESS = "remote-address";
    static final String REQUEST_URL = "request-url";
    static final String KEY_HOST = "Host";
    static final String KEY_USER_AGENT = "User-Agent";
    protected static final String APPLICATION_NAMES = "applicationNames";
    protected List<ICondition> filterCondition = new LinkedList<ICondition>();
    static final long serialVersionUID = -845199212979249010L;

    CommonFilter(AuthFilterConfig authFilterConfig) {
        this.initialize(authFilterConfig);
    }

    /*
     * WARNING - void declaration
     */
    public boolean init(String s1) {
        if (s1 == null) {
            Tr.error((TraceComponent)tc, (String)"AUTH_FILTER_INIT_NULL_STRING", (Object[])new Object[0]);
            return false;
        }
        StringTokenizer st1 = new StringTokenizer(s1, ";");
        StringTokenizer st2 = null;
        String s2 = null;
        while (st1.hasMoreTokens()) {
            s2 = st1.nextToken();
            st2 = new StringTokenizer(s2, "^=!<>%");
            String key = st2.nextToken();
            if (!st2.hasMoreTokens()) {
                Tr.error((TraceComponent)tc, (String)"AUTH_FILTER_MALFORMED_CONDITION", (Object[])new Object[]{s1, s2, null});
                return false;
            }
            String valueString = st2.nextToken();
            String operand = s2.substring(key.length(), s2.length() - valueString.length()).trim();
            boolean ipAddress = false;
            if (REMOTE_ADDRESS.equals(key)) {
                ipAddress = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding " + key + " " + operand + " " + valueString), (Object[])new Object[0]);
            }
            try {
                ICondition condition = this.makeConditionWithSymbolOperand(key, operand, valueString, ipAddress);
                this.filterCondition.add(condition);
            }
            catch (FilterException condition) {
                void e;
                FFDCFilter.processException((Throwable)condition, (String)"com.ibm.ws.security.authentication.filter.internal.CommonFilter", (String)"145", (Object)this, (Object[])new Object[]{s1});
                throw new RuntimeException((Throwable)e);
            }
        }
        return true;
    }

    protected void initialize(AuthFilterConfig filterConfig) {
        this.buildICondition(filterConfig.getWebApps(), "webApp", "name", false);
        this.buildICondition(filterConfig.getRequestUrls(), REQUEST_URL, "urlPattern", false);
        this.buildICondition(filterConfig.getRemoteAddresses(), REMOTE_ADDRESS, "ip", true);
        this.buildICondition(filterConfig.getHosts(), KEY_HOST, "name", false);
        this.buildICondition(filterConfig.getUserAgents(), KEY_USER_AGENT, "agent", false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("combine filter conditions: " + this.filterCondition.toString()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildICondition(List<Properties> filterElements, String elementName, String attrName, boolean ipAddress) {
        if (filterElements != null && !filterElements.isEmpty()) {
            Iterator<Properties> iter = filterElements.iterator();
            while (iter.hasNext()) {
                try {
                    Properties props = iter.next();
                    ICondition condition = this.makeConditionWithMatchType(elementName, props.getProperty("matchType"), props.getProperty(attrName), ipAddress);
                    this.filterCondition.add(condition);
                }
                catch (FilterException props) {
                    void e;
                    FFDCFilter.processException((Throwable)props, (String)"com.ibm.ws.security.authentication.filter.internal.CommonFilter", (String)"173", (Object)this, (Object[])new Object[]{filterElements, elementName, attrName, ipAddress});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Un-expected exception for processing " + elementName), (Object[])new Object[]{e});
                }
            }
        }
    }

    private ICondition makeConditionWithSymbolOperand(String key, String operand, String valueString, boolean ipAddress) throws FilterException {
        if (operand.equals("==")) {
            return new EqualCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        if (operand.equals("!=")) {
            NotContainsCondition cond = new NotContainsCondition(key, operand);
            this.processOrValues(valueString, ipAddress, cond);
            return cond;
        }
        if (operand.equals("^=")) {
            OrCondition cond = new OrCondition(key, operand);
            this.processOrValues(valueString, ipAddress, cond);
            return cond;
        }
        if (operand.equals("%=")) {
            return new ContainsCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        if (operand.equals("<")) {
            return new LessCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        if (operand.equals(">")) {
            return new GreaterCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        Tr.error((TraceComponent)tc, (String)"AUTH_FILTER_MALFORMED_SYMBOL_MATCH_TYPE", (Object[])new Object[]{operand});
        throw new FilterException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages", (String)"AUTH_FILTER_MALFORMED_SYMBOL_MATCH_TYPE", null, (String)"CWWKS4352E: The filter match type should be one of: ==, !=, %=, > or <. The match type used was {0}."));
    }

    private ICondition makeConditionWithMatchType(String key, String operand, String valueString, boolean ipAddress) throws FilterException {
        if (operand.equalsIgnoreCase("equals")) {
            return new EqualCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        if (operand.equalsIgnoreCase("notContain")) {
            NotContainsCondition cond = new NotContainsCondition(key, operand);
            this.processOrValues(valueString, ipAddress, cond);
            return cond;
        }
        if (operand.equalsIgnoreCase("contains")) {
            OrCondition cond = new OrCondition(key, operand);
            this.processOrValues(valueString, ipAddress, cond);
            return cond;
        }
        if (operand.equalsIgnoreCase("lessThan")) {
            return new LessCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        if (operand.equalsIgnoreCase("greaterThan")) {
            return new GreaterCondition(key, this.makeValue(valueString, ipAddress), operand);
        }
        Tr.error((TraceComponent)tc, (String)"AUTH_FILTER_MALFORMED_WORD_MATCH_TYPE", (Object[])new Object[]{operand});
        throw new FilterException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.authentication.filter.internal.resources.FilterMessages", (String)"AUTH_FILTER_MALFORMED_WORD_MATCH_TYPE", null, (String)"CWWKS4353E: The filter match type should be one of: equals, notContain, contains, greaterThan or lessThan. The match type used was {0}."));
    }

    private void processOrValues(String valueString, boolean ipAddress, OrCondition cond) throws FilterException {
        StringTokenizer tokens = new StringTokenizer(valueString, "|");
        while (tokens != null && tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            cond.addValue(this.makeValue(token, ipAddress));
        }
    }

    private IValue makeValue(String value, boolean ipAddress) throws FilterException {
        if (ipAddress) {
            return new ValueAddressRange(value);
        }
        return new ValueString(value);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAccepted(IRequestInfo req) {
        boolean answer = true;
        if (this.processAll) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processAll is true, therefore we always intercept.", (Object[])new Object[0]);
            }
            return answer;
        }
        String HTTPheader = null;
        for (ICondition cond : this.filterCondition) {
            HTTPheader = req.getHeader(cond.getKey());
            boolean ipAddress = false;
            if (HTTPheader == null) {
                String key = cond.getKey();
                if (key.equals(REMOTE_ADDRESS)) {
                    HTTPheader = req.getRemoteAddr();
                    ipAddress = true;
                } else if (key.equals(REQUEST_URL)) {
                    HTTPheader = req.getRequestURL();
                } else if (key.equals("webApp") || key.equals(APPLICATION_NAMES)) {
                    HTTPheader = req.getApplicationName();
                } else {
                    if (cond instanceof NotContainsCondition) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No HTTPheader found, and no 'remote-address' or 'request-url' or 'requestApp' rule used - do not Intercept.", (Object[])new Object[0]);
                    }
                    return false;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking condition {0} {1}.", (Object[])new Object[]{cond, HTTPheader});
            }
            try {
                IValue compareValue = ipAddress ? new ValueIPAddress(HTTPheader) : new ValueString(HTTPheader);
                answer = cond.checkCondition(compareValue);
                if (answer) continue;
                break;
            }
            catch (FilterException compareValue) {
                void e;
                FFDCFilter.processException((Throwable)compareValue, (String)"com.ibm.ws.security.authentication.filter.internal.CommonFilter", (String)"350", (Object)this, (Object[])new Object[]{req});
                throw new RuntimeException((Throwable)e);
            }
        }
        return answer;
    }

    public void setProcessAll(boolean b) {
        this.processAll = b;
    }
}

