/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.config.ssl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SSLConfig {
    private static final TraceComponent tc = Tr.register(SSLConfig.class);
    private static final OptionsKey NO_PROTECTION = new OptionsKey(1, 1);
    private final JSSEHelper jsseHelper;
    static final Pattern p = Pattern.compile("(?:(SSL)|(TLS))_([A-Z0-9]*)(_anon)?(_[a-zA-Z0-9]*)??(_EXPORT)?_WITH_([A-Z0-9]*)(?:_(\\d*))?([_a-zA-Z0-9]*)?_(?:(?:(SHA)(\\d*))|(MD5))");
    private static final int SSL_INDEX = 1;
    private static final int TLS_INDEX = 2;
    private static final int KEY_NEGOTIATION_PROTOCOL_INDEX = 3;
    private static final int KEY_NEGOTIATION_PROTOCOL_ANON_INDEX = 4;
    private static final int KEY_NEGOTIATION_PROTOCOL_OTHER_INDEX = 5;
    private static final int KEY_NEGOTIATION_PROTOCOL_EXPORT_INDEX = 6;
    private static final int ENCRYPTION_ALGORITHM_INDEX = 7;
    private static final int ENCRYPTION_ALGORITHM_KEY_LENGTH_INDEX = 8;
    private static final int ENCRYPTION_ALGORITHM_OTHER_INDEX = 9;
    private static final int SHA_ALGORITHM_INDEX = 10;
    private static final int SHA_KEY_LENGTH_INDEX = 11;
    private static final int MD5_ALGORITHM_INDEX = 12;
    private static final int MINIMUM_STRONG_KEY_LENGTH = 128;
    static final long serialVersionUID = -4618664124662983779L;

    public SSLConfig(JSSEHelper jsseHelper) {
        this.jsseHelper = jsseHelper;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private SSLContext getSslContext(final String sslConfigName) throws SSLConfigurationNotAvailableException, SSLException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SSLContext>(){
                static final long serialVersionUID = 8210169827526526904L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public SSLContext run() throws SSLConfigurationNotAvailableException, SSLException {
                    return SSLConfig.this.jsseHelper.getSSLContext(sslConfigName, null, null, false);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            assert (SSLException.class.isAssignableFrom(SSLConfigurationNotAvailableException.class));
            throw (SSLException)pae.getCause();
        }
    }

    public SSLServerSocketFactory createSSLServerFactory(String sslConfigName) throws SSLConfigurationNotAvailableException, SSLException {
        return this.getSslContext(sslConfigName).getServerSocketFactory();
    }

    public SSLSocketFactory createSSLFactory(String sslConfigName) throws SSLConfigurationNotAvailableException, SSLException {
        return this.getSslContext(sslConfigName).getSocketFactory();
    }

    public String[] getCipherSuites(String sslAliasName, String[] candidateCipherSuites) throws SSLException {
        Properties props = this.jsseHelper.getProperties(sslAliasName);
        return this.getCipherSuites(sslAliasName, candidateCipherSuites, props);
    }

    String[] getCipherSuites(String sslAliasName, String[] candidateCipherSuites, Properties props) throws SSLException {
        String enabledCipherString = props.getProperty("com.ibm.ssl.enabledCipherSuites");
        if (enabledCipherString != null) {
            String[] requested = enabledCipherString.split("[,\\s]+");
            OptionsKey options = this.getAssociationOptions(sslAliasName, props);
            return this.filter(candidateCipherSuites, requested, options);
        }
        String securityLevelString = props.getProperty("com.ibm.ssl.securityLevel");
        return Constants.adjustSupportedCiphersToSecurityLevel((String[])candidateCipherSuites, (String)securityLevelString);
    }

    private String[] filter(String[] candidateCipherSuites, String[] requested, OptionsKey options) {
        List<String> candidates = Arrays.asList(candidateCipherSuites);
        EnumSet<Options> supports = this.toOptions(options.supports, true);
        EnumSet<Options> requires = this.toOptions(options.requires, false);
        ArrayList<String> result = new ArrayList<String>(requested.length);
        for (String choice : requested) {
            if (!SSLConfig.matches(supports, requires, choice)) {
                Tr.warning((TraceComponent)tc, (String)"CSIv2_COMMON_CIPHER_SUITE_MISMATCH", (Object[])new Object[]{choice, SSLConfig.getOptions(choice), supports, requires});
            }
            if (!candidates.contains(choice)) continue;
            result.add(choice);
        }
        return result.toArray(new String[result.size()]);
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public OptionsKey getAssociationOptions(final String sslAliasName) throws SSLException {
        if (sslAliasName == null) {
            return NO_PROTECTION;
        }
        try {
            Properties props = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                static final long serialVersionUID = -8545943989691528748L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Properties run() throws SSLException {
                    return SSLConfig.this.jsseHelper.getProperties(sslAliasName);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
            return this.getAssociationOptions(sslAliasName, props);
        }
        catch (PrivilegedActionException pae) {
            throw (SSLException)pae.getCause();
        }
    }

    OptionsKey getAssociationOptions(String sslAliasName, Properties props) throws SSLException {
        if (props == null) {
            Tr.warning((TraceComponent)tc, (String)"CSIv2_SSLCONFIG_DOES_NOT_EXISTS", (Object[])new Object[]{sslAliasName});
            throw new SSLException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages", (String)"CSIv2_SSLCONFIG_DOES_NOT_EXISTS", (Object[])new Object[]{sslAliasName}, (String)"CWWKS9591W: The {0} SSL configuration does not exist.  This could be due to a missing SSL element or an invalid reference to a keystore or truststore element in the configuration."));
        }
        String clientAuthRequiredString = props.getProperty("com.ibm.ssl.clientAuthentication");
        boolean isClientAuthRequired = "true".equalsIgnoreCase(clientAuthRequiredString);
        int clientAuthRequired = isClientAuthRequired ? 64 : 0;
        String clientAuthSupportedString = props.getProperty("com.ibm.ssl.clientAuthenticationSupported");
        int clientAuthSupported = "true".equalsIgnoreCase(clientAuthSupportedString) || isClientAuthRequired ? 64 : 0;
        String securityLevelString = props.getProperty("com.ibm.ssl.securityLevel");
        if ("LOW".equals(securityLevelString)) {
            return new OptionsKey((short)(0x22 | clientAuthSupported), (short)(2 | clientAuthRequired));
        }
        return new OptionsKey((short)(0x26 | clientAuthSupported), (short)(6 | clientAuthRequired));
    }

    private EnumSet<Options> toOptions(short flags, boolean supports) {
        EnumSet<Options> options;
        EnumSet<Options> enumSet = options = supports ? EnumSet.of(Options.noexport, Options.tls) : EnumSet.noneOf(Options.class);
        if ((flags & 2) == 2) {
            options.add(Options.integrity);
        }
        if ((flags & 4) == 4) {
            options.add(Options.confidentiality);
        }
        if ((flags & 0x20) == 32) {
            options.add(Options.establishTrustInTarget);
        }
        return options;
    }

    public static EnumSet<Options> getOptions(String cipherSuiteName) {
        EnumSet<Options> result = EnumSet.noneOf(Options.class);
        Matcher m = p.matcher(cipherSuiteName);
        if (m.matches()) {
            result.add(Options.integrity);
            if (m.group(2) != null) {
                result.add(Options.tls);
            }
            if (m.group(4) == null) {
                result.add(Options.establishTrustInTarget);
            }
            if (m.group(6) == null) {
                result.add(Options.noexport);
            }
            if (!m.group(7).equals("NULL")) {
                result.add(Options.confidentiality);
                if (m.group(8) != null && m.group(8).length() > 0 && Integer.parseInt(m.group(8)) >= 128 && m.group(11) != null && m.group(11).length() > 0 && Integer.parseInt(m.group(11)) >= 128) {
                    result.add(Options.strong);
                }
            }
        }
        return result;
    }

    public static String[] getCompatibleCipherSuites(String[] choices, EnumSet<Options> supports, EnumSet<Options> requires) {
        ArrayList<String> compatible = new ArrayList<String>(choices.length);
        for (String choice : choices) {
            boolean matches = SSLConfig.matches(supports, requires, choice);
            if (!matches) continue;
            compatible.add(choice);
        }
        return compatible.toArray(new String[compatible.size()]);
    }

    private static boolean matches(EnumSet<Options> supports, EnumSet<Options> requires, String choice) {
        EnumSet<Options> actual = SSLConfig.getOptions(choice);
        boolean matches = actual.containsAll(requires) && supports.containsAll(actual);
        return matches;
    }

    public String getSSLAlias() throws SSLException {
        HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", "outbound");
        Properties defaultSSLProps = null;
        defaultSSLProps = this.jsseHelper.getProperties(null, connectionInfo, null);
        if (defaultSSLProps != null) {
            return defaultSSLProps.getProperty("com.ibm.ssl.alias");
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    public String getSSLAlias(String host, int port) throws SSLException {
        final HashMap<String, String> connectionInfo = new HashMap<String, String>();
        connectionInfo.put("com.ibm.ssl.direction", "outbound");
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", String.valueOf(port));
        Properties sslProps = null;
        try {
            sslProps = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                static final long serialVersionUID = -7581626428284594252L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Properties run() throws SSLException {
                    return SSLConfig.this.jsseHelper.getProperties(null, connectionInfo, null);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SSLException)pae.getCause();
        }
        if (sslProps != null) {
            return sslProps.getProperty("com.ibm.ssl.alias");
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class Options
    extends Enum<Options> {
        public static final /* enum */ Options integrity;
        public static final /* enum */ Options confidentiality;
        public static final /* enum */ Options establishTrustInTarget;
        public static final /* enum */ Options strong;
        public static final /* enum */ Options noexport;
        public static final /* enum */ Options tls;
        private static final /* synthetic */ Options[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static Options[] values() {
            return (Options[])$VALUES.clone();
        }

        public static Options valueOf(String name) {
            return Enum.valueOf(Options.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Options.class);
            integrity = new Options();
            confidentiality = new Options();
            establishTrustInTarget = new Options();
            strong = new Options();
            noexport = new Options();
            tls = new Options();
            $VALUES = new Options[]{integrity, confidentiality, establishTrustInTarget, strong, noexport, tls};
        }
    }
}

