/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1InputStream;
import com.ibm.ws.transport.iiop.asn1.DEREncodable;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DERApplicationSpecific
extends DERObject {
    private int tag;
    private byte[] octets;
    static final long serialVersionUID = -5504789793412603848L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DERApplicationSpecific(int tag, byte[] octets) {
        this.tag = tag;
        this.octets = octets;
    }

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this.tag = tag | 0x20;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(baos);
        dos.writeObject(object);
        this.octets = baos.toByteArray();
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(0x40 | this.tag, this.octets);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        if (this.tag != other.tag) {
            return false;
        }
        if (this.octets.length != other.octets.length) {
            return false;
        }
        for (int i = 0; i < this.octets.length; ++i) {
            if (this.octets[i] == other.octets[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        byte[] b = this.getContents();
        int value = 0;
        for (int i = 0; i != b.length; ++i) {
            value ^= (b[i] & 0xFF) << i % 4;
        }
        return value ^ this.getApplicationTag();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DERApplicationSpecific.class);
    }
}

